/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.extended;

import com.intellij.psi.PsiElement;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.fir.FirSourceElement;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirDiagnostic;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirDiagnosticFactory0;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirQualifiedAccessExpression;
import org.jetbrains.kotlin.fir.references.FirReference;
import org.jetbrains.kotlin.fir.references.FirResolvedNamedReference;
import org.jetbrains.kotlin.fir.symbols.AbstractFirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.CallableId;
import org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeNullability;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u000e\u0010\u000f\u001a\u0004\u0018\u00010\u0010*\u00020\u0002H\u0002J\f\u0010\u0011\u001a\u00020\u0012*\u00020\u0013H\u0002J\f\u0010\u0014\u001a\u00020\u0007*\u00020\u0013H\u0002R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/extended/UselessCallOnNotNullChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lorg/jetbrains/kotlin/fir/expressions/FirQualifiedAccessExpression;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirQualifiedAccessChecker;", "()V", "triggerOn", "", "", "check", "", "expression", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/fir/analysis/diagnostics/DiagnosticReporter;", "getCallableId", "Lorg/jetbrains/kotlin/fir/symbols/CallableId;", "getNullability", "Lorg/jetbrains/kotlin/fir/types/ConeNullability;", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "getPackage", "checkers"})
public final class UselessCallOnNotNullChecker
extends FirExpressionChecker<FirQualifiedAccessExpression> {
    private static final Set<String> triggerOn;
    @NotNull
    public static final UselessCallOnNotNullChecker INSTANCE;

    /*
     * WARNING - void declaration
     */
    @Override
    public void check(@NotNull FirQualifiedAccessExpression expression2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        block4: {
            void source$iv;
            Intrinsics.checkNotNullParameter(expression2, "expression");
            Intrinsics.checkNotNullParameter(context2, "context");
            Intrinsics.checkNotNullParameter(reporter, "reporter");
            CallableId callableId = this.getCallableId(expression2);
            if (callableId == null) {
                return;
            }
            CallableId method = callableId;
            FirExpression firExpression2 = expression2.getExplicitReceiver();
            if (firExpression2 == null) {
                return;
            }
            FirExpression calleeOn = firExpression2;
            String calleePackageName = this.getPackage(calleeOn);
            String string2 = method.getCallableName().asString();
            Intrinsics.checkNotNullExpressionValue(string2, "method.callableName.asString()");
            String calleeName = string2;
            if (!triggerOn.contains(calleePackageName + '.' + calleeName)) {
                return;
            }
            if (this.getNullability(calleeOn) != ConeNullability.NOT_NULL) break block4;
            DiagnosticReporter diagnosticReporter = reporter;
            FirSourceElement firSourceElement = expression2.getSource();
            FirDiagnosticFactory0<FirSourceElement, PsiElement> factory$iv = FirErrors.INSTANCE.getUSELESS_CALL_ON_NOT_NULL();
            boolean $i$f$report = false;
            void v3 = source$iv;
            if (v3 != null) {
                void $this$report$iv;
                void var12_12 = v3;
                boolean bl = false;
                boolean bl2 = false;
                void it$iv = var12_12;
                boolean bl3 = false;
                $this$report$iv.report((FirDiagnostic)factory$iv.on((FirSourceElement)it$iv));
            }
        }
    }

    private final CallableId getCallableId(FirQualifiedAccessExpression $this$getCallableId) {
        FirReference firReference = $this$getCallableId.getCalleeReference();
        if (!(firReference instanceof FirResolvedNamedReference)) {
            firReference = null;
        }
        FirResolvedNamedReference firResolvedNamedReference = (FirResolvedNamedReference)firReference;
        AbstractFirBasedSymbol<Object> abstractFirBasedSymbol = firResolvedNamedReference != null ? firResolvedNamedReference.getResolvedSymbol() : null;
        if (!(abstractFirBasedSymbol instanceof FirNamedFunctionSymbol)) {
            abstractFirBasedSymbol = null;
        }
        FirNamedFunctionSymbol firNamedFunctionSymbol = (FirNamedFunctionSymbol)abstractFirBasedSymbol;
        return firNamedFunctionSymbol != null ? firNamedFunctionSymbol.getCallableId() : null;
    }

    /*
     * Enabled aggressive block sorting
     */
    private final String getPackage(FirExpression $this$getPackage) {
        FqName fqName2;
        Object object;
        FirTypeRef firTypeRef = $this$getPackage.getTypeRef();
        if (!(firTypeRef instanceof FirResolvedTypeRef)) {
            firTypeRef = null;
        }
        if ((object = (FirResolvedTypeRef)firTypeRef) != null) {
            FirTypeRef $this$coneType$iv = (FirTypeRef)object;
            boolean $i$f$getConeType = false;
            FirTypeRef $this$coneTypeUnsafe$iv$iv = $this$coneType$iv;
            boolean $i$f$coneTypeUnsafe = false;
            ConeKotlinType coneKotlinType = ((FirResolvedTypeRef)$this$coneTypeUnsafe$iv$iv).getType();
            if (coneKotlinType == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.types.ConeKotlinType");
            }
            object = coneKotlinType;
            if (coneKotlinType != null && (object = ConeTypeUtilsKt.getClassId((ConeKotlinType)object)) != null) {
                fqName2 = ((ClassId)object).getPackageFqName();
                return String.valueOf(fqName2);
            }
        }
        fqName2 = null;
        return String.valueOf(fqName2);
    }

    private final ConeNullability getNullability(FirExpression $this$getNullability) {
        FirTypeRef firTypeRef = $this$getNullability.getTypeRef();
        if (firTypeRef == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.types.FirResolvedTypeRef");
        }
        return ((FirResolvedTypeRef)firTypeRef).getType().getNullability();
    }

    private UselessCallOnNotNullChecker() {
    }

    static {
        UselessCallOnNotNullChecker uselessCallOnNotNullChecker;
        INSTANCE = uselessCallOnNotNullChecker = new UselessCallOnNotNullChecker();
        triggerOn = SetsKt.setOf("kotlin.collections.orEmpty", "kotlin.sequences.orEmpty", "kotlin.text.orEmpty", "kotlin.text.isNullOrEmpty", "kotlin.text.isNullOrEmpty", "kotlin.text.isNullOrBlank", "kotlin.isNullOrBlank", "kotlin.isNullOrEmpty", "kotlin.orEmpty");
    }
}

