/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.jvm;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.InlineClassesUtilsKt;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000*\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u0014\u0010\u0004\u001a\u00020\u00012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u001a\u000e\u0010\b\u001a\u00020\u00012\u0006\u0010\t\u001a\u00020\n\u001a\n\u0010\u000b\u001a\u00020\u0001*\u00020\f\u001a\n\u0010\u000b\u001a\u00020\u0001*\u00020\u0007\u001a\f\u0010\r\u001a\u00020\u0001*\u00020\u0007H\u0002\u001a\f\u0010\u0004\u001a\u00020\u0001*\u00020\u0007H\u0002\u00a8\u0006\u000e"}, d2={"isDontMangleClass", "", "classDescriptor", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "requiresFunctionNameMangling", "valueParameterTypes", "", "Lorg/jetbrains/kotlin/types/KotlinType;", "shouldHideConstructorDueToInlineClassTypeValueParameters", "descriptor", "Lorg/jetbrains/kotlin/descriptors/CallableMemberDescriptor;", "isInlineClassThatRequiresMangling", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "isTypeParameterWithUpperBoundThatRequiresMangling", "descriptors.jvm"})
public final class InlineClassManglingRulesKt {
    public static final boolean shouldHideConstructorDueToInlineClassTypeValueParameters(@NotNull CallableMemberDescriptor descriptor2) {
        boolean bl;
        block8: {
            Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
            CallableMemberDescriptor callableMemberDescriptor = descriptor2;
            if (!(callableMemberDescriptor instanceof ClassConstructorDescriptor)) {
                callableMemberDescriptor = null;
            }
            ClassConstructorDescriptor classConstructorDescriptor = (ClassConstructorDescriptor)callableMemberDescriptor;
            if (classConstructorDescriptor == null) {
                return false;
            }
            ClassConstructorDescriptor constructorDescriptor = classConstructorDescriptor;
            if (Visibilities.isPrivate(constructorDescriptor.getVisibility())) {
                return false;
            }
            ClassDescriptor classDescriptor2 = constructorDescriptor.getConstructedClass();
            Intrinsics.checkExpressionValueIsNotNull(classDescriptor2, "constructorDescriptor.constructedClass");
            if (classDescriptor2.isInline()) {
                return false;
            }
            if (DescriptorUtils.isSealedClass(constructorDescriptor.getConstructedClass())) {
                return false;
            }
            List<ValueParameterDescriptor> list2 = constructorDescriptor.getValueParameters();
            Intrinsics.checkExpressionValueIsNotNull(list2, "constructorDescriptor.valueParameters");
            Iterable $this$any$iv = list2;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    ValueParameterDescriptor it = (ValueParameterDescriptor)element$iv;
                    boolean bl2 = false;
                    ValueParameterDescriptor valueParameterDescriptor = it;
                    Intrinsics.checkExpressionValueIsNotNull(valueParameterDescriptor, "it");
                    KotlinType kotlinType = valueParameterDescriptor.getType();
                    Intrinsics.checkExpressionValueIsNotNull(kotlinType, "it.type");
                    if (!InlineClassManglingRulesKt.requiresFunctionNameMangling(kotlinType)) continue;
                    bl = true;
                    break block8;
                }
                bl = false;
            }
        }
        return bl;
    }

    public static final boolean requiresFunctionNameMangling(@NotNull List<? extends KotlinType> valueParameterTypes) {
        boolean bl;
        block3: {
            Intrinsics.checkParameterIsNotNull(valueParameterTypes, "valueParameterTypes");
            Iterable $this$any$iv = valueParameterTypes;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    KotlinType it = (KotlinType)element$iv;
                    boolean bl2 = false;
                    if (!InlineClassManglingRulesKt.requiresFunctionNameMangling(it)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    public static final boolean isInlineClassThatRequiresMangling(@NotNull DeclarationDescriptor $this$isInlineClassThatRequiresMangling) {
        Intrinsics.checkParameterIsNotNull($this$isInlineClassThatRequiresMangling, "$this$isInlineClassThatRequiresMangling");
        return InlineClassesUtilsKt.isInlineClass($this$isInlineClassThatRequiresMangling) && !InlineClassManglingRulesKt.isDontMangleClass((ClassDescriptor)$this$isInlineClassThatRequiresMangling);
    }

    public static final boolean isInlineClassThatRequiresMangling(@NotNull KotlinType $this$isInlineClassThatRequiresMangling) {
        Intrinsics.checkParameterIsNotNull($this$isInlineClassThatRequiresMangling, "$this$isInlineClassThatRequiresMangling");
        ClassifierDescriptor classifierDescriptor = $this$isInlineClassThatRequiresMangling.getConstructor().getDeclarationDescriptor();
        return classifierDescriptor != null && InlineClassManglingRulesKt.isInlineClassThatRequiresMangling(classifierDescriptor);
    }

    private static final boolean requiresFunctionNameMangling(@NotNull KotlinType $this$requiresFunctionNameMangling) {
        return InlineClassManglingRulesKt.isInlineClassThatRequiresMangling($this$requiresFunctionNameMangling) || InlineClassManglingRulesKt.isTypeParameterWithUpperBoundThatRequiresMangling($this$requiresFunctionNameMangling);
    }

    private static final boolean isDontMangleClass(ClassDescriptor classDescriptor2) {
        return Intrinsics.areEqual(DescriptorUtilsKt.getFqNameSafe(classDescriptor2), DescriptorUtils.RESULT_FQ_NAME);
    }

    private static final boolean isTypeParameterWithUpperBoundThatRequiresMangling(@NotNull KotlinType $this$isTypeParameterWithUpperBoundThatRequiresMangling) {
        ClassifierDescriptor classifierDescriptor = $this$isTypeParameterWithUpperBoundThatRequiresMangling.getConstructor().getDeclarationDescriptor();
        if (!(classifierDescriptor instanceof TypeParameterDescriptor)) {
            classifierDescriptor = null;
        }
        TypeParameterDescriptor typeParameterDescriptor = (TypeParameterDescriptor)classifierDescriptor;
        if (typeParameterDescriptor == null) {
            return false;
        }
        TypeParameterDescriptor descriptor2 = typeParameterDescriptor;
        return InlineClassManglingRulesKt.requiresFunctionNameMangling(TypeUtilsKt.getRepresentativeUpperBound(descriptor2));
    }
}

