/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir;

import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.properties.ReadOnlyProperty;
import kotlin.reflect.KClass;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.FirSessionComponent;
import org.jetbrains.kotlin.fir.FirSessionKt;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u0002H\u00010\u0003B\u0013\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u00a2\u0006\u0002\u0010\u0007J\"\u0010\u000e\u001a\u00028\u00002\u0006\u0010\u000f\u001a\u00020\u00042\n\u0010\u0010\u001a\u0006\u0012\u0002\b\u00030\u0011H\u0096\u0002\u00a2\u0006\u0002\u0010\u0012R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/fir/ComponentArrayAccessor;", "T", "Lorg/jetbrains/kotlin/fir/FirSessionComponent;", "Lkotlin/properties/ReadOnlyProperty;", "Lorg/jetbrains/kotlin/fir/FirSession;", "type", "Lkotlin/reflect/KClass;", "(Lkotlin/reflect/KClass;)V", "id", "", "getId", "()I", "getType", "()Lkotlin/reflect/KClass;", "getValue", "thisRef", "property", "Lkotlin/reflect/KProperty;", "(Lorg/jetbrains/kotlin/fir/FirSession;Lkotlin/reflect/KProperty;)Lorg/jetbrains/kotlin/fir/FirSessionComponent;", "tree"})
public final class ComponentArrayAccessor<T extends FirSessionComponent>
implements ReadOnlyProperty<FirSession, T> {
    private final int id;
    @NotNull
    private final KClass<T> type;

    public final int getId() {
        return this.id;
    }

    @Override
    @NotNull
    public T getValue(@NotNull FirSession thisRef, @NotNull KProperty<?> property) {
        Intrinsics.checkParameterIsNotNull(thisRef, "thisRef");
        Intrinsics.checkParameterIsNotNull(property, "property");
        Object t = CollectionsKt.getOrNull(thisRef.getComponentArray$tree(), this.id);
        if (!(t instanceof FirSessionComponent)) {
            t = null;
        }
        FirSessionComponent firSessionComponent = (FirSessionComponent)t;
        if (firSessionComponent == null) {
            String string2 = "No '" + this.type + "'(" + this.id + ") component in session: " + thisRef;
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string2.toString());
        }
        return (T)firSessionComponent;
    }

    @NotNull
    public final KClass<T> getType() {
        return this.type;
    }

    public ComponentArrayAccessor(@NotNull KClass<T> type2) {
        Intrinsics.checkParameterIsNotNull(type2, "type");
        this.type = type2;
        this.id = FirSessionKt.access$componentId(this.type);
    }
}

