/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.coroutines.internal;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000\u001e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\u001a\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0005H\u0000\u001a\u0018\u0010\u0004\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u0007H\u0000\u001a,\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u00012\b\b\u0002\u0010\t\u001a\u00020\u00012\b\b\u0002\u0010\n\u001a\u00020\u0001H\u0000\u001a,\u0010\u0004\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u000b2\b\b\u0002\u0010\t\u001a\u00020\u000b2\b\b\u0002\u0010\n\u001a\u00020\u000bH\u0000\"\u0014\u0010\u0000\u001a\u00020\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\u00a8\u0006\f"}, d2={"AVAILABLE_PROCESSORS", "", "getAVAILABLE_PROCESSORS", "()I", "systemProp", "", "propertyName", "", "defaultValue", "minValue", "maxValue", "", "kotlinx-coroutines-core"})
public final class SystemPropsKt {
    private static final int AVAILABLE_PROCESSORS = Runtime.getRuntime().availableProcessors();

    public static final int getAVAILABLE_PROCESSORS() {
        return AVAILABLE_PROCESSORS;
    }

    @Nullable
    public static final String systemProp(@NotNull String propertyName) {
        String string;
        Intrinsics.checkParameterIsNotNull(propertyName, "propertyName");
        try {
            string = System.getProperty(propertyName);
        }
        catch (SecurityException e) {
            string = null;
        }
        return string;
    }

    public static final boolean systemProp(@NotNull String propertyName, boolean defaultValue2) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull(propertyName, "propertyName");
        try {
            boolean bl2;
            String string = System.getProperty(propertyName);
            if (string != null) {
                String string2 = string;
                bl2 = Boolean.parseBoolean(string2);
            } else {
                bl2 = defaultValue2;
            }
            bl = bl2;
        }
        catch (SecurityException e) {
            bl = defaultValue2;
        }
        return bl;
    }

    public static final int systemProp(@NotNull String propertyName, int defaultValue2, int minValue, int maxValue) {
        Intrinsics.checkParameterIsNotNull(propertyName, "propertyName");
        return (int)SystemPropsKt.systemProp(propertyName, (long)defaultValue2, (long)minValue, (long)maxValue);
    }

    public static /* synthetic */ int systemProp$default(String string, int n, int n2, int n3, int n4, Object object) {
        if ((n4 & 4) != 0) {
            n2 = 1;
        }
        if ((n4 & 8) != 0) {
            n3 = Integer.MAX_VALUE;
        }
        return SystemPropsKt.systemProp(string, n, n2, n3);
    }

    public static final long systemProp(@NotNull String propertyName, long defaultValue2, long minValue, long maxValue) {
        Intrinsics.checkParameterIsNotNull(propertyName, "propertyName");
        String string = SystemPropsKt.systemProp(propertyName);
        if (string == null) {
            return defaultValue2;
        }
        String value = string;
        Long l = StringsKt.toLongOrNull(value);
        if (l == null) {
            String string2 = "System property '" + propertyName + "' has unrecognized value '" + value + '\'';
            throw (Throwable)new IllegalStateException(string2.toString());
        }
        long parsed = l;
        long l2 = parsed;
        if (minValue > l2 || maxValue < l2) {
            String string3 = "System property '" + propertyName + "' should be in range " + minValue + ".." + maxValue + ", but is '" + parsed + '\'';
            throw (Throwable)new IllegalStateException(string3.toString());
        }
        return parsed;
    }

    public static /* synthetic */ long systemProp$default(String string, long l, long l2, long l3, int n, Object object) {
        if ((n & 4) != 0) {
            l2 = 1L;
        }
        if ((n & 8) != 0) {
            l3 = Long.MAX_VALUE;
        }
        return SystemPropsKt.systemProp(string, l, l2, l3);
    }
}

