/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.modules;

import java.io.File;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.build.JvmSourceRoot;
import org.jetbrains.kotlin.config.IncrementalCompilation;
import org.jetbrains.kotlin.modules.KotlinModuleXmlBuilder;
import org.jetbrains.kotlin.utils.Printer;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0010\r\n\u0000\n\u0002\u0010\u0002\n\u0002\b\n\u0018\u0000 '2\u00020\u0001:\u0001'B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0084\u0001\u0010\n\u001a\u00020\u00002\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u000f2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\b\u0010\u0015\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0016\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\u00042\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00100\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fJ\u0006\u0010\u001b\u001a\u00020\u001cJ\u0018\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u001f\u001a\u00020\fH\u0002J\u0010\u0010 \u001a\u00020\f2\u0006\u0010!\u001a\u00020\u0010H\u0002J\u0018\u0010\"\u001a\u00020\u001e2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u001f\u001a\u00020\fH\u0002J$\u0010#\u001a\u00020\u001e2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00100\u0019H\u0002J\u0016\u0010%\u001a\u00020\u001e2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00120\u000fH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0007\u001a\u00060\bj\u0002`\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lorg/jetbrains/kotlin/modules/KotlinModuleXmlBuilder;", "", "()V", "done", "", "p", "Lorg/jetbrains/kotlin/utils/Printer;", "xml", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "addModule", "moduleName", "", "outputDir", "sourceFiles", "", "Ljava/io/File;", "javaSourceRoots", "Lorg/jetbrains/kotlin/build/JvmSourceRoot;", "classpathRoots", "commonSourceFiles", "modularJdkRoot", "targetTypeId", "isTests", "directoriesToFilterOut", "", "friendDirs", "asText", "", "closeTag", "", "tag", "getEscapedPath", "sourceFile", "openTag", "processClasspath", "files", "processJavaSourceRoots", "roots", "Companion", "kotlin-build-common"})
public final class KotlinModuleXmlBuilder {
    private final StringBuilder xml = new StringBuilder();
    private final Printer p = new Printer(this.xml);
    private boolean done;
    private static final Map<String, String> xmlEscapeReplacement;
    private static final Regex xmlEscapeRegex;
    @Deprecated
    public static final Companion Companion;

    @NotNull
    public final KotlinModuleXmlBuilder addModule(@NotNull String moduleName, @NotNull String outputDir2, @NotNull Iterable<? extends File> sourceFiles2, @NotNull Iterable<JvmSourceRoot> javaSourceRoots, @NotNull Iterable<? extends File> classpathRoots, @NotNull Iterable<? extends File> commonSourceFiles, @Nullable File modularJdkRoot, @NotNull String targetTypeId, boolean isTests, @NotNull Set<? extends File> directoriesToFilterOut, @NotNull Iterable<? extends File> friendDirs) {
        Intrinsics.checkParameterIsNotNull(moduleName, "moduleName");
        Intrinsics.checkParameterIsNotNull(outputDir2, "outputDir");
        Intrinsics.checkParameterIsNotNull(sourceFiles2, "sourceFiles");
        Intrinsics.checkParameterIsNotNull(javaSourceRoots, "javaSourceRoots");
        Intrinsics.checkParameterIsNotNull(classpathRoots, "classpathRoots");
        Intrinsics.checkParameterIsNotNull(commonSourceFiles, "commonSourceFiles");
        Intrinsics.checkParameterIsNotNull(targetTypeId, "targetTypeId");
        Intrinsics.checkParameterIsNotNull(directoriesToFilterOut, "directoriesToFilterOut");
        Intrinsics.checkParameterIsNotNull(friendDirs, "friendDirs");
        boolean bl = !this.done;
        boolean bl2 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string = "Already done";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        this.p.println("<!-- Module script for " + (isTests ? "tests" : "production") + " -->");
        this.p.println("<", "module", " ", "name", "=\"", KotlinModuleXmlBuilder.Companion.escapeXml(moduleName), "\" ", "type", "=\"", KotlinModuleXmlBuilder.Companion.escapeXml(targetTypeId), "\" ", "outputDir", "=\"", this.getEscapedPath(new File(outputDir2)), "\">");
        this.p.pushIndent();
        for (File file2 : friendDirs) {
            this.p.println("<", "friendDir", " ", "path", "=\"", this.getEscapedPath(file2), "\"/>");
        }
        for (File file3 : sourceFiles2) {
            this.p.println("<", "sources", " ", "path", "=\"", this.getEscapedPath(file3), "\"/>");
        }
        for (File file4 : commonSourceFiles) {
            this.p.println("<", "commonSources", " ", "path", "=\"", this.getEscapedPath(file4), "\"/>");
        }
        this.processJavaSourceRoots(javaSourceRoots);
        this.processClasspath(classpathRoots, directoriesToFilterOut);
        if (modularJdkRoot != null) {
            this.p.println("<", "modularJdkRoot", " ", "path", "=\"", this.getEscapedPath(modularJdkRoot), "\"/>");
        }
        this.closeTag(this.p, "module");
        return this;
    }

    private final void processClasspath(Iterable<? extends File> files2, Set<? extends File> directoriesToFilterOut) {
        this.p.println("<!-- Classpath -->");
        for (File file2 : files2) {
            boolean isOutput;
            boolean bl = isOutput = directoriesToFilterOut.contains(file2) && !IncrementalCompilation.isEnabledForJvm();
            if (isOutput) {
                this.p.println("<!-- Output directory, commented out -->");
                this.p.println("<!-- ");
                this.p.pushIndent();
            }
            this.p.println("<", "classpath", " ", "path", "=\"", this.getEscapedPath(file2), "\"/>");
            if (!isOutput) continue;
            this.p.popIndent();
            this.p.println("-->");
        }
    }

    private final void processJavaSourceRoots(Iterable<JvmSourceRoot> roots2) {
        this.p.println("<!-- Java source roots -->");
        for (JvmSourceRoot root2 : roots2) {
            this.p.print("<");
            this.p.printWithNoIndent("javaSourceRoots", " ", "path", "=\"", this.getEscapedPath(root2.getFile()), "\"");
            if (root2.getPackagePrefix() != null) {
                this.p.printWithNoIndent(" ", "packagePrefix", "=\"", root2.getPackagePrefix(), "\"");
            }
            this.p.printWithNoIndent("/>");
            this.p.println(new Object[0]);
        }
    }

    @NotNull
    public final CharSequence asText() {
        if (!this.done) {
            this.closeTag(this.p, "modules");
            this.done = true;
        }
        return this.xml;
    }

    private final void openTag(Printer p, String tag) {
        p.println('<' + tag + '>');
        p.pushIndent();
    }

    private final void closeTag(Printer p, String tag) {
        p.popIndent();
        p.println("</" + tag + '>');
    }

    private final String getEscapedPath(File sourceFile) {
        return KotlinModuleXmlBuilder.Companion.escapeXml(FilesKt.getInvariantSeparatorsPath(sourceFile));
    }

    public KotlinModuleXmlBuilder() {
        this.openTag(this.p, "modules");
    }

    static {
        Companion = new Companion(null);
        xmlEscapeReplacement = MapsKt.mapOf(TuplesKt.to("<", "&lt;"), TuplesKt.to(">", "&gt;"), TuplesKt.to("&", "&amp;"), TuplesKt.to("'", "&#39;"), TuplesKt.to("\"", "&quot;"));
        xmlEscapeRegex = new Regex(CollectionsKt.joinToString$default(xmlEscapeReplacement.keySet(), "|", "(?:", ")", 0, null, Companion.xmlEscapeRegex.1.INSTANCE, 24, null));
    }

    public static final /* synthetic */ Map access$getXmlEscapeReplacement$cp() {
        return xmlEscapeReplacement;
    }

    public static final /* synthetic */ Companion access$Companion() {
        return Companion;
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u0007H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/modules/KotlinModuleXmlBuilder$Companion;", "", "()V", "xmlEscapeRegex", "Lkotlin/text/Regex;", "xmlEscapeReplacement", "", "", "escapeXml", "string", "kotlin-build-common"})
    private static final class Companion {
        private final String escapeXml(String string) {
            CharSequence charSequence = string;
            Regex regex = xmlEscapeRegex;
            Function1 function1 = escapeXml.1.INSTANCE;
            boolean bl = false;
            return regex.replace(charSequence, function1);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

