/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.lang;

import com.intellij.openapi.diagnostic.LoggerRt;
import com.intellij.util.containers.Stack;
import com.intellij.util.lang.CachePoolImpl;
import com.intellij.util.lang.ClasspathCache;
import com.intellij.util.lang.FileLoader;
import com.intellij.util.lang.JarLoader;
import com.intellij.util.lang.Loader;
import com.intellij.util.lang.MemoryResource;
import com.intellij.util.lang.Resource;
import com.intellij.util.lang.UrlClassLoader;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.jar.Attributes;
import org.jetbrains.annotations.Nullable;

public class ClassPath {
    private static final ResourceStringLoaderIterator ourResourceIterator = new ResourceStringLoaderIterator();
    private static final LoaderCollector ourLoaderCollector = new LoaderCollector();
    private final Stack<URL> myUrls = new Stack();
    private final List<Loader> myLoaders = new ArrayList<Loader>();
    private volatile boolean myAllUrlsWereProcessed;
    private final AtomicInteger myLastLoaderProcessed = new AtomicInteger();
    private final Map<URL, Loader> myLoadersMap = new HashMap<URL, Loader>();
    private final ClasspathCache myCache = new ClasspathCache();
    final boolean myCanLockJars;
    private final boolean myCanUseCache;
    private final boolean myAcceptUnescapedUrls;
    final boolean myPreloadJarContents;
    final boolean myCanHavePersistentIndex;
    final boolean myLazyClassloadingCaches;
    @Nullable
    private final CachePoolImpl myCachePool;
    @Nullable
    private final UrlClassLoader.CachingCondition myCachingCondition;
    final boolean myLogErrorOnMissingJar;
    private static final ResourceLoadingLogger ourResourceLoadingLogger;
    static final boolean ourLogTiming;
    private static final AtomicLong ourTotalTime;
    private static final AtomicInteger ourTotalRequests;
    private static final ThreadLocal<Boolean> ourDoingTiming;

    public ClassPath(List<URL> urls, boolean canLockJars, boolean canUseCache, boolean acceptUnescapedUrls, boolean preloadJarContents, boolean canHavePersistentIndex, @Nullable CachePoolImpl cachePool, @Nullable UrlClassLoader.CachingCondition cachingCondition, boolean logErrorOnMissingJar, boolean lazyClassloadingCaches) {
        this.myLazyClassloadingCaches = lazyClassloadingCaches;
        this.myCanLockJars = canLockJars;
        this.myCanUseCache = canUseCache && !this.myLazyClassloadingCaches;
        this.myAcceptUnescapedUrls = acceptUnescapedUrls;
        this.myPreloadJarContents = preloadJarContents;
        this.myCachePool = cachePool;
        this.myCachingCondition = cachingCondition;
        this.myCanHavePersistentIndex = canHavePersistentIndex;
        this.myLogErrorOnMissingJar = logErrorOnMissingJar;
        this.push(urls);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void push(List<URL> urls) {
        if (!urls.isEmpty()) {
            Stack<URL> stack = this.myUrls;
            synchronized (stack) {
                for (int i = urls.size() - 1; i >= 0; --i) {
                    this.myUrls.push(urls.get(i));
                }
                this.myAllUrlsWereProcessed = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Resource getResource(String s) {
        long started = ClassPath.startTiming();
        try {
            Loader loader;
            int i;
            String shortName = ClasspathCache.transformName(s);
            if (this.myCanUseCache) {
                boolean allUrlsWereProcessed = this.myAllUrlsWereProcessed;
                i = allUrlsWereProcessed ? 0 : this.myLastLoaderProcessed.get();
                Resource prevResource = this.myCache.iterateLoaders(s, ourResourceIterator, s, this, shortName);
                if (prevResource != null || allUrlsWereProcessed) {
                    Resource resource = prevResource;
                    return resource;
                }
            } else {
                i = 0;
            }
            while ((loader = this.getLoader(i++)) != null) {
                if (this.myCanUseCache && !loader.containsName(s, shortName)) continue;
                Resource resource = loader.getResource(s);
                if (resource == null) continue;
                Resource resource2 = resource;
                return resource2;
            }
        }
        finally {
            ClassPath.logTiming(this, started, s);
        }
        return null;
    }

    public Enumeration<URL> getResources(String name) {
        return new MyEnumeration(name);
    }

    @Nullable
    private Loader getLoader(int i) {
        if (i < this.myLastLoaderProcessed.get()) {
            return this.myLoaders.get(i);
        }
        return this.getLoaderSlowPath(i);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private synchronized Loader getLoaderSlowPath(int i) {
        while (this.myLoaders.size() < i + 1) {
            URL url;
            Stack<URL> stack = this.myUrls;
            synchronized (stack) {
                if (this.myUrls.empty()) {
                    if (this.myCanUseCache) {
                        this.myAllUrlsWereProcessed = true;
                    }
                    return null;
                }
                url = this.myUrls.pop();
            }
            if (this.myLoadersMap.containsKey(url)) continue;
            try {
                this.initLoaders(url, this.myLoaders.size());
            }
            catch (IOException e) {
                LoggerRt.getInstance(ClassPath.class).info("url: " + url, e);
            }
        }
        return this.myLoaders.get(i);
    }

    private void initLoaders(URL url, int index2) throws IOException {
        File file2;
        Loader loader;
        String path2;
        if (this.myAcceptUnescapedUrls) {
            path2 = url.getFile();
        } else {
            try {
                path2 = url.toURI().getSchemeSpecificPart();
            }
            catch (URISyntaxException e) {
                LoggerRt.getInstance(ClassPath.class).error("url: " + url, e);
                path2 = url.getFile();
            }
        }
        if (path2 != null && "file".equals(url.getProtocol()) && (loader = this.createLoader(url, index2, file2 = new File(path2), file2.getName().startsWith("classpath"))) != null) {
            this.initLoader(url, loader);
        }
    }

    private Loader createLoader(URL url, int index2, File file2, boolean processRecursively) throws IOException {
        if (file2.isDirectory()) {
            return new FileLoader(url, index2, this);
        }
        if (file2.isFile()) {
            String[] referencedJars;
            JarLoader loader = new JarLoader(url, index2, this);
            if (processRecursively && (referencedJars = ClassPath.loadManifestClasspath(loader)) != null) {
                long s2 = ourLogTiming ? System.nanoTime() : 0L;
                ArrayList<URL> urls = new ArrayList<URL>(referencedJars.length);
                for (String referencedJar : referencedJars) {
                    try {
                        urls.add(UrlClassLoader.internProtocol(new URI(referencedJar).toURL()));
                    }
                    catch (Exception e) {
                        LoggerRt.getInstance(ClassPath.class).warn("url: " + url + " / " + referencedJar, e);
                    }
                }
                this.push(urls);
                if (ourLogTiming) {
                    System.out.println("Loaded all " + referencedJars.length + " urls " + (System.nanoTime() - s2) / 1000000L + "ms");
                }
            }
            return loader;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initLoader(URL url, Loader loader) throws IOException {
        if (this.myCanUseCache) {
            boolean lastOne;
            ClasspathCache.LoaderData data;
            ClasspathCache.LoaderData loaderData = data = this.myCachePool == null ? null : this.myCachePool.getCachedData(url);
            if (data == null) {
                data = loader.buildData();
                if (this.myCachePool != null && this.myCachingCondition != null && this.myCachingCondition.shouldCacheData(url)) {
                    this.myCachePool.cacheData(url, data);
                }
            }
            this.myCache.applyLoaderData(data, loader);
            Stack<URL> stack = this.myUrls;
            synchronized (stack) {
                lastOne = this.myUrls.isEmpty();
            }
            if (lastOne) {
                this.myAllUrlsWereProcessed = true;
            }
        }
        this.myLoaders.add(loader);
        this.myLoadersMap.put(url, loader);
        this.myLastLoaderProcessed.incrementAndGet();
    }

    Attributes getManifestData(URL url) {
        return this.myCanUseCache && this.myCachePool != null ? this.myCachePool.getManifestData(url) : null;
    }

    void cacheManifestData(URL url, Attributes manifestAttributes) {
        if (this.myCanUseCache && this.myCachePool != null && this.myCachingCondition != null && this.myCachingCondition.shouldCacheData(url)) {
            this.myCachePool.cacheManifestData(url, manifestAttributes);
        }
    }

    private static long startTiming() {
        if (!ourLogTiming) {
            return 0L;
        }
        if (ourDoingTiming.get() != null) {
            return 0L;
        }
        ourDoingTiming.set(Boolean.TRUE);
        return System.nanoTime();
    }

    private static void logTiming(ClassPath path2, long started, String msg) {
        if (!ourLogTiming) {
            return;
        }
        if (started == 0L) {
            return;
        }
        ourDoingTiming.set(null);
        long time = System.nanoTime() - started;
        long totalTime = ourTotalTime.addAndGet(time);
        int totalRequests = ourTotalRequests.incrementAndGet();
        if (time > 10000000L) {
            System.out.println(time / 1000000L + " ms for " + msg);
        }
        if (totalRequests % 10000 == 0) {
            System.out.println(path2.getClass().getClassLoader() + ", requests:" + ourTotalRequests + ", time:" + totalTime / 1000000L + "ms");
        }
    }

    private static String[] loadManifestClasspath(JarLoader loader) {
        try {
            String[] urls;
            String classPath2 = loader.getClassPathManifestAttribute();
            if (classPath2 != null && (urls = classPath2.split(" ")).length > 0 && urls[0].startsWith("file:")) {
                return urls;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    static {
        String className2 = System.getProperty("intellij.class.resources.loading.logger");
        ResourceLoadingLogger resourceLoadingLogger = null;
        if (className2 != null) {
            try {
                resourceLoadingLogger = (ResourceLoadingLogger)Class.forName(className2).newInstance();
            }
            catch (Throwable e) {
                LoggerRt.getInstance(ClassPath.class).error("Failed to instantiate resource loading logger " + className2, e);
            }
        }
        ourResourceLoadingLogger = resourceLoadingLogger;
        ourLogTiming = Boolean.getBoolean("idea.print.classpath.timing");
        ourTotalTime = new AtomicLong();
        ourTotalRequests = new AtomicInteger();
        ourDoingTiming = new ThreadLocal();
        if (ourLogTiming) {
            Runtime.getRuntime().addShutdownHook(new Thread("Shutdown hook for tracing classloading information"){

                @Override
                public void run() {
                    System.out.println("Classloading requests:" + ClassPath.class.getClassLoader() + "," + ourTotalRequests + ", time:" + ourTotalTime.get() / 1000000L + "ms");
                }
            });
        }
    }

    public static interface ResourceLoadingLogger {
        public void logResource(String var1, URL var2, long var3);
    }

    private static class LoaderCollector
    extends ClasspathCache.LoaderIterator<Object, Collection<Loader>, Object> {
        private LoaderCollector() {
        }

        @Override
        Object process(Loader loader, Collection<Loader> parameter2, Object parameter22, String shortName) {
            parameter2.add(loader);
            return null;
        }
    }

    private static class ResourceStringLoaderIterator
    extends ClasspathCache.LoaderIterator<Resource, String, ClassPath> {
        private ResourceStringLoaderIterator() {
        }

        @Override
        Resource process(Loader loader, String s, ClassPath classPath2, String shortName) {
            if (!loader.containsName(s, shortName)) {
                return null;
            }
            Resource resource = loader.getResource(s);
            if (resource != null && ourResourceLoadingLogger != null) {
                long resourceSize;
                try {
                    resourceSize = resource instanceof MemoryResource ? (long)resource.getBytes().length : -1L;
                }
                catch (IOException e) {
                    resourceSize = -1L;
                }
                ourResourceLoadingLogger.logResource(s, loader.getBaseURL(), resourceSize);
            }
            return resource;
        }
    }

    private class MyEnumeration
    implements Enumeration<URL> {
        private int myIndex;
        private Resource myRes;
        private final String myName;
        private final String myShortName;
        private final List<Loader> myLoaders;

        MyEnumeration(String name) {
            this.myName = name;
            this.myShortName = ClasspathCache.transformName(name);
            ArrayList loaders = null;
            if (ClassPath.this.myCanUseCache && ClassPath.this.myAllUrlsWereProcessed) {
                LinkedHashSet loadersSet = new LinkedHashSet();
                ClassPath.this.myCache.iterateLoaders(name, ourLoaderCollector, loadersSet, this, this.myShortName);
                if (name.endsWith("/")) {
                    ClassPath.this.myCache.iterateLoaders(name.substring(0, name.length() - 1), ourLoaderCollector, loadersSet, this, this.myShortName);
                } else {
                    ClassPath.this.myCache.iterateLoaders(name + "/", ourLoaderCollector, loadersSet, this, this.myShortName);
                }
                loaders = new ArrayList(loadersSet);
            }
            this.myLoaders = loaders;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean next() {
            if (this.myRes != null) {
                return true;
            }
            long started = ClassPath.startTiming();
            try {
                if (this.myLoaders != null) {
                    while (this.myIndex < this.myLoaders.size()) {
                        Loader loader;
                        if (!(loader = this.myLoaders.get(this.myIndex++)).containsName(this.myName, this.myShortName)) {
                            this.myRes = null;
                            continue;
                        }
                        this.myRes = loader.getResource(this.myName);
                        if (this.myRes == null) continue;
                        boolean bl = true;
                        return bl;
                    }
                } else {
                    Loader loader;
                    while ((loader = ClassPath.this.getLoader(this.myIndex++)) != null) {
                        if (ClassPath.this.myCanUseCache && !loader.containsName(this.myName, this.myShortName)) continue;
                        this.myRes = loader.getResource(this.myName);
                        if (this.myRes == null) continue;
                        boolean bl = true;
                        return bl;
                    }
                }
            }
            finally {
                ClassPath.logTiming(ClassPath.this, started, this.myName);
            }
            return false;
        }

        @Override
        public boolean hasMoreElements() {
            return this.next();
        }

        @Override
        public URL nextElement() {
            if (!this.next()) {
                throw new NoSuchElementException();
            }
            Resource resource = this.myRes;
            this.myRes = null;
            return resource.getURL();
        }
    }
}

