/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.common;

import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.common.PerformanceMeasurement;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0002\b\u0002\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010\tJ\b\u0010\u000e\u001a\u00020\bH\u0016R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/cli/common/CodeAnalysisMeasurement;", "Lorg/jetbrains/kotlin/cli/common/PerformanceMeasurement;", "files", "", "lines", "milliseconds", "", "description", "", "(IIJLjava/lang/String;)V", "getLines", "()I", "speed", "", "render", "cli"})
public final class CodeAnalysisMeasurement
implements PerformanceMeasurement {
    private final double speed;
    private final int files;
    private final int lines;
    private final long milliseconds;
    private final String description;

    @Override
    @NotNull
    public String render() {
        StringBuilder stringBuilder = new StringBuilder().append("ANALYZE: ").append(this.files).append(" files (").append(this.lines).append(" lines) ");
        String string = this.description;
        if (string == null) {
            string = "";
        }
        String string2 = "%.3f";
        Object[] objectArray = new Object[]{this.speed};
        StringBuilder stringBuilder2 = stringBuilder.append(string).append("in ").append(this.milliseconds).append(" ms - ");
        String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkExpressionValueIsNotNull(string3, "java.lang.String.format(this, *args)");
        String string4 = string3;
        return stringBuilder2.append(string4).append(" loc/s").toString();
    }

    public final int getLines() {
        return this.lines;
    }

    public CodeAnalysisMeasurement(int files2, int lines, long milliseconds, @Nullable String description2) {
        this.files = files2;
        this.lines = lines;
        this.milliseconds = milliseconds;
        this.description = description2;
        this.speed = (double)this.lines * (double)1000 / (double)this.milliseconds;
    }
}

