/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.diff;

import com.intellij.openapi.util.Ref;
import com.intellij.util.ThreeState;
import com.intellij.util.diff.DiffTreeChangeBuilder;
import com.intellij.util.diff.FlyweightCapableTreeStructure;
import com.intellij.util.diff.ShallowNodeComparator;
import com.intellij.util.text.CharArrayUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class DiffTree<OT, NT> {
    private final FlyweightCapableTreeStructure<OT> myOldTree;
    private final FlyweightCapableTreeStructure<NT> myNewTree;
    private final ShallowNodeComparator<OT, NT> myComparator;
    private final List<Ref<OT[]>> myOldChildrenLists;
    private final List<Ref<NT[]>> myNewChildrenLists;
    private final CharSequence myOldText;
    private final CharSequence myNewText;
    private final int myOldTreeStart;
    private final int myNewTreeStart;
    private static final DiffTreeChangeBuilder EMPTY_CONSUMER = new DiffTreeChangeBuilder(){

        public void nodeReplaced(@NotNull Object oldChild, @NotNull Object newChild) {
            if (oldChild == null) {
                1.$$$reportNull$$$0(0);
            }
            if (newChild == null) {
                1.$$$reportNull$$$0(1);
            }
        }

        public void nodeDeleted(@NotNull Object oldParent, @NotNull Object oldNode) {
            if (oldParent == null) {
                1.$$$reportNull$$$0(2);
            }
            if (oldNode == null) {
                1.$$$reportNull$$$0(3);
            }
        }

        public void nodeInserted(@NotNull Object oldParent, @NotNull Object newNode, int pos) {
            if (oldParent == null) {
                1.$$$reportNull$$$0(4);
            }
            if (newNode == null) {
                1.$$$reportNull$$$0(5);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "oldChild";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newChild";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "oldParent";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "oldNode";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newNode";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/util/diff/DiffTree$1";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "nodeReplaced";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "nodeDeleted";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "nodeInserted";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    };

    private DiffTree(@NotNull FlyweightCapableTreeStructure<OT> oldTree, @NotNull FlyweightCapableTreeStructure<NT> newTree, @NotNull ShallowNodeComparator<OT, NT> comparator, @NotNull CharSequence oldText) {
        if (oldTree == null) {
            DiffTree.$$$reportNull$$$0(0);
        }
        if (newTree == null) {
            DiffTree.$$$reportNull$$$0(1);
        }
        if (comparator == null) {
            DiffTree.$$$reportNull$$$0(2);
        }
        if (oldText == null) {
            DiffTree.$$$reportNull$$$0(3);
        }
        this.myOldChildrenLists = new ArrayList<Ref<OT[]>>();
        this.myNewChildrenLists = new ArrayList<Ref<NT[]>>();
        this.myOldTree = oldTree;
        this.myNewTree = newTree;
        this.myComparator = comparator;
        this.myOldText = oldText;
        this.myOldTreeStart = oldTree.getStartOffset(oldTree.getRoot());
        this.myNewText = newTree.toString(newTree.getRoot());
        this.myNewTreeStart = newTree.getStartOffset(newTree.getRoot());
    }

    public static <OT, NT> void diff(@NotNull FlyweightCapableTreeStructure<OT> oldTree, @NotNull FlyweightCapableTreeStructure<NT> newTree, @NotNull ShallowNodeComparator<OT, NT> comparator, @NotNull DiffTreeChangeBuilder<OT, NT> consumer, @NotNull CharSequence oldText) {
        if (oldTree == null) {
            DiffTree.$$$reportNull$$$0(4);
        }
        if (newTree == null) {
            DiffTree.$$$reportNull$$$0(5);
        }
        if (comparator == null) {
            DiffTree.$$$reportNull$$$0(6);
        }
        if (consumer == null) {
            DiffTree.$$$reportNull$$$0(7);
        }
        if (oldText == null) {
            DiffTree.$$$reportNull$$$0(8);
        }
        DiffTree<OT, NT> tree = new DiffTree<OT, NT>(oldTree, newTree, comparator, oldText);
        super.build(oldTree.getRoot(), newTree.getRoot(), 0, consumer);
    }

    @NotNull
    private static <OT, NT> DiffTreeChangeBuilder<OT, NT> emptyConsumer() {
        DiffTreeChangeBuilder diffTreeChangeBuilder = EMPTY_CONSUMER;
        if (diffTreeChangeBuilder == null) {
            DiffTree.$$$reportNull$$$0(9);
        }
        return diffTreeChangeBuilder;
    }

    @NotNull
    private CompareResult build(@NotNull OT oldNode, @NotNull NT newNode, int level, @NotNull DiffTreeChangeBuilder<OT, NT> consumer) {
        CompareResult result2;
        if (oldNode == null) {
            DiffTree.$$$reportNull$$$0(10);
        }
        if (newNode == null) {
            DiffTree.$$$reportNull$$$0(11);
        }
        if (consumer == null) {
            DiffTree.$$$reportNull$$$0(12);
        }
        if (level == this.myNewChildrenLists.size()) {
            this.myNewChildrenLists.add(new Ref());
            this.myOldChildrenLists.add(new Ref());
        }
        Ref<T[]> oldChildrenR = this.myOldChildrenLists.get(level);
        int oldChildrenSize = this.myOldTree.getChildren(oldNode, oldChildrenR);
        T[] oldChildren = oldChildrenR.get();
        Ref<T[]> newChildrenR = this.myNewChildrenLists.get(level);
        int newChildrenSize = this.myNewTree.getChildren(newNode, newChildrenR);
        T[] newChildren = newChildrenR.get();
        if (Math.abs(oldChildrenSize - newChildrenSize) > 20) {
            consumer.nodeReplaced(oldNode, newNode);
            result2 = CompareResult.NOT_EQUAL;
        } else if (oldChildrenSize == 0 && newChildrenSize == 0) {
            if (!this.myComparator.hashCodesEqual(oldNode, newNode) || !this.myComparator.typesEqual(oldNode, newNode)) {
                consumer.nodeReplaced(oldNode, newNode);
                result2 = CompareResult.NOT_EQUAL;
            } else {
                result2 = CompareResult.EQUAL;
            }
        } else {
            int minSize = Math.min(oldChildrenSize, newChildrenSize);
            int suffixLength = this.match(oldChildren, oldChildrenSize - 1, newChildren, newChildrenSize - 1, level, -1, minSize);
            int maxPrefixLength = minSize - suffixLength - (oldChildrenSize == newChildrenSize && suffixLength < minSize ? 1 : 0);
            int prefixLength = this.match(oldChildren, 0, newChildren, 0, level, 1, maxPrefixLength);
            if (oldChildrenSize == newChildrenSize && suffixLength + prefixLength == oldChildrenSize) {
                result2 = CompareResult.EQUAL;
            } else if (consumer == DiffTree.emptyConsumer()) {
                result2 = CompareResult.NOT_EQUAL;
            } else {
                int oldIndex = prefixLength;
                int newIndex = prefixLength;
                while (oldIndex < oldChildrenSize - suffixLength || newIndex < newChildrenSize - suffixLength) {
                    ThreeElementMatchResult vicinityMatch = this.matchNext3Children(oldChildren, newChildren, oldIndex, newIndex, oldChildrenSize - suffixLength, newChildrenSize - suffixLength);
                    if (vicinityMatch.hasStartMatch()) {
                        if (vicinityMatch == ThreeElementMatchResult.drillDownStartMatch) {
                            this.build(oldChildren[oldIndex], newChildren[newIndex], level + 1, consumer);
                        } else if (vicinityMatch == ThreeElementMatchResult.replaceStart) {
                            consumer.nodeReplaced(oldChildren[oldIndex], newChildren[newIndex]);
                        }
                        ++oldIndex;
                        ++newIndex;
                        continue;
                    }
                    if (vicinityMatch != ThreeElementMatchResult.noMatch) {
                        int i;
                        for (i = vicinityMatch.skipOldCount() - 1; i >= 0; --i) {
                            consumer.nodeDeleted(oldNode, oldChildren[oldIndex]);
                            ++oldIndex;
                        }
                        for (i = vicinityMatch.skipNewCount() - 1; i >= 0; --i) {
                            consumer.nodeInserted(oldNode, newChildren[newIndex], newIndex);
                            ++newIndex;
                        }
                        continue;
                    }
                    int suffixMatch = this.matchLastChildren(level, consumer, oldChildrenSize - suffixLength, oldChildren, oldIndex, newChildrenSize - suffixLength, newChildren, newIndex);
                    if (suffixMatch > 0) {
                        suffixLength += suffixMatch;
                        continue;
                    }
                    consumer.nodeReplaced(oldChildren[oldIndex], newChildren[newIndex]);
                    ++oldIndex;
                    ++newIndex;
                }
                result2 = CompareResult.NOT_EQUAL;
            }
        }
        this.myOldTree.disposeChildren(oldChildren, oldChildrenSize);
        this.myNewTree.disposeChildren(newChildren, newChildrenSize);
        CompareResult compareResult = result2;
        if (compareResult == null) {
            DiffTree.$$$reportNull$$$0(13);
        }
        return compareResult;
    }

    private ThreeElementMatchResult matchNext3Children(OT[] oldChildren, NT[] newChildren, int oldIndex, int newIndex, int oldLimit, int newLimit) {
        NT newChild3;
        if (oldIndex >= oldLimit) {
            return ThreeElementMatchResult.skipNew1;
        }
        if (newIndex >= newLimit) {
            return ThreeElementMatchResult.skipOld1;
        }
        OT oldChild1 = oldChildren[oldIndex];
        NT newChild1 = newChildren[newIndex];
        CompareResult c11 = this.looksEqual(oldChild1, newChild1);
        if (c11 == CompareResult.EQUAL) {
            return ThreeElementMatchResult.fullStartMatch;
        }
        if (c11 == CompareResult.DRILL_DOWN_NEEDED) {
            return ThreeElementMatchResult.drillDownStartMatch;
        }
        OT oldChild2 = oldIndex < oldLimit - 1 ? (OT)oldChildren[oldIndex + 1] : null;
        NT newChild2 = newIndex < newLimit - 1 ? (NT)newChildren[newIndex + 1] : null;
        CompareResult c12 = this.looksEqual(oldChild1, newChild2);
        if (c12 == CompareResult.EQUAL || c12 == CompareResult.DRILL_DOWN_NEEDED) {
            return ThreeElementMatchResult.skipNew1;
        }
        CompareResult c21 = this.looksEqual(oldChild2, newChild1);
        if (c21 == CompareResult.EQUAL || c21 == CompareResult.DRILL_DOWN_NEEDED) {
            return ThreeElementMatchResult.skipOld1;
        }
        if (c11 == CompareResult.TYPE_ONLY) {
            return ThreeElementMatchResult.replaceStart;
        }
        if (c12 == CompareResult.TYPE_ONLY) {
            return ThreeElementMatchResult.skipNew1;
        }
        if (c21 == CompareResult.TYPE_ONLY) {
            return ThreeElementMatchResult.skipOld1;
        }
        OT oldChild3 = oldIndex < oldLimit - 2 ? (OT)oldChildren[oldIndex + 2] : null;
        NT NT = newChild3 = newIndex < newLimit - 2 ? (NT)newChildren[newIndex + 2] : null;
        if (this.looksEqual(oldChild1, newChild3) != CompareResult.NOT_EQUAL) {
            return ThreeElementMatchResult.skipNew2;
        }
        if (this.looksEqual(oldChild3, newChild1) != CompareResult.NOT_EQUAL) {
            return ThreeElementMatchResult.skipOld2;
        }
        return ThreeElementMatchResult.noMatch;
    }

    private int matchLastChildren(int level, DiffTreeChangeBuilder<OT, NT> consumer, int oldChildrenLimit, OT[] oldChildren, int oldIndex, int newChildrenLimit, NT[] newChildren, int newIndex) {
        NT newLastChild;
        OT oldLastChild;
        CompareResult c;
        int len = 0;
        while (oldIndex < oldChildrenLimit - len && newIndex < newChildrenLimit - len && (c = this.looksEqual(oldLastChild = oldChildren[oldChildrenLimit - len - 1], newLastChild = newChildren[newChildrenLimit - len - 1])) != CompareResult.NOT_EQUAL) {
            if (c == CompareResult.DRILL_DOWN_NEEDED) {
                this.build(oldLastChild, newLastChild, level + 1, consumer);
            } else if (c == CompareResult.TYPE_ONLY) {
                consumer.nodeReplaced(oldLastChild, newLastChild);
            }
            ++len;
        }
        return len;
    }

    private int match(OT[] oldChildren, int oldIndex, NT[] newChildren, int newIndex, int level, int step, int maxLength) {
        int delta;
        for (delta = 0; delta != maxLength * step; delta += step) {
            OT oldChild = oldChildren[oldIndex + delta];
            NT newChild = newChildren[newIndex + delta];
            CompareResult c11 = this.looksEqual(oldChild, newChild);
            if (c11 == CompareResult.DRILL_DOWN_NEEDED) {
                CompareResult compareResult = c11 = this.textMatch(oldChild, newChild) ? this.build(oldChild, newChild, level + 1, DiffTree.<OT, NT>emptyConsumer()) : CompareResult.NOT_EQUAL;
                assert (c11 != CompareResult.DRILL_DOWN_NEEDED);
            }
            if (c11 != CompareResult.EQUAL) break;
        }
        return delta * step;
    }

    private boolean textMatch(OT oldChild, NT newChild) {
        int oldStart = this.myOldTree.getStartOffset(oldChild) - this.myOldTreeStart;
        int oldEnd = this.myOldTree.getEndOffset(oldChild) - this.myOldTreeStart;
        int newStart = this.myNewTree.getStartOffset(newChild) - this.myNewTreeStart;
        int newEnd = this.myNewTree.getEndOffset(newChild) - this.myNewTreeStart;
        return CharArrayUtil.regionMatches(this.myOldText, oldStart, oldEnd, this.myNewText, newStart, newEnd);
    }

    @NotNull
    private CompareResult looksEqual(OT oldChild1, NT newChild1) {
        if (oldChild1 == null || newChild1 == null || !this.myComparator.typesEqual(oldChild1, newChild1)) {
            CompareResult compareResult = CompareResult.NOT_EQUAL;
            if (compareResult == null) {
                DiffTree.$$$reportNull$$$0(14);
            }
            return compareResult;
        }
        ThreeState ret = this.myComparator.deepEqual(oldChild1, newChild1);
        if (ret == ThreeState.YES) {
            CompareResult compareResult = CompareResult.EQUAL;
            if (compareResult == null) {
                DiffTree.$$$reportNull$$$0(15);
            }
            return compareResult;
        }
        if (ret == ThreeState.UNSURE) {
            CompareResult compareResult = CompareResult.DRILL_DOWN_NEEDED;
            if (compareResult == null) {
                DiffTree.$$$reportNull$$$0(16);
            }
            return compareResult;
        }
        CompareResult compareResult = CompareResult.TYPE_ONLY;
        if (compareResult == null) {
            DiffTree.$$$reportNull$$$0(17);
        }
        return compareResult;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldTree";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newTree";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comparator";
                break;
            }
            case 3: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldText";
                break;
            }
            case 7: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 9: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/diff/DiffTree";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldNode";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newNode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/diff/DiffTree";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "emptyConsumer";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "build";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "looksEqual";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "diff";
                break;
            }
            case 9: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "build";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static enum ThreeElementMatchResult {
        fullStartMatch,
        drillDownStartMatch,
        replaceStart,
        skipNew1,
        skipNew2,
        skipOld1,
        skipOld2,
        noMatch;


        final int skipNewCount() {
            return this == skipNew1 ? 1 : (this == skipNew2 ? 2 : 0);
        }

        final int skipOldCount() {
            return this == skipOld1 ? 1 : (this == skipOld2 ? 2 : 0);
        }

        final boolean hasStartMatch() {
            return this == fullStartMatch || this == drillDownStartMatch || this == replaceStart;
        }
    }

    private static enum CompareResult {
        EQUAL,
        DRILL_DOWN_NEEDED,
        TYPE_ONLY,
        NOT_EQUAL;

    }
}

