/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.osgi.core;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.ivy.osgi.core.ExecutionEnvironmentProfile;
import org.apache.ivy.util.Message;

public class ExecutionEnvironmentProfileProvider {
    private Map<String, ExecutionEnvironmentProfile> profileList = ExecutionEnvironmentProfileProvider.loadDefaultProfileList();
    private static final ExecutionEnvironmentProfileProvider INSTANCE;

    public static ExecutionEnvironmentProfileProvider getInstance() {
        return INSTANCE;
    }

    public ExecutionEnvironmentProfile getProfile(String profile) {
        return this.profileList.get(profile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, ExecutionEnvironmentProfile> loadDefaultProfileList() throws IOException {
        ClassLoader loader = ExecutionEnvironmentProfileProvider.class.getClassLoader();
        InputStream defaultProfilesFile = loader.getResourceAsStream("org/apache/ivy/osgi/core/jvm-packages.properties");
        if (defaultProfilesFile == null) {
            throw new FileNotFoundException("org/apache/ivy/osgi/core/jvm-packages.properties not found in the classpath");
        }
        Properties props = new Properties();
        try {
            props.load(defaultProfilesFile);
        }
        finally {
            defaultProfilesFile.close();
        }
        HashMap<String, ExecutionEnvironmentProfile> profiles = new HashMap<String, ExecutionEnvironmentProfile>();
        for (Map.Entry<Object, Object> prop : props.entrySet()) {
            String profileName;
            String propName = (String)prop.getKey();
            if (!propName.endsWith(".pkglist") || profiles.containsKey(profileName = propName.substring(0, propName.length() - 8))) continue;
            ExecutionEnvironmentProfileProvider.loadProfile(props, profiles, profileName);
        }
        return profiles;
    }

    private static ExecutionEnvironmentProfile loadProfile(Properties props, Map<String, ExecutionEnvironmentProfile> profiles, String name) {
        ExecutionEnvironmentProfile profile = new ExecutionEnvironmentProfile(name);
        String extendedProfileName = props.getProperty(name + ".extends");
        if (extendedProfileName != null) {
            ExecutionEnvironmentProfile extendedProfile = profiles.get(extendedProfileName);
            if (extendedProfile == null) {
                extendedProfile = ExecutionEnvironmentProfileProvider.loadProfile(props, profiles, extendedProfileName);
            }
            profile.pkgNames.addAll(extendedProfile.pkgNames);
        }
        String pkgList = props.getProperty(name + ".pkglist");
        String[] packages = pkgList.split(",");
        for (int i = 0; i < packages.length; ++i) {
            String pkg = packages[i].trim();
            if (pkg.length() == 0) continue;
            profile.pkgNames.add(pkg);
        }
        profiles.put(name, profile);
        String aliasList = props.getProperty(name + ".aliases");
        if (aliasList != null) {
            String[] aliases = aliasList.split(",");
            for (int i = 0; i < aliases.length; ++i) {
                String alias = aliases[i].trim();
                if (alias.length() == 0) continue;
                ExecutionEnvironmentProfile profileAlias = new ExecutionEnvironmentProfile(alias);
                profileAlias.pkgNames = profile.pkgNames;
                profiles.put(alias, profileAlias);
            }
        }
        Message.verbose("Execution environment profile " + profile.getName() + " loaded");
        return profile;
    }

    static {
        try {
            INSTANCE = new ExecutionEnvironmentProfileProvider();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

