/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.inline;

import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.PropertyGetterDescriptor;
import org.jetbrains.kotlin.descriptors.PropertySetterDescriptor;
import org.jetbrains.kotlin.js.backend.ast.JsBinaryOperation;
import org.jetbrains.kotlin.js.backend.ast.JsBinaryOperator;
import org.jetbrains.kotlin.js.backend.ast.JsContext;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsInvocation;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.JsNode;
import org.jetbrains.kotlin.js.backend.ast.JsVisitorWithContextImpl;
import org.jetbrains.kotlin.js.backend.ast.metadata.MetadataProperties;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J \u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000b2\u000e\u0010\f\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u000e0\rH\u0016J \u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u00062\u000e\u0010\f\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u000e0\rH\u0016J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\b2\u0006\u0010\n\u001a\u00020\u0006H\u0002J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\b2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/js/inline/DummyAccessorInvocationTransformer;", "Lorg/jetbrains/kotlin/js/backend/ast/JsVisitorWithContextImpl;", "()V", "copyInlineMetadata", "", "from", "Lorg/jetbrains/kotlin/js/backend/ast/JsNameRef;", "to", "Lorg/jetbrains/kotlin/js/backend/ast/JsInvocation;", "endVisit", "x", "Lorg/jetbrains/kotlin/js/backend/ast/JsBinaryOperation;", "ctx", "Lorg/jetbrains/kotlin/js/backend/ast/JsContext;", "Lorg/jetbrains/kotlin/js/backend/ast/JsNode;", "tryCreatePropertyGetterInvocation", "tryCreatePropertySetterInvocation", "js.translator"})
public final class DummyAccessorInvocationTransformer
extends JsVisitorWithContextImpl {
    public void endVisit(@NotNull JsNameRef x, @NotNull JsContext<? super JsNode> ctx) {
        Intrinsics.checkParameterIsNotNull(x, "x");
        Intrinsics.checkParameterIsNotNull(ctx, "ctx");
        super.endVisit(x, ctx);
        JsInvocation dummy = this.tryCreatePropertyGetterInvocation(x);
        if (dummy != null) {
            ctx.replaceMe((JsNode)dummy);
        }
    }

    public void endVisit(@NotNull JsBinaryOperation x, @NotNull JsContext<? super JsNode> ctx) {
        Intrinsics.checkParameterIsNotNull(x, "x");
        Intrinsics.checkParameterIsNotNull(ctx, "ctx");
        super.endVisit(x, ctx);
        JsInvocation dummy = this.tryCreatePropertySetterInvocation(x);
        if (dummy != null) {
            ctx.replaceMe((JsNode)dummy);
        }
    }

    private final JsInvocation tryCreatePropertyGetterInvocation(JsNameRef x) {
        if (MetadataProperties.getInlineStrategy(x) != null && MetadataProperties.getDescriptor(x) instanceof PropertyGetterDescriptor) {
            JsInvocation dummyInvocation = new JsInvocation((JsExpression)x, new JsExpression[0]);
            this.copyInlineMetadata(x, dummyInvocation);
            return dummyInvocation;
        }
        return null;
    }

    private final JsInvocation tryCreatePropertySetterInvocation(JsBinaryOperation x) {
        JsBinaryOperator jsBinaryOperator = x.getOperator();
        Intrinsics.checkExpressionValueIsNotNull(jsBinaryOperator, "x.operator");
        if (!jsBinaryOperator.isAssignment() || !(x.getArg1() instanceof JsNameRef)) {
            return null;
        }
        JsExpression jsExpression = x.getArg1();
        if (jsExpression == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.js.backend.ast.JsNameRef");
        }
        JsNameRef name = (JsNameRef)jsExpression;
        if (MetadataProperties.getInlineStrategy(name) != null && MetadataProperties.getDescriptor(name) instanceof PropertySetterDescriptor) {
            JsInvocation dummyInvocation = new JsInvocation((JsExpression)name, x.getArg2());
            this.copyInlineMetadata(name, dummyInvocation);
            return dummyInvocation;
        }
        return null;
    }

    private final void copyInlineMetadata(JsNameRef from, JsInvocation to) {
        MetadataProperties.setInlineStrategy(to, MetadataProperties.getInlineStrategy(from));
        MetadataProperties.setDescriptor(to, MetadataProperties.getDescriptor(from));
        MetadataProperties.setPsiElement(to, MetadataProperties.getPsiElement(from));
    }
}

