/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import com.intellij.psi.PsiElement;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptorWithResolutionScopes;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptorWithTypeParameters;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptorNonRoot;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptorWithVisibility;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.MemberDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.ScriptDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.SourceFile;
import org.jetbrains.kotlin.descriptors.TypeAliasDescriptor;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.diagnostics.ParametrizedDiagnostic;
import org.jetbrains.kotlin.idea.MainFunctionDetector;
import org.jetbrains.kotlin.incremental.components.NoLookupLocation;
import org.jetbrains.kotlin.name.FqNameUnsafe;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.BodiesResolveContext;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.MultiTargetPlatformKt;
import org.jetbrains.kotlin.resolve.OverloadChecker;
import org.jetbrains.kotlin.resolve.OverloadFilter;
import org.jetbrains.kotlin.resolve.scopes.MemberScope;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\f\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u0016\u0010\r\u001a\u00020\n2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0002J\u001e\u0010\r\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u000fH\u0002J\u0016\u0010\u0015\u001a\u00020\n2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00160\u000fH\u0002J\u0010\u0010\u0017\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002JS\u0010\u0018\u001a\u00020\n2\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u00160\u001a2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001d0\u000f2\u0006\u0010\u0004\u001a\u00020\u00052\u001e\u0010\u001e\u001a\u001a\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020!\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00160\u000f0\u001fH\u0082\bJ\u001c\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020#\u0012\u0004\u0012\u00020\u00140\u001a2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u001c\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00160\u000f2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00160\u000fH\u0002J?\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00160\u000f2\u0006\u0010&\u001a\u00020\u001d2\u0006\u0010\u0004\u001a\u00020\u00052\u001e\u0010\u001e\u001a\u001a\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020!\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00160\u000f0\u001fH\u0082\bJ\"\u0010'\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00160\u000f0\u000f2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00160\u000fH\u0002J$\u0010(\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u00160\u001a2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J\u0018\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020\u001d2\u0006\u0010,\u001a\u00020\u001dH\u0002J\u0018\u0010-\u001a\u00020*2\u0006\u0010+\u001a\u00020\u00162\u0006\u0010,\u001a\u00020\u0016H\u0002J\u0018\u0010.\u001a\u00020*2\u0006\u0010/\u001a\u00020\u001d2\u0006\u00100\u001a\u00020\u001dH\u0002J\u0018\u00101\u001a\u00020*2\u0006\u0010+\u001a\u00020\u001d2\u0006\u0010,\u001a\u00020\u001dH\u0002J\u0016\u00102\u001a\u00020\n2\f\u00103\u001a\b\u0012\u0004\u0012\u00020\u00160\u000fH\u0002J\f\u00104\u001a\u00020**\u00020\u001dH\u0002J\f\u00105\u001a\u00020**\u00020\u001dH\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00066"}, d2={"Lorg/jetbrains/kotlin/resolve/OverloadResolver;", "", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "overloadFilter", "Lorg/jetbrains/kotlin/resolve/OverloadFilter;", "overloadChecker", "Lorg/jetbrains/kotlin/resolve/OverloadChecker;", "(Lorg/jetbrains/kotlin/resolve/BindingTrace;Lorg/jetbrains/kotlin/resolve/OverloadFilter;Lorg/jetbrains/kotlin/resolve/OverloadChecker;)V", "checkOverloads", "", "c", "Lorg/jetbrains/kotlin/resolve/BodiesResolveContext;", "checkOverloadsInClass", "members", "", "Lorg/jetbrains/kotlin/descriptors/CallableMemberDescriptor;", "classDescriptor", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptorWithResolutionScopes;", "nestedClassConstructors", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "checkOverloadsInPackage", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptorNonRoot;", "checkOverloadsInPackages", "collectModulePackageMembersWithSameName", "packageMembersByName", "Lcom/intellij/util/containers/MultiMap;", "Lorg/jetbrains/kotlin/name/FqNameUnsafe;", "interestingDescriptors", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "getMembersByName", "Lkotlin/Function2;", "Lorg/jetbrains/kotlin/resolve/scopes/MemberScope;", "Lorg/jetbrains/kotlin/name/Name;", "findConstructorsInNestedClassesAndTypeAliases", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "findRedeclarations", "getModulePackageMembersWithSameName", "descriptor", "getPossibleRedeclarationGroups", "groupModulePackageMembersByFqName", "isConstructorsOfDifferentRedeclaredClasses", "", "member1", "member2", "isDefinitionsForDifferentPlatforms", "isExpectDeclarationAndDefinition", "declaration", "definition", "isTopLevelMainInDifferentFiles", "reportRedeclarations", "redeclarations", "isPrivate", "isSynthesized", "frontend"})
public final class OverloadResolver {
    private final BindingTrace trace;
    private final OverloadFilter overloadFilter;
    private final OverloadChecker overloadChecker;

    public final void checkOverloads(@NotNull BodiesResolveContext c) {
        Intrinsics.checkParameterIsNotNull(c, "c");
        MultiMap<ClassDescriptor, FunctionDescriptor> inClasses = this.findConstructorsInNestedClassesAndTypeAliases(c);
        Iterator<ClassDescriptorWithResolutionScopes> iterator2 = c.getDeclaredClasses().values().iterator();
        while (iterator2.hasNext()) {
            ClassDescriptorWithResolutionScopes value;
            ClassDescriptorWithResolutionScopes classDescriptorWithResolutionScopes = value = iterator2.next();
            Intrinsics.checkExpressionValueIsNotNull(classDescriptorWithResolutionScopes, "value");
            Collection<FunctionDescriptor> collection = inClasses.get(value);
            Intrinsics.checkExpressionValueIsNotNull(collection, "inClasses.get(value)");
            this.checkOverloadsInClass(classDescriptorWithResolutionScopes, collection);
        }
        this.checkOverloadsInPackages(c);
    }

    private final MultiMap<ClassDescriptor, FunctionDescriptor> findConstructorsInNestedClassesAndTypeAliases(BodiesResolveContext c) {
        DeclarationDescriptor containingDeclaration;
        MultiMap<ClassDescriptor, FunctionDescriptor> constructorsByOuterClass = MultiMap.create();
        Iterator<ClassifierDescriptorWithTypeParameters> iterator2 = c.getDeclaredClasses().values().iterator();
        while (iterator2.hasNext()) {
            ClassDescriptorWithResolutionScopes klass2;
            ClassDescriptorWithResolutionScopes classDescriptorWithResolutionScopes = klass2 = iterator2.next();
            Intrinsics.checkExpressionValueIsNotNull(classDescriptorWithResolutionScopes, "klass");
            ClassKind classKind = classDescriptorWithResolutionScopes.getKind();
            Intrinsics.checkExpressionValueIsNotNull((Object)classKind, "klass.kind");
            if (classKind.isSingleton()) continue;
            Name name = klass2.getName();
            Intrinsics.checkExpressionValueIsNotNull(name, "klass.name");
            if (name.isSpecial() || (containingDeclaration = klass2.getContainingDeclaration()) instanceof ScriptDescriptor) continue;
            if (containingDeclaration instanceof ClassDescriptor) {
                constructorsByOuterClass.putValues((ClassDescriptor)containingDeclaration, klass2.getConstructors());
                continue;
            }
            if (containingDeclaration instanceof FunctionDescriptor || containingDeclaration instanceof PropertyDescriptor || containingDeclaration instanceof PackageFragmentDescriptor) continue;
            throw (Throwable)new IllegalStateException("Illegal class container: " + containingDeclaration);
        }
        iterator2 = c.getTypeAliases().values().iterator();
        while (iterator2.hasNext()) {
            TypeAliasDescriptor typeAlias;
            TypeAliasDescriptor typeAliasDescriptor = typeAlias = (TypeAliasDescriptor)iterator2.next();
            Intrinsics.checkExpressionValueIsNotNull(typeAliasDescriptor, "typeAlias");
            containingDeclaration = typeAliasDescriptor.getContainingDeclaration();
            if (!(containingDeclaration instanceof ClassDescriptor)) continue;
            constructorsByOuterClass.putValues((ClassDescriptor)containingDeclaration, typeAlias.getConstructors());
        }
        MultiMap<ClassDescriptor, FunctionDescriptor> multiMap = constructorsByOuterClass;
        Intrinsics.checkExpressionValueIsNotNull(multiMap, "constructorsByOuterClass");
        return multiMap;
    }

    private final void checkOverloadsInPackages(BodiesResolveContext c) {
        MultiMap<FqNameUnsafe, DeclarationDescriptorNonRoot> membersByName = this.groupModulePackageMembersByFqName(c, this.overloadFilter);
        for (Map.Entry<FqNameUnsafe, Collection<DeclarationDescriptorNonRoot>> e : membersByName.entrySet()) {
            Collection<DeclarationDescriptorNonRoot> collection = e.getValue();
            Intrinsics.checkExpressionValueIsNotNull(collection, "e.value");
            this.checkOverloadsInPackage(collection);
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final MultiMap<FqNameUnsafe, DeclarationDescriptorNonRoot> groupModulePackageMembersByFqName(BodiesResolveContext c, OverloadFilter overloadFilter) {
        Iterable $receiver$iv$iv$iv;
        ClassifierDescriptor classifier2;
        Name name;
        Object scope;
        Object containingPackageScope$iv$iv;
        ModuleDescriptor containingModule$iv$iv;
        DeclarationDescriptor containingPackage$iv$iv;
        OverloadResolver this_$iv$iv;
        OverloadResolver this_$iv;
        FqNameUnsafe descriptorFQN$iv;
        Collection<PropertyDescriptor> interestingDescriptors$iv;
        MultiMap<FqNameUnsafe, DeclarationDescriptorNonRoot> packageMembersByName = new MultiMap<FqNameUnsafe, DeclarationDescriptorNonRoot>();
        OverloadResolver overloadResolver = this;
        Collection<SimpleFunctionDescriptor> collection = c.getFunctions().values();
        if (collection == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.Collection<org.jetbrains.kotlin.descriptors.DeclarationDescriptor>");
        }
        Collection collection2 = CollectionsKt.plus((Collection)CollectionsKt.plus(collection, (Iterable)c.getDeclaredClasses().values()), (Iterable)c.getTypeAliases().values());
        HashSet<FqNameUnsafe> observedFQNs$iv = new HashSet<FqNameUnsafe>();
        for (DeclarationDescriptor declarationDescriptor : interestingDescriptors$iv) {
            Collection<DeclarationDescriptorNonRoot> collection3;
            if (!(declarationDescriptor.getContainingDeclaration() instanceof PackageFragmentDescriptor) || observedFQNs$iv.contains(descriptorFQN$iv = DescriptorUtils.getFqName(declarationDescriptor))) continue;
            observedFQNs$iv.add(descriptorFQN$iv);
            this_$iv$iv = this_$iv;
            containingPackage$iv$iv = declarationDescriptor.getContainingDeclaration();
            if (!(containingPackage$iv$iv instanceof PackageFragmentDescriptor)) {
                throw (Throwable)((Object)new AssertionError((Object)(declarationDescriptor + " is not a top-level package member")));
            }
            if (DescriptorUtils.getContainingModuleOrNull(declarationDescriptor) == null) {
                DeclarationDescriptor declarationDescriptor2 = declarationDescriptor;
                if (declarationDescriptor2 instanceof CallableMemberDescriptor) {
                    collection3 = (Collection<ClassConstructorDescriptor>)CollectionsKt.listOf(declarationDescriptor);
                } else {
                    if (!(declarationDescriptor2 instanceof ClassDescriptor)) throw (Throwable)((Object)new AssertionError((Object)("Unexpected descriptor kind: " + declarationDescriptor)));
                    Collection<ClassConstructorDescriptor> collection4 = ((ClassDescriptor)declarationDescriptor).getConstructors();
                    collection3 = collection4;
                    Intrinsics.checkExpressionValueIsNotNull(collection4, "descriptor.constructors");
                }
            } else {
                void $receiver$iv$iv$iv$iv;
                Collection collection5;
                containingPackageScope$iv$iv = containingModule$iv$iv.getPackage(((PackageFragmentDescriptor)containingPackage$iv$iv).getFqName()).getMemberScope();
                Intrinsics.checkExpressionValueIsNotNull(declarationDescriptor.getName(), "descriptor.name");
                scope = containingPackageScope$iv$iv;
                Collection functions2 = scope.getContributedFunctions(name, NoLookupLocation.WHEN_CHECK_DECLARATION_CONFLICTS);
                ClassifierDescriptor classifierDescriptor = classifier2 = scope.getContributedClassifier(name, NoLookupLocation.WHEN_CHECK_DECLARATION_CONFLICTS);
                if (classifierDescriptor instanceof ClassDescriptor) {
                    ClassKind classKind = ((ClassDescriptor)classifier2).getKind();
                    Intrinsics.checkExpressionValueIsNotNull((Object)classKind, "classifier.kind");
                    if (!classKind.isSingleton()) {
                        Collection<ClassConstructorDescriptor> collection6 = ((ClassDescriptor)classifier2).getConstructors();
                        Intrinsics.checkExpressionValueIsNotNull(collection6, "classifier.constructors");
                        collection5 = CollectionsKt.plus(functions2, (Iterable)collection6);
                    } else {
                        collection5 = functions2;
                    }
                } else {
                    collection5 = classifierDescriptor instanceof TypeAliasDescriptor ? (Collection)CollectionsKt.plus(functions2, (Iterable)((TypeAliasDescriptor)classifier2).getConstructors()) : functions2;
                }
                Iterable iterable = $receiver$iv$iv$iv = (Iterable)collection5;
                Collection destination$iv$iv$iv$iv = new ArrayList();
                for (Object element$iv$iv$iv$iv : $receiver$iv$iv$iv$iv) {
                    DeclarationDescriptorNonRoot it$iv$iv = (DeclarationDescriptorNonRoot)element$iv$iv$iv$iv;
                    if (!Intrinsics.areEqual(DescriptorUtils.getContainingModule(it$iv$iv), containingModule$iv$iv)) continue;
                    destination$iv$iv$iv$iv.add(element$iv$iv$iv$iv);
                }
                List possibleOverloads$iv$iv = (List)destination$iv$iv$iv$iv;
                collection3 = overloadFilter.filterPackageMemberOverloads(possibleOverloads$iv$iv);
            }
            Collection<ClassConstructorDescriptor> packageMembersWithSameName$iv = collection3;
            packageMembersByName.putValues(descriptorFQN$iv, packageMembersWithSameName$iv);
        }
        this_$iv = this;
        interestingDescriptors$iv = c.getProperties().values();
        observedFQNs$iv = new HashSet();
        for (DeclarationDescriptor declarationDescriptor : interestingDescriptors$iv) {
            Collection<DeclarationDescriptorNonRoot> collection7;
            if (!(declarationDescriptor.getContainingDeclaration() instanceof PackageFragmentDescriptor) || observedFQNs$iv.contains(descriptorFQN$iv = DescriptorUtils.getFqName(declarationDescriptor))) continue;
            observedFQNs$iv.add(descriptorFQN$iv);
            this_$iv$iv = this_$iv;
            containingPackage$iv$iv = declarationDescriptor.getContainingDeclaration();
            if (!(containingPackage$iv$iv instanceof PackageFragmentDescriptor)) {
                throw (Throwable)((Object)new AssertionError((Object)(declarationDescriptor + " is not a top-level package member")));
            }
            if (DescriptorUtils.getContainingModuleOrNull(declarationDescriptor) == null) {
                containingPackageScope$iv$iv = declarationDescriptor;
                if (containingPackageScope$iv$iv instanceof CallableMemberDescriptor) {
                    collection7 = (Collection<ClassConstructorDescriptor>)CollectionsKt.listOf(declarationDescriptor);
                } else {
                    if (!(containingPackageScope$iv$iv instanceof ClassDescriptor)) throw (Throwable)((Object)new AssertionError((Object)("Unexpected descriptor kind: " + declarationDescriptor)));
                    Collection<ClassConstructorDescriptor> collection8 = ((ClassDescriptor)declarationDescriptor).getConstructors();
                    collection7 = collection8;
                    Intrinsics.checkExpressionValueIsNotNull(collection8, "descriptor.constructors");
                }
            } else {
                void $receiver$iv$iv$iv$iv;
                Iterable $receiver$iv$iv$iv2;
                containingPackageScope$iv$iv = containingModule$iv$iv.getPackage(((PackageFragmentDescriptor)containingPackage$iv$iv).getFqName()).getMemberScope();
                Intrinsics.checkExpressionValueIsNotNull(declarationDescriptor.getName(), "descriptor.name");
                scope = containingPackageScope$iv$iv;
                Collection<PropertyDescriptor> variables = scope.getContributedVariables(name, NoLookupLocation.WHEN_CHECK_DECLARATION_CONFLICTS);
                classifier2 = scope.getContributedClassifier(name, NoLookupLocation.WHEN_CHECK_DECLARATION_CONFLICTS);
                $receiver$iv$iv$iv = $receiver$iv$iv$iv2 = (Iterable)CollectionsKt.plus(variables, (Iterable)CollectionsKt.listOfNotNull(classifier2));
                Collection destination$iv$iv$iv$iv = new ArrayList();
                for (Object element$iv$iv$iv$iv : $receiver$iv$iv$iv$iv) {
                    DeclarationDescriptorNonRoot it$iv$iv = (DeclarationDescriptorNonRoot)element$iv$iv$iv$iv;
                    if (!Intrinsics.areEqual(DescriptorUtils.getContainingModule(it$iv$iv), containingModule$iv$iv)) continue;
                    destination$iv$iv$iv$iv.add(element$iv$iv$iv$iv);
                }
                List possibleOverloads$iv$iv = (List)destination$iv$iv$iv$iv;
                collection7 = overloadFilter.filterPackageMemberOverloads(possibleOverloads$iv$iv);
            }
            Collection<ClassConstructorDescriptor> packageMembersWithSameName$iv = collection7;
            packageMembersByName.putValues(descriptorFQN$iv, packageMembersWithSameName$iv);
        }
        return packageMembersByName;
    }

    /*
     * WARNING - void declaration
     */
    private final Collection<DeclarationDescriptorNonRoot> getModulePackageMembersWithSameName(DeclarationDescriptor descriptor2, OverloadFilter overloadFilter, Function2<? super MemberScope, ? super Name, ? extends Collection<? extends DeclarationDescriptorNonRoot>> getMembersByName) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        DeclarationDescriptor containingPackage = descriptor2.getContainingDeclaration();
        if (!(containingPackage instanceof PackageFragmentDescriptor)) {
            throw (Throwable)((Object)new AssertionError((Object)(descriptor2 + " is not a top-level package member")));
        }
        ModuleDescriptor moduleDescriptor = DescriptorUtils.getContainingModuleOrNull(descriptor2);
        if (moduleDescriptor == null) {
            Collection<ClassConstructorDescriptor> collection;
            DeclarationDescriptor declarationDescriptor = descriptor2;
            if (declarationDescriptor instanceof CallableMemberDescriptor) {
                collection = (Collection<ClassConstructorDescriptor>)CollectionsKt.listOf(descriptor2);
            } else if (declarationDescriptor instanceof ClassDescriptor) {
                Collection<ClassConstructorDescriptor> collection2 = ((ClassDescriptor)descriptor2).getConstructors();
                collection = collection2;
                Intrinsics.checkExpressionValueIsNotNull(collection2, "descriptor.constructors");
            } else {
                throw (Throwable)((Object)new AssertionError((Object)("Unexpected descriptor kind: " + descriptor2)));
            }
            return collection;
        }
        ModuleDescriptor containingModule = moduleDescriptor;
        MemberScope containingPackageScope = containingModule.getPackage(((PackageFragmentDescriptor)containingPackage).getFqName()).getMemberScope();
        Name name = descriptor2.getName();
        Intrinsics.checkExpressionValueIsNotNull(name, "descriptor.name");
        Iterable iterable = $receiver$iv = (Iterable)getMembersByName.invoke(containingPackageScope, name);
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            DeclarationDescriptorNonRoot it = (DeclarationDescriptorNonRoot)element$iv$iv;
            if (!Intrinsics.areEqual(DescriptorUtils.getContainingModule(it), containingModule)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List possibleOverloads = (List)destination$iv$iv;
        return overloadFilter.filterPackageMemberOverloads(possibleOverloads);
    }

    private final void checkOverloadsInClass(ClassDescriptorWithResolutionScopes classDescriptor, Collection<? extends FunctionDescriptor> nestedClassConstructors) {
        MultiMap<Name, CallableMemberDescriptor> functionsByName = MultiMap.create();
        Iterator<Object> iterator2 = classDescriptor.getDeclaredCallableMembers().iterator();
        while (iterator2.hasNext()) {
            CallableMemberDescriptor callableMemberDescriptor;
            CallableMemberDescriptor callableMemberDescriptor2 = callableMemberDescriptor = iterator2.next();
            Intrinsics.checkExpressionValueIsNotNull(callableMemberDescriptor2, "function");
            functionsByName.putValue(callableMemberDescriptor2.getName(), callableMemberDescriptor);
        }
        for (FunctionDescriptor functionDescriptor : nestedClassConstructors) {
            DeclarationDescriptor declarationDescriptor = functionDescriptor.getContainingDeclaration();
            Intrinsics.checkExpressionValueIsNotNull(declarationDescriptor, "nestedConstructor.containingDeclaration");
            Name name = declarationDescriptor.getName();
            functionsByName.putValue(name, functionDescriptor);
        }
        for (Map.Entry entry : functionsByName.entrySet()) {
            Object v2 = entry.getValue();
            Intrinsics.checkExpressionValueIsNotNull(v2, "e.value");
            this.checkOverloadsInClass((Collection)v2);
        }
    }

    private final void checkOverloadsInPackage(Collection<? extends DeclarationDescriptorNonRoot> members) {
        Object $receiver$iv;
        if (members.size() == 1) {
            return;
        }
        LinkedHashMap redeclarationsMap = new LinkedHashMap();
        Object object = this.getPossibleRedeclarationGroups(members).iterator();
        while (object.hasNext()) {
            Collection<DeclarationDescriptorNonRoot> redeclarationGroup = object.next();
            Collection<DeclarationDescriptorNonRoot> redeclarations = this.findRedeclarations(redeclarationGroup);
            $receiver$iv = redeclarations;
            Iterator iterator2 = $receiver$iv.iterator();
            while (iterator2.hasNext()) {
                Object object2;
                Map $receiver$iv2 = redeclarationsMap;
                Object element$iv = iterator2.next();
                DeclarationDescriptorNonRoot it = (DeclarationDescriptorNonRoot)element$iv;
                Object value$iv = $receiver$iv2.get(it);
                if (value$iv == null) {
                    Set answer$iv = new LinkedHashSet();
                    $receiver$iv2.put(it, answer$iv);
                    object2 = answer$iv;
                } else {
                    object2 = value$iv;
                }
                ((Set)object2).addAll(redeclarations);
            }
        }
        HashSet reported = new HashSet();
        $receiver$iv = redeclarationsMap;
        Iterator iterator3 = $receiver$iv.entrySet().iterator();
        while (iterator3.hasNext()) {
            Object object3 = object = iterator3.next();
            DeclarationDescriptorNonRoot member = (DeclarationDescriptorNonRoot)object3.getKey();
            object3 = object;
            Set conflicting = (Set)object3.getValue();
            if (reported.contains(member)) continue;
            reported.addAll(conflicting);
            this.reportRedeclarations(conflicting);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final Collection<Collection<DeclarationDescriptorNonRoot>> getPossibleRedeclarationGroups(Collection<? extends DeclarationDescriptorNonRoot> members) {
        void $receiver$iv$iv;
        Object element$iv$iv2;
        void $receiver$iv$iv2;
        Iterable $receiver$iv;
        ArrayList<Collection<Object>> result2 = new ArrayList<Collection<Object>>();
        Iterable iterable = $receiver$iv = (Iterable)members;
        Iterable destination$iv$iv = new ArrayList();
        for (Object element$iv$iv2 : $receiver$iv$iv2) {
            DeclarationDescriptorNonRoot it = (DeclarationDescriptorNonRoot)element$iv$iv2;
            if (!(!this.isPrivate(it))) continue;
            destination$iv$iv.add(element$iv$iv2);
        }
        List nonPrivates = (List)destination$iv$iv;
        Iterable $receiver$iv2 = members;
        destination$iv$iv = $receiver$iv2;
        Map destination$iv$iv2 = new LinkedHashMap();
        element$iv$iv2 = $receiver$iv$iv.iterator();
        while (element$iv$iv2.hasNext()) {
            Object object;
            Map $receiver$iv$iv$iv = destination$iv$iv2;
            Object element$iv$iv3 = element$iv$iv2.next();
            DeclarationDescriptorNonRoot it = (DeclarationDescriptorNonRoot)element$iv$iv3;
            SourceFile key$iv$iv = DescriptorUtils.getContainingSourceFile(it);
            Object value$iv$iv$iv = $receiver$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                ArrayList answer$iv$iv$iv = new ArrayList();
                $receiver$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv3);
        }
        Map bySourceFile = destination$iv$iv2;
        boolean hasGroupIncludingNonPrivateMembers = false;
        for (List membersInFile : bySourceFile.values()) {
            boolean bl;
            block9: {
                Iterable $receiver$iv3 = membersInFile;
                if ($receiver$iv3 instanceof Collection && ((Collection)$receiver$iv3).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $receiver$iv3) {
                        DeclarationDescriptorNonRoot it = (DeclarationDescriptorNonRoot)element$iv;
                        if (!this.isPrivate(it)) continue;
                        bl = true;
                        break block9;
                    }
                    bl = false;
                }
            }
            if (!bl) continue;
            hasGroupIncludingNonPrivateMembers = true;
            Set group = SetsKt.plus((Set)new LinkedHashSet(nonPrivates), membersInFile);
            result2.add(group);
        }
        if (!hasGroupIncludingNonPrivateMembers && nonPrivates.size() > 1) {
            result2.add(nonPrivates);
        }
        return result2;
    }

    private final boolean isPrivate(@NotNull DeclarationDescriptor $receiver) {
        return $receiver instanceof DeclarationDescriptorWithVisibility && Visibilities.isPrivate(((DeclarationDescriptorWithVisibility)$receiver).getVisibility());
    }

    private final void checkOverloadsInClass(Collection<? extends CallableMemberDescriptor> members) {
        if (members.size() == 1) {
            return;
        }
        this.reportRedeclarations(this.findRedeclarations(members));
    }

    private final boolean isSynthesized(@NotNull DeclarationDescriptor $receiver) {
        return $receiver instanceof CallableMemberDescriptor && ((CallableMemberDescriptor)$receiver).getKind() == CallableMemberDescriptor.Kind.SYNTHESIZED;
    }

    private final Collection<DeclarationDescriptorNonRoot> findRedeclarations(Collection<? extends DeclarationDescriptorNonRoot> members) {
        LinkedHashSet<DeclarationDescriptorNonRoot> redeclarations = new LinkedHashSet<DeclarationDescriptorNonRoot>();
        for (DeclarationDescriptorNonRoot declarationDescriptorNonRoot : members) {
            if (this.isSynthesized(declarationDescriptorNonRoot)) continue;
            for (DeclarationDescriptorNonRoot declarationDescriptorNonRoot2 : members) {
                if (Intrinsics.areEqual(declarationDescriptorNonRoot, declarationDescriptorNonRoot2) || this.isConstructorsOfDifferentRedeclaredClasses(declarationDescriptorNonRoot, declarationDescriptorNonRoot2) || this.isTopLevelMainInDifferentFiles(declarationDescriptorNonRoot, declarationDescriptorNonRoot2) || this.isDefinitionsForDifferentPlatforms(declarationDescriptorNonRoot, declarationDescriptorNonRoot2) || this.isExpectDeclarationAndDefinition(declarationDescriptorNonRoot, declarationDescriptorNonRoot2) || this.isExpectDeclarationAndDefinition(declarationDescriptorNonRoot2, declarationDescriptorNonRoot) || this.overloadChecker.isOverloadable(declarationDescriptorNonRoot, declarationDescriptorNonRoot2)) continue;
                redeclarations.add(declarationDescriptorNonRoot);
            }
        }
        return redeclarations;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isConstructorsOfDifferentRedeclaredClasses(DeclarationDescriptor member1, DeclarationDescriptor member2) {
        ClassifierDescriptorWithTypeParameters parent2;
        if (!(member1 instanceof ConstructorDescriptor)) return false;
        if (!(member2 instanceof ConstructorDescriptor)) {
            return false;
        }
        ClassifierDescriptorWithTypeParameters parent1 = ((ConstructorDescriptor)member1).getContainingDeclaration();
        if (parent1 == (parent2 = ((ConstructorDescriptor)member2).getContainingDeclaration())) return false;
        ClassifierDescriptorWithTypeParameters classifierDescriptorWithTypeParameters = parent1;
        Intrinsics.checkExpressionValueIsNotNull(classifierDescriptorWithTypeParameters, "parent1");
        DeclarationDescriptor declarationDescriptor = classifierDescriptorWithTypeParameters.getContainingDeclaration();
        ClassifierDescriptorWithTypeParameters classifierDescriptorWithTypeParameters2 = parent2;
        Intrinsics.checkExpressionValueIsNotNull(classifierDescriptorWithTypeParameters2, "parent2");
        if (!Intrinsics.areEqual(declarationDescriptor, classifierDescriptorWithTypeParameters2.getContainingDeclaration())) return false;
        return true;
    }

    private final boolean isTopLevelMainInDifferentFiles(DeclarationDescriptor member1, DeclarationDescriptor member2) {
        if (!MainFunctionDetector.Companion.isMain$default(MainFunctionDetector.Companion, member1, false, false, 6, null) || !MainFunctionDetector.Companion.isMain$default(MainFunctionDetector.Companion, member2, false, false, 6, null)) {
            return false;
        }
        KtFile file1 = DescriptorToSourceUtils.getContainingFile(member1);
        KtFile file2 = DescriptorToSourceUtils.getContainingFile(member2);
        return file1 == null || file2 == null || file1 != file2;
    }

    private final boolean isExpectDeclarationAndDefinition(DeclarationDescriptor declaration, DeclarationDescriptor definition) {
        return declaration instanceof MemberDescriptor && ((MemberDescriptor)declaration).isExpect() && definition instanceof MemberDescriptor && !((MemberDescriptor)definition).isExpect();
    }

    private final boolean isDefinitionsForDifferentPlatforms(DeclarationDescriptorNonRoot member1, DeclarationDescriptorNonRoot member2) {
        if (!(member1 instanceof MemberDescriptor) || !(member2 instanceof MemberDescriptor)) {
            return false;
        }
        return ((MemberDescriptor)member1).isActual() && ((MemberDescriptor)member2).isActual() && Intrinsics.areEqual(MultiTargetPlatformKt.getMultiTargetPlatform((MemberDescriptor)member1), MultiTargetPlatformKt.getMultiTargetPlatform((MemberDescriptor)member2)) ^ true;
    }

    private final void reportRedeclarations(Collection<? extends DeclarationDescriptorNonRoot> redeclarations) {
        if (redeclarations.isEmpty()) {
            return;
        }
        for (DeclarationDescriptorNonRoot declarationDescriptorNonRoot : redeclarations) {
            Diagnostic diagnostic;
            PsiElement it;
            BindingTrace bindingTrace;
            PsiElement psiElement;
            PsiElement psiElement$iv;
            BindingTrace trace$iv;
            DeclarationDescriptorNonRoot declarationDescriptorNonRoot2 = declarationDescriptorNonRoot;
            if (declarationDescriptorNonRoot2 instanceof PropertyDescriptor || declarationDescriptorNonRoot2 instanceof ClassifierDescriptor) {
                trace$iv = this.trace;
                if (DescriptorToSourceUtils.descriptorToDeclaration(declarationDescriptorNonRoot) != null) {
                    PsiElement psiElement2 = psiElement$iv = psiElement;
                    bindingTrace = trace$iv;
                    ParametrizedDiagnostic<PsiElement> parametrizedDiagnostic = Errors.REDECLARATION.on(it, redeclarations);
                    Intrinsics.checkExpressionValueIsNotNull(parametrizedDiagnostic, "Errors.REDECLARATION.on(it, redeclarations)");
                    diagnostic = parametrizedDiagnostic;
                    bindingTrace.report(diagnostic);
                }
                continue;
            }
            if (!(declarationDescriptorNonRoot2 instanceof FunctionDescriptor)) continue;
            trace$iv = this.trace;
            if (DescriptorToSourceUtils.descriptorToDeclaration(declarationDescriptorNonRoot) == null) continue;
            it = psiElement$iv = psiElement;
            bindingTrace = trace$iv;
            ParametrizedDiagnostic<PsiElement> parametrizedDiagnostic = Errors.CONFLICTING_OVERLOADS.on(it, redeclarations);
            Intrinsics.checkExpressionValueIsNotNull(parametrizedDiagnostic, "Errors.CONFLICTING_OVERL\u2026DS.on(it, redeclarations)");
            diagnostic = parametrizedDiagnostic;
            bindingTrace.report(diagnostic);
        }
    }

    public OverloadResolver(@NotNull BindingTrace trace, @NotNull OverloadFilter overloadFilter, @NotNull OverloadChecker overloadChecker) {
        Intrinsics.checkParameterIsNotNull(trace, "trace");
        Intrinsics.checkParameterIsNotNull(overloadFilter, "overloadFilter");
        Intrinsics.checkParameterIsNotNull(overloadChecker, "overloadChecker");
        this.trace = trace;
        this.overloadFilter = overloadFilter;
        this.overloadChecker = overloadChecker;
    }

    @NotNull
    public static final /* synthetic */ Collection access$getModulePackageMembersWithSameName(OverloadResolver $this, @NotNull DeclarationDescriptor descriptor2, @NotNull OverloadFilter overloadFilter, @NotNull Function2 getMembersByName) {
        return $this.getModulePackageMembersWithSameName(descriptor2, overloadFilter, getMembersByName);
    }
}

