/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.compiled;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.BinaryFileDecompiler;
import com.intellij.openapi.project.DefaultProjectFactory;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.compiled.ClassFileDecompilers;
import com.intellij.psi.impl.compiled.ClsDecompilerImpl;
import com.intellij.psi.impl.compiled.ClsFileImpl;
import org.jetbrains.annotations.NotNull;

public class ClassFileDecompiler
implements BinaryFileDecompiler {
    private static final Logger LOG = Logger.getInstance(ClassFileDecompiler.class);

    @Override
    @NotNull
    public CharSequence decompile(@NotNull VirtualFile file2) {
        ClassFileDecompilers.Decompiler decompiler;
        if (file2 == null) {
            ClassFileDecompiler.$$$reportNull$$$0(0);
        }
        if ((decompiler = ClassFileDecompilers.getInstance().find(file2, ClassFileDecompilers.Decompiler.class)) instanceof ClsDecompilerImpl) {
            CharSequence charSequence = ClsFileImpl.decompile(file2);
            if (charSequence == null) {
                ClassFileDecompiler.$$$reportNull$$$0(1);
            }
            return charSequence;
        }
        if (decompiler instanceof ClassFileDecompilers.Full) {
            PsiManager manager = PsiManager.getInstance(DefaultProjectFactory.getInstance().getDefaultProject());
            CharSequence charSequence = ((ClassFileDecompilers.Full)decompiler).createFileViewProvider(file2, manager, true).getContents();
            if (charSequence == null) {
                ClassFileDecompiler.$$$reportNull$$$0(2);
            }
            return charSequence;
        }
        if (decompiler instanceof ClassFileDecompilers.Light) {
            CharSequence charSequence;
            try {
                charSequence = ((ClassFileDecompilers.Light)decompiler).getText(file2);
            }
            catch (ClassFileDecompilers.Light.CannotDecompileException e) {
                LOG.warn("decompiler: " + decompiler.getClass(), e);
                CharSequence charSequence2 = ClsFileImpl.decompile(file2);
                if (charSequence2 == null) {
                    ClassFileDecompiler.$$$reportNull$$$0(4);
                }
                return charSequence2;
            }
            if (charSequence == null) {
                ClassFileDecompiler.$$$reportNull$$$0(3);
            }
            return charSequence;
        }
        throw new IllegalStateException(decompiler.getClass().getName() + " should be on of " + ClassFileDecompilers.Full.class.getName() + " or " + ClassFileDecompilers.Light.class.getName());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/compiled/ClassFileDecompiler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/compiled/ClassFileDecompiler";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "decompile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "decompile";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

