/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.impl;

import com.intellij.lexer.Lexer;
import com.intellij.lexer.TokenList;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.ArrayUtil;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Experimental
public class TokenSequence
implements TokenList {
    private static final Logger LOG = Logger.getInstance(TokenSequence.class);
    private final CharSequence myText;
    final int[] lexStarts;
    final IElementType[] lexTypes;
    final int lexemeCount;

    TokenSequence(int[] lexStarts, IElementType[] lexTypes, int lexemeCount, CharSequence text) {
        this.lexStarts = lexStarts;
        this.lexTypes = lexTypes;
        this.lexemeCount = lexemeCount;
        this.myText = text;
        assert (lexemeCount < lexStarts.length);
        assert (lexemeCount < lexTypes.length);
    }

    void assertMatches(@NotNull CharSequence text, @NotNull Lexer lexer) {
        if (text == null) {
            TokenSequence.$$$reportNull$$$0(0);
        }
        if (lexer == null) {
            TokenSequence.$$$reportNull$$$0(1);
        }
        TokenSequence sequence2 = new Builder(text, lexer).performLexing();
        assert (this.lexemeCount == sequence2.lexemeCount);
        for (int j = 0; j <= this.lexemeCount; ++j) {
            if (sequence2.lexStarts[j] != this.lexStarts[j] || sequence2.lexTypes[j] != this.lexTypes[j]) assert (false);
        }
    }

    @NotNull
    public static TokenSequence performLexing(@NotNull CharSequence text, @NotNull Lexer lexer) {
        TokenList existing;
        if (text == null) {
            TokenSequence.$$$reportNull$$$0(2);
        }
        if (lexer == null) {
            TokenSequence.$$$reportNull$$$0(3);
        }
        if (lexer instanceof TokenList.WrappingLexer && (existing = ((TokenList.WrappingLexer)lexer).getTokens()) instanceof TokenSequence && Comparing.equal(text, ((TokenSequence)existing).myText)) {
            return new TokenSequence(((TokenSequence)existing).lexStarts, (IElementType[])((TokenSequence)existing).lexTypes.clone(), ((TokenSequence)existing).lexemeCount, text);
        }
        TokenSequence tokenSequence = new Builder(text, lexer).performLexing();
        if (tokenSequence == null) {
            TokenSequence.$$$reportNull$$$0(4);
        }
        return tokenSequence;
    }

    @Override
    public int getTokenCount() {
        return this.lexemeCount;
    }

    @Override
    @Nullable
    public IElementType getTokenType(int index) {
        if (index < 0 || index >= this.getTokenCount()) {
            return null;
        }
        return this.lexTypes[index];
    }

    @Override
    public int getTokenStart(int index) {
        return this.lexStarts[index];
    }

    @Override
    public int getTokenEnd(int index) {
        return this.lexStarts[index + 1];
    }

    @Override
    @NotNull
    public CharSequence getTokenizedText() {
        CharSequence charSequence = this.myText;
        if (charSequence == null) {
            TokenSequence.$$$reportNull$$$0(5);
        }
        return charSequence;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lexer";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/impl/TokenSequence";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/impl/TokenSequence";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "performLexing";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getTokenizedText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "assertMatches";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "performLexing";
                break;
            }
            case 4: 
            case 5: {
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private static class Builder {
        private final CharSequence myText;
        private final Lexer myLexer;
        private int[] myLexStarts;
        private IElementType[] myLexTypes;

        Builder(@NotNull CharSequence text, @NotNull Lexer lexer) {
            if (text == null) {
                Builder.$$$reportNull$$$0(0);
            }
            if (lexer == null) {
                Builder.$$$reportNull$$$0(1);
            }
            this.myText = text;
            this.myLexer = lexer;
            int approxLexCount = Math.max(10, this.myText.length() / 5);
            this.myLexStarts = new int[approxLexCount];
            this.myLexTypes = new IElementType[approxLexCount];
        }

        @NotNull
        TokenSequence performLexing() {
            IElementType type2;
            this.myLexer.start(this.myText);
            int i = 0;
            int offset2 = 0;
            while ((type2 = this.myLexer.getTokenType()) != null) {
                int tokenStart;
                if (i % 20 == 0) {
                    ProgressIndicatorProvider.checkCanceled();
                }
                if (i >= this.myLexTypes.length - 1) {
                    this.resizeLexemes(i * 3 / 2);
                }
                if ((tokenStart = this.myLexer.getTokenStart()) < offset2) {
                    this.reportDescendingOffsets(i, offset2, tokenStart);
                }
                this.myLexStarts[i] = offset2 = tokenStart;
                this.myLexTypes[i] = type2;
                ++i;
                this.myLexer.advance();
            }
            this.myLexStarts[i] = this.myText.length();
            return new TokenSequence(this.myLexStarts, this.myLexTypes, i, this.myText);
        }

        private void reportDescendingOffsets(int tokenIndex, int offset2, int tokenStart) {
            @NonNls StringBuilder sb = new StringBuilder();
            IElementType tokenType = this.myLexer.getTokenType();
            sb.append("Token sequence broken").append("\n  this: '").append(this.myLexer.getTokenText()).append("' (").append(tokenType).append(':').append(tokenType != null ? tokenType.getLanguage() : null).append(") ").append(tokenStart).append(":").append(this.myLexer.getTokenEnd());
            if (tokenIndex > 0) {
                int prevStart = this.myLexStarts[tokenIndex - 1];
                sb.append("\n  prev: '").append(this.myText.subSequence(prevStart, offset2)).append("' (").append(this.myLexTypes[tokenIndex - 1]).append(':').append(this.myLexTypes[tokenIndex - 1].getLanguage()).append(") ").append(prevStart).append(":").append(offset2);
            }
            int quoteStart = Math.max(tokenStart - 256, 0);
            int quoteEnd = Math.min(tokenStart + 256, this.myText.length());
            sb.append("\n  quote: [").append(quoteStart).append(':').append(quoteEnd).append("] '").append(this.myText.subSequence(quoteStart, quoteEnd)).append('\'');
            LOG.error(sb.toString());
        }

        private void resizeLexemes(int newSize) {
            this.myLexStarts = ArrayUtil.realloc(this.myLexStarts, newSize);
            this.myLexTypes = ArrayUtil.realloc(this.myLexTypes, newSize, IElementType.ARRAY_FACTORY);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "text";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "lexer";
                    break;
                }
            }
            objectArray[1] = "com/intellij/lang/impl/TokenSequence$Builder";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

