/*====================================================================

			  §ǡɤ߹

                                               K.Yamagami
                                               S.Kurohashi 93. 5.31

    $Id: read_rule.c,v 1.37 2008/02/11 09:37:09 kawahara Exp $
====================================================================*/
#include "knp.h"

extern REGEXPMRPHS *regexpmrphs_alloc();

/* global variable declaration */
HomoRule	HomoRuleArray[HomoRule_MAX];
int 	        CurHomoRuleSize = 0;

KoouRule	KoouRuleArray[KoouRule_MAX];
int		CurKoouRuleSize = 0;

DpndRule	DpndRuleArray[DpndRule_MAX];
int		CurDpndRuleSize = 0;

BnstRule 	ContRuleArray[ContRule_MAX];
int 	        ContRuleSize = 0;

void		*EtcRuleArray = NULL;
int		CurEtcRuleSize = 0;
int		ExistEtcRule = 0;

GeneralRuleType	*GeneralRuleArray = NULL;
int		GeneralRuleNum = 0;
int		GeneralRuleMax = 0;

extern int 	LineNo;
extern int 	LineNoForError;

/*==================================================================*/
void read_mrph_rule(char *file_name, MrphRule *rp, int *count, int max)
/*==================================================================*/
{
    FILE     *fp;
    CELL     *body_cell;

    /* ʣƥ롼ե뤬ꤵƤȤ */
    if (*count) {
	fprintf(stderr, ";; Mrph rule is duplicated (%s) !!\n", file_name);
	exit(1);
    }

    file_name = check_rule_filename(file_name);

    if ( (fp = fopen(file_name, "r")) == NULL ) {
	fprintf(stderr, ";; Cannot open file (%s) !!\n", file_name);
	exit(1);
    }

    if (OptDisplay == OPT_DEBUG) {
	fprintf(Outfp, "Reading %s ... ", file_name);
    }

    LineNo = 1;

    while (!s_feof(fp)) {
	LineNoForError = LineNo;

	body_cell = s_read(fp);
	store_regexpmrphs(&(rp->pre_pattern), car(body_cell));
	store_regexpmrphs(&(rp->self_pattern), car(cdr(body_cell)));
	store_regexpmrphs(&(rp->post_pattern), car(cdr(cdr(body_cell))));

	rp->f = NULL;
	list2feature(cdr(cdr(cdr(body_cell))), &(rp->f));

	if (++(*count) == max) {
	    fprintf(stderr, ";; Too many Rule for %s.\n", file_name);
	    exit(1);
	}
	
	rp++;
    }

    if (OptDisplay == OPT_DEBUG) {
	fputs("done.\n", Outfp);
    }

    free(file_name);    
    fclose(fp);
}

/*==================================================================*/
		     int case2num(char *cp)
/*==================================================================*/
{
    int i;

    for (i = 0; *Case_name[i]; i++)
	if (str_eq(cp, Case_name[i]))
	    return i;
    return -1;
}

/*==================================================================*/
		void read_koou_rule(char *file_name)
/*==================================================================*/
{
    FILE     *fp;
    CELL     *body_cell;
    KoouRule  *rp = KoouRuleArray;

    /* ʣƥ롼ե뤬ꤵƤȤ */
    if (CurKoouRuleSize) {
	fprintf(stderr, ";; Koou rule is duplicated (%s) !!\n", file_name);
	exit(1);
    }

    file_name = check_rule_filename(file_name);

    if ( (fp = fopen(file_name, "r")) == NULL ) {
	fprintf(stderr, ";; Cannot open file (%s) !!\n", file_name);
	exit(1);
    }

    if (OptDisplay == OPT_DEBUG) {
	fprintf(Outfp, "Reading %s ... ", file_name);
    }

    free(file_name);

    LineNo = 1;

    while (!s_feof(fp)) {
	LineNoForError = LineNo;

	body_cell = s_read(fp);
	store_regexpmrphs(&(rp->start_pattern), car(body_cell));

	body_cell = cdr(body_cell);
	store_regexpmrphs(&(rp->end_pattern), car(body_cell));

	rp->dpnd_type = 'D'; /* default */
	body_cell = cdr(body_cell);
	if (!Null(car(body_cell))) {
	    store_regexpmrphs(&(rp->uke_pattern), car(body_cell));
	} else {
	    rp->uke_pattern = NULL;
	}

	body_cell = cdr(body_cell);
	if (!Null(car(body_cell))) {
	    rp->dpnd_type = *(_Atom(car(body_cell)));
	}

	if (++CurKoouRuleSize == KoouRule_MAX) {
	    fprintf(stderr, ";; Too many KoouRule.");
	    exit(1);
	}

	rp++;
    }

    if (OptDisplay == OPT_DEBUG) {
	fputs("done.\n", Outfp);
    }

    fclose(fp);
}

/*==================================================================*/
		 void read_homo_rule(char *file_name)
/*==================================================================*/
{
    FILE     *fp;
    CELL     *body_cell;
    HomoRule  *rp = HomoRuleArray;

    /* ʣƥ롼ե뤬ꤵƤȤ */
    if (CurHomoRuleSize) {
	fprintf(stderr, ";; Homo rule is duplicated (%s) !!\n", file_name);
	exit(1);
    }

    file_name = check_rule_filename(file_name);

    if ( (fp = fopen(file_name, "r")) == NULL ) {
	fprintf(stderr, ";; Cannot open file (%s) !!\n", file_name);
	exit(1);
    }

    if (OptDisplay == OPT_DEBUG) {
	fprintf(Outfp, "Reading %s ... ", file_name);
    }
    
    free(file_name);

    LineNo = 1;

    while (!s_feof(fp)) {
	LineNoForError = LineNo;

	body_cell = s_read(fp);

	/* η롼ɹ */
	store_regexpmrphs(&(rp->pre_pattern), car(body_cell));

	/* homoη롼ɹ */
	store_regexpmrphs(&(rp->pattern), car(cdr(body_cell)));

	list2feature(cdr(cdr(body_cell)), &(rp->f));

	if (++CurHomoRuleSize == HomoRule_MAX) {
	    fprintf(stderr, ";; Too many HomoRule.");
	    exit(1);
	}
	rp++;
    }

    if (OptDisplay == OPT_DEBUG) {
	fputs("done.\n", Outfp);
    }

    fclose(fp);
}


/*==================================================================*/
void read_bnst_rule(char *file_name, BnstRule *rp, int *count, int max)
/*==================================================================*/
{
    FILE     *fp;
    CELL     *body_cell;

    /* ʣƥ롼ե뤬ꤵƤȤ */
    if (*count) {
	fprintf(stderr, ";; Bnst rule is duplicated (%s) !!\n", file_name);
	exit(1);
    }

    file_name = check_rule_filename(file_name);
    
    if ( (fp = fopen(file_name, "r")) == NULL ) {
	fprintf(stderr, ";; Cannot open file (%s) !!\n", file_name);
	exit(1);
    }

    if (OptDisplay == OPT_DEBUG) {
	fprintf(Outfp, "Reading %s ... ", file_name);
    }

    free(file_name);

    LineNo = 1;

    while (!s_feof(fp)) {
	LineNoForError = LineNo;

	body_cell = s_read(fp);
	store_regexpbnsts(&(rp->pre_pattern), car(body_cell));
	store_regexpbnsts(&(rp->self_pattern), car(cdr(body_cell)));
	store_regexpbnsts(&(rp->post_pattern), car(cdr(cdr(body_cell))));

	rp->f = NULL;
	list2feature(cdr(cdr(cdr(body_cell))), &(rp->f));
	
	if (++(*count) == max) {
	    fprintf(stderr, ";; Too many BnstRule.");
	    exit(1);
	}
	rp++;
    }

    if (OptDisplay == OPT_DEBUG) {
	fputs("done.\n", Outfp);
    }

    fclose(fp);
}

/*==================================================================*/
		 void read_dpnd_rule(char *file_name)
/*==================================================================*/
{
    int		i;
    FILE	*fp;
    CELL	*body_cell, *loop_cell;
    DpndRule	*rp = DpndRuleArray;

    /* ʣƥ롼ե뤬ꤵƤȤ */
    if (CurDpndRuleSize) {
	fprintf(stderr, ";; Dpnd rule is duplicated (%s) !!\n", file_name);
	exit(1);
    }

    file_name = check_rule_filename(file_name);

    if ( (fp = fopen(file_name, "r")) == NULL ) {
	fprintf(stderr, ";; Cannot open file (%s) !!\n", file_name);
	exit(1);
    }

    if (OptDisplay == OPT_DEBUG) {
	fprintf(Outfp, "Reading %s ... ", file_name);
    }

    free(file_name);

    LineNo = 1;

    while (!s_feof(fp)) {
	LineNoForError = LineNo;

	body_cell = s_read(fp);

	list2feature_pattern(&(rp->dependant), car(body_cell));	
	loop_cell = car(cdr(body_cell));
	i = 0;
	while (!Null(car(loop_cell))) {
	    list2feature_pattern(&(rp->governor[i]), car(car(loop_cell)));
	    rp->dpnd_type[i] = *(_Atom(car(cdr(car(loop_cell)))));

	    loop_cell = cdr(loop_cell);
	    if (++i == DpndRule_G_MAX) {
		fprintf(stderr, ";; Too many Governors in a DpndRule.");
		exit(1);
	    }
	}
	rp->dpnd_type[i] = 0;	/* dpnd_type[i] != 0 governorΤ */

	list2feature_pattern(&(rp->barrier), car(cdr(cdr(body_cell))));
	rp->preference = atoi(_Atom(car(cdr(cdr(cdr(body_cell))))));

	/* դ˷ꤹ뤫ɤ */
	if (!Null(car(cdr(cdr(cdr(cdr(body_cell)))))) && 
	    str_eq(_Atom(car(cdr(cdr(cdr(cdr(body_cell)))))), "U"))
	    rp->decide = 1;
	else
	    rp->decide = 0;

	if (++CurDpndRuleSize == DpndRule_MAX) {
	    fprintf(stderr, ";; Too many DpndRule.");
	    exit(1);
	}
	
	rp++;
    }

    if (OptDisplay == OPT_DEBUG) {
	fputs("done.\n", Outfp);
    }

    fclose(fp);
}

/*==================================================================*/
		 void read_dpnd_rule_for_chinese(char *file_name)
/*==================================================================*/
{
    int		i;
    int         num;
    FILE	*fp;
    CELL	*body_cell, *loop_cell, *prob_cell;
    DpndRule	*rp = DpndRuleArray;

    /* ʣƥ롼ե뤬ꤵƤȤ */
    if (CurDpndRuleSize) {
	fprintf(stderr, ";; Dpnd rule is duplicated (%s) !!\n", file_name);
	exit(1);
    }

    file_name = check_rule_filename(file_name);

    if ( (fp = fopen(file_name, "r")) == NULL ) {
	fprintf(stderr, ";; Cannot open file (%s) !!\n", file_name);
	exit(1);
    }

    if (OptDisplay == OPT_DEBUG) {
	fprintf(Outfp, "Reading %s ... ", file_name);
    }

    free(file_name);

    LineNo = 1;

    while (!s_feof(fp)) {
	LineNoForError = LineNo;
	body_cell = s_read(fp);

	list2feature_pattern(&(rp->dependant), car(body_cell));

	loop_cell = car(cdr(body_cell));
	i = 0;
	while (!Null(car(loop_cell))) {
	    list2feature_pattern(&(rp->governor[i]), car(loop_cell));
/* 	    strcpy(rp->gov_word[i], _Atom(car(car(car(cdr(car(car(loop_cell)))))))); */
/* 	    rp->dpnd_type[i] = *(_Atom(car(cdr(car(loop_cell))))); */
/* 	    prob_cell = car(cdr(cdr(car(loop_cell)))); */
/* 	    rp->prob_LtoR[i] = atof(_Atom(car(car(prob_cell)))); */
/* 	    rp->prob_RtoL[i] = atof(_Atom(car(car(cdr(prob_cell))))); */
/* 	    rp->count[i] = atoi(_Atom(car(cdr(cdr(cdr(car(loop_cell))))))); */
/* 	    strcpy(rp->dpnd_relation[i], _Atom(car(cdr(cdr(cdr(cdr(car(loop_cell)))))))); */

	    loop_cell = cdr(loop_cell);

	    if (++i == DpndRule_G_MAX) {
		fprintf(stderr, ";; Too many Governors in a DpndRule.");
		exit(1);
	    }
	}
	rp->dpnd_type[i] = 0;	/* dpnd_type[i] != 0 governorΤ */
	
	num++;
	list2feature_pattern(&(rp->barrier), car(cdr(cdr(body_cell))));
	rp->preference = atoi(_Atom(car(cdr(cdr(cdr(body_cell))))));

	/* դ˷ꤹ뤫ɤ */
	if (!Null(car(cdr(cdr(cdr(cdr(body_cell)))))) && 
	    str_eq(_Atom(car(cdr(cdr(cdr(cdr(body_cell)))))), "U"))
	    rp->decide = 1;
	else
	    rp->decide = 0;

	if (++CurDpndRuleSize == DpndRule_MAX) {
	    fprintf(stderr, ";; Too many DpndRule.");
	    exit(1);
	}
	
	rp++;
    }

    if (OptDisplay == OPT_DEBUG) {
	fputs("done.\n", Outfp);
    }

    fclose(fp);
}

/*==================================================================*/
		     void init_etc_rule(int flag)
/*==================================================================*/
{
    if (ExistEtcRule)
	usage();
    ExistEtcRule = flag;
    if (flag == IsMrphRule || flag == IsMrph2Rule) {
	EtcRuleArray = (MrphRule *)malloc_data(sizeof(MrphRule)*EtcRule_MAX, "init_etc_rule");
    }
    else if (flag == IsBnstRule) {
	EtcRuleArray = (BnstRule *)malloc_data(sizeof(BnstRule)*EtcRule_MAX, "init_etc_rule");
    }
}

/*==================================================================*/
  void read_etc_rule(char *file_name, void *rp, int *count, int max)
/*==================================================================*/
{
    if (ExistEtcRule == IsMrphRule || ExistEtcRule == IsMrph2Rule) {
	read_mrph_rule(file_name, (MrphRule *)rp, count, max);
    }
    else if (ExistEtcRule == IsBnstRule) {
	read_bnst_rule(file_name, (BnstRule *)rp, count, max);
    }
}

/*==================================================================*/
	       void read_general_rule(RuleVector *rule)
/*==================================================================*/
{
    if (GeneralRuleNum >= GeneralRuleMax) {
	GeneralRuleMax += RuleIncrementStep;
	GeneralRuleArray = (GeneralRuleType *)realloc(GeneralRuleArray, 
						      sizeof(GeneralRuleType)*GeneralRuleMax);
    }

    /* Ƽ勵, ⡼ɤ */
    (GeneralRuleArray+GeneralRuleNum)->type = rule->type;
    (GeneralRuleArray+GeneralRuleNum)->mode = rule->mode;
    (GeneralRuleArray+GeneralRuleNum)->breakmode = rule->breakmode;
    (GeneralRuleArray+GeneralRuleNum)->direction = rule->direction;
    (GeneralRuleArray+GeneralRuleNum)->CurRuleSize = 0;

    if ((GeneralRuleArray+GeneralRuleNum)->type == MorphRuleType || 
	(GeneralRuleArray+GeneralRuleNum)->type == PreProcessMorphRuleType || 
	(GeneralRuleArray+GeneralRuleNum)->type == NeMorphRuleType) {
	(GeneralRuleArray+GeneralRuleNum)->RuleArray = 
	    (MrphRule *)malloc_data(sizeof(MrphRule)*GeneralRule_MAX, "read_general_rule");
	read_mrph_rule(rule->file, (MrphRule *)((GeneralRuleArray+GeneralRuleNum)->RuleArray), 
		       &((GeneralRuleArray+GeneralRuleNum)->CurRuleSize), GeneralRule_MAX);
    }
    else if ((GeneralRuleArray+GeneralRuleNum)->type == TagRuleType || 
	     (GeneralRuleArray+GeneralRuleNum)->type == BnstRuleType || 
	     (GeneralRuleArray+GeneralRuleNum)->type == AfterDpndBnstRuleType || 
	     (GeneralRuleArray+GeneralRuleNum)->type == AfterDpndTagRuleType || 
	     (GeneralRuleArray+GeneralRuleNum)->type == PostProcessTagRuleType) {
	(GeneralRuleArray+GeneralRuleNum)->RuleArray = 
	    (BnstRule *)malloc_data(sizeof(BnstRule)*GeneralRule_MAX, "read_general_rule");
	read_bnst_rule(rule->file, (BnstRule *)((GeneralRuleArray+GeneralRuleNum)->RuleArray), 
		       &((GeneralRuleArray+GeneralRuleNum)->CurRuleSize), GeneralRule_MAX);
    }

    GeneralRuleNum++;
}

/*====================================================================
                               END
====================================================================*/
