/*====================================================================

			  ʹ¤: ¦

                                               S.Kurohashi 93. 5.31

    $Id: case_data.c,v 1.73 2009/08/12 00:13:43 kawahara Exp $
====================================================================*/
#include "knp.h"
#include "case_data.h"

int SOTO_SCORE = 7;

char fukugoji_string[SMALL_DATA_LEN];

/*==================================================================*/
char *extract_fukugoji_string(BNST_DATA *b_ptr, BNST_DATA *pre_b_ptr)
/*==================================================================*/
{
    int i;

    /* °줬ʤȤ */
    if (b_ptr->num < 1 || pre_b_ptr->mrph_num == 0) {
	return NULL;
    }

    fukugoji_string[0] = '\0';

    /* ʸν */
    strcat(fukugoji_string, (pre_b_ptr->mrph_ptr + pre_b_ptr->mrph_num - 1)->Goi);

    /* ʸ */
    for (i = 0; i < b_ptr->mrph_num; i++) {
	if (check_feature((b_ptr->mrph_ptr + i)->f, "Ω") && /* üʳμΩ */
	    strcmp(Class[(b_ptr->mrph_ptr + i)->Hinshi][0].id, "ü")) {
	    strcat(fukugoji_string, (b_ptr->mrph_ptr + i)->Goi);
	    if (i + 1 < b_ptr->mrph_num && !strcmp((b_ptr->mrph_ptr + i + 1)->Goi, "") && /* ηǤư̡֤ */
		!strcmp(Class[(b_ptr->mrph_ptr + i + 1)->Hinshi][0].id, "ư")) {
		strcat(fukugoji_string, (b_ptr->mrph_ptr + i + 1)->Goi);
	    }
	    break;
	}
    }

    /* ɤߤ */
    for (i = 0; *(FukugojiYomiTable[i]); i += 2) {
	if (str_eq(fukugoji_string, FukugojiYomiTable[i])) {
	    strcpy(fukugoji_string, FukugojiYomiTable[i + 1]);
	    break;
	}
    }

    return fukugoji_string;
}

/*==================================================================*/
		char *canonicalize_fukugoji(char *str)
/*==================================================================*/
{
    int i;

    /* ʣ缭Τɽɽ֤ */
    for (i = 0; *(FukugojiCanonicalTable[i]); i += 2) {
	if (str_eq(str, FukugojiCanonicalTable[i])) {
	    return FukugojiCanonicalTable[i + 1];
	}
    }

    return NULL;
}

/*==================================================================*/
	       char *make_fukugoji_id(BNST_DATA *b_ptr)
/*==================================================================*/
{
    int fc;
    char *fukugoji_str, *canonical_str;

    fukugoji_str = extract_fukugoji_string(b_ptr, b_ptr - 1);
    if (fukugoji_str && (canonical_str = canonicalize_fukugoji(fukugoji_str)) != NULL) {
	sprintf(fukugoji_string, "ID:%s", canonical_str);
	return fukugoji_string;
    }
    else {
	return NULL;
    }
}

/*==================================================================*/
	   char *make_fukugoji_case_string(TAG_DATA *b_ptr)
/*==================================================================*/
{
    int fc;
    char *fukugoji_str;

    fukugoji_str = extract_fukugoji_string((BNST_DATA *)b_ptr, (BNST_DATA *)(b_ptr - 1));
    if (fukugoji_str && (fc = pp_hstr_to_code(fukugoji_str)) != END_M) {
	sprintf(fukugoji_string, "Բϳ-%s", pp_code_to_kstr(fc));
	return fukugoji_string;
    }
    else {
	return NULL;
    }
}

/*==================================================================*/
int check_cc_relation(CF_PRED_MGR *cpm_ptr, TAG_DATA *b_ptr, char *pp_str)
/*==================================================================*/
{
    int i;

    if (!cpm_ptr || !cpm_ptr->cmm[0].cf_ptr) {
	return 0;
    }

    for (i = 0; i < cpm_ptr->cf.element_num; i++) {
	if (cpm_ptr->elem_b_ptr[i] && 
	    cpm_ptr->elem_b_ptr[i]->num == b_ptr->num && 
	    MatchPP(cpm_ptr->cmm[0].cf_ptr->pp[cpm_ptr->cmm[0].result_lists_d[0].flag[i]][0], 
		    pp_str)) {
	    return 1;
	}
    }
    return 0;
}

/*==================================================================*/
int _make_data_from_feature_to_pp(CF_PRED_MGR *cpm_ptr, TAG_DATA *b_ptr, 
				  int *pp_num, char *fcp)
/*==================================================================*/
{
    CASE_FRAME *c_ptr = &(cpm_ptr->cf);
    int cc;

    /* ѸιȤʤ */
    if (cpm_ptr->cf.type == CF_PRED) {
	if (!strncmp(fcp, "Բϳ-", strlen("Բϳ-"))) {
	    cc = pp_kstr_to_code(fcp+strlen("Բϳ-"));
	    if (cc == END_M) {
		fprintf(stderr, ";; case <%s> in a rule is unknown!\n", fcp + strlen("Բϳ-"));
		exit(1);
	    }
	    c_ptr->pp[c_ptr->element_num][(*pp_num)++] = cc;
	    if (*pp_num >= PP_ELEMENT_MAX) {
		fprintf(stderr, ";; not enough pp_num (%d)!\n", PP_ELEMENT_MAX);
		exit(1);
	    }
	}
	else if (!strcmp(fcp, "ɬܳ")) {
	    c_ptr->oblig[c_ptr->element_num] = TRUE;
	}
	else if (!strcmp(fcp, "ѸƱʸ")) {	/* ֡ˡפΤȤ */
	    if (cpm_ptr->pred_b_ptr->num != b_ptr->num) {
		return FALSE;
	    }
	}
    }
    /* ̾ιȤʤ */
    else {
	if (!strcmp(fcp, "̾")) {
	    /* : ƱʤǤϤʤ 
	             ϢνξϤδطδط */
	    if (b_ptr->dpnd_type != 'A' &&
		(!check_feature(b_ptr->f, ":Ϣ") || 
		 check_cc_relation(b_ptr->cpm_ptr, cpm_ptr->pred_b_ptr, "δط"))) {
		c_ptr->pp[c_ptr->element_num][(*pp_num)++] = 0;
		c_ptr->pp_str[c_ptr->element_num] = NULL;
	    }
	}
    }

    return TRUE;
}

/*==================================================================*/
TAG_DATA *_make_data_cframe_pp(CF_PRED_MGR *cpm_ptr, TAG_DATA *b_ptr, int flag)
/*==================================================================*/
{
    int pp_num = 0, cc, not_flag;
    char *buffer, *start_cp, *loop_cp;
    CASE_FRAME *c_ptr = &(cpm_ptr->cf);
    FEATURE *fp;

    /* flag == TRUE:  
       flag == FALSE: Ϣν */

    /*  */
    if (flag == TRUE) {
	if (b_ptr->num > 0 && /* ʣ缭ʤɤϤҤȤδܶߤ */
	    check_feature(b_ptr->f, "ɽľ")) {
	    b_ptr--;
	}

	/* ֡N׶ػ (=>롼) */
	if (cpm_ptr->cf.type == CF_PRED && 
	    check_feature(b_ptr->f, ":γ") && 
	    check_feature(cpm_ptr->pred_b_ptr->f, "Ѹ:Ƚ")) {
	    return NULL;
	}

	c_ptr->oblig[c_ptr->element_num] = FALSE;

	/* ߤ */
	if (start_cp = check_feature(b_ptr->f, "")) {
	    buffer = strdup(start_cp+strlen(":"));
	    start_cp = buffer;
	    loop_cp = start_cp;
	    flag = 1; /* 2: OK, 1: ̤, 0: NG */
	    not_flag = 0;
	    while (*loop_cp) {
		if (flag == 1 && *loop_cp == '&' && *(loop_cp+1) == '&') {
		    *loop_cp = '\0';
		    if ((!not_flag && !check_feature(cpm_ptr->pred_b_ptr->f, start_cp)) || 
			(not_flag && check_feature(cpm_ptr->pred_b_ptr->f, start_cp))) {
			flag = 0; /* NG */
		    }
		    loop_cp += 2;
		    start_cp = loop_cp;
		    not_flag = 0;
		}
		else if (flag < 2 && *loop_cp == '|' && *(loop_cp+1) == '|') {
		    if (flag == 1) {
			*loop_cp = '\0';
			if ((!not_flag && check_feature(cpm_ptr->pred_b_ptr->f, start_cp)) || 
			    (not_flag && !check_feature(cpm_ptr->pred_b_ptr->f, start_cp))) {
			    flag = 2; /* OK */
			}
		    }
		    else {
			flag = 1; /* 0 -> 1 */
		    }
		    loop_cp += 2;
		    start_cp = loop_cp;
		    not_flag = 0;
		}
		else if (*loop_cp == ':') {
		    *loop_cp = '\0';
		    if (flag == 2 || (flag == 1 && 
			(!not_flag && check_feature(cpm_ptr->pred_b_ptr->f, start_cp)) || 
			(not_flag && !check_feature(cpm_ptr->pred_b_ptr->f, start_cp)))) {
			if (_make_data_from_feature_to_pp(cpm_ptr, b_ptr, &pp_num, loop_cp+1) == FALSE) {
			    free(buffer);
			    return NULL;
			}
		    }
		    break;
		}
		else {
		    if (*loop_cp == '^') {
			not_flag = 1;
		    }
		    loop_cp++;
		}
	    }
	    free(buffer);
	}

	if (check_feature(b_ptr->f, "Գľ廲")) { /* ֡()פʤɤγʤϡפγʤߤ */
	    fp = (b_ptr + 1)->f;
	}
	else {
	    fp = b_ptr->f;
	}

	/* featureʤ */
	while (fp) {
	    if (_make_data_from_feature_to_pp(cpm_ptr, b_ptr, &pp_num, fp->cp) == FALSE) {
		return NULL;
	    }
	    fp = fp->next;
	}

	if (pp_num) {
	    c_ptr->pp[c_ptr->element_num][pp_num] = END_M;
	    return b_ptr;
	}
	else {
	    return NULL;
	}
    }
    /* Ϣν (ȤꤢѸΤȤΤ) */
    else if (cpm_ptr->cf.type == CF_PRED) {
	fp = b_ptr->f;
	c_ptr->oblig[c_ptr->element_num] = FALSE;

	while (fp) {
	    if (!strncmp(fp->cp, "ԲϢ-", strlen("ԲϢ-"))) {
		cc = pp_kstr_to_code(fp->cp+strlen("ԲϢ-"));
		if (cc == END_M) {
		    fprintf(stderr, ";; case <%s> in a rule is unknown!\n", fp->cp+11);
		    exit(1);
		}
		c_ptr->pp[c_ptr->element_num][pp_num++] = cc;
		if (pp_num >= PP_ELEMENT_MAX) {
		    fprintf(stderr, ";; not enough pp_num (%d)!\n", PP_ELEMENT_MAX);
		    exit(1);
		}
	    }
	    fp = fp->next;
	}
	c_ptr->pp[c_ptr->element_num][pp_num] = END_M;
	return b_ptr;
    }
    return NULL;
}

/*==================================================================*/
   void _make_data_cframe_sm(CF_PRED_MGR *cpm_ptr, TAG_DATA *b_ptr)
/*==================================================================*/
{
    int sm_num = 0, size;
    CASE_FRAME *c_ptr = &(cpm_ptr->cf);

    if (Thesaurus == USE_NTT) {
	size = SM_CODE_SIZE;
    }
    else if (Thesaurus == USE_BGH) {
	size = BGH_CODE_SIZE;
    }

    /*  -- ʸ */
    if (check_feature(b_ptr->f, "ʸ")) {
	strcpy(c_ptr->sm[c_ptr->element_num]+size*sm_num, 
	       sm2code("ʸ"));
	sm_num++;
    }
    /*  *
    else if (check_feature(b_ptr->f, "")) {
	strcpy(c_ptr->sm[c_ptr->element_num]+size*sm_num, 
	       sm2code(""));
	sm_num++;
	} */
    else {
	if (check_feature(b_ptr->f, "")) {
	    strcpy(c_ptr->sm[c_ptr->element_num]+size*sm_num, 
		   sm2code(""));
	    sm_num++;
	}
	if (check_feature(b_ptr->f, "")) {
	    strcpy(c_ptr->sm[c_ptr->element_num]+size*sm_num, 
		   sm2code(""));
	    sm_num++;
	}
	/* ͭ̾ =>  */
	if (check_feature(b_ptr->f, "̾") || 
	    check_feature(b_ptr->f, "ȿ̾")) {
	    strcpy(c_ptr->sm[c_ptr->element_num]+size*sm_num, 
		   sm2code(""));
	    sm_num++;
	}
	
	/*  */
	if (Thesaurus == USE_NTT) {
	    /* ȤΤǰ̣Ǥ٤ƥԡ */
	    strcpy(c_ptr->sm[c_ptr->element_num]+size*sm_num, 
		   b_ptr->SM_code);
	    sm_num += strlen(b_ptr->SM_code)/size;	    
	}
	else if (Thesaurus == USE_BGH) {
	    if (bgh_match_check(sm2code(""), b_ptr->BGH_code)) {
		strcpy(c_ptr->sm[c_ptr->element_num]+size*sm_num, 
		       sm2code(""));
		sm_num++;
	    }
	}
    }

    *(c_ptr->sm[c_ptr->element_num]+size*sm_num) = '\0';
}

/*==================================================================*/
   void _make_data_cframe_ex(CF_PRED_MGR *cpm_ptr, TAG_DATA *b_ptr)
/*==================================================================*/
{
    int i = 1;
    CASE_FRAME *c_ptr = &(cpm_ptr->cf);
    char *cp;

    i = 2;

    if (Thesaurus == USE_BGH) {
	strcpy(c_ptr->ex[c_ptr->element_num], b_ptr->BGH_code);
    }
    else if (Thesaurus == USE_NTT) {
	strcpy(c_ptr->ex[c_ptr->element_num], b_ptr->SM_code);
    }

    if ((OptCaseFlag & OPT_CASE_USE_REP_CF) && 
	(cp = get_mrph_rep_from_f(b_ptr->head_ptr, FALSE))) {
	strcpy(c_ptr->ex_list[c_ptr->element_num][0], cp);
    }
    else {
	strcpy(c_ptr->ex_list[c_ptr->element_num][0], b_ptr->head_ptr->Goi);
    }
    c_ptr->ex_num[c_ptr->element_num] = 1;
    c_ptr->ex_freq[c_ptr->element_num][0] = 1;
}

/*==================================================================*/
	      void set_data_cf_type(CF_PRED_MGR *cpm_ptr)
/*==================================================================*/
{
    TAG_DATA *b_ptr = cpm_ptr->pred_b_ptr;
    char *vtype = NULL;

    cpm_ptr->cf.type = CF_PRED;
    cpm_ptr->cf.type_flag = 0;
    cpm_ptr->cf.voice = b_ptr->voice;

    if ((vtype = check_feature(b_ptr->f, "Ѹ"))) {
	vtype += strlen("Ѹ:");
	strcpy(cpm_ptr->cf.pred_type, vtype);
    }
    else if ((vtype = check_feature(b_ptr->f, "Ѹʲ"))) {
	vtype += strlen("Ѹʲ:");
	strcpy(cpm_ptr->cf.pred_type, vtype);
    }
    else if (check_feature(b_ptr->f, "Ѹ")) {
	strcpy(cpm_ptr->cf.pred_type, "");
    }
    else if (check_feature(b_ptr->f, "θ")) {
	strcpy(cpm_ptr->cf.pred_type, "̾");
	cpm_ptr->cf.type = CF_NOUN;
    }
    else {
	cpm_ptr->cf.pred_type[0] = '\0';
    }

    if (cpm_ptr->cf.type == CF_PRED &&
	(check_feature(b_ptr->f, "") || 
	 check_feature(b_ptr->f, "Ѹ:Ƚ"))) {
	cpm_ptr->cf.type_flag = 1;
    }
}

/*==================================================================*/
int make_data_cframe_child(SENTENCE_DATA *sp, CF_PRED_MGR *cpm_ptr, TAG_DATA *child_ptr, int child_num, int closest_flag)
/*==================================================================*/
{
    TAG_DATA *cel_b_ptr;

    if ((cel_b_ptr = _make_data_cframe_pp(cpm_ptr, child_ptr, TRUE))) {
	/* ֤ߤ󻰸Ĥ򿩤٤ ҤȤ̾ǤȤȤ
	   ֤ߤ򻰸Ŀ٤ ξϤΤޤξǤˤʤ
	*/

	if (check_feature(cel_b_ptr->f, "") && 
	    (check_feature(cel_b_ptr->f, ":") || check_feature(cel_b_ptr->f, ":")) && 
	    cel_b_ptr->num > 0 && 
	    (check_feature((sp->tag_data + cel_b_ptr->num - 1)->f, ":") || 
	     check_feature((sp->tag_data + cel_b_ptr->num - 1)->f, ":Ʊ̤")) && 
	    !check_feature((sp->tag_data + cel_b_ptr->num - 1)->f, "") && 
	    !check_feature((sp->tag_data + cel_b_ptr->num - 1)->f, "")) {
	    _make_data_cframe_sm(cpm_ptr, sp->tag_data + cel_b_ptr->num - 1);
	    _make_data_cframe_ex(cpm_ptr, sp->tag_data + cel_b_ptr->num - 1);
	    cpm_ptr->elem_b_ptr[cpm_ptr->cf.element_num] = sp->tag_data + cel_b_ptr->num - 1;
	    cpm_ptr->cf.adjacent[cpm_ptr->cf.element_num] = FALSE;
	}
	else {
	    /* ľʤΥޡ (: ľΤ) */
	    if (closest_flag) {
		cpm_ptr->cf.adjacent[cpm_ptr->cf.element_num] = TRUE;
	    }
	    else {
		cpm_ptr->cf.adjacent[cpm_ptr->cf.element_num] = FALSE;
	    }
	    _make_data_cframe_sm(cpm_ptr, cel_b_ptr);
	    _make_data_cframe_ex(cpm_ptr, cel_b_ptr);
	    cpm_ptr->elem_b_ptr[cpm_ptr->cf.element_num] = cel_b_ptr;
	}

	cpm_ptr->elem_b_ptr[cpm_ptr->cf.element_num]->next = NULL; /* ǳǼ */

	/* ʤƤʤȤޡ */
	if (check_feature(cel_b_ptr->f, ":̤") || 
	    check_feature(cel_b_ptr->f, ":γ") || 
	    cel_b_ptr->inum > 0) {
	    cpm_ptr->elem_b_num[cpm_ptr->cf.element_num] = -1;
	}
	else {
	    cpm_ptr->elem_b_num[cpm_ptr->cf.element_num] = child_num;
	}

	cpm_ptr->cf.weight[cpm_ptr->cf.element_num] = 0;
	cpm_ptr->cf.element_num++;
	if (cpm_ptr->cf.element_num > CF_ELEMENT_MAX) {
	    cpm_ptr->cf.element_num = 0;
	}
	return TRUE;
    }

    return FALSE;
}

/*==================================================================*/
 int make_data_cframe_rentai(SENTENCE_DATA *sp, CF_PRED_MGR *cpm_ptr)
/*==================================================================*/
{
    TAG_DATA *b_ptr = cpm_ptr->pred_b_ptr, *cel_b_ptr = NULL;
    int renkaku_exception_p = 0;

    if (check_feature(b_ptr->f, "ǻ:2")) {
	renkaku_exception_p = 1;
    }

    /* Ϣν */
    if ((check_feature(b_ptr->f, ":Ϣ") && 
	 (b_ptr->para_type != PARA_NORMAL || 
	  b_ptr->num == b_ptr->parent->num)) || /* Ѹʤ顢Vפ<PARA>ƱȤΤ */
	(b_ptr->para_type == PARA_NORMAL && /* Ϣν */
	 check_feature(b_ptr->f, ":Ϣ") && /* ñϢѷ˸ꤹ٤ */
	 b_ptr->parent->para_top_p && 
	 check_feature(b_ptr->parent->child[0]->f, ":Ϣ")) || 
	renkaku_exception_p) {

	/* para_type == PARA_NORMAL ϡV,V PARA NפΤȤ
	   ΤȤϿ(PARA)ο(N)ǤȤ롥

	   Ƥpara_top_pɤߤƤVNN PARAפ
	   ȶ̤Ǥʤ
        */

	/* ѸǤϤʤȤ */
	if (b_ptr->para_type != PARA_NORMAL) {
	    if (b_ptr->parent) {
		/* Τ */
		if (renkaku_exception_p && 
		    b_ptr->parent->parent) {
		    if (check_feature(b_ptr->parent->parent->f, "θ")) {
			cel_b_ptr = b_ptr->parent->parent;
			_make_data_cframe_pp(cpm_ptr, b_ptr, FALSE);
		    }
		}
		else {
		    cel_b_ptr = b_ptr->parent;
		    _make_data_cframe_pp(cpm_ptr, b_ptr, FALSE);
		}

		if (cel_b_ptr) {
		    _make_data_cframe_sm(cpm_ptr, cel_b_ptr);
		    _make_data_cframe_ex(cpm_ptr, cel_b_ptr);
		    cpm_ptr->elem_b_ptr[cpm_ptr->cf.element_num] = cel_b_ptr;
		    cpm_ptr->elem_b_num[cpm_ptr->cf.element_num] = -1;
		    cpm_ptr->cf.weight[cpm_ptr->cf.element_num] = 0;
		    cpm_ptr->cf.adjacent[cpm_ptr->cf.element_num] = FALSE;
		    cpm_ptr->cf.element_num++;
		}
	    }
	}
	/* ѸΤȤ */
	else {
	    cel_b_ptr = b_ptr;
	    while (cel_b_ptr->parent->para_type == PARA_NORMAL) {
		cel_b_ptr = cel_b_ptr->parent;
	    }

	    if (cel_b_ptr->parent && 
		cel_b_ptr->parent->parent) {
		_make_data_cframe_pp(cpm_ptr, cel_b_ptr->parent, FALSE);
		_make_data_cframe_sm(cpm_ptr, cel_b_ptr->parent->parent);
		_make_data_cframe_ex(cpm_ptr, cel_b_ptr->parent->parent);
		cpm_ptr->elem_b_ptr[cpm_ptr->cf.element_num] = cel_b_ptr->parent->parent;
		cpm_ptr->elem_b_num[cpm_ptr->cf.element_num] = -1;
		cpm_ptr->cf.weight[cpm_ptr->cf.element_num] = 2; /* Ρ */
		cpm_ptr->cf.adjacent[cpm_ptr->cf.element_num] = FALSE;
		cpm_ptr->cf.element_num++;
	    }
	}
    }

    return TRUE;
}

/*==================================================================*/
    int make_data_cframe(SENTENCE_DATA *sp, CF_PRED_MGR *cpm_ptr)
/*==================================================================*/
{
    TAG_DATA *b_ptr = cpm_ptr->pred_b_ptr;
    TAG_DATA *cel_b_ptr = NULL;
    int i, child_num, first, closest, orig_child_num = -1, renkaku_exception_p;

    cpm_ptr->cf.samecase[0][0] = END_M;
    cpm_ptr->cf.samecase[0][1] = END_M;

    cpm_ptr->cf.pred_b_ptr = b_ptr;
    b_ptr->cpm_ptr = cpm_ptr;

    /* ɽس etc.  */

    cpm_ptr->cf.element_num = 0;

    /* Ϣν */
    make_data_cframe_rentai(sp, cpm_ptr);

    for (child_num = 0; b_ptr->child[child_num]; child_num++);

    /* ʬ(Ѹ)ʣ̾ */
    if (b_ptr->inum > 0) {
	TAG_DATA *t_ptr;

	/* ʬ(Ѹ)ʣ̾ΤȤο : Ϣν찷
	    ϢʤΤȤ(֡Τϡ)ϤǤ˰äƤ */
	if (cpm_ptr->cf.type == CF_PRED && /* ȤꤢѤΤȤΤ */
	    !check_feature(b_ptr->f, ":Ϣ")) {
	    if (!check_feature(b_ptr->parent->f, "δط") || 
		check_feature(b_ptr->f, "Ѹ:")) {
		_make_data_cframe_pp(cpm_ptr, b_ptr, FALSE);
	    }
	    else {
		cpm_ptr->cf.pp[cpm_ptr->cf.element_num][0] = pp_hstr_to_code("δط");
		cpm_ptr->cf.pp[cpm_ptr->cf.element_num][1] = END_M;
		cpm_ptr->cf.oblig[cpm_ptr->cf.element_num] = FALSE;
	    }
	    _make_data_cframe_sm(cpm_ptr, b_ptr->parent);
	    _make_data_cframe_ex(cpm_ptr, b_ptr->parent);
	    cpm_ptr->elem_b_ptr[cpm_ptr->cf.element_num] = b_ptr->parent;
	    cpm_ptr->elem_b_num[cpm_ptr->cf.element_num] = -1;
	    cpm_ptr->cf.weight[cpm_ptr->cf.element_num] = 0;
	    cpm_ptr->cf.adjacent[cpm_ptr->cf.element_num] = FALSE;
	    cpm_ptr->cf.element_num++;
	}

	/* ʸhead˷̾μ갷 *

	t_ptr = b_ptr->parent;
	while (1) {
	    if (t_ptr->cpm_ptr) { * ̤γʲо *
		t_ptr = NULL;
		break;
	    }
	    if (t_ptr->inum == 0) {
		break;
	    }
	    t_ptr = t_ptr->parent;
	}

	* ... n3 n2 n1
	   ʣ̾(ߤ)ǽѸ(ʲо)Ф
	   n1λҶȤäƤ *
	if (t_ptr) {
	    orig_child_num = child_num;
	    for (i = 0; t_ptr->child[i]; i++) {
		* ʸʳ *
		if (t_ptr->child[i]->inum == 0) {
		    b_ptr->child[child_num++] = t_ptr->child[i];
		}
	    }
	}
	*/
    }

    /* ҶǤ */
    for (i = child_num - 1; i >= 0; i--) {
	if (make_data_cframe_child(sp, cpm_ptr, b_ptr->child[i], i, 
				   i == 0 && b_ptr->num == b_ptr->child[i]->num + 1 && 
				   !check_feature(b_ptr->f, "ѸƱʸ") ? TRUE : FALSE)) {
	    if (cpm_ptr->cf.element_num == 0) { /* ҶϤʤΤˡʤä */
		return -1;
	    }
	}
    }

    /* ʣ̾: ҶȤˤɤ */
    if (orig_child_num >= 0) {
	b_ptr->child[orig_child_num] = NULL;
    }

    /* Ѹʸ᤬֡ʡˡˡפΤȤ 
       ֤פγʥե졼Фƥ˳(Ʊʸ)
       ʤϻҶνǰ */
    if (check_feature(b_ptr->f, "ѸƱʸ")) {
	if (_make_data_cframe_pp(cpm_ptr, b_ptr, TRUE)) {
	    _make_data_cframe_sm(cpm_ptr, b_ptr);
	    _make_data_cframe_ex(cpm_ptr, b_ptr);
	    cpm_ptr->elem_b_ptr[cpm_ptr->cf.element_num] = b_ptr;
	    cpm_ptr->elem_b_num[cpm_ptr->cf.element_num] = child_num;
	    cpm_ptr->cf.weight[cpm_ptr->cf.element_num] = 0;
	    cpm_ptr->cf.adjacent[cpm_ptr->cf.element_num] = TRUE;
	    cpm_ptr->cf.element_num++;
	}
    }

    /* ѸΤȤǤ expand  */
    if (b_ptr->para_type == PARA_NORMAL && 
	b_ptr->parent && 
	b_ptr->parent->para_top_p) {
	child_num = 0;

	/* <PARA>˷Ҷå */
	for (i = 0; b_ptr->parent->child[i]; i++) {
	    if (b_ptr->parent->child[i]->para_type == PARA_NORMAL) {
		child_num++;
	    }
	}
	for (i = 0; b_ptr->parent->child[i]; i++) {
	    if (b_ptr->parent->child[i]->para_type == PARA_NIL && 
		b_ptr->parent->child[i]->num < b_ptr->num) {
		if ((cel_b_ptr = _make_data_cframe_pp(cpm_ptr, b_ptr->parent->child[i], TRUE))) {
		    _make_data_cframe_sm(cpm_ptr, cel_b_ptr);
		    _make_data_cframe_ex(cpm_ptr, cel_b_ptr);
		    cpm_ptr->elem_b_ptr[cpm_ptr->cf.element_num] = cel_b_ptr;

		    /* ʤƤʤȤޡ */
		    if (check_feature(cel_b_ptr->f, ":̤") || 
			check_feature(cel_b_ptr->f, ":γ")) {
			cpm_ptr->elem_b_num[cpm_ptr->cf.element_num] = -1;
		    }
		    else {
			cpm_ptr->elem_b_num[cpm_ptr->cf.element_num] = i;
		    }

		    cpm_ptr->cf.weight[cpm_ptr->cf.element_num] = child_num;
		    cpm_ptr->cf.adjacent[cpm_ptr->cf.element_num] = FALSE;
		    cpm_ptr->cf.element_num++;
		}
		if (cpm_ptr->cf.element_num > CF_ELEMENT_MAX) {
		    cpm_ptr->cf.element_num = 0;
		    return -1;
		}
	    }
	}
    }

    /* ľǤμ */
    closest = get_closest_case_component(sp, cpm_ptr);

    /* ľǤΤҤȤļΥγ
        <>ʳ: ޡγ V
          <>ʳ: */
    if (OptCaseFlag & OPT_CASE_NO && 
	closest > -1 && 
	cpm_ptr->elem_b_ptr[closest]->num > 0 && 
	!check_feature((sp->tag_data + cpm_ptr->elem_b_ptr[closest]->num - 1)->f, "") && 
	!check_feature((sp->tag_data + cpm_ptr->elem_b_ptr[closest]->num - 1)->f, "") && 
	check_feature((sp->tag_data + cpm_ptr->elem_b_ptr[closest]->num - 1)->f, ":γ")) {
	TAG_DATA *bp;
	bp = sp->tag_data + cpm_ptr->elem_b_ptr[closest]->num - 1;

	/* Ƥʤϳʥե졼ˤäưŪѤ */
	cpm_ptr->cf.pp[cpm_ptr->cf.element_num][0] = pp_hstr_to_code("̤");
	cpm_ptr->cf.pp[cpm_ptr->cf.element_num][1] = END_M;
	cpm_ptr->cf.sp[cpm_ptr->cf.element_num] = pp_hstr_to_code(""); /* ɽس */
	cpm_ptr->cf.oblig[cpm_ptr->cf.element_num] = FALSE;
	_make_data_cframe_sm(cpm_ptr, bp);
	_make_data_cframe_ex(cpm_ptr, bp);
	cpm_ptr->elem_b_ptr[cpm_ptr->cf.element_num] = bp;
	cpm_ptr->elem_b_num[cpm_ptr->cf.element_num] = -1;
	cpm_ptr->cf.weight[cpm_ptr->cf.element_num] = 0;
	cpm_ptr->cf.adjacent[cpm_ptr->cf.element_num] = FALSE;
	if (cpm_ptr->cf.element_num < CF_ELEMENT_MAX) {
	    cpm_ptr->cf.element_num++;
	}
    }

    return closest; /* ʲϺͽ */

    /* ǤҤȤĤǻֳʤΤߤξ硢ǤʤƱ褦˰
       ľλֳʤǤȤγʤʤǤȤ̤˰ (ߤϥ˳ʤΤ) */

    for (i = 0; i < cpm_ptr->cf.element_num; i++) {
	if (!MatchPP(cpm_ptr->cf.pp[i][0], "")) {
	    return closest;
	}
	/* ľʤǥ˳ʤ <> ΤȤϺʤ */
	else if (cpm_ptr->pred_b_ptr->num == cpm_ptr->elem_b_ptr[i]->num + 1 && 
		 check_feature(cpm_ptr->elem_b_ptr[i]->f, ":˳")) {
	    return closest;
	}
    }
    cpm_ptr->cf.element_num = 0;
    return -1;
}

/*==================================================================*/
		 void set_pred_voice(BNST_DATA *ptr)
/*==================================================================*/
{
    /*  */

    char *cp;

    ptr->voice = 0;

    if (cp = check_feature(ptr->f, "")) {
	char *token, *str;

	str = strdup(cp + strlen(":"));
	token = strtok(str, "|");
	while (token) {
	    if (!strcmp(token, "ư")) {
		ptr->voice |= VOICE_UKEMI;
	    }
	    else if (!strcmp(token, "")) {
		ptr->voice |= VOICE_SHIEKI;
	    }
	    else if (!strcmp(token, "餦")) {
		ptr->voice |= VOICE_MORAU;
	    }
	    else if (!strcmp(token, "ۤ")) {
		ptr->voice |= VOICE_HOSHII;
	    }
	    else if (!strcmp(token, "&ư")) {
		ptr->voice |= VOICE_SHIEKI_UKEMI;
	    }
	    /* ֲǽפ̤ */

	    token = strtok(NULL, "|");
	}
	free(str);
    }
}

/*====================================================================
                               END
====================================================================*/
