# $Id: Tag.pm,v 1.4 2008/10/07 16:58:48 shibata Exp $
package KNP::Tag;
require 5.004_04; # For base pragma.
use KNP::Morpheme;
use strict;
use base qw/ KNP::Depend KNP::Fstring Juman::MList /;
use Encode;

=head1 NAME

KNP::Tag - ֥ in KNP

=head1 SYNOPSIS

  $b = new KNP::Tag( "+ 1D <ϳ->", 0 );

=head1 DESCRIPTION

ʲϤñ̤Ȥʤ륿γƼݻ륪֥ȡ

=head1 CONSTRUCTOR

=over 4

=item new ( SPEC, ID )

1 C<SPEC>  KNP νϤƸƤӽФȡιԤƤ
륿֥Ȥ롥

=cut
sub new {
    my( $class, $spec, $id ) = @_;
    my $new = bless( {}, $class );

    $spec =~ s/\s*$//;
    if( $spec eq '+' ){
	$new->id( $id );
    } elsif( my( $parent_id, $dpndtype, $fstring ) = ( $spec =~ m/^\+ (-?\d+)(\w)(.*)$/ ) ){
	$new->id( $id );
	$new->dpndtype( $dpndtype );
	$new->parent_id( $parent_id );
	$new->fstring( $fstring );
    } else {
	die "KNP::Tag::new(): Illegal spec = $spec\n";
    }
    $new;
}

=back

=head1 METHODS

1ĤΥϡʣηǤʤ롥äơ֥Ȥϡ
󥪥֥ C<Juman::MList> Ѿ褦˼졤
Ф C<mrph> ᥽åɤѲǽǤ롥

֤ΰ¸ط˴ؤݻ뤿ˡC<KNP::Depend> 
饹ѾƤ롥äơʲΥ᥽åɤѲǽǤ롥

=over 4

=item parent

西֤

=item child

Υ˷äƤ륿ΥꥹȤ֤

=item id

󥹥ȥ饯ƤӽФȤ˻ꤵ줿 ID ̵֤ξ -1 
֤

=back

KNP ˤäƳƤ줿ħʸݻȤ뤿ˡ
C<KNP::Fstring> 饹ѾƤ롥äơʲΥ᥽åɤ
ǽǤ롥

=over 4

=item fstring

ħʸ֤

=item feature

ħΥꥹȤ֤

=item push_feature

ħɲä롥

=back

äơʲΥ᥽åɤƤ롥

=over 4

=item spec

֥ȤʸѴ롥

=cut
sub spec {
    my( $this ) = @_;
    sprintf( "+ %d%s %s\n%s",
	     $this->parent() ? $this->parent->id() : -1,
	     $this->dpndtype(),
	     $this->fstring(),
	     $this->SUPER::spec() );
}

=item synnodes

SynNodesξ֤

=cut
sub synnodes {
    my ( $this ) = @_;

    if( defined $this->{synnodes} ){
	@{$this->{synnodes}};
    } else {
	wantarray ? () : 0;
    }
}

=back

=head1 SEE ALSO

=over 4

=item *

L<KNP::Depend>

=item *

L<KNP::Fstring>

=item *

L<Juman::MList>

=item *

L<KNP::Morpheme>

=back

=head1 AUTHOR

=over 4

=item
ڲ ̭ <tsuchiya@pine.kuee.kyoto-u.ac.jp>

=cut

1;
__END__
# Local Variables:
# mode: perl
# coding: euc-japan
# use-kuten-for-period: nil
# use-touten-for-comma: nil
# End:
