# $Id: Fstring.pm,v 1.2 2006/10/31 08:53:08 shibata Exp $
package KNP::Fstring;
require 5.000;
use Carp;
use strict;

=head1 NAME

KNP::Fstring - ħʸ򻲾Ȥ

=head1 SYNOPSIS

Υ饹ߥ󥰤ƻѤ롥

=head1 DESCRIPTION

C<KNP::Fstring> 饹ϡħʸ򻲾Ȥ᥽åɤ󶡤륯饹
Ǥ롥

=head1 CONSTRUCTOR

Υ饹ϥߥ󥰤ƻѤ褦߷פƤ뤿ᡤ̤ʥ
ȥ饯Ƥʤ

=head1 METHODS

=over 4

=item fstring

=item fstring [ STRING ]

ħʸ֤ꤵ줿ϡꤵ줿ʸħʸ
Ȥ롥

=cut
sub fstring {
    my $this = shift;
    if( @_ ){
	&set_fstring( $this, @_ );
    } elsif( defined $this->{fstring} ){
	$this->{fstring};
    } else {
	undef;
    }
}

=item feature

=item feature [ STRING... ]

ƤħΥꥹȤ֤ꤵ줿ϡꤵ줿ħΥꥹ
Ȥ롥

ꥹȤȤƻꤹ뤳ȤϤǤʤΤǡħƾõ
뤿ˤϻȤʤ

=cut
sub feature {
    my $this = shift;
    if( @_ ){
	&set_feature( $this, @_ );
    } elsif( defined $this->{feature} ){
	@{$this->{feature}};
    } else {
	wantarray ? () : 0;
    }
}

=item set_fstring [ STRING ]

ħʸꤹ롥ꤵ줿ʸ֤

=cut
sub set_fstring {
    my( $this, $str ) = @_;
    unless( defined $str ){
	$this->{feature} = [];
	$this->{fstring} = undef;
    } else {
	$str =~ s/\A\s*//;
	$str =~ s/\s*\Z//;
	unless( $str =~ m/\A(<[^<>]*>)*\Z/ ){
	    carp "Illegal feature string: $str";
	    return undef;
	}
	$this->{fstring} = $str;
	$str =~ s/\A<//;
	$str =~ s/>\Z//;
	$this->{feature} = [ split( /></, $str ) ];
	$this->{fstring};
    }
}

=item set_feature [ STRING... ]

ħΥꥹȤꤹ롥ꤵ줿ħΥꥹȤ֤

=cut
sub set_feature {
    my $this = shift;
    if( grep( /[<>]/, @_ ) ){
	# <> ޤ褦ħʸɲäǤʤ
	carp "Illegal feature string: @_";
	return ( wantarray ? () : 0 );
    }
    $this->{feature} = [ @_ ];
    $this->{fstring} = join( '', map( sprintf( '<%s>', $_ ), @_ ) );
    @{$this->{feature}};
}

=item push_feature ( FEATURES )

ꤵ줿ħɲä롥ɲøħο֤

=cut
sub push_feature {
    my( $this, @feature ) = @_;
    scalar( $this->set_feature( $this->feature(), @feature ) );
}

=back

=head1 AUTHOR

=over 4

=item
ڲ ̭ <tsuchiya@pine.kuee.kyoto-u.ac.jp>

=cut

1;
__END__
# Local Variables:
# mode: perl
# coding: euc-japan
# use-kuten-for-period: nil
# use-touten-for-comma: nil
# End:
