# $Id: KNP.pm,v 1.6 2009/04/07 14:46:59 shibata Exp $
package KNP;
require 5.004_04; # For base pragma.
use Carp;
use English qw/ $LIST_SEPARATOR /;
use Juman;
use KNP::Result;
use strict;
use base qw/ KNP::Obsolete Juman::Process /;
use vars qw/ $VERSION %DEFAULT /;

=head1 NAME

KNP - ʸϤԤ⥸塼

=head1 SYNOPSIS

 use KNP;
 $knp = new KNP;
 $result = $knp->parse( "ʸʸϤƤ" );
 print $result->all;

=head1 DESCRIPTION

C<KNP> ϡKNP ѤƹʸϤԤ⥸塼Ǥ롥

ñ˹ʸϤԤʤСC<KNP::Simple> ѤǤ롥
C<KNP::Simple> ϡC<KNP> ⥸塼ΥåѡǤꡤñ˹ʸ
ϴѤǤ褦߷פƤ롥

=head1 CONSTRUCTOR

C<KNP> ֥Ȥ륳󥹥ȥ饯ϡʲΰդ롥

=head2 Synopsis

    $knp = new KNP
             [ -Server        => string,]
             [ -Port          => integer,]
             [ -Command       => string,]
             [ -Timeout       => integer,]
             [ -Option        => string,]
             [ -Rcfile        => filename,]
             [ -IgnorePattern => string,]
             [ -JumanServer   => string,]
             [ -JumanPort     => integer,]
             [ -JumanCommand  => string,]
             [ -JumanOption   => string,]

=head2 Options

=over 4

=item -Server

KNP СΥۥ̾ά줿ϡĶѿ C<KNPSERVER> ǻ
줿СѤ롥ĶѿꤵƤʤϡKNP 
ץȤƸƤӽФ

=item -Port

KNP СΥݡֹ桥

=item -Command

KNP μ¹ԥե̾KNP СѤʤ˻Ȥ롥

=item -Timeout

Сޤϻҥץ̿Ԥ֡

=item -Option

KNP ¹ԤݤΥޥɥ饤άϡ
C<$KNP::DEFAULT{option}> ͤѤ롥

եꤹ C<-r> ץȡKNP ˤä̵뤵
Ƭѥꤹ C<-i> ץˤĤƤϡ줾̤ 
C<-Rcfile>, C<-IgnorePattern> ˤäƻꤹ٤Ǥ롥

=item -Rcfile

KNP եꤹ륪ץ

ΥץȡKNP СѤξΩʤȤ¿äˡ
СѤƤ뼭Ȱ㤦ꤷƤեϡտޤ
̤ˤưʤ

=item -IgnorePattern

KNP ˤä̵뤵Ƭѥ

=item -JumanServer

=item -JumanPort

=item -JumanCommand

=item -JumanOption

=item -JumanRcfile

Juman ƤӽФΥץŪ˻ꤹ뤿Υץ

=back

=head1 METHODS

=over 4

=item knp( OBJ )

=item parse( OBJ )

ʸޤϷ󥪥֥ OBJ оݤȤƹʸϤԤʸ
Ϸ̥֥Ȥ֤

ʸ󤬶ʸǤäꡤʸƬʸ C<#> Ǥä
ꤷˤϡʸ̵뤵 undef ֤ͤȤʤ롥

ޤʸ̿Ūʥ顼ȯ undef ֤ξ
ϡľ C<error> ᥽åɤѤ뤳Ȥˤäơºݤȯ
顼Τ뤳ȤǤ롥

äơC<parse> ᥽åɤ֤ͤ򡤴İ˽뤿
ϡʲΤ褦ʥץबɬפǤ롥

  Example:

    $result = $knp->parse( $str );
    if( $result ){
        # ʸϤ
        if( $result->error() ){
            # ʸ˲餫Υ顼å
            # Ϥ줿
        }
        else {
            # ˹ʸϤλ
        }
    } else {
        if( $knp->error() ){
            # ʸ̿Ūʥ顼ȯ
        }
        else {
            # оݤȤʤʸ̵뤵졤Ԥʤä
        }
    }

ŪˤϰʲΤ褦ʥץǽʬ

  Example:

    $result = $knp->parse( $str );
    if( $result ){
        # ʸϤ
    }

=item parse_string( STRING )

ʸоݤȤƹʸϤԤʸϥ֥Ȥ֤

=item parse_mlist( MLIST )

󥪥֥ȤоݤȤƹʸϤԤʸϷ̥֥
Ȥ֤

=item result

ľιʸϷ̥֥Ȥ֤

=item error

ľ̿Ūʥ顼֤

=item detail( [TYPE] )

C<-detail> ץꤷ˸¤ͭȤʤ᥽åɡ

=item juman( STRING )

ʸǲϤǲϷ̥֥Ȥ֤

=back

=head1 ENVIRONMENT

=over 4

=item KNPSERVER

Ķѿ C<KNPSERVER> ꤵƤϡꤵƤۥȤ 
KNP СȤѤ롥

=back

=head1 SEE ALSO

=over 4

=item *

L<KNP::Simple>

=item *

L<KNP::Result>

=back

=head1 HISTORY

This module is the completely rewritten version of the original module
written by Sadao Kurohashi <kuro@i.kyoto-u.ac.jp>.

=head1 AUTHOR

=over 4

=item
TSUCHIYA Masatoshi <tsuchiya@pine.kuee.kyoto-u.ac.jp>

=back

=head1 COPYRIGHT

ѵڤӺۤˤĤƤ GPL2 ޤ Artistic License ˽äƤ

=cut


### Сɽ
$VERSION = '0.4.9';

# ޥѿ
%DEFAULT =
    ( command => &Juman::Process::which_command('knp'),
      server  => $ENV{KNPSERVER} || '',		# KNP СΥۥ̾
      port    => 31000,				# KNP СΥݡֹ
      timeout => 60,				# KNP СαԤ
      option  => '-tab',			# KNP Ϥ륪ץ
      rcfile  => $ENV{HOME}.'/.knprc',
      bclass  => $KNP::Result::DEFAULT{bclass},
      mclass  => $KNP::Result::DEFAULT{mclass},
      tclass  => $KNP::Result::DEFAULT{tclass}, );
while( my( $key, $value ) = each %Juman::DEFAULT ){
    $DEFAULT{"juman$key"} = $value;
}



#----------------------------------------------------------------------
#		Constructor
#----------------------------------------------------------------------

# KNP ҥץȤƼ¹ԤƤ硤ɸϤΥХåե󥰤ˤ
# ƽϤŤˤʤʤ褦ˤ뤿Τޤʤ
sub BEGIN {
    unless( $DEFAULT{server} ){
	require FileHandle or die;
	STDOUT->autoflush(1);
    }
}

sub new {
    my $class = shift @_;
    my $this = {};
    bless $this, $class;

    if( @_ == 1 ){
	# СηǸƤӽФ줿ν
	my( $argv ) = @_;
	$this->setup( $argv, \%DEFAULT );
    } else {
	# ǸƤӽФ줿ν
	my( %option ) = @_;
	$this->setup( \%option, \%DEFAULT );
    }

    if( $this->{OPTION}->{rcfile} and $this->{OPTION}->{server} ){
	carp "Rcfile option may not work with KNP server";
    }

    $this;
}

sub close {
    my( $this ) = @_;
    $this->{PREVIOUS} = [];
    $this->Juman::Process::close();
}



#----------------------------------------------------------------------
#		ʸϤԤ᥽å
#----------------------------------------------------------------------
sub knp { &parse(@_); }
sub parse {
    my( $this, $object ) = @_;
    if( ref($object) and $object->isa('Juman::MList') ){
	&parse_mlist( $this, $object );
    } else {
	&parse_string( $this, $object );
    }
}

# ʸоݤȤơʸϤԤ᥽å
sub parse_string {
    my( $this, $str ) = @_;
    
    # ȲԤΤߤʤʸ̵뤵
    return &_set_error( $this, undef ) if $str =~ m/^\s*$/s;

    # "#" ǻϤޤʸ̵뤵
    return &_set_error( $this, undef ) if $str =~ /^\#/;

    &_real_parse( $this,
		  &juman_lines( $this, $str ),
		  $str );
}

# 󥪥֥ȤоݤȤơʸϤԤ᥽å
sub parse_mlist {
    my( $this, $mlist ) = @_;
    &_real_parse( $this,
		  [ $mlist->Juman::MList::spec(), "EOS\n" ],
		  join( '', map( $_->midasi(), $mlist->mrph ) ) );
}

# ºݤιʸϤԤؿ
sub _real_parse {
    my( $this, $array, $str ) = @_;

    return &_set_error( $this, ";; TIMEOUT is occured when Juman was called.\n" )
	unless( @{$array} );

    # UTFե饰å
    if (utf8::is_utf8($str)) {
	require Encode;
	foreach my $str (@{$array}) {
	    $str = Encode::encode('euc-jp', $str);
	}
	$this->{input_is_utf8} = 1;
    }
    else {
	$this->{input_is_utf8} = 0;
    }

    # Parse ERROR ʤɤȯ˸Ĵ٤뤿ᡤʸϤʸ
    # ¸Ƥ
    unshift( @{$this->{PREVIOUS}}, $str );
    splice( @{$this->{PREVIOUS}}, 10 ) if @{$this->{PREVIOUS}} > 10;

    # ʸ
    my @error;
    my $counter = 0;
    my $pattern = $this->pattern();
  PARSE:
    my $sock = $this->open();
    $sock->print( @$array );
    $counter++;

    # ʸϷ̤ɤ߽Ф
    my( @buf );
    my $skip = ( $this->{OPTION}->{option} =~ /\-detail/ ) ? 1 : 0;
    while( defined( $str = $sock->getline ) ){
	if ($this->{input_is_utf8}) {
	    $str = Encode::decode('euc-jp', $str);
	}
	push( @buf, $str );
	last if $str =~ /$pattern/ and ! $skip--;
    }
#    die "Mysterious error: KNP server or process gives no response" unless @buf;

    # ʸϷ̤κǸ EOS ΤߤιԤ̵ϡɤ߽Ф˥
    # ॢȤȯƤ롥
    unless( @buf and $buf[$#buf] =~ /$pattern/ ){
 	if( $counter == 1 ){
 	    push( @error, ";; TIMEOUT is occured.\n" );
	    my $i = $[;
	    push( @error,
		  map( sprintf(";; TIMEOUT:%02d:%s\n",$i++,$_), @{$this->{PREVIOUS}} ) );
 	}
	$this->close();
	goto PARSE if( $counter <= 1 );
	return &_set_error( $this, join( '', @error ) );
    }

    # "Cannot detect consistent CS scopes." Ȥ顼ξϡKNP 
    # ΥХǤǽΤǡö KNP Ƶư롥
    if( grep( /^;; Cannot detect consistent CS scopes./, @buf ) ){
 	if( $counter == 1 ){
 	    push( @error, ";; Cannot detect consistent CS scopes.\n" );
	    my $i = $[;
	    push( @error,
		  map( sprintf(";; CS:%02d:%s\n",$i++,$_), @{$this->{PREVIOUS}} ) );
 	}
 	$this->close();
 	goto PARSE if( $counter <= 1 );
    }

    # -detail ץ󤬻ꤵƤ
    if( $this->{OPTION}->{option} =~ /\-detail/ ){
	my( $str, @mrph, @bnst );
	while( defined( $str = shift @buf ) ){
	    push( @mrph, $str );
	    last if $str =~ /$pattern/;
	}
	while( defined( $str = shift @buf ) ){
	    if( $str =~ /^#/ ){
		unshift( @buf, $str );
		last;
	    }
	    push( @bnst, $str );
	}
	$this->{DETAIL} = { mrph   => join( '', @mrph ),
			    bnst   => join( '', @bnst ),
			    struct => join( '', @buf ) };
    }

    # ʸϷ̤롥
    unshift( @buf, @error );
    &_internal_analysis( $this, \@buf );
}



#----------------------------------------------------------------------
#		ǲϤԤ᥽å
#----------------------------------------------------------------------
sub _new_juman {
    my( $this ) = @_;
    unless( $this->{JUMAN} ){
	my %opt;
	while( my( $key, $value ) = each %{$this->{OPTION}} ){
	    $key =~ s/^juman// and $opt{$key} = $value;
	}
	$this->{JUMAN} = new Juman( %opt );
    }
}

sub juman_lines {
    my( $this, $str ) = @_;
    &_new_juman($this);
    $this->{JUMAN}->juman_lines( $str );
}

sub juman {
    my( $this, $str ) = @_;
    &_new_juman($this);
    $this->{JUMAN}->juman( $str );
}



#----------------------------------------------------------------------
#		ʸϷ̤Ϥؿ
#----------------------------------------------------------------------
sub analysis {
    my( $this, @result ) = @_;
    &_internal_analysis( $this, \@result );
}

sub _internal_analysis {
    my( $this, $result ) = @_;

    my $pattern = $this->{OPTION}->{option} =~ /\-(?:(mrph)?tab|bnst)\b/ ? $this->pattern() : '';
    $result = new KNP::Result( result  => $result,
			       pattern => $pattern,
			       bclass  => $this->{OPTION}->{bclass},
			       mclass  => $this->{OPTION}->{mclass},
			       tclass  => $this->{OPTION}->{tclass} );

    # result ᥽åɤ黲ȤǤ褦¸
    $this->{RESULT} = $result;

    # NOTE: Υϥå幽¤ľܥƤ륹ץȤθ
    # Τξٹ
    $this->{ALL}     = $result->all;
    $this->{COMMENT} = $result->comment;
    $this->{ERROR}   = $result->error;
    $this->{MRPH}    = [ $result->mrph ];
    $this->{BNST}    = [ $result->bnst ];

    delete $this->{_fatal_error};
    $result;
}

sub _set_error {
    my( $this, $error ) = @_;

    # ¹Է̤ꥻå
    delete $this->{RESULT};

    # ߴΤΥϥå
    delete $this->{ALL};
    delete $this->{COMMENT};
    delete $this->{ERROR};
    delete $this->{MRPH};
    delete $this->{BNST};

    if( $error ){
	$this->{_fatal_error} = $error;
    } else {
	delete $this->{_fatal_error};
    }
    undef;
}



#----------------------------------------------------------------------
#		ʸϷ̤Ф᥽å
#----------------------------------------------------------------------
sub detail {
    if( @_ == 1 ){
	my( $this ) = @_;
	$this->{DETAIL};
    } elsif( @_ == 2 ){
	my( $this, $type ) = @_;
	if( defined $this->{DETAIL}{$type} ){
	    $this->{DETAIL}{$type};
	} else {
	    carp "Unknown type ($type)";
	    undef;
	}
    } else {
        local $LIST_SEPARATOR = ', ';
        carp "Too many arguments (@_)";
	undef;
    }
}

sub result {
    my( $this ) = @_;
    $this->{RESULT} || undef;
}

sub error {
    my( $this ) = @_;
    $this->{_fatal_error} || undef;
}

1;
__END__
# Local Variables:
# mode: perl
# coding: euc-japan
# use-kuten-for-period: nil
# use-touten-for-comma: nil
# End:
