#!/usr/bin/env perl

use encoding 'euc-jp', STDIN => 'shiftjis';

# ʬɽǡ
#
#   1. եåԡǥ(sakuin.dat)ȥ˥(sakuin)ΰܤǼ̤
#      б
#
#   2. ˥ǤμΥХ򤳤ǽ
#
#   3. ˥Ǥˤϱѻʬब뤬̵롥
#
#   4. ˥ǤǤֹ椬ֹȹֹˤ狼Ƥꡤ줾
#      1ޤ2Ǥ롥
#      եåԡǥ(ֹ3)Ȥ魯˥˥ǤǤ
#      ֹȹֹޤȤưĤοȤ롥
#      ޤȤ᤿Ȥ4ˤʤΤϤʤñϢʤΤǰ
#      ݾڤʤ

#
#  Ǥΰ
#

$ZohoFirstLine = '000001,00001,A,,ط,,,1.1000,01,01,01,ԡʤΡ,,,Τ';

#
#  եåԡǤΰ
#

$FloppyFirstLine = ',,4.310,1,10,*,';

#
# ˥(sakuin)ΥХ
#

$bug_fix{"ä,ä,2.1527,B,1,3"} = "ä,ä,2.1527,5B,1,3";
$bug_fix{"Ǥˤʤ,Ǥˤʤ,2.1527,B,1,2"} = "Ǥˤʤ,Ǥˤʤ,2.1527,5B,1,2";
$bug_fix{"ˤʤ,ʤˤʤ,2.1527,B,1,4"} = "ˤʤ,ʤˤʤ,2.1527,5B,1,4";
$bug_fix{"Է,󤱤,2.1527,B,2,6"} = "Է,󤱤,2.1527,5B,2,6";
$bug_fix{"Թ,󤳤,2.1527,B,2,5"} = "Թ,󤳤,2.1527,5B,2,5";
$bug_fix{"Է,礦,2.1527,B,2,4"} = "Է,礦,2.1527,5B,2,4";
$bug_fix{"Թ,礦,2.1527,B,2,3"} = "Թ,礦,2.1527,5B,2,3";
$bug_fix{"湬,,2.1527,B,2,2"} = "湬,,2.1527,5B,2,2";
$bug_fix{"乬,󤳤,2.1527,B,2,7"} = "乬,󤳤,2.1527,5B,2,7";
$bug_fix{"ϸ,Ȥ,2.1527,B,2,1"} = "ϸ,Ȥ,2.1527,5B,2,1";
$bug_fix{"񤹤,ʤ󤹤,2.3310,B,1,4"} = "񤹤,ʤ󤹤,2.3310,2B,1,4";
$bug_fix{"Ҥ,Ҥ,2.3310,B,1,2"} = "Ҥ,Ҥ,2.3310,2B,1,2";
$bug_fix{"Ҥ,ꤵ,2.3310,B,1,3"} = "Ҥ,ꤵ,2.3310,2B,1,3";
$bug_fix{"񵷤,ʤ󤮤,2.3310,B,2,2"} = "񵷤,ʤ󤮤,2.3310,2B,2,2";
$bug_fix{"񤹤,Ҥʤ󤹤,2.3310,B,2,1"} = "񤹤,Ҥʤ󤹤,2.3310,2B,2,1";
$bug_fix{"Ǥ,ˤ󤹤,2.3312,B,1,4"} = "Ǥ,ˤ󤹤,2.3312,6B,1,4";
$bug_fix{",դ󤹤,2.3312,B,1,2"} = ",դ󤹤,2.3312,6B,1,2";
$bug_fix{",դ礯,2.3312,B,1,3"} = ",դ礯,2.3312,6B,1,3";
$bug_fix{"ܤ,Ф褦,2.3810,B,1,3"} = "ܤ,Ф褦,2.3810,8B,1,3";
$bug_fix{"ܤ,䤷ʤ,2.3810,B,1,2"} = "ܤ,䤷ʤ,2.3810,8B,1,2";
$bug_fix{"ܿ,褦礯,2.3810,B,1,4"} = "ܿ,褦礯,2.3810,8B,1,4";
$bug_fix{"餹,ʤ餹,2.3810,B,2,2"} = "餹,ʤ餹,2.3810,8B,2,2";
$bug_fix{",,2.3810,B,2,1"} = ",,2.3810,8B,2,1";
$bug_fix{"餹,,2.3810,B,3,2"} = "餹,,2.3810,8B,3,2";
$bug_fix{"ܤ,褦,2.3810,B,3,1"} = "ܤ,褦,2.3810,8B,3,1";
$bug_fix{"餹,Ҥ,2.3810,B,3,3"} = "餹,Ҥ,2.3810,8B,3,3";
$bug_fix{"Ҥ,ۤܤ,2.3810,B,4,1"} = "Ҥ,ۤܤ,2.3810,8B,4,1";
$bug_fix{"Ӥ,ܤ褦,2.3810,B,4,3"} = "Ӥ,ܤ褦,2.3810,8B,4,3";
$bug_fix{"ͷҤ,椦ܤ,2.3810,B,4,2"} = "ͷҤ,椦ܤ,2.3810,8B,4,2";
$bug_fix{",ˤ夦,2.3810,B,5,1"} = ",ˤ夦,2.3810,8B,5,1";
$bug_fix{"ν,礥 礦,1.2330,4,1,5"} = "ν,礦,1.2330,4,1,5";
$bug_fix{"ν,礥 礦,1.2411,1,6,1"} = "ν,礦,1.2411,1,6,1";
$bug_fix{"ɤ,ɤ,4.318 ,1,1,6"} = "ɤ,ɤ,4.3180,1,1,6";
$bug_fix{"ʤ,ʤ,4.318 ,1,1,2"} = "ʤ,ʤ,4.3180,1,1,2";
$bug_fix{"椨,ʤˤ椨,4.318 ,1,1,4"} = "椨,ʤˤ椨,4.3180,1,1,4";
$bug_fix{"ʤä,ʤä,4.318 ,1,1,5"} = "ʤä,ʤä,4.3180,1,1,5";
$bug_fix{"ʤ,ʤ,4.318 ,1,1,3"} = "ʤ,ʤ,4.3180,1,1,3";
$bug_fix{",,4.318 ,1,3,2"} = ",,4.3180,1,3,2";
$bug_fix{"ʤ,ʤ,4.318 ,1,3,1"} = "ʤ,ʤ,4.3180,1,3,1";
$bug_fix{",,1.1000,7,1,2"} = ",-,1.1000,7,1,2"; # ɤߤϿʤ
$bug_fix{",,1.2020,1,1,4"} = ",-,1.2020,1,1,4"; # ɤߤϿʤ
$bug_fix{"λҫ,Τ,1.4430,18,2,1"} = "λ,Τ,1.4430,18,2,1";

#
# main : ǽΰԤǥСȽǤȤϴؿƤ֤
#

$_ = <STDIN>;
chomp;
s/\r//g;

if ($_ eq $ZohoFirstLine) {
    print STDERR "Your BGH is Zoho Kaitei Version.\n";
    &zoho_format($_);
    while ( <STDIN> ) {
	chomp;
	s/\r//g;
	&zoho_format($_);
    }
}elsif ($_ eq $FloppyFirstLine) {
    print STDERR "Your BGH is Floppy Disk Version.\n";
    &fd_format($_);
    while ( <STDIN> ) {
	chomp;
	s/\r//g;
	&fd_format($_);
    }
} else {
    print STDERR "Your BGH is Monitor Version.\n";
    &monitor_format($_);
    while ( <STDIN> ) {
	chomp;
	s/\r//g;
	&monitor_format($_);
    }
}

#
# zoho_format : (bunruidb.txt)
# 11ΥɤϤޤ
#

sub zoho_format {
    
    my ($input) = @_;

    my ($a, $b, $c, $d, $e, $f, $g, $code1, $code2, $code3, $code4, $code5, $h, $hyouki, $yomi) = split(/,|\./, $input);

    if ($hyouki =~ /|||\)/) {next;} # invalid items

    $code = $code1.$code2.$code3.$code4.$code5;

    foreach $item (split(//,$hyouki)) {
	foreach $yomi_item (split(//,$yomi)) {
	    print "$item/$yomi_item $code\n";
	}
    }
}

#
# fd_format : եåԡǥ(sakuin.dat)
#

sub fd_format {
    
    my ($input) = @_;

    ($yomi, $hyouki, $code1, $code2, $code3, $code4) = split(/,|\./, $input);

    if ($hyouki =~ /|\)/) {next;} # invalid items

    if (length($code2) == 2) {
	$code2 .= "00";		# ʬֹϸ0Ĥ
    }
    elsif (length($code2) == 3) {
	$code2 .= "0";		# ʬֹϸ0Ĥ
    }
    $code = sprintf("%d%d%02d%03d", $code1, $code2, $code3, $code4);

    print "$hyouki/$yomi $code\n";
}

#
# monitor_format : ˥(sakuin)
#

sub monitor_format {
    
    my ($input) = @_;

    if ($bug_fix{$input}) {$input = $bug_fix{$input};}

    ($hyouki, $yomi, $code1, $code2, $code3, $code4, $code5) 
	= split(/,|\./, $input);
    
    $hyouki =~ s/[^\]*//g;
    $yomi =~ s/[^\]*//g;
    $code3 =~ s/[A-Z]$//;
    $code = sprintf("%d%d%02d%02d%02d", $code1, $code2, $code3, $code4, $code5);

    foreach $item (split(//,$hyouki)) {
	foreach $yomi_item (split(//,$yomi)) {
	    print "$item/$yomi_item $code\n";
	}
	# ȿѡȿưס֤ʤꤢȤꤢ礦פʤ
	# ǤŬ롥
    }	
}
