#!/usr/bin/env python3
# vim:fileencoding=utf-8

import os
from typing import List


def to_linear(a: float) -> float:
    if a <= 0.04045:
        return a / 12.92
    else:
        return float(pow((a + 0.055) / 1.055, 2.4))


def generate_srgb_lut(line_prefix: str = '') -> List[str]:
    values: List[str] = []
    lines: List[str] = []

    for i in range(256):
        values.append('{:1.5f}f'.format(to_linear(i / 255.0)))

    for i in range(16):
        lines.append(line_prefix + ', '.join(values[i * 16:(i + 1) * 16]) + ',')

    return lines


def generate_srgb_gamma_c() -> str:
    lines: List[str] = []

    lines.append('// Generated by gen-srgb-lut.py DO NOT edit')
    lines.append('#include "srgb_gamma.h"')
    lines.append('')
    lines.append('const GLfloat srgb_lut[256] = {')
    lines += generate_srgb_lut('    ')
    lines.append('};')

    return "\n".join(lines)


def main() -> None:
    c = generate_srgb_gamma_c()
    with open(os.path.join('kitty', 'srgb_gamma.c'), 'w') as f:
        f.write(f'{c}\n')


if __name__ == '__main__':
    main()
