/*

    This file is part of Kitlist, a program to maintain a simple list
    of items and assign items to one or more categories.

    Copyright (C) 2008,2009 Frank Dean

    Kitlist is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Kitlist is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Kitlist.  If not, see <http://www.gnu.org/licenses/>.

*/

#ifndef KIT_PARSER_H
#define KIT_PARSER_H 1

#include <libxml++/libxml++.h>

#include "kitmodel.hpp"


/**
 * \brief SaxParser implementation for reading the KitModel from an
 * XML document.
 */
class KitParser : public xmlpp::SaxParser {
 private:
    ModelCategory* m_category; ///< The most recently processed category element
    ModelItem* m_item; ///< The most recently processed item element
    Glib::ustring m_cdata; /// <The most recently processed CDATA
    void process_item(const AttributeList& attributes);
    void process_category(const AttributeList& attributes);
    void process_category_item(const AttributeList& attributes);
 public:
    /// Constructor taking the rich data model to save the XML document within.
    KitParser(KitModel& model) : xmlpp::SaxParser(), m_model(model), m_category(NULL), m_item(NULL) {}
    virtual ~KitParser() {}
 protected:
    KitModel& m_model;
    virtual void on_start_document();
    virtual void on_end_document();
    virtual void on_start_element(const Glib::ustring& name,
                                  const AttributeList& attributes);
    virtual void on_end_element(const Glib::ustring& name);
    virtual void on_characters(const Glib::ustring& text);
    virtual void on_comment(const Glib::ustring& text);
    virtual void on_warning(const Glib::ustring& text);
    virtual void on_error(const Glib::ustring& text);
    virtual void on_fatal_error(const Glib::ustring& text);

};

#endif // KIT_PARSER_H
