/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.ki.shell.configuration;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlinx.ki.shell.Plugin;
import org.jetbrains.kotlinx.ki.shell.configuration.CachedInstance;
import org.jetbrains.kotlinx.ki.shell.configuration.Converter;
import org.jetbrains.kotlinx.ki.shell.configuration.ListConverter;
import org.jetbrains.kotlinx.ki.shell.configuration.ReplConfiguration;
import org.jetbrains.kotlinx.ki.shell.configuration.TrimConverter;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\u0010(\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J/\u0010\u0011\u001a\u0004\u0018\u0001H\u0012\"\b\b\u0000\u0010\u0012*\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00062\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u0002H\u00120\u0016H\u0016\u00a2\u0006\u0002\u0010\u0017J\u0012\u0010\u0018\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0019\u001a\u00020\u0006H\u0016J\u000e\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0016J\b\u0010\u001b\u001a\u00020\u001cH\u0016J\u000e\u0010\n\u001a\b\u0012\u0004\u0012\u00020\r0\u001dH\u0016J\u0018\u0010\u001e\u001a\u00020\u001c2\u0006\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u001f\u001a\u00020\u0006H\u0016R\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR6\u0010\n\u001a*\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\f0\u000bj\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\f`\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006 "}, d2={"Lorg/jetbrains/kotlinx/ki/shell/configuration/PropertyBasedReplConfiguration;", "Lorg/jetbrains/kotlinx/ki/shell/configuration/ReplConfiguration;", "props", "Ljava/util/Properties;", "defaultPlugins", "", "", "(Ljava/util/Properties;Ljava/util/List;)V", "getDefaultPlugins", "()Ljava/util/List;", "plugins", "Ljava/util/LinkedHashMap;", "Lorg/jetbrains/kotlinx/ki/shell/configuration/CachedInstance;", "Lorg/jetbrains/kotlinx/ki/shell/Plugin;", "Lkotlin/collections/LinkedHashMap;", "getProps", "()Ljava/util/Properties;", "get", "T", "", "key", "converter", "Lorg/jetbrains/kotlinx/ki/shell/configuration/Converter;", "(Ljava/lang/String;Lorg/jetbrains/kotlinx/ki/shell/configuration/Converter;)Ljava/lang/Object;", "getPlugin", "klassName", "list", "load", "", "", "set", "value", "ki-shell"})
public class PropertyBasedReplConfiguration
extends ReplConfiguration {
    @NotNull
    private final Properties props;
    @NotNull
    private final List<String> defaultPlugins;
    @NotNull
    private final LinkedHashMap<String, CachedInstance<Plugin>> plugins;

    public PropertyBasedReplConfiguration(@NotNull Properties props, @NotNull List<String> defaultPlugins) {
        Intrinsics.checkNotNullParameter(props, "props");
        Intrinsics.checkNotNullParameter(defaultPlugins, "defaultPlugins");
        this.props = props;
        this.defaultPlugins = defaultPlugins;
        this.plugins = new LinkedHashMap();
    }

    @NotNull
    protected final Properties getProps() {
        return this.props;
    }

    @NotNull
    protected final List<String> getDefaultPlugins() {
        return this.defaultPlugins;
    }

    @Override
    @Nullable
    public <T> T get(@NotNull String key, @NotNull Converter<T> converter) {
        T t;
        String strValue;
        Intrinsics.checkNotNullParameter(key, "key");
        Intrinsics.checkNotNullParameter(converter, "converter");
        String string2 = strValue = this.props.getProperty(key);
        if (string2 != null) {
            String it = string2;
            boolean bl = false;
            t = converter.convert(strValue);
        } else {
            t = null;
        }
        return t;
    }

    @Override
    public void set(@NotNull String key, @NotNull String value2) {
        Intrinsics.checkNotNullParameter(key, "key");
        Intrinsics.checkNotNullParameter(value2, "value");
        this.check(key, value2);
        this.props.setProperty(key, value2);
    }

    @NotNull
    public List<String> list() {
        return CollectionsKt.toList((Iterable)this.getData().keySet());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void load() {
        List<String> pluginClasses = this.get("plugins", new ListConverter(TrimConverter.INSTANCE), this.defaultPlugins);
        Iterable $this$forEach$iv = pluginClasses;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            void this_$iv;
            CachedInstance instance;
            String klassName = (String)element$iv;
            boolean bl = false;
            CachedInstance cachedInstance = instance = new CachedInstance();
            Class<Plugin> type$iv = Plugin.class;
            boolean $i$f$load = false;
            Object cached$iv = this_$iv.getCache().get();
            if (cached$iv == null) {
                Class<?> klass$iv = this_$iv.getClass().getClassLoader().loadClass(klassName);
                Object obj = klass$iv.newInstance();
                if (obj == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlinx.ki.shell.Plugin");
                }
                Plugin result$iv = (Plugin)obj;
                this_$iv.getCache().set(result$iv);
            } else {
                Plugin cfr_ignored_0 = (Plugin)cached$iv;
            }
            ((Map)this.plugins).put(klassName, instance);
        }
    }

    @Override
    @Nullable
    public Plugin getPlugin(@NotNull String klassName) {
        Intrinsics.checkNotNullParameter(klassName, "klassName");
        CachedInstance<Plugin> cachedInstance = this.plugins.get(klassName);
        return cachedInstance != null ? cachedInstance.get() : null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Iterator<Plugin> plugins() {
        void $this$mapTo$iv$iv;
        Collection<CachedInstance<Plugin>> collection = this.plugins.values();
        Intrinsics.checkNotNullExpressionValue(collection, "plugins.values");
        Iterable $this$map$iv = collection;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            CachedInstance cachedInstance = (CachedInstance)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            Object t = it.get();
            Intrinsics.checkNotNull(t);
            collection2.add((Plugin)t);
        }
        return ((List)destination$iv$iv).iterator();
    }
}

