/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.util;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.incremental.KotlinLookupLocation;
import org.jetbrains.kotlin.incremental.UtilsKt;
import org.jetbrains.kotlin.incremental.components.LookupLocation;
import org.jetbrains.kotlin.incremental.components.LookupTracker;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.KotlinTypeKt;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000\u0018\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u001a\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"record", "", "Lorg/jetbrains/kotlin/incremental/components/LookupTracker;", "expression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "type", "Lorg/jetbrains/kotlin/types/KotlinType;", "frontend"})
public final class LookupTrackerUtilKt {
    public static final void record(@NotNull LookupTracker $this$record, @NotNull KtExpression expression2, @NotNull KotlinType type2) {
        Intrinsics.checkNotNullParameter($this$record, "<this>");
        Intrinsics.checkNotNullParameter(expression2, "expression");
        Intrinsics.checkNotNullParameter(type2, "type");
        if (KotlinTypeKt.isError(type2) || TypeUtilsKt.isUnit(type2)) {
            return;
        }
        ClassifierDescriptor classifierDescriptor = type2.getConstructor().getDeclarationDescriptor();
        if (classifierDescriptor == null) {
            return;
        }
        ClassifierDescriptor typeDescriptor = classifierDescriptor;
        DeclarationDescriptor declarationDescriptor = typeDescriptor.getContainingDeclaration();
        Intrinsics.checkNotNullExpressionValue(declarationDescriptor, "typeDescriptor.containingDeclaration");
        DeclarationDescriptor scopeDescriptor = declarationDescriptor;
        if (scopeDescriptor instanceof PackageFragmentDescriptor && !DescriptorUtils.isLocal(typeDescriptor)) {
            LookupLocation lookupLocation = new KotlinLookupLocation(expression2);
            PackageFragmentDescriptor packageFragmentDescriptor = (PackageFragmentDescriptor)scopeDescriptor;
            Name name2 = typeDescriptor.getName();
            Intrinsics.checkNotNullExpressionValue(name2, "typeDescriptor.name");
            UtilsKt.record($this$record, lookupLocation, packageFragmentDescriptor, name2);
        } else if (scopeDescriptor instanceof ClassDescriptor && !DescriptorUtils.isLocal(typeDescriptor)) {
            LookupLocation lookupLocation = new KotlinLookupLocation(expression2);
            ClassDescriptor classDescriptor = (ClassDescriptor)scopeDescriptor;
            Name name3 = typeDescriptor.getName();
            Intrinsics.checkNotNullExpressionValue(name3, "typeDescriptor.name");
            UtilsKt.record($this$record, lookupLocation, classDescriptor, name3);
        }
        for (TypeProjection typeArgument : type2.getArguments()) {
            if (typeArgument.isStarProjection()) continue;
            KotlinType kotlinType = typeArgument.getType();
            Intrinsics.checkNotNullExpressionValue(kotlinType, "typeArgument.type");
            LookupTrackerUtilKt.record($this$record, expression2, kotlinType);
        }
    }
}

