/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.eclipse.sisu.plexus;

import java.lang.annotation.Annotation;
import javax.inject.Inject;
import org.jetbrains.kotlin.com.google.inject.Key;
import org.jetbrains.kotlin.com.google.inject.Singleton;
import org.jetbrains.kotlin.com.google.inject.TypeLiteral;
import org.jetbrains.kotlin.com.google.inject.name.Named;
import org.jetbrains.kotlin.com.google.inject.name.Names;
import org.jetbrains.kotlin.org.eclipse.sisu.inject.BeanLocator;
import org.jetbrains.kotlin.org.eclipse.sisu.plexus.DefaultPlexusBeans;
import org.jetbrains.kotlin.org.eclipse.sisu.plexus.HintedPlexusBeans;
import org.jetbrains.kotlin.org.eclipse.sisu.plexus.PlexusBean;
import org.jetbrains.kotlin.org.eclipse.sisu.plexus.PlexusBeanLocator;
import org.jetbrains.kotlin.org.eclipse.sisu.plexus.RealmFilteredBeans;

@Singleton
public final class DefaultPlexusBeanLocator
implements PlexusBeanLocator {
    private final BeanLocator beanLocator;
    private final String visibility;

    @Inject
    public DefaultPlexusBeanLocator(BeanLocator beanLocator) {
        this(beanLocator, null);
    }

    public DefaultPlexusBeanLocator(BeanLocator beanLocator, String visibility2) {
        this.beanLocator = beanLocator;
        this.visibility = visibility2;
    }

    @Override
    public <T> Iterable<PlexusBean<T>> locate(TypeLiteral<T> role, String ... hints) {
        Key<T> key = hints.length == 1 ? Key.get(role, (Annotation)Names.named(hints[0])) : Key.get(role, Named.class);
        Iterable beans = this.beanLocator.locate(key);
        if ("realm".equalsIgnoreCase(this.visibility)) {
            beans = new RealmFilteredBeans(beans);
        }
        return hints.length <= 1 ? new DefaultPlexusBeans(beans) : new HintedPlexusBeans(beans, role, hints);
    }
}

