/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.eclipse.aether.util.graph.transformer;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.kotlin.org.eclipse.aether.RepositoryException;
import org.jetbrains.kotlin.org.eclipse.aether.util.graph.transformer.ConflictResolver;

public final class JavaScopeSelector
extends ConflictResolver.ScopeSelector {
    @Override
    public void selectScope(ConflictResolver.ConflictContext context) throws RepositoryException {
        String scope2 = context.getWinner().getDependency().getScope();
        if (!"system".equals(scope2)) {
            scope2 = this.chooseEffectiveScope(context.getItems());
        }
        context.setScope(scope2);
    }

    private String chooseEffectiveScope(Collection<ConflictResolver.ConflictItem> items) {
        HashSet<String> scopes = new HashSet<String>();
        for (ConflictResolver.ConflictItem item : items) {
            if (item.getDepth() <= 1) {
                return item.getDependency().getScope();
            }
            scopes.addAll(item.getScopes());
        }
        return this.chooseEffectiveScope((Set<String>)scopes);
    }

    private String chooseEffectiveScope(Set<String> scopes) {
        if (scopes.size() > 1) {
            scopes.remove("system");
        }
        String effectiveScope = "";
        if (scopes.size() == 1) {
            effectiveScope = scopes.iterator().next();
        } else if (scopes.contains("compile")) {
            effectiveScope = "compile";
        } else if (scopes.contains("runtime")) {
            effectiveScope = "runtime";
        } else if (scopes.contains("provided")) {
            effectiveScope = "provided";
        } else if (scopes.contains("test")) {
            effectiveScope = "test";
        }
        return effectiveScope;
    }
}

