/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.eclipse.aether.transfer;

import org.jetbrains.kotlin.org.eclipse.aether.metadata.Metadata;
import org.jetbrains.kotlin.org.eclipse.aether.repository.LocalRepository;
import org.jetbrains.kotlin.org.eclipse.aether.repository.RemoteRepository;
import org.jetbrains.kotlin.org.eclipse.aether.transfer.MetadataTransferException;

public class MetadataNotFoundException
extends MetadataTransferException {
    public MetadataNotFoundException(Metadata metadata2, LocalRepository repository) {
        super(metadata2, null, "Could not find metadata " + metadata2 + MetadataNotFoundException.getString(" in ", repository));
    }

    private static String getString(String prefix, LocalRepository repository) {
        if (repository == null) {
            return "";
        }
        return prefix + repository.getId() + " (" + repository.getBasedir() + ")";
    }

    public MetadataNotFoundException(Metadata metadata2, RemoteRepository repository) {
        super(metadata2, repository, "Could not find metadata " + metadata2 + MetadataNotFoundException.getString(" in ", repository));
    }

    public MetadataNotFoundException(Metadata metadata2, RemoteRepository repository, String message, boolean fromCache) {
        super(metadata2, repository, message, fromCache);
    }

    public MetadataNotFoundException(Metadata metadata2, RemoteRepository repository, String message, Throwable cause) {
        super(metadata2, repository, message, cause);
    }
}

