/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.eclipse.aether.internal.impl.collect;

import java.util.HashMap;
import java.util.Map;
import org.jetbrains.kotlin.org.eclipse.aether.RepositorySystemSession;
import org.jetbrains.kotlin.org.eclipse.aether.artifact.ArtifactType;
import org.jetbrains.kotlin.org.eclipse.aether.artifact.ArtifactTypeRegistry;

public class CachingArtifactTypeRegistry
implements ArtifactTypeRegistry {
    private final ArtifactTypeRegistry delegate;
    private final Map<String, ArtifactType> types;

    public static ArtifactTypeRegistry newInstance(RepositorySystemSession session2) {
        return CachingArtifactTypeRegistry.newInstance(session2.getArtifactTypeRegistry());
    }

    public static ArtifactTypeRegistry newInstance(ArtifactTypeRegistry delegate2) {
        return delegate2 != null ? new CachingArtifactTypeRegistry(delegate2) : null;
    }

    private CachingArtifactTypeRegistry(ArtifactTypeRegistry delegate2) {
        this.delegate = delegate2;
        this.types = new HashMap<String, ArtifactType>();
    }

    @Override
    public ArtifactType get(String typeId) {
        ArtifactType type2 = this.types.get(typeId);
        if (type2 == null) {
            type2 = this.delegate.get(typeId);
            this.types.put(typeId, type2);
        }
        return type2;
    }
}

