/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.apache.http.impl.auth;

import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.jetbrains.kotlin.org.apache.http.Consts;
import org.jetbrains.kotlin.org.apache.http.HeaderElement;
import org.jetbrains.kotlin.org.apache.http.HttpRequest;
import org.jetbrains.kotlin.org.apache.http.auth.ChallengeState;
import org.jetbrains.kotlin.org.apache.http.auth.MalformedChallengeException;
import org.jetbrains.kotlin.org.apache.http.impl.auth.AuthSchemeBase;
import org.jetbrains.kotlin.org.apache.http.message.BasicHeaderValueParser;
import org.jetbrains.kotlin.org.apache.http.message.ParserCursor;
import org.jetbrains.kotlin.org.apache.http.util.CharArrayBuffer;

public abstract class RFC2617Scheme
extends AuthSchemeBase
implements Serializable {
    private final Map<String, String> params = new HashMap<String, String>();
    private transient Charset credentialsCharset;

    @Deprecated
    public RFC2617Scheme(ChallengeState challengeState) {
        super(challengeState);
        this.credentialsCharset = Consts.ASCII;
    }

    public RFC2617Scheme(Charset credentialsCharset) {
        this.credentialsCharset = credentialsCharset != null ? credentialsCharset : Consts.ASCII;
    }

    public Charset getCredentialsCharset() {
        return this.credentialsCharset != null ? this.credentialsCharset : Consts.ASCII;
    }

    String getCredentialsCharset(HttpRequest request) {
        String charset = (String)request.getParams().getParameter("http.auth.credential-charset");
        if (charset == null) {
            charset = this.getCredentialsCharset().name();
        }
        return charset;
    }

    @Override
    protected void parseChallenge(CharArrayBuffer buffer, int pos, int len) throws MalformedChallengeException {
        BasicHeaderValueParser parser = BasicHeaderValueParser.INSTANCE;
        ParserCursor cursor = new ParserCursor(pos, buffer.length());
        HeaderElement[] elements = parser.parseElements(buffer, cursor);
        this.params.clear();
        for (HeaderElement element : elements) {
            this.params.put(element.getName().toLowerCase(Locale.ROOT), element.getValue());
        }
    }

    protected Map<String, String> getParameters() {
        return this.params;
    }

    public String getParameter(String name2) {
        if (name2 == null) {
            return null;
        }
        return this.params.get(name2.toLowerCase(Locale.ROOT));
    }

    @Override
    public String getRealm() {
        return this.getParameter("realm");
    }
}

