/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.lower;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.BodyLoweringPass;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.descriptors.DescriptorVisibility;
import org.jetbrains.kotlin.ir.IrBuiltIns;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.backend.js.JsCommonBackendContext;
import org.jetbrains.kotlin.ir.backend.js.ir.JsIrBuilder;
import org.jetbrains.kotlin.ir.backend.js.lower.PropertyLazyInitLoweringKt;
import org.jetbrains.kotlin.ir.backend.js.utils.MiscKt;
import org.jetbrains.kotlin.ir.builders.declarations.DeclarationBuildersKt;
import org.jetbrains.kotlin.ir.builders.declarations.IrFieldBuilder;
import org.jetbrains.kotlin.ir.builders.declarations.IrFunctionBuilder;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationContainer;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationsKt;
import org.jetbrains.kotlin.ir.declarations.IrFactory;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrSetField;
import org.jetbrains.kotlin.ir.expressions.IrStatementOriginImpl;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 )2\u00020\u0001:\u0001)B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J$\u0010\u0016\u001a\u00020\u00172\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u001b0\u00192\u0006\u0010\u001c\u001a\u00020\u001aH\u0002J\u0012\u0010\u001d\u001a\u0004\u0018\u00010\b2\u0006\u0010\u001e\u001a\u00020\u0007H\u0002J\u0018\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$H\u0016J(\u0010%\u001a\u00020 *\u00020\b2\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u001b0\u00192\u0006\u0010\u001c\u001a\u00020\u001aH\u0002J\u0014\u0010&\u001a\u00020\u001a*\u00020\u00132\u0006\u0010'\u001a\u00020(H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\u0005\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\b0\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR \u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\f0\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\nR\u0014\u0010\u000e\u001a\u00020\u000f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u00138BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006*"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/lower/PropertyLazyInitLowering;", "Lorg/jetbrains/kotlin/backend/common/BodyLoweringPass;", "context", "Lorg/jetbrains/kotlin/ir/backend/js/JsCommonBackendContext;", "(Lorg/jetbrains/kotlin/ir/backend/js/JsCommonBackendContext;)V", "fileToInitializationFuns", "", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "getFileToInitializationFuns", "()Ljava/util/Map;", "fileToInitializerPureness", "", "getFileToInitializerPureness", "irBuiltIns", "Lorg/jetbrains/kotlin/ir/IrBuiltIns;", "getIrBuiltIns", "()Lorg/jetbrains/kotlin/ir/IrBuiltIns;", "irFactory", "Lorg/jetbrains/kotlin/ir/declarations/IrFactory;", "getIrFactory", "()Lorg/jetbrains/kotlin/ir/declarations/IrFactory;", "buildBodyWithIfGuard", "Lorg/jetbrains/kotlin/ir/IrStatement;", "initializers", "", "Lorg/jetbrains/kotlin/ir/declarations/IrField;", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "initializedField", "createInitializationFunction", "file", "lower", "", "irBody", "Lorg/jetbrains/kotlin/ir/expressions/IrBody;", "container", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "buildPropertiesInitializationBody", "createInitializationField", "fileName", "", "Companion", "backend.js"})
public final class PropertyLazyInitLowering
implements BodyLoweringPass {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final JsCommonBackendContext context;

    public PropertyLazyInitLowering(@NotNull JsCommonBackendContext context) {
        Intrinsics.checkNotNullParameter(context, "context");
        this.context = context;
    }

    private final IrBuiltIns getIrBuiltIns() {
        return this.context.getIrBuiltIns();
    }

    private final IrFactory getIrFactory() {
        return this.context.getIrFactory();
    }

    private final Map<IrFile, IrSimpleFunction> getFileToInitializationFuns() {
        return this.context.getPropertyLazyInitialization().getFileToInitializationFuns();
    }

    private final Map<IrFile, Boolean> getFileToInitializerPureness() {
        return this.context.getPropertyLazyInitialization().getFileToInitializerPureness();
    }

    @Override
    public void lower(@NotNull IrBody irBody, @NotNull IrDeclaration container) {
        IrSimpleFunction irSimpleFunction;
        Intrinsics.checkNotNullParameter(irBody, "irBody");
        Intrinsics.checkNotNullParameter(container, "container");
        if (!this.context.getPropertyLazyInitialization().getEnabled()) {
            return;
        }
        if (!(container instanceof IrField || container instanceof IrSimpleFunction || container instanceof IrProperty)) {
            return;
        }
        if (!PropertyLazyInitLoweringKt.access$isCompatibleDeclaration(container, this.context)) {
            return;
        }
        IrDeclarationParent irDeclarationParent = container.getParent();
        IrFile irFile = irDeclarationParent instanceof IrFile ? (IrFile)irDeclarationParent : null;
        if (irFile == null) {
            return;
        }
        IrFile file2 = irFile;
        if (this.getFileToInitializationFuns().containsKey(file2)) {
            irSimpleFunction = this.getFileToInitializationFuns().get(file2);
        } else if (Intrinsics.areEqual(this.getFileToInitializerPureness().get(file2), true)) {
            irSimpleFunction = null;
        } else {
            IrSimpleFunction irSimpleFunction2;
            IrSimpleFunction it = irSimpleFunction2 = this.createInitializationFunction(file2);
            boolean bl = false;
            this.getFileToInitializationFuns().put(file2, it);
            irSimpleFunction = irSimpleFunction2;
        }
        if (irSimpleFunction == null) {
            return;
        }
        IrSimpleFunction initFun = irSimpleFunction;
        IrCall initializationCall = JsIrBuilder.buildCall$default(JsIrBuilder.INSTANCE, initFun.getSymbol(), initFun.getReturnType(), null, Companion.PROPERTY_INIT_FUN_CALL.INSTANCE, 4, null);
        if (container instanceof IrSimpleFunction) {
            MiscKt.prependFunctionCall(irBody, initializationCall);
        }
    }

    private final IrSimpleFunction createInitializationFunction(IrFile file2) {
        String fileName = IrDeclarationsKt.getName(file2);
        List declarations2 = CollectionsKt.toList((Iterable)file2.getDeclarations());
        Map fieldToInitializer = PropertyLazyInitLoweringKt.access$calculateFieldToExpression(declarations2, this.context);
        if (fieldToInitializer.isEmpty()) {
            return null;
        }
        boolean allFieldsInFilePure = PropertyLazyInitLoweringKt.access$allFieldsInFilePure(fieldToInitializer.values());
        Object object = allFieldsInFilePure;
        this.getFileToInitializerPureness().put(file2, (Boolean)object);
        if (allFieldsInFilePure) {
            return null;
        }
        Object $this$createInitializationFunction_u24lambda_u2d1 = object = this.createInitializationField(this.getIrFactory(), fileName);
        boolean bl = false;
        file2.getDeclarations().add((IrDeclaration)$this$createInitializationFunction_u24lambda_u2d1);
        $this$createInitializationFunction_u24lambda_u2d1.setParent(file2);
        Object initializedField = object;
        IrFactory $this$addFunction$iv = this.getIrFactory();
        boolean $i$f$addFunction = false;
        Object $this$buildFun$iv$iv = $this$addFunction$iv;
        boolean $i$f$buildFun = false;
        IrFunctionBuilder $this$buildFun_u24lambda_u2d16$iv$iv = new IrFunctionBuilder();
        boolean bl2 = false;
        IrFunctionBuilder $this$createInitializationFunction_u24lambda_u2d2 = $this$buildFun_u24lambda_u2d16$iv$iv;
        boolean bl3 = false;
        Name name2 = Name.identifier("init properties " + fileName);
        Intrinsics.checkNotNullExpressionValue(name2, "identifier(\"init properties $fileName\")");
        $this$createInitializationFunction_u24lambda_u2d2.setName(name2);
        $this$createInitializationFunction_u24lambda_u2d2.setReturnType(this.getIrBuiltIns().getUnitType());
        DescriptorVisibility descriptorVisibility = DescriptorVisibilities.INTERNAL;
        Intrinsics.checkNotNullExpressionValue(descriptorVisibility, "INTERNAL");
        $this$createInitializationFunction_u24lambda_u2d2.setVisibility(descriptorVisibility);
        $this$createInitializationFunction_u24lambda_u2d2.setOrigin(JsIrBuilder.SYNTHESIZED_DECLARATION.INSTANCE);
        Object function$iv = $this$buildFun$iv$iv = DeclarationBuildersKt.buildFunction((IrFactory)$this$buildFun$iv$iv, $this$buildFun_u24lambda_u2d16$iv$iv);
        boolean bl4 = false;
        ((IrDeclarationContainer)file2).getDeclarations().add((IrDeclaration)function$iv);
        function$iv.setParent(file2);
        Object $this$createInitializationFunction_u24lambda_u2d3 = object = $this$buildFun$iv$iv;
        boolean bl5 = false;
        this.buildPropertiesInitializationBody((IrSimpleFunction)$this$createInitializationFunction_u24lambda_u2d3, fieldToInitializer, (IrField)initializedField);
        return object;
    }

    private final IrField createInitializationField(IrFactory $this$createInitializationField, String fileName) {
        IrFactory $this$buildField$iv = $this$createInitializationField;
        boolean $i$f$buildField = false;
        IrFieldBuilder $this$buildField_u24lambda_u2d4$iv = new IrFieldBuilder();
        boolean bl = false;
        IrFieldBuilder $this$createInitializationField_u24lambda_u2d4 = $this$buildField_u24lambda_u2d4$iv;
        boolean bl2 = false;
        Name name2 = Name.identifier("properties initialized " + fileName);
        Intrinsics.checkNotNullExpressionValue(name2, "identifier(\"properties initialized $fileName\")");
        $this$createInitializationField_u24lambda_u2d4.setName(name2);
        $this$createInitializationField_u24lambda_u2d4.setType(this.getIrBuiltIns().getBooleanType());
        $this$createInitializationField_u24lambda_u2d4.setStatic(true);
        $this$createInitializationField_u24lambda_u2d4.setFinal(true);
        $this$createInitializationField_u24lambda_u2d4.setOrigin(JsIrBuilder.SYNTHESIZED_DECLARATION.INSTANCE);
        return DeclarationBuildersKt.buildField($this$buildField$iv, $this$buildField_u24lambda_u2d4$iv);
    }

    private final void buildPropertiesInitializationBody(IrSimpleFunction $this$buildPropertiesInitializationBody, Map<IrField, ? extends IrExpression> initializers, IrField initializedField) {
        $this$buildPropertiesInitializationBody.setBody(this.getIrFactory().createBlockBody(-1, -1, CollectionsKt.listOf(this.buildBodyWithIfGuard(initializers, initializedField))));
    }

    private final IrStatement buildBodyWithIfGuard(Map<IrField, ? extends IrExpression> initializers, IrField initializedField) {
        List<IrExpression> list2;
        List<IrExpression> $this$buildBodyWithIfGuard_u24lambda_u2d6 = list2 = CollectionsKt.createListBuilder();
        boolean bl = false;
        IrSetField upGuard = PropertyLazyInitLoweringKt.access$createIrSetField(initializedField, JsIrBuilder.INSTANCE.buildBoolean(this.context.getIrBuiltIns().getBooleanType(), true));
        $this$buildBodyWithIfGuard_u24lambda_u2d6.add(upGuard);
        Map<IrField, ? extends IrExpression> $this$forEach$iv = initializers;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<IrField, ? extends IrExpression>> iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry<IrField, ? extends IrExpression> element$iv;
            Map.Entry<IrField, ? extends IrExpression> entry = element$iv = iterator2.next();
            boolean bl2 = false;
            IrField field2 = entry.getKey();
            IrExpression expression2 = entry.getValue();
            $this$buildBodyWithIfGuard_u24lambda_u2d6.add(PropertyLazyInitLoweringKt.access$createIrSetField(field2, expression2));
        }
        $this$buildBodyWithIfGuard_u24lambda_u2d6.add(JsIrBuilder.INSTANCE.buildBlock(this.getIrBuiltIns().getUnitType()));
        List statements = CollectionsKt.build(list2);
        return JsIrBuilder.INSTANCE.buildIfElse(this.getIrBuiltIns().getUnitType(), PropertyLazyInitLoweringKt.access$createIrGetField(initializedField), JsIrBuilder.INSTANCE.buildBlock(this.getIrBuiltIns().getUnitType()), JsIrBuilder.INSTANCE.buildComposite(this.getIrBuiltIns().getUnitType(), statements));
    }

    @Override
    public void lower(@NotNull IrFile irFile) {
        BodyLoweringPass.DefaultImpls.lower(this, irFile);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/lower/PropertyLazyInitLowering$Companion;", "", "()V", "PROPERTY_INIT_FUN_CALL", "backend.js"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/lower/PropertyLazyInitLowering$Companion$PROPERTY_INIT_FUN_CALL;", "Lorg/jetbrains/kotlin/ir/expressions/IrStatementOriginImpl;", "()V", "backend.js"})
        public static final class PROPERTY_INIT_FUN_CALL
        extends IrStatementOriginImpl {
            @NotNull
            public static final PROPERTY_INIT_FUN_CALL INSTANCE = new PROPERTY_INIT_FUN_CALL();

            private PROPERTY_INIT_FUN_CALL() {
                super("PROPERTY_INIT_FUN_CALL");
            }
        }
    }
}

