/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.expression;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.config.AnalysisFlags;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticFactory1;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.FirLanguageSettingsComponentKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirAnnotationHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirOptInUsageBaseChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirAnnotationUtilsKt;
import org.jetbrains.kotlin.fir.expressions.FirAnnotationCall;
import org.jetbrains.kotlin.fir.expressions.FirCall;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.symbols.ConeClassLikeLookupTag;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.resolve.checkers.OptInNames;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\"\u0010\f\u001a\u00020\u00062\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirOptInAnnotationCallChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lorg/jetbrains/kotlin/fir/expressions/FirAnnotationCall;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirAnnotationCallChecker;", "()V", "check", "", "expression", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkOptInIsEnabled", "element", "Lorg/jetbrains/kotlin/KtSourceElement;", "checkers"})
public final class FirOptInAnnotationCallChecker
extends FirExpressionChecker<FirAnnotationCall> {
    @NotNull
    public static final FirOptInAnnotationCallChecker INSTANCE = new FirOptInAnnotationCallChecker();

    private FirOptInAnnotationCallChecker() {
    }

    @Override
    public void check(@NotNull FirAnnotationCall expression2, @NotNull CheckerContext context, @NotNull DiagnosticReporter reporter2) {
        Object object;
        Intrinsics.checkNotNullParameter(expression2, "expression");
        Intrinsics.checkNotNullParameter(context, "context");
        Intrinsics.checkNotNullParameter(reporter2, "reporter");
        FirTypeRef $this$coneTypeSafe$iv = expression2.getAnnotationTypeRef();
        boolean $i$f$coneTypeSafe = false;
        FirResolvedTypeRef firResolvedTypeRef = $this$coneTypeSafe$iv instanceof FirResolvedTypeRef ? (FirResolvedTypeRef)$this$coneTypeSafe$iv : null;
        ConeKotlinType coneKotlinType = firResolvedTypeRef != null ? firResolvedTypeRef.getType() : null;
        if (!(coneKotlinType instanceof ConeClassLikeType)) {
            coneKotlinType = null;
        }
        if ((object = (ConeClassLikeType)((ConeKotlinType)((ConeClassLikeType)coneKotlinType))) == null || (object = ((ConeClassLikeType)object).getLookupTag()) == null) {
            return;
        }
        Object lookupTag2 = object;
        ClassId classId = ((ConeClassLikeLookupTag)lookupTag2).getClassId();
        boolean isRequiresOptIn = Intrinsics.areEqual(classId, OptInNames.INSTANCE.getREQUIRES_OPT_IN_CLASS_ID());
        boolean isOptIn = Intrinsics.areEqual(classId, OptInNames.INSTANCE.getOPT_IN_CLASS_ID());
        if (isRequiresOptIn || isOptIn) {
            this.checkOptInIsEnabled(expression2.getSource(), context, reporter2);
            if (isOptIn) {
                FirCall $this$arguments$iv = expression2;
                boolean $i$f$getArguments = false;
                List<FirExpression> arguments2 = $this$arguments$iv.getArgumentList().getArguments();
                if (arguments2.isEmpty()) {
                    KtDiagnosticReportHelpersKt.reportOn$default(reporter2, (AbstractKtSourceElement)expression2.getSource(), FirErrors.INSTANCE.getOPT_IN_WITHOUT_ARGUMENTS(), (DiagnosticContext)context, null, 8, null);
                } else {
                    FirExpression annotationClasses;
                    FirExpression firExpression2 = annotationClasses = FirAnnotationUtilsKt.findArgumentByName(expression2, OptInNames.INSTANCE.getUSE_EXPERIMENTAL_ANNOTATION_CLASS());
                    List<FirRegularClassSymbol> list2 = firExpression2 != null ? FirAnnotationHelpersKt.extractClassesFromArgument(firExpression2) : null;
                    if (list2 == null) {
                        list2 = CollectionsKt.emptyList();
                    }
                    for (FirRegularClassSymbol classSymbol : list2) {
                        FirOptInUsageBaseChecker $this$check_u24lambda_u2d0 = FirOptInUsageBaseChecker.INSTANCE;
                        boolean bl = false;
                        if (FirOptInUsageBaseChecker.loadExperimentalityForMarkerAnnotation$default($this$check_u24lambda_u2d0, classSymbol, null, 1, null) != null) continue;
                        AbstractKtSourceElement abstractKtSourceElement = expression2.getSource();
                        KtDiagnosticFactory1<FqName> ktDiagnosticFactory1 = FirErrors.INSTANCE.getOPT_IN_ARGUMENT_IS_NOT_MARKER();
                        FqName fqName2 = classSymbol.getClassId().asSingleFqName();
                        Intrinsics.checkNotNullExpressionValue(fqName2, "classSymbol.classId.asSingleFqName()");
                        KtDiagnosticReportHelpersKt.reportOn$default(reporter2, abstractKtSourceElement, ktDiagnosticFactory1, (Object)fqName2, (DiagnosticContext)context, null, 16, null);
                    }
                }
            }
        }
    }

    private final void checkOptInIsEnabled(KtSourceElement element, CheckerContext context, DiagnosticReporter reporter2) {
        LanguageVersionSettings languageVersionSettings = FirLanguageSettingsComponentKt.getLanguageVersionSettings(context.getSession());
        List<String> optInFqNames = languageVersionSettings.getFlag(AnalysisFlags.getOptIn());
        if (!languageVersionSettings.supportsFeature(LanguageFeature.OptInRelease) && !optInFqNames.contains(OptInNames.INSTANCE.getREQUIRES_OPT_IN_FQ_NAME().asString())) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter2, (AbstractKtSourceElement)element, FirErrors.INSTANCE.getOPT_IN_IS_NOT_ENABLED(), (DiagnosticContext)context, null, 8, null);
        }
    }
}

