/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util;

import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.util.SameThreadExecutorService;

public final class ConcurrencyUtil {
    @NotNull
    public static <K, V> V cacheOrGet(@NotNull ConcurrentMap<K, V> map2, @NotNull K key, @NotNull V defaultValue) {
        Object v;
        if (map2 == null) {
            ConcurrencyUtil.$$$reportNull$$$0(1);
        }
        if (key == null) {
            ConcurrencyUtil.$$$reportNull$$$0(2);
        }
        if (defaultValue == null) {
            ConcurrencyUtil.$$$reportNull$$$0(3);
        }
        if ((v = map2.get(key)) != null) {
            Object v2 = v;
            if (v2 == null) {
                ConcurrencyUtil.$$$reportNull$$$0(4);
            }
            return v2;
        }
        V prev = map2.putIfAbsent(key, defaultValue);
        V v3 = prev == null ? defaultValue : prev;
        if (v3 == null) {
            ConcurrencyUtil.$$$reportNull$$$0(5);
        }
        return v3;
    }

    @NotNull
    public static <T> T cacheOrGet(@NotNull AtomicReference<T> ref, @NotNull T defaultValue) {
        if (ref == null) {
            ConcurrencyUtil.$$$reportNull$$$0(6);
        }
        if (defaultValue == null) {
            ConcurrencyUtil.$$$reportNull$$$0(7);
        }
        T t = ref.updateAndGet(prev -> prev == null ? defaultValue : prev);
        if (t == null) {
            ConcurrencyUtil.$$$reportNull$$$0(8);
        }
        return t;
    }

    @NotNull
    public static ThreadPoolExecutor newSingleThreadExecutor(@NotNull @NonNls String name2) {
        if (name2 == null) {
            ConcurrencyUtil.$$$reportNull$$$0(9);
        }
        return ConcurrencyUtil.newSingleThreadExecutor(name2, 5);
    }

    @NotNull
    public static ThreadPoolExecutor newSingleThreadExecutor(@NonNls @NotNull String name2, int priority) {
        if (name2 == null) {
            ConcurrencyUtil.$$$reportNull$$$0(10);
        }
        return new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), ConcurrencyUtil.newNamedThreadFactory(name2, true, priority));
    }

    @NotNull
    public static ExecutorService newSameThreadExecutorService() {
        return new SameThreadExecutorService();
    }

    @NotNull
    public static ThreadFactory newNamedThreadFactory(@NonNls @NotNull String name2, boolean isDaemon, int priority) {
        if (name2 == null) {
            ConcurrencyUtil.$$$reportNull$$$0(14);
        }
        ThreadFactory threadFactory = r -> {
            Thread thread2 = new Thread(r, name2);
            thread2.setDaemon(isDaemon);
            thread2.setPriority(priority);
            return thread2;
        };
        if (threadFactory == null) {
            ConcurrencyUtil.$$$reportNull$$$0(15);
        }
        return threadFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void runUnderThreadName(@NotNull String name2, @NotNull Runnable runnable) {
        Thread currentThread;
        String oldThreadName;
        if (name2 == null) {
            ConcurrencyUtil.$$$reportNull$$$0(26);
        }
        if (runnable == null) {
            ConcurrencyUtil.$$$reportNull$$$0(27);
        }
        if (name2.equals(oldThreadName = (currentThread = Thread.currentThread()).getName())) {
            runnable.run();
        } else {
            currentThread.setName(name2);
            try {
                runnable.run();
            }
            finally {
                currentThread.setName(oldThreadName);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 13: 
            case 15: 
            case 17: 
            case 25: 
            case 29: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 13: 
            case 15: 
            case 17: 
            case 25: 
            case 29: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tasks";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultValue";
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 13: 
            case 15: 
            case 17: 
            case 25: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/util/ConcurrencyUtil";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 16: 
            case 23: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unit";
                break;
            }
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "threads";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "futures";
                break;
            }
            case 24: 
            case 27: 
            case 31: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "delegate";
                break;
            }
            case 30: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lock";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/util/ConcurrencyUtil";
                break;
            }
            case 4: 
            case 5: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "cacheOrGet";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "newSingleScheduledThreadExecutor";
                break;
            }
            case 15: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "newNamedThreadFactory";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "underThreadNameRunnable";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "once";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "invokeAll";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "cacheOrGet";
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 13: 
            case 15: 
            case 17: 
            case 25: 
            case 29: {
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "newSingleThreadExecutor";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "newSingleScheduledThreadExecutor";
                break;
            }
            case 14: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "newNamedThreadFactory";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "awaitQuiescence";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "joinAll";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getAll";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "underThreadNameRunnable";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "runUnderThreadName";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "once";
                break;
            }
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "withLock";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 13: 
            case 15: 
            case 17: 
            case 25: 
            case 29: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

