/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi;

import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.core.JavaPsiBundle;
import org.jetbrains.kotlin.com.intellij.openapi.util.NullUtils;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.kotlin.com.intellij.psi.PsiClass;
import org.jetbrains.kotlin.com.intellij.psi.PsiClassType;
import org.jetbrains.kotlin.com.intellij.psi.PsiType;
import org.jetbrains.kotlin.com.intellij.psi.PsiTypeVisitor;
import org.jetbrains.kotlin.com.intellij.psi.TypeAnnotationProvider;
import org.jetbrains.kotlin.com.intellij.psi.search.GlobalSearchScope;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiUtil;
import org.jetbrains.kotlin.com.intellij.psi.util.TypeConversionUtil;

public final class PsiIntersectionType
extends PsiType.Stub {
    private final PsiType[] myConjuncts;

    private PsiIntersectionType(PsiType @NotNull [] conjuncts) {
        if (conjuncts == null) {
            PsiIntersectionType.$$$reportNull$$$0(0);
        }
        super(TypeAnnotationProvider.EMPTY);
        if (NullUtils.hasNull(conjuncts)) {
            throw new IllegalArgumentException("Null conjunct");
        }
        this.myConjuncts = conjuncts;
    }

    @NotNull
    public static PsiType createIntersection(@NotNull List<PsiType> conjuncts) {
        if (conjuncts == null) {
            PsiIntersectionType.$$$reportNull$$$0(1);
        }
        return PsiIntersectionType.createIntersection(conjuncts.toArray(PsiIntersectionType.createArray(conjuncts.size())));
    }

    @NotNull
    public static PsiType createIntersection(PsiType ... conjuncts) {
        return PsiIntersectionType.createIntersection(true, conjuncts);
    }

    @NotNull
    public static PsiType createIntersection(boolean flatten2, PsiType ... conjuncts) {
        if (conjuncts == null) {
            PsiIntersectionType.$$$reportNull$$$0(2);
        }
        assert (conjuncts.length > 0);
        if (flatten2) {
            conjuncts = PsiIntersectionType.flattenAndRemoveDuplicates(conjuncts);
        }
        if (conjuncts.length == 1) {
            PsiType psiType2 = conjuncts[0];
            if (psiType2 == null) {
                PsiIntersectionType.$$$reportNull$$$0(3);
            }
            return psiType2;
        }
        return new PsiIntersectionType(conjuncts);
    }

    private static PsiType @NotNull [] flattenAndRemoveDuplicates(PsiType @NotNull [] conjuncts) {
        PsiType[] psiTypeArray;
        if (conjuncts == null) {
            PsiIntersectionType.$$$reportNull$$$0(4);
        }
        try {
            Set<PsiType> flattenConjuncts = PsiIntersectionType.flatten(conjuncts, new LinkedHashSet<PsiType>());
            psiTypeArray = flattenConjuncts.toArray(PsiIntersectionType.createArray(flattenConjuncts.size()));
        }
        catch (NoSuchElementException e) {
            throw new RuntimeException(Arrays.toString(conjuncts), e);
        }
        if (psiTypeArray == null) {
            PsiIntersectionType.$$$reportNull$$$0(5);
        }
        return psiTypeArray;
    }

    @NotNull
    public static Set<PsiType> flatten(PsiType @NotNull [] conjuncts, Set<PsiType> types2) {
        if (conjuncts == null) {
            PsiIntersectionType.$$$reportNull$$$0(6);
        }
        for (PsiType conjunct : conjuncts) {
            if (conjunct instanceof PsiIntersectionType) {
                PsiIntersectionType type2 = (PsiIntersectionType)conjunct;
                PsiIntersectionType.flatten(type2.getConjuncts(), types2);
                continue;
            }
            types2.add(conjunct);
        }
        if (types2.size() > 1) {
            PsiType[] array2 = types2.toArray(PsiIntersectionType.createArray(types2.size()));
            Iterator<PsiType> iterator2 = types2.iterator();
            block1: while (iterator2.hasNext()) {
                PsiType type3 = iterator2.next();
                for (PsiType existing : array2) {
                    boolean allowUncheckedConversion;
                    if (type3 == existing) continue;
                    boolean bl = allowUncheckedConversion = type3 instanceof PsiClassType && ((PsiClassType)type3).isRaw();
                    if (!TypeConversionUtil.isAssignable(type3, existing, allowUncheckedConversion)) continue;
                    iterator2.remove();
                    continue block1;
                }
            }
            if (types2.isEmpty()) {
                types2.add(array2[0]);
            }
        }
        Set<PsiType> set = types2;
        if (set == null) {
            PsiIntersectionType.$$$reportNull$$$0(7);
        }
        return set;
    }

    public PsiType @NotNull [] getConjuncts() {
        if (this.myConjuncts == null) {
            PsiIntersectionType.$$$reportNull$$$0(8);
        }
        return this.myConjuncts;
    }

    @Override
    @NotNull
    public String getPresentableText(boolean annotated) {
        String string2 = StringUtil.join(this.myConjuncts, psiType2 -> psiType2.getPresentableText(annotated), " & ");
        if (string2 == null) {
            PsiIntersectionType.$$$reportNull$$$0(9);
        }
        return string2;
    }

    @Override
    @NotNull
    public String getCanonicalText(boolean annotated) {
        String string2 = this.myConjuncts[0].getCanonicalText(annotated);
        if (string2 == null) {
            PsiIntersectionType.$$$reportNull$$$0(10);
        }
        return string2;
    }

    @Override
    @NotNull
    public String getInternalCanonicalText() {
        String string2 = StringUtil.join(this.myConjuncts, psiType2 -> psiType2.getInternalCanonicalText(), " & ");
        if (string2 == null) {
            PsiIntersectionType.$$$reportNull$$$0(11);
        }
        return string2;
    }

    @Override
    public boolean isValid() {
        for (PsiType conjunct : this.myConjuncts) {
            if (conjunct.isValid()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean equalsToText(@NotNull String text2) {
        if (text2 == null) {
            PsiIntersectionType.$$$reportNull$$$0(12);
        }
        return false;
    }

    @Override
    public <A> A accept(@NotNull PsiTypeVisitor<A> visitor2) {
        if (visitor2 == null) {
            PsiIntersectionType.$$$reportNull$$$0(13);
        }
        return visitor2.visitIntersectionType(this);
    }

    @Override
    public GlobalSearchScope getResolveScope() {
        return this.myConjuncts[0].getResolveScope();
    }

    @Override
    public PsiType @NotNull [] getSuperTypes() {
        if (this.myConjuncts == null) {
            PsiIntersectionType.$$$reportNull$$$0(14);
        }
        return this.myConjuncts;
    }

    @NotNull
    public PsiType getRepresentative() {
        PsiType psiType2 = this.myConjuncts[0];
        if (psiType2 == null) {
            PsiIntersectionType.$$$reportNull$$$0(15);
        }
        return psiType2;
    }

    public boolean equals(Object obj) {
        PsiType[] second2;
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof PsiIntersectionType)) {
            return false;
        }
        PsiType[] first2 = this.getConjuncts();
        if (first2.length != (second2 = ((PsiIntersectionType)obj).getConjuncts()).length) {
            return false;
        }
        for (int i = 0; i < first2.length; ++i) {
            if (first2[i].equals(second2[i])) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return this.myConjuncts[0].hashCode();
    }

    @Override
    public String toString() {
        return Arrays.stream(this.myConjuncts).map(PsiType::getPresentableText).collect(Collectors.joining(", ", "PsiIntersectionType: ", ""));
    }

    @Nls
    public String getConflictingConjunctsMessage() {
        PsiType[] conjuncts = this.getConjuncts();
        for (int i = 0; i < conjuncts.length; ++i) {
            PsiClass conjunct = PsiUtil.resolveClassInClassTypeOnly(conjuncts[i]);
            if (conjunct == null || conjunct.isInterface()) continue;
            for (int i1 = i + 1; i1 < conjuncts.length; ++i1) {
                PsiClass oppositeConjunct = PsiUtil.resolveClassInClassTypeOnly(conjuncts[i1]);
                if (oppositeConjunct == null || oppositeConjunct.isInterface() || conjunct.isInheritor(oppositeConjunct, true) || oppositeConjunct.isInheritor(conjunct, true)) continue;
                return JavaPsiBundle.message("conflicting.conjuncts", conjuncts[i].getPresentableText(), conjuncts[i1].getPresentableText());
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 14: 
            case 15: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 14: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "conjuncts";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/psi/PsiIntersectionType";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/psi/PsiIntersectionType";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createIntersection";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "flattenAndRemoveDuplicates";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "flatten";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getConjuncts";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableText";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getCanonicalText";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getInternalCanonicalText";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuperTypes";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getRepresentative";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createIntersection";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 14: 
            case 15: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "flattenAndRemoveDuplicates";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "flatten";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "equalsToText";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 14: 
            case 15: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

