/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.google.common.util.concurrent;

import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jetbrains.kotlin.com.google.common.annotations.GwtIncompatible;
import org.jetbrains.kotlin.com.google.common.base.Preconditions;
import org.jetbrains.kotlin.com.google.common.util.concurrent.AbstractFuture;
import org.jetbrains.kotlin.com.google.common.util.concurrent.ListenableFuture;
import org.jetbrains.kotlin.com.google.common.util.concurrent.MoreExecutors;

@GwtIncompatible
final class TimeoutFuture<V>
extends AbstractFuture.TrustedFuture<V> {
    private ListenableFuture<V> delegateRef;
    private Future<?> timer;

    static <V> ListenableFuture<V> create(ListenableFuture<V> delegate2, long time, TimeUnit unit2, ScheduledExecutorService scheduledExecutor) {
        TimeoutFuture<V> result2 = new TimeoutFuture<V>(delegate2);
        Fire<V> fire = new Fire<V>(result2);
        result2.timer = scheduledExecutor.schedule(fire, time, unit2);
        delegate2.addListener(fire, MoreExecutors.directExecutor());
        return result2;
    }

    private TimeoutFuture(ListenableFuture<V> delegate2) {
        this.delegateRef = Preconditions.checkNotNull(delegate2);
    }

    @Override
    protected String pendingToString() {
        ListenableFuture<V> localInputFuture = this.delegateRef;
        if (localInputFuture != null) {
            return "inputFuture=[" + localInputFuture + "]";
        }
        return null;
    }

    @Override
    protected void afterDone() {
        this.maybePropagateCancellationTo(this.delegateRef);
        Future<?> localTimer = this.timer;
        if (localTimer != null) {
            localTimer.cancel(false);
        }
        this.delegateRef = null;
        this.timer = null;
    }

    private static final class Fire<V>
    implements Runnable {
        TimeoutFuture<V> timeoutFutureRef;

        Fire(TimeoutFuture<V> timeoutFuture) {
            this.timeoutFutureRef = timeoutFuture;
        }

        @Override
        public void run() {
            TimeoutFuture<V> timeoutFuture = this.timeoutFutureRef;
            if (timeoutFuture == null) {
                return;
            }
            ListenableFuture delegate2 = ((TimeoutFuture)timeoutFuture).delegateRef;
            if (delegate2 == null) {
                return;
            }
            this.timeoutFutureRef = null;
            if (delegate2.isDone()) {
                timeoutFuture.setFuture(delegate2);
            } else {
                try {
                    timeoutFuture.setException(new TimeoutException("Future timed out: " + delegate2));
                }
                finally {
                    delegate2.cancel(true);
                }
            }
        }
    }
}

