/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.google.common.collect;

import java.io.Serializable;
import java.util.Map;
import org.jetbrains.kotlin.com.google.common.annotations.GwtIncompatible;
import org.jetbrains.kotlin.com.google.common.base.Preconditions;
import org.jetbrains.kotlin.com.google.common.collect.ClassToInstanceMap;
import org.jetbrains.kotlin.com.google.common.collect.ForwardingMap;
import org.jetbrains.kotlin.com.google.common.collect.ImmutableMap;
import org.jetbrains.kotlin.com.google.common.primitives.Primitives;

@GwtIncompatible
public final class ImmutableClassToInstanceMap<B>
extends ForwardingMap<Class<? extends B>, B>
implements Serializable,
ClassToInstanceMap<B> {
    private static final ImmutableClassToInstanceMap<Object> EMPTY = new ImmutableClassToInstanceMap(ImmutableMap.of());
    private final ImmutableMap<Class<? extends B>, B> delegate;

    public static <B> ImmutableClassToInstanceMap<B> of() {
        return EMPTY;
    }

    public static <B, T extends B> ImmutableClassToInstanceMap<B> of(Class<T> type2, T value2) {
        ImmutableMap<Class<T>, T> map2 = ImmutableMap.of(type2, value2);
        return new ImmutableClassToInstanceMap<T>(map2);
    }

    public static <B> Builder<B> builder() {
        return new Builder();
    }

    public static <B, S extends B> ImmutableClassToInstanceMap<B> copyOf(Map<? extends Class<? extends S>, ? extends S> map2) {
        if (map2 instanceof ImmutableClassToInstanceMap) {
            ImmutableClassToInstanceMap cast = (ImmutableClassToInstanceMap)map2;
            return cast;
        }
        return new Builder().putAll(map2).build();
    }

    private ImmutableClassToInstanceMap(ImmutableMap<Class<? extends B>, B> delegate2) {
        this.delegate = delegate2;
    }

    @Override
    protected Map<Class<? extends B>, B> delegate() {
        return this.delegate;
    }

    @Override
    public <T extends B> T getInstance(Class<T> type2) {
        return (T)this.delegate.get(Preconditions.checkNotNull(type2));
    }

    @Override
    @Deprecated
    public <T extends B> T putInstance(Class<T> type2, T value2) {
        throw new UnsupportedOperationException();
    }

    Object readResolve() {
        return this.isEmpty() ? ImmutableClassToInstanceMap.of() : this;
    }

    public static final class Builder<B> {
        private final ImmutableMap.Builder<Class<? extends B>, B> mapBuilder = ImmutableMap.builder();

        public <T extends B> Builder<B> put(Class<T> key, T value2) {
            this.mapBuilder.put(key, value2);
            return this;
        }

        public <T extends B> Builder<B> putAll(Map<? extends Class<? extends T>, ? extends T> map2) {
            for (Map.Entry<Class<T>, T> entry : map2.entrySet()) {
                Class<? extends T> type2 = entry.getKey();
                T value2 = entry.getValue();
                this.mapBuilder.put(type2, Builder.cast(type2, value2));
            }
            return this;
        }

        private static <B, T extends B> T cast(Class<T> type2, B value2) {
            return Primitives.wrap(type2).cast(value2);
        }

        public ImmutableClassToInstanceMap<B> build() {
            ImmutableMap<Class<B>, B> map2 = this.mapBuilder.build();
            if (map2.isEmpty()) {
                return ImmutableClassToInstanceMap.of();
            }
            return new ImmutableClassToInstanceMap(map2);
        }
    }
}

