/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.checkers.diagnostics;

import java.util.Collection;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.checkers.diagnostics.AbstractTestDiagnostic;
import org.jetbrains.kotlin.checkers.diagnostics.ActualDiagnostic;
import org.jetbrains.kotlin.checkers.diagnostics.factories.DebugInfoDiagnosticFactory1;
import org.jetbrains.kotlin.checkers.utils.CheckerTestUtil;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.kotlin.com.intellij.util.containers.ContainerUtil;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.UnboundDiagnostic;
import org.jetbrains.kotlin.diagnostics.rendering.AbstractDiagnosticWithParametersRenderer;
import org.jetbrains.kotlin.diagnostics.rendering.DefaultErrorMessages;
import org.jetbrains.kotlin.diagnostics.rendering.DiagnosticParameterRenderer;
import org.jetbrains.kotlin.diagnostics.rendering.DiagnosticRenderer;
import org.jetbrains.kotlin.diagnostics.rendering.DiagnosticWithParameters1Renderer;
import org.jetbrains.kotlin.diagnostics.rendering.Renderers;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0005\u0018\u0000 #2\u00020\u0001:\u0002#$B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\u000e\u0010\u0005\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010\tJ\u001a\u0010\u0016\u001a\u00020\u00032\b\b\u0002\u0010\u0017\u001a\u00020\u00182\b\b\u0002\u0010\u0019\u001a\u00020\u0018J\u0011\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0001H\u0096\u0002J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\r\u001a\u00020\bH\u0016J\u0013\u0010\u001f\u001a\u00020\u00182\b\u0010\u001c\u001a\u0004\u0018\u00010 H\u0096\u0002J\b\u0010!\u001a\u00020\u001bH\u0016J\b\u0010\"\u001a\u00020\u0003H\u0016R\u0011\u0010\n\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\u00020\bX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\fR\u0019\u0010\u0005\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0016\u0010\u0004\u001a\u0004\u0018\u00010\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\f\u00a8\u0006%"}, d2={"Lorg/jetbrains/kotlin/checkers/diagnostics/TextDiagnostic;", "Lorg/jetbrains/kotlin/checkers/diagnostics/AbstractTestDiagnostic;", "name", "", "platform", "parameters", "", "inference", "Lorg/jetbrains/kotlin/checkers/diagnostics/TextDiagnostic$InferenceCompatibility;", "(Ljava/lang/String;Ljava/lang/String;Ljava/util/List;Lorg/jetbrains/kotlin/checkers/diagnostics/TextDiagnostic$InferenceCompatibility;)V", "description", "getDescription", "()Ljava/lang/String;", "inferenceCompatibility", "getInferenceCompatibility", "()Lorg/jetbrains/kotlin/checkers/diagnostics/TextDiagnostic$InferenceCompatibility;", "setInferenceCompatibility", "(Lorg/jetbrains/kotlin/checkers/diagnostics/TextDiagnostic$InferenceCompatibility;)V", "getName", "getParameters", "()Ljava/util/List;", "getPlatform", "asString", "withNewInference", "", "renderParameters", "compareTo", "", "other", "enhanceInferenceCompatibility", "", "equals", "", "hashCode", "toString", "Companion", "InferenceCompatibility", "frontend"})
public final class TextDiagnostic
implements AbstractTestDiagnostic {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String name;
    @Nullable
    private final String platform;
    @Nullable
    private final List<String> parameters;
    @NotNull
    private InferenceCompatibility inferenceCompatibility;
    private static final Pattern crossPlatformLineBreak = Pattern.compile("\\r?\\n");

    public TextDiagnostic(@NotNull String name2, @Nullable String platform, @Nullable List<String> parameters2, @Nullable InferenceCompatibility inference) {
        Intrinsics.checkNotNullParameter(name2, "name");
        this.name = name2;
        this.platform = platform;
        this.parameters = parameters2;
        InferenceCompatibility inferenceCompatibility = inference;
        if (inferenceCompatibility == null) {
            inferenceCompatibility = InferenceCompatibility.ALL;
        }
        this.inferenceCompatibility = inferenceCompatibility;
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    @Nullable
    public String getPlatform() {
        return this.platform;
    }

    @Nullable
    public final List<String> getParameters() {
        return this.parameters;
    }

    @Override
    @NotNull
    public InferenceCompatibility getInferenceCompatibility() {
        return this.inferenceCompatibility;
    }

    public void setInferenceCompatibility(@NotNull InferenceCompatibility inferenceCompatibility) {
        Intrinsics.checkNotNullParameter((Object)inferenceCompatibility, "<set-?>");
        this.inferenceCompatibility = inferenceCompatibility;
    }

    @NotNull
    public final String getDescription() {
        return (this.getPlatform() != null ? this.getPlatform() + ':' : "") + this.getName();
    }

    @Override
    public int compareTo(@NotNull AbstractTestDiagnostic other) {
        Intrinsics.checkNotNullParameter(other, "other");
        return this.getName().compareTo(other.getName());
    }

    @Override
    public void enhanceInferenceCompatibility(@NotNull InferenceCompatibility inferenceCompatibility) {
        Intrinsics.checkNotNullParameter((Object)inferenceCompatibility, "inferenceCompatibility");
        this.setInferenceCompatibility(inferenceCompatibility);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || !Intrinsics.areEqual(this.getClass(), other.getClass())) {
            return false;
        }
        TextDiagnostic that = (TextDiagnostic)other;
        if (!Intrinsics.areEqual(this.getName(), that.getName())) {
            return false;
        }
        boolean bl = this.getPlatform() != null ? !Intrinsics.areEqual(this.getPlatform(), that.getPlatform()) : that.getPlatform() != null;
        if (bl) {
            return false;
        }
        boolean bl2 = this.parameters != null ? !Intrinsics.areEqual(this.parameters, that.parameters) : that.parameters != null;
        if (bl2) {
            return false;
        }
        return this.getInferenceCompatibility() == that.getInferenceCompatibility();
    }

    public int hashCode() {
        int result2 = this.getName().hashCode();
        String string2 = this.getPlatform();
        result2 = 31 * result2 + (string2 != null ? string2.hashCode() : 0);
        List<String> list2 = this.parameters;
        result2 = 31 * result2 + (list2 != null ? ((Object)list2).hashCode() : 0);
        result2 = 31 * result2 + this.getInferenceCompatibility().hashCode();
        return result2;
    }

    @NotNull
    public final String asString(boolean withNewInference, boolean renderParameters) {
        StringBuilder result2 = new StringBuilder();
        if (withNewInference && this.getInferenceCompatibility().getAbbreviation$frontend() != null) {
            result2.append(this.getInferenceCompatibility().getAbbreviation$frontend());
            result2.append(";");
        }
        if (this.getPlatform() != null) {
            result2.append(this.getPlatform());
            result2.append(":");
        }
        result2.append(this.getName());
        if (renderParameters && this.parameters != null) {
            result2.append("(");
            result2.append(StringUtil.join((Collection)this.parameters, TextDiagnostic::asString$lambda-0, ", "));
            result2.append(")");
        }
        String string2 = result2.toString();
        Intrinsics.checkNotNullExpressionValue(string2, "result.toString()");
        return string2;
    }

    public static /* synthetic */ String asString$default(TextDiagnostic textDiagnostic, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        if ((n & 2) != 0) {
            bl2 = true;
        }
        return textDiagnostic.asString(bl, bl2);
    }

    @NotNull
    public String toString() {
        return TextDiagnostic.asString$default(this, false, false, 3, null);
    }

    private static final String asString$lambda-0(String it) {
        return '\"' + crossPlatformLineBreak.matcher(it).replaceAll(" ") + '\"';
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0011\b\u0002\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0000R\u001c\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bj\u0002\b\fj\u0002\b\rj\u0002\b\u000e\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/checkers/diagnostics/TextDiagnostic$InferenceCompatibility;", "", "abbreviation", "", "(Ljava/lang/String;ILjava/lang/String;)V", "getAbbreviation$frontend", "()Ljava/lang/String;", "setAbbreviation$frontend", "(Ljava/lang/String;)V", "isCompatible", "", "other", "NEW", "OLD", "ALL", "frontend"})
    public static final class InferenceCompatibility
    extends Enum<InferenceCompatibility> {
        @Nullable
        private String abbreviation;
        public static final /* enum */ InferenceCompatibility NEW = new InferenceCompatibility("NI");
        public static final /* enum */ InferenceCompatibility OLD = new InferenceCompatibility("OI");
        public static final /* enum */ InferenceCompatibility ALL = new InferenceCompatibility(null);
        private static final /* synthetic */ InferenceCompatibility[] $VALUES;

        private InferenceCompatibility(String abbreviation) {
            this.abbreviation = abbreviation;
        }

        @Nullable
        public final String getAbbreviation$frontend() {
            return this.abbreviation;
        }

        public final void setAbbreviation$frontend(@Nullable String string2) {
            this.abbreviation = string2;
        }

        public final boolean isCompatible(@NotNull InferenceCompatibility other) {
            Intrinsics.checkNotNullParameter((Object)other, "other");
            return this == other || this == ALL || other == ALL;
        }

        public static InferenceCompatibility[] values() {
            return (InferenceCompatibility[])$VALUES.clone();
        }

        public static InferenceCompatibility valueOf(String value2) {
            return Enum.valueOf(InferenceCompatibility.class, value2);
        }

        static {
            $VALUES = inferenceCompatibilityArray = new InferenceCompatibility[]{InferenceCompatibility.NEW, InferenceCompatibility.OLD, InferenceCompatibility.ALL};
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0012\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0002J\u001c\u0010\u0010\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0011\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0012\u001a\u00020\u000fH\u0002J\u000e\u0010\u0013\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u000fR\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/checkers/diagnostics/TextDiagnostic$Companion;", "", "()V", "crossPlatformLineBreak", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "asTextDiagnostic", "Lorg/jetbrains/kotlin/checkers/diagnostics/TextDiagnostic;", "abstractTestDiagnostic", "Lorg/jetbrains/kotlin/checkers/diagnostics/AbstractTestDiagnostic;", "actualDiagnostic", "Lorg/jetbrains/kotlin/checkers/diagnostics/ActualDiagnostic;", "computeInferenceCompatibility", "Lorg/jetbrains/kotlin/checkers/diagnostics/TextDiagnostic$InferenceCompatibility;", "abbreviation", "", "extractDataBefore", "prefix", "anchor", "parseDiagnostic", "text", "frontend"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final TextDiagnostic parseDiagnostic(@NotNull String text2) {
            Intrinsics.checkNotNullParameter(text2, "text");
            Matcher matcher2 = CheckerTestUtil.INSTANCE.getIndividualDiagnosticPattern().matcher(text2);
            if (!matcher2.find()) {
                throw new IllegalArgumentException("Could not parse diagnostic: " + text2);
            }
            InferenceCompatibility inference = this.computeInferenceCompatibility(this.extractDataBefore(matcher2.group(1), ";"));
            String platform = this.extractDataBefore(matcher2.group(2), ":");
            String name2 = matcher2.group(3);
            String string2 = matcher2.group(5);
            if (string2 == null) {
                Intrinsics.checkNotNullExpressionValue(name2, "name");
                return new TextDiagnostic(name2, platform, null, inference);
            }
            String parameters2 = string2;
            Intrinsics.checkNotNullExpressionValue(name2, "name");
            Object object = new char[]{'\"'};
            object = StringsKt.trim(parameters2, object);
            Regex regex = new Regex("\",\\s*\"");
            int n = 0;
            return new TextDiagnostic(name2, platform, regex.split((CharSequence)object, n), inference);
        }

        private final InferenceCompatibility computeInferenceCompatibility(String abbreviation) {
            InferenceCompatibility inferenceCompatibility;
            if (abbreviation == null) {
                inferenceCompatibility = InferenceCompatibility.ALL;
            } else {
                InferenceCompatibility[] $this$single$iv = InferenceCompatibility.values();
                boolean $i$f$single = false;
                InferenceCompatibility single$iv = null;
                boolean found$iv = false;
                int n = $this$single$iv.length;
                for (int i = 0; i < n; ++i) {
                    InferenceCompatibility element$iv;
                    InferenceCompatibility inference = element$iv = $this$single$iv[i];
                    boolean bl = false;
                    if (!Intrinsics.areEqual(abbreviation, inference.getAbbreviation$frontend())) continue;
                    if (found$iv) {
                        throw new IllegalArgumentException("Array contains more than one matching element.");
                    }
                    single$iv = element$iv;
                    found$iv = true;
                }
                if (!found$iv) {
                    throw new NoSuchElementException("Array contains no element matching the predicate.");
                }
                inferenceCompatibility = single$iv;
            }
            return inferenceCompatibility;
        }

        private final String extractDataBefore(String prefix, String anchor2) {
            boolean bl;
            boolean bl2 = bl = prefix == null || StringsKt.endsWith$default(prefix, anchor2, false, 2, null);
            if (_Assertions.ENABLED && !bl) {
                boolean bl3 = false;
                String string2 = prefix;
                if (string2 == null) {
                    string2 = "";
                }
                String string3 = string2;
                throw new AssertionError((Object)string3);
            }
            String string4 = prefix;
            return string4 != null ? StringsKt.substringBeforeLast(string4, anchor2, prefix) : null;
        }

        @NotNull
        public final TextDiagnostic asTextDiagnostic(@NotNull AbstractTestDiagnostic abstractTestDiagnostic) {
            Intrinsics.checkNotNullParameter(abstractTestDiagnostic, "abstractTestDiagnostic");
            return abstractTestDiagnostic instanceof ActualDiagnostic ? this.asTextDiagnostic((ActualDiagnostic)abstractTestDiagnostic) : (TextDiagnostic)abstractTestDiagnostic;
        }

        private final TextDiagnostic asTextDiagnostic(ActualDiagnostic actualDiagnostic) {
            Diagnostic diagnostic = actualDiagnostic.getDiagnostic();
            DiagnosticRenderer renderer2 = diagnostic.getFactory() instanceof DebugInfoDiagnosticFactory1 ? (DiagnosticRenderer)new DiagnosticWithParameters1Renderer("{0}", (DiagnosticParameterRenderer)Renderers.TO_STRING) : DefaultErrorMessages.getRendererForDiagnostic(diagnostic);
            String diagnosticName = actualDiagnostic.getName();
            if (renderer2 instanceof AbstractDiagnosticWithParametersRenderer) {
                Object[] renderParameters = ((AbstractDiagnosticWithParametersRenderer)renderer2).renderParameters((UnboundDiagnostic)diagnostic);
                List<String> list2 = ContainerUtil.map(renderParameters, Companion::asTextDiagnostic$lambda-2);
                Intrinsics.checkNotNullExpressionValue(list2, "map(renderParameters, { it.toString() })");
                List<String> parameters2 = list2;
                return new TextDiagnostic(diagnosticName, actualDiagnostic.getPlatform(), parameters2, actualDiagnostic.getInferenceCompatibility());
            }
            return new TextDiagnostic(diagnosticName, actualDiagnostic.getPlatform(), null, actualDiagnostic.getInferenceCompatibility());
        }

        private static final String asTextDiagnostic$lambda-2(Object it) {
            return String.valueOf(it);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

