/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.cli;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.cli.Action;
import kotlinx.cli.ArgumentAction;
import kotlinx.cli.CommandLineException;
import kotlinx.cli.CommandLineInterface;
import kotlinx.cli.FlagAction;
import kotlinx.cli.HelpPrintedException;
import kotlinx.cli.HelpPrinter;
import kotlinx.cli.MissingArgumentException;
import kotlinx.cli.PositionalArgument;
import kotlinx.cli.StopParsingException;
import kotlinx.cli.UtilKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010*\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010 \n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u000f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\bH\u0002J\u0016\u0010\u000f\u001a\u00020\f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\nH\u0002J\u0010\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u0011H\u0002J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0013\u001a\u00020\u0011H\u0002J\u001b\u0010\u0016\u001a\u00020\f2\u000e\u0010\u0017\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00110\u0018\u00a2\u0006\u0002\u0010\u0019J\u0014\u0010\u0016\u001a\u00020\f2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00110\u001aJ\u0014\u0010\u001b\u001a\u00020\f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\nJ\u0016\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00110\u001a2\u0006\u0010\u0013\u001a\u00020\u0011H\u0002J\u001c\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00110\u001a2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00110\u001aH\u0002J\u0016\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00110\u001a2\u0006\u0010\u0013\u001a\u00020\u0011H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\nX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lkotlinx/cli/CommandLineParser;", "", "cli", "Lkotlinx/cli/CommandLineInterface;", "(Lkotlinx/cli/CommandLineInterface;)V", "currentPositional", "Lkotlinx/cli/PositionalArgument;", "currentPositionalCount", "", "positionalsIterator", "", "checkEnoughPositionals", "", "positionalArgument", "actualCount", "doParse", "argsIterator", "", "handlePositionalArgument", "arg", "isShortTagPrefixed", "", "parse", "args", "", "([Ljava/lang/String;)V", "", "parseTokenized", "tokenizeArg", "tokenizeArgs", "tokenizeShortTags", "ki-shell"})
public final class CommandLineParser {
    @NotNull
    private final CommandLineInterface cli;
    private ListIterator<? extends PositionalArgument> positionalsIterator;
    @Nullable
    private PositionalArgument currentPositional;
    private int currentPositionalCount;

    public CommandLineParser(@NotNull CommandLineInterface cli) {
        Intrinsics.checkNotNullParameter(cli, "cli");
        this.cli = cli;
    }

    public final void parse(@NotNull String[] args2) {
        Intrinsics.checkNotNullParameter(args2, "args");
        this.parse(ArraysKt.asList(args2));
    }

    public final void parse(@NotNull List<String> args2) {
        Intrinsics.checkNotNullParameter(args2, "args");
        this.parseTokenized(this.tokenizeArgs(args2).listIterator());
    }

    public final void parseTokenized(@NotNull ListIterator<String> argsIterator) {
        Intrinsics.checkNotNullParameter(argsIterator, "argsIterator");
        if (!argsIterator.hasNext() && this.cli.getPrintHelpByDefault()) {
            CommandLineInterface.printHelp$default(this.cli, null, 1, null);
            throw new HelpPrintedException();
        }
        try {
            this.doParse(argsIterator);
        }
        catch (StopParsingException e) {
            throw e;
        }
        catch (Throwable e) {
            String string2 = e.getMessage();
            if (string2 != null) {
                String it = string2;
                boolean bl = false;
                HelpPrinter helpPrinter = this.cli.getDefaultHelpPrinter();
                if (helpPrinter != null) {
                    helpPrinter.printText(it);
                }
            }
            CommandLineInterface.printHelp$default(this.cli, null, 1, null);
            throw e;
        }
    }

    private final void doParse(ListIterator<String> argsIterator) {
        this.positionalsIterator = this.cli.getPositionalArgumentsIterator();
        ListIterator<? extends PositionalArgument> listIterator = this.positionalsIterator;
        if (listIterator == null) {
            Intrinsics.throwUninitializedPropertyAccessException("positionalsIterator");
            listIterator = null;
        }
        this.currentPositional = (PositionalArgument)UtilKt.nextOrNull((Iterator)listIterator);
        this.currentPositionalCount = 0;
        while (argsIterator.hasNext()) {
            String arg = argsIterator.next();
            if (this.cli.getArgumentsAfterDoubleDashArePositional() && Intrinsics.areEqual(arg, "--")) {
                while (argsIterator.hasNext()) {
                    this.handlePositionalArgument(argsIterator.next());
                }
                return;
            }
            Action action = this.cli.getFlagAction(arg);
            if (action == null) {
                this.handlePositionalArgument(arg);
                continue;
            }
            try {
                action.invoke(argsIterator);
            }
            catch (MissingArgumentException e) {
                throw new CommandLineException("No argument for flag " + arg);
            }
        }
        PositionalArgument positionalArgument2 = this.currentPositional;
        if (positionalArgument2 != null) {
            PositionalArgument it = positionalArgument2;
            boolean bl = false;
            this.checkEnoughPositionals(it, this.currentPositionalCount);
        }
        while (true) {
            ListIterator<? extends PositionalArgument> listIterator2;
            if ((listIterator2 = this.positionalsIterator) == null) {
                Intrinsics.throwUninitializedPropertyAccessException("positionalsIterator");
                listIterator2 = null;
            }
            if (!listIterator2.hasNext()) break;
            ListIterator<? extends PositionalArgument> listIterator3 = this.positionalsIterator;
            if (listIterator3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException("positionalsIterator");
                listIterator3 = null;
            }
            this.checkEnoughPositionals(listIterator3.next(), 0);
        }
    }

    private final void handlePositionalArgument(String arg) {
        PositionalArgument cp = this.currentPositional;
        boolean bl = false;
        if (cp != null) {
            cp.getAction().invoke(arg);
            int n = this.currentPositionalCount;
            this.currentPositionalCount = n + 1;
            if (this.currentPositionalCount >= cp.getMaxArgs()) {
                ListIterator<? extends PositionalArgument> listIterator = this.positionalsIterator;
                if (listIterator == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("positionalsIterator");
                    listIterator = null;
                }
                this.currentPositional = (PositionalArgument)UtilKt.nextOrNull((Iterator)listIterator);
                this.currentPositionalCount = 0;
            }
        } else {
            throw new CommandLineException("Unexpected positional argument: '" + arg + "'");
        }
    }

    private final void checkEnoughPositionals(PositionalArgument positionalArgument2, int actualCount) {
        if (actualCount < positionalArgument2.getMinArgs()) {
            throw new CommandLineException("Not enough positional arguments for " + positionalArgument2.getName() + ": " + actualCount + ", expected at least " + positionalArgument2.getMinArgs());
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> tokenizeArgs(List<String> args2) {
        void $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv = args2;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = this.tokenizeArg(it);
            CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final List<String> tokenizeArg(String arg) {
        if (this.cli.getFlagAction(arg) != null) {
            return CollectionsKt.listOf(arg);
        }
        if (this.cli.getLongTagValueDelimiter() != null) {
            int k;
            boolean bl;
            block7: {
                Iterable $this$any$iv = this.cli.getLongTagPrefixes();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        String it = (String)element$iv;
                        boolean bl2 = false;
                        if (!StringsKt.startsWith$default(arg, it, false, 2, null)) continue;
                        bl = true;
                        break block7;
                    }
                    bl = false;
                }
            }
            if (bl && (k = StringsKt.indexOf$default((CharSequence)arg, this.cli.getLongTagValueDelimiter(), 0, false, 6, null)) >= 0) {
                String string2 = arg.substring(0, k);
                Intrinsics.checkNotNullExpressionValue(string2, "this as java.lang.String\u2026ing(startIndex, endIndex)");
                String longTag = string2;
                String string3 = arg.substring(k + 1);
                Intrinsics.checkNotNullExpressionValue(string3, "this as java.lang.String).substring(startIndex)");
                String longValue = string3;
                String[] stringArray = new String[]{longTag, longValue};
                return CollectionsKt.listOf(stringArray);
            }
        }
        if (this.isShortTagPrefixed(arg)) {
            return this.tokenizeShortTags(arg);
        }
        return CollectionsKt.listOf(arg);
    }

    private final List<String> tokenizeShortTags(String arg) {
        ArrayList<Object> result2 = new ArrayList<Object>();
        int n = arg.length();
        for (int i = 1; i < n; ++i) {
            Action action;
            String fullTag = this.cli.getShortTagPrefix() + arg.charAt(i);
            if (this.cli.getFlagAction(fullTag) == null) {
                return CollectionsKt.listOf(arg);
            }
            Action action2 = action;
            if (!(action2 instanceof FlagAction)) {
                if (action2 instanceof ArgumentAction) {
                    result2.add(fullTag);
                    if (i < StringsKt.getLastIndex(arg)) {
                        String string2 = arg.substring(i + 1);
                        Intrinsics.checkNotNullExpressionValue(string2, "this as java.lang.String).substring(startIndex)");
                        result2.add(string2);
                    }
                    return result2;
                }
                throw new IllegalStateException(("Unexpected short tag action: " + fullTag + " => " + action).toString());
            }
            result2.add(fullTag);
        }
        return result2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isShortTagPrefixed(String arg) {
        String it;
        if (this.cli.getShortTagPrefix() == null) return false;
        if (!StringsKt.startsWith$default(arg, this.cli.getShortTagPrefix(), false, 2, null)) return false;
        Iterable $this$none$iv = this.cli.getLongTagPrefixes();
        boolean $i$f$none = false;
        if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
            return true;
        }
        Iterator iterator2 = $this$none$iv.iterator();
        do {
            if (!iterator2.hasNext()) return true;
            Object element$iv = iterator2.next();
            it = (String)element$iv;
            boolean bl = false;
        } while (!StringsKt.startsWith$default(arg, it, false, 2, null));
        return false;
    }
}

