/*
 * Decompiled with CFR 0.152.
 */
package kotlin.script.experimental.jvm.impl;

import java.io.File;
import java.net.JarURLConnection;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u00000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u001a\u0010\u0005\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0001H\u0002\u001a\u0012\u0010\t\u001a\u00020\n2\n\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\f\u001a\u001e\u0010\r\u001a\u0004\u0018\u00010\u00012\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\f2\u0006\u0010\u000f\u001a\u00020\u0001H\u0000\u001a\u001e\u0010\u0010\u001a\u0010\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u0001\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u0001H\u0002\u001a\u0014\u0010\u0013\u001a\u0004\u0018\u00010\n2\n\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\f\u001a\u0018\u0010\u0014\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0015\u001a\u00020\u00012\u0006\u0010\u0016\u001a\u00020\u0017\u001a\u000e\u0010\u0018\u001a\u0004\u0018\u00010\n*\u00020\u0007H\u0000\u001a\u000e\u0010\u0019\u001a\u0004\u0018\u00010\n*\u00020\u0007H\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"FILE_PROTOCOL", "", "JAR_PROTOCOL", "JAR_SEPARATOR", "SCHEME_SEPARATOR", "extractRoot", "resourceURL", "Ljava/net/URL;", "resourcePath", "getResourcePathForClass", "Ljava/io/File;", "aClass", "Ljava/lang/Class;", "getResourceRoot", "context", "path", "splitJarUrl", "Lkotlin/Pair;", "url", "tryGetResourcePathForClass", "tryGetResourcePathForClassByName", "name", "classLoader", "Ljava/lang/ClassLoader;", "toContainingJarOrNull", "toFileOrNull", "kotlin-scripting-jvm"})
public final class PathUtilKt {
    @NotNull
    private static final String JAR_PROTOCOL = "jar";
    @NotNull
    private static final String FILE_PROTOCOL = "file";
    @NotNull
    private static final String JAR_SEPARATOR = "!/";
    @NotNull
    private static final String SCHEME_SEPARATOR = "://";

    @Nullable
    public static final String getResourceRoot(@NotNull Class<?> context, @NotNull String path2) {
        Intrinsics.checkNotNullParameter(context, "context");
        Intrinsics.checkNotNullParameter(path2, "path");
        URL url = context.getResource(path2);
        if (url == null) {
            String string2 = path2.substring(1);
            Intrinsics.checkNotNullExpressionValue(string2, "this as java.lang.String).substring(startIndex)");
            url = ClassLoader.getSystemResource(string2);
        }
        URL uRL = url;
        return uRL != null ? PathUtilKt.extractRoot(uRL, path2) : null;
    }

    private static final String extractRoot(URL resourceURL, String resourcePath) {
        String string2;
        if (!StringsKt.startsWith$default((CharSequence)resourcePath, '/', false, 2, null) || StringsKt.startsWith$default((CharSequence)resourcePath, '\\', false, 2, null)) {
            return null;
        }
        String resultPath = null;
        String protocol = resourceURL.getProtocol();
        if (Intrinsics.areEqual(protocol, FILE_PROTOCOL)) {
            File file2 = PathUtilKt.toFileOrNull(resourceURL);
            Intrinsics.checkNotNull(file2);
            String path2 = file2.getPath();
            Intrinsics.checkNotNullExpressionValue(path2, "path");
            String testPath = StringsKt.replace$default(path2, '\\', '/', false, 4, null);
            String testResourcePath = StringsKt.replace$default(resourcePath, '\\', '/', false, 4, null);
            if (StringsKt.endsWith(testPath, testResourcePath, true)) {
                String string3 = path2.substring(0, path2.length() - resourcePath.length());
                Intrinsics.checkNotNullExpressionValue(string3, "this as java.lang.String\u2026ing(startIndex, endIndex)");
                resultPath = string3;
            }
        } else if (Intrinsics.areEqual(protocol, JAR_PROTOCOL)) {
            Pair<String, String> paths;
            String string4 = resourceURL.getFile();
            Intrinsics.checkNotNullExpressionValue(string4, "resourceURL.file");
            Pair<String, String> pair = paths = PathUtilKt.splitJarUrl(string4);
            if ((pair != null ? pair.getFirst() : null) != null) {
                resultPath = new File(paths.getFirst()).getCanonicalPath();
            }
        }
        String string5 = resultPath;
        if (string5 != null) {
            char[] cArray = new char[]{File.separatorChar};
            string2 = StringsKt.trimEnd(string5, cArray);
        } else {
            string2 = null;
        }
        return string2;
    }

    private static final Pair<String, String> splitJarUrl(String url) {
        String jarPath;
        String resourcePath;
        block6: {
            Integer n = StringsKt.indexOf$default((CharSequence)url, JAR_SEPARATOR, 0, false, 6, null);
            int it = ((Number)n).intValue();
            boolean bl = false;
            Integer n2 = it >= 0 ? n : null;
            if (n2 == null) {
                return null;
            }
            int pivot = n2;
            String string2 = url.substring(pivot + 2);
            Intrinsics.checkNotNullExpressionValue(string2, "this as java.lang.String).substring(startIndex)");
            resourcePath = string2;
            String string3 = url.substring(0, pivot);
            Intrinsics.checkNotNullExpressionValue(string3, "this as java.lang.String\u2026ing(startIndex, endIndex)");
            jarPath = string3;
            if (StringsKt.startsWith$default(jarPath, "jar:", false, 2, null)) {
                String string4 = jarPath.substring(JAR_PROTOCOL.length() + 1);
                Intrinsics.checkNotNullExpressionValue(string4, "this as java.lang.String).substring(startIndex)");
                jarPath = string4;
            }
            if (StringsKt.startsWith$default(jarPath, FILE_PROTOCOL, false, 2, null)) {
                try {
                    File file2 = PathUtilKt.toFileOrNull(new URL(jarPath));
                    Intrinsics.checkNotNull(file2);
                    String string5 = file2.getPath();
                    Intrinsics.checkNotNullExpressionValue(string5, "URL(jarPath).toFileOrNull()!!.path");
                    jarPath = StringsKt.replace$default(string5, '\\', '/', false, 4, null);
                }
                catch (Exception e) {
                    String string6 = jarPath.substring(FILE_PROTOCOL.length());
                    Intrinsics.checkNotNullExpressionValue(string6, "this as java.lang.String).substring(startIndex)");
                    jarPath = string6;
                    if (StringsKt.startsWith$default(jarPath, SCHEME_SEPARATOR, false, 2, null)) {
                        String string7 = jarPath.substring(SCHEME_SEPARATOR.length());
                        Intrinsics.checkNotNullExpressionValue(string7, "this as java.lang.String).substring(startIndex)");
                        jarPath = string7;
                    }
                    if (!StringsKt.startsWith$default((CharSequence)jarPath, ':', false, 2, null)) break block6;
                    String string8 = jarPath.substring(1);
                    Intrinsics.checkNotNullExpressionValue(string8, "this as java.lang.String).substring(startIndex)");
                    jarPath = string8;
                }
            }
        }
        return new Pair<String, String>(jarPath, resourcePath);
    }

    @Nullable
    public static final File tryGetResourcePathForClass(@NotNull Class<?> aClass) {
        File file2;
        Intrinsics.checkNotNullParameter(aClass, "aClass");
        StringBuilder stringBuilder2 = new StringBuilder().append('/');
        String string2 = aClass.getName();
        Intrinsics.checkNotNullExpressionValue(string2, "aClass.name");
        String path2 = stringBuilder2.append(StringsKt.replace$default(string2, '.', '/', false, 4, null)).append(".class").toString();
        String string3 = PathUtilKt.getResourceRoot(aClass, path2);
        if (string3 != null) {
            String it = string3;
            boolean bl = false;
            file2 = new File(it).getAbsoluteFile();
        } else {
            file2 = null;
        }
        return file2;
    }

    @NotNull
    public static final File getResourcePathForClass(@NotNull Class<?> aClass) {
        Intrinsics.checkNotNullParameter(aClass, "aClass");
        File file2 = PathUtilKt.tryGetResourcePathForClass(aClass);
        if (file2 == null) {
            throw new IllegalStateException("Resource for class: " + aClass.getName() + " not found");
        }
        return file2;
    }

    @Nullable
    public static final File tryGetResourcePathForClassByName(@NotNull String name2, @NotNull ClassLoader classLoader2) {
        File file2;
        Intrinsics.checkNotNullParameter(name2, "name");
        Intrinsics.checkNotNullParameter(classLoader2, "classLoader");
        try {
            File file3;
            Class<?> clazz = classLoader2.loadClass(name2);
            if (clazz != null) {
                Class<?> p0 = clazz;
                boolean bl = false;
                file3 = PathUtilKt.tryGetResourcePathForClass(p0);
            } else {
                file3 = null;
            }
            file2 = file3;
        }
        catch (ClassNotFoundException _) {
            file2 = null;
        }
        catch (NoClassDefFoundError _) {
            file2 = null;
        }
        return file2;
    }

    @Nullable
    public static final File toFileOrNull(@NotNull URL $this$toFileOrNull) {
        File file2;
        File file3;
        Intrinsics.checkNotNullParameter($this$toFileOrNull, "<this>");
        try {
            file3 = new File($this$toFileOrNull.toURI());
        }
        catch (IllegalArgumentException e) {
            file3 = null;
        }
        catch (URISyntaxException e) {
            file3 = null;
        }
        if ((file2 = file3) == null) {
            URL $this$toFileOrNull_u24lambda_u2d2 = $this$toFileOrNull;
            boolean bl = false;
            file2 = !Intrinsics.areEqual($this$toFileOrNull_u24lambda_u2d2.getProtocol(), FILE_PROTOCOL) ? null : new File($this$toFileOrNull_u24lambda_u2d2.getFile());
        }
        return file2;
    }

    @Nullable
    public static final File toContainingJarOrNull(@NotNull URL $this$toContainingJarOrNull) {
        URLConnection uRLConnection;
        Object object;
        Intrinsics.checkNotNullParameter($this$toContainingJarOrNull, "<this>");
        return Intrinsics.areEqual($this$toContainingJarOrNull.getProtocol(), JAR_PROTOCOL) ? ((object = (uRLConnection = $this$toContainingJarOrNull.openConnection()) instanceof JarURLConnection ? (JarURLConnection)uRLConnection : null) != null && (object = ((JarURLConnection)object).getJarFileURL()) != null ? PathUtilKt.toFileOrNull((URL)object) : null) : null;
    }
}

