/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.jvm.checkers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.config.JvmTarget;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.ClassConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationUseSiteTarget;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.descriptors.annotations.KotlinRetention;
import org.jetbrains.kotlin.descriptors.annotations.KotlinTarget;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.incremental.components.NoLookupLocation;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.load.java.JvmAnnotationNames;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtAnnotated;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtAnnotationUseSiteTarget;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.resolve.AdditionalAnnotationChecker;
import org.jetbrains.kotlin.resolve.AnnotationChecker;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.constants.ConstantValue;
import org.jetbrains.kotlin.resolve.constants.KClassValue;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.jvm.JvmPlatformAnnotationFeaturesSupport;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.ErrorsJvm;
import org.jetbrains.kotlin.resolve.scopes.MemberScope;
import org.jetbrains.kotlin.types.TypeUtils;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001:\u00010B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\"\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\"\u0010\u0012\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\"\u0010\u0013\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J>\u0010\u0014\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00110\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\u00172\u0006\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u0002\u001a\u00020\u0003H\u0016J \u0010\u001e\u001a\u00020\u00152\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J \u0010!\u001a\u00020\u00152\u0006\u0010\"\u001a\u00020 2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J(\u0010#\u001a\u00020\u00152\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u001e\u0010$\u001a\u00020\u00152\f\u0010%\u001a\b\u0012\u0004\u0012\u00020 0\u00172\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0010\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020\u000eH\u0002J\u0012\u0010)\u001a\u0004\u0018\u00010*2\u0006\u0010\u000f\u001a\u00020\u000eH\u0002J#\u0010+\u001a\u0002H,\"\u0004\b\u0000\u0010,2\u0006\u0010-\u001a\u0002H,2\u0006\u0010.\u001a\u0002H,H\u0002\u00a2\u0006\u0002\u0010/R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lorg/jetbrains/kotlin/resolve/jvm/checkers/RepeatableAnnotationChecker;", "Lorg/jetbrains/kotlin/resolve/AdditionalAnnotationChecker;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "jvmTarget", "Lorg/jetbrains/kotlin/config/JvmTarget;", "platformAnnotationFeaturesSupport", "Lorg/jetbrains/kotlin/resolve/jvm/JvmPlatformAnnotationFeaturesSupport;", "module", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "(Lorg/jetbrains/kotlin/config/LanguageVersionSettings;Lorg/jetbrains/kotlin/config/JvmTarget;Lorg/jetbrains/kotlin/resolve/jvm/JvmPlatformAnnotationFeaturesSupport;Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;)V", "checkContainerParameters", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "containerClass", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "annotationClass", "reportOn", "Lorg/jetbrains/kotlin/psi/KtAnnotationEntry;", "checkContainerRetention", "checkContainerTarget", "checkEntries", "", "entries", "", "actualTargets", "Lorg/jetbrains/kotlin/descriptors/annotations/KotlinTarget;", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "annotated", "Lorg/jetbrains/kotlin/psi/KtAnnotated;", "checkJavaRepeatableAnnotationDeclaration", "javaRepeatable", "Lorg/jetbrains/kotlin/resolve/jvm/checkers/RepeatableAnnotationChecker$ResolvedAnnotation;", "checkKotlinRepeatableAnnotationDeclaration", "kotlinRepeatable", "checkRepeatableAnnotationContainer", "checkRepeatedEntries", "annotations", "isRepeatableAnnotation", "", "classDescriptor", "resolveContainerAnnotation", "Lorg/jetbrains/kotlin/name/FqName;", "select", "D", "warning", "error", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;", "ResolvedAnnotation", "frontend.java"})
public final class RepeatableAnnotationChecker
implements AdditionalAnnotationChecker {
    @NotNull
    private final LanguageVersionSettings languageVersionSettings;
    @NotNull
    private final JvmTarget jvmTarget;
    @NotNull
    private final JvmPlatformAnnotationFeaturesSupport platformAnnotationFeaturesSupport;
    @NotNull
    private final ModuleDescriptor module;

    public RepeatableAnnotationChecker(@NotNull LanguageVersionSettings languageVersionSettings, @NotNull JvmTarget jvmTarget, @NotNull JvmPlatformAnnotationFeaturesSupport platformAnnotationFeaturesSupport, @NotNull ModuleDescriptor module2) {
        Intrinsics.checkNotNullParameter(languageVersionSettings, "languageVersionSettings");
        Intrinsics.checkNotNullParameter(jvmTarget, "jvmTarget");
        Intrinsics.checkNotNullParameter(platformAnnotationFeaturesSupport, "platformAnnotationFeaturesSupport");
        Intrinsics.checkNotNullParameter(module2, "module");
        this.languageVersionSettings = languageVersionSettings;
        this.jvmTarget = jvmTarget;
        this.platformAnnotationFeaturesSupport = platformAnnotationFeaturesSupport;
        this.module = module2;
    }

    @Override
    public void checkEntries(@NotNull List<? extends KtAnnotationEntry> entries2, @NotNull List<? extends KotlinTarget> actualTargets, @NotNull BindingTrace trace, @Nullable KtAnnotated annotated, @NotNull LanguageVersionSettings languageVersionSettings) {
        ClassDescriptor annotationClass;
        Iterable $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter(entries2, "entries");
        Intrinsics.checkNotNullParameter(actualTargets, "actualTargets");
        Intrinsics.checkNotNullParameter(trace, "trace");
        Intrinsics.checkNotNullParameter(languageVersionSettings, "languageVersionSettings");
        if (entries2.isEmpty()) {
            return;
        }
        Iterable $this$mapNotNull$iv = entries2;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            ResolvedAnnotation resolvedAnnotation;
            AnnotationUseSiteTarget useSiteTarget;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            KtAnnotationEntry entry = (KtAnnotationEntry)element$iv$iv;
            boolean bl2 = false;
            AnnotationDescriptor descriptor2 = (AnnotationDescriptor)trace.get(BindingContext.ANNOTATION, entry);
            KtAnnotationUseSiteTarget ktAnnotationUseSiteTarget = entry.getUseSiteTarget();
            AnnotationUseSiteTarget annotationUseSiteTarget = useSiteTarget = ktAnnotationUseSiteTarget == null ? null : ktAnnotationUseSiteTarget.getAnnotationUseSiteTarget();
            ResolvedAnnotation resolvedAnnotation2 = descriptor2 != null ? new ResolvedAnnotation(entry, descriptor2, useSiteTarget) : null;
            if (resolvedAnnotation2 == null) continue;
            ResolvedAnnotation it$iv$iv = resolvedAnnotation = resolvedAnnotation2;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List annotations2 = (List)destination$iv$iv;
        this.checkRepeatedEntries(annotations2, trace);
        if (annotated instanceof KtClassOrObject && ((KtClassOrObject)annotated).hasModifier(KtTokens.ANNOTATION_KEYWORD) && (annotationClass = (ClassDescriptor)trace.get(BindingContext.CLASS, annotated)) != null) {
            Object v2;
            ResolvedAnnotation javaRepeatable;
            block9: {
                Object object;
                Object object22;
                Iterable iterable2;
                block8: {
                    iterable2 = $this$mapNotNullTo$iv$iv = (Iterable)annotations2;
                    for (Object object22 : iterable2) {
                        ResolvedAnnotation it = (ResolvedAnnotation)object22;
                        boolean bl = false;
                        if (!Intrinsics.areEqual(it.getDescriptor().getFqName(), JvmAnnotationNames.REPEATABLE_ANNOTATION)) continue;
                        object = object22;
                        break block8;
                    }
                    object = null;
                }
                javaRepeatable = (ResolvedAnnotation)object;
                iterable2 = annotations2;
                Iterable iterable3 = iterable2;
                object22 = iterable3.iterator();
                while (object22.hasNext()) {
                    Object e = object22.next();
                    ResolvedAnnotation it = (ResolvedAnnotation)e;
                    boolean bl = false;
                    if (!Intrinsics.areEqual(it.getDescriptor().getFqName(), StandardNames.FqNames.repeatable)) continue;
                    v2 = e;
                    break block9;
                }
                v2 = null;
            }
            ResolvedAnnotation kotlinRepeatable = v2;
            if (javaRepeatable != null) {
                this.checkJavaRepeatableAnnotationDeclaration(javaRepeatable, annotationClass, trace);
            } else if (kotlinRepeatable != null) {
                this.checkKotlinRepeatableAnnotationDeclaration(kotlinRepeatable, annotationClass, trace);
            }
        }
    }

    private final void checkJavaRepeatableAnnotationDeclaration(ResolvedAnnotation javaRepeatable, ClassDescriptor annotationClass, BindingTrace trace) {
        ClassDescriptor containerClass;
        ConstantValue<?> containerKClassValue = javaRepeatable.getDescriptor().getAllValueArguments().get(Name.identifier("value"));
        if (containerKClassValue instanceof KClassValue && (containerClass = TypeUtils.getClassDescriptor(((KClassValue)containerKClassValue).getArgumentType(this.module))) != null) {
            this.checkRepeatableAnnotationContainer(annotationClass, containerClass, trace, javaRepeatable.getEntry());
        }
    }

    private final void checkKotlinRepeatableAnnotationDeclaration(ResolvedAnnotation kotlinRepeatable, ClassDescriptor annotationClass, BindingTrace trace) {
        MemberScope memberScope2 = annotationClass.getUnsubstitutedInnerClassesScope();
        Name name2 = Name.identifier("Container");
        Intrinsics.checkNotNullExpressionValue(name2, "identifier(JvmAbi.REPEAT\u2026NNOTATION_CONTAINER_NAME)");
        ClassifierDescriptor nestedClassNamedContainer = memberScope2.getContributedClassifier(name2, NoLookupLocation.FOR_ALREADY_TRACKED);
        if (nestedClassNamedContainer != null) {
            trace.report(this.select(ErrorsJvm.REPEATABLE_ANNOTATION_HAS_NESTED_CLASS_NAMED_CONTAINER, ErrorsJvm.REPEATABLE_ANNOTATION_HAS_NESTED_CLASS_NAMED_CONTAINER_ERROR).on((KtAnnotationEntry)((PsiElement)kotlinRepeatable.getEntry())));
        }
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final void checkRepeatedEntries(List<ResolvedAnnotation> annotations, BindingTrace trace) {
        entryTypesWithAnnotations = new HashMap<K, V>();
        for (ResolvedAnnotation var5_5 : annotations) {
            block18: {
                entry = var5_5.component1();
                descriptor = var5_5.component2();
                useSiteTarget = var5_5.component3();
                var10_10 = descriptor.getFqName();
                if (var10_10 == null) continue;
                fqName = var10_10;
                var11_11 = DescriptorUtilsKt.getAnnotationClass(descriptor);
                if (var11_11 == null) continue;
                classDescriptor = var11_11;
                $this$getOrPut$iv = entryTypesWithAnnotations;
                $i$f$getOrPut = false;
                value$iv = $this$getOrPut$iv.get(fqName);
                if (value$iv == null) {
                    $i$a$-getOrPut-RepeatableAnnotationChecker$checkRepeatedEntries$existingTargetsForAnnotation$1 = false;
                    answer$iv = new ArrayList<E>();
                    $this$getOrPut$iv.put(fqName, answer$iv);
                    v0 /* !! */  = answer$iv;
                } else {
                    v0 /* !! */  = value$iv;
                }
                if ((existingTargetsForAnnotation = (List)v0 /* !! */ ).contains((Object)useSiteTarget)) ** GOTO lbl-1000
                $this$any$iv = existingTargetsForAnnotation;
                $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    v1 = false;
                } else {
                    for (T element$iv : $this$any$iv) {
                        it = (AnnotationUseSiteTarget)element$iv;
                        $i$a$-any-RepeatableAnnotationChecker$checkRepeatedEntries$duplicateAnnotation$1 = false;
                        if (!(it == null != (useSiteTarget == null))) continue;
                        v1 = true;
                        break block18;
                    }
                    v1 = false;
                }
            }
            if (v1) lbl-1000:
            // 2 sources

            {
                v2 = true;
            } else {
                v2 = duplicateAnnotation = false;
            }
            if (duplicateAnnotation && this.isRepeatableAnnotation(classDescriptor) && DescriptorUtilsKt.getAnnotationRetention(classDescriptor) != KotlinRetention.SOURCE) {
                if (this.jvmTarget == JvmTarget.JVM_1_6) {
                    trace.report(ErrorsJvm.REPEATED_ANNOTATION_TARGET6.on((KtAnnotationEntry)((PsiElement)entry)));
                } else if (this.languageVersionSettings.supportsFeature(LanguageFeature.RepeatableAnnotations)) {
                    explicitContainer = this.resolveContainerAnnotation(classDescriptor);
                    if (explicitContainer != null) {
                        block19: {
                            $this$any$iv = annotations;
                            $i$f$any = false;
                            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                                v3 = false;
                            } else {
                                for (T element$iv : $this$any$iv) {
                                    it = (ResolvedAnnotation)element$iv;
                                    $i$a$-any-RepeatableAnnotationChecker$checkRepeatedEntries$1 = false;
                                    if (!Intrinsics.areEqual(it.getDescriptor().getFqName(), explicitContainer)) continue;
                                    v3 = true;
                                    break block19;
                                }
                                v3 = false;
                            }
                        }
                        if (v3) {
                            trace.report(ErrorsJvm.REPEATED_ANNOTATION_WITH_CONTAINER.on((KtAnnotationEntry)((PsiElement)entry), fqName, explicitContainer));
                        }
                    }
                } else {
                    trace.report(ErrorsJvm.NON_SOURCE_REPEATED_ANNOTATION.on((KtAnnotationEntry)((PsiElement)entry)));
                }
            }
            existingTargetsForAnnotation.add(useSiteTarget);
        }
    }

    private final void checkRepeatableAnnotationContainer(ClassDescriptor annotationClass, ClassDescriptor containerClass, BindingTrace trace, KtAnnotationEntry reportOn) {
        Diagnostic p0;
        Diagnostic diagnostic;
        Diagnostic diagnostic2 = this.checkContainerParameters(containerClass, annotationClass, reportOn);
        if (diagnostic2 != null) {
            p0 = diagnostic = diagnostic2;
            boolean bl = false;
            trace.report(p0);
        }
        diagnostic2 = this.checkContainerRetention(containerClass, annotationClass, reportOn);
        if (diagnostic2 != null) {
            p0 = diagnostic = diagnostic2;
            boolean bl = false;
            trace.report(p0);
        }
        diagnostic2 = this.checkContainerTarget(containerClass, annotationClass, reportOn);
        if (diagnostic2 != null) {
            p0 = diagnostic = diagnostic2;
            boolean bl = false;
            trace.report(p0);
        }
    }

    private final Diagnostic checkContainerParameters(ClassDescriptor containerClass, ClassDescriptor annotationClass, KtAnnotationEntry reportOn) {
        Object v1;
        block6: {
            Object v0;
            Iterable<ValueParameterDescriptor> iterable;
            ClassConstructorDescriptor containerCtor;
            block5: {
                ClassConstructorDescriptor classConstructorDescriptor;
                Object object2 = containerClass.getUnsubstitutedPrimaryConstructor();
                if (object2 == null) {
                    return null;
                }
                containerCtor = classConstructorDescriptor = object2;
                object2 = containerCtor.getValueParameters();
                Intrinsics.checkNotNullExpressionValue(object2, "containerCtor.valueParameters");
                iterable = object2 = (Iterable)object2;
                for (Object object3 : iterable) {
                    ValueParameterDescriptor it = (ValueParameterDescriptor)object3;
                    boolean bl = false;
                    if (!Intrinsics.areEqual(it.getName().asString(), "value")) continue;
                    v0 = object3;
                    break block5;
                }
                v0 = null;
            }
            ValueParameterDescriptor value2 = v0;
            if (value2 == null || !KotlinBuiltIns.isArray(value2.getType()) || !Intrinsics.areEqual(CollectionsKt.single(value2.getType().getArguments()).getType().getConstructor().getDeclarationDescriptor(), annotationClass)) {
                return this.select(ErrorsJvm.REPEATABLE_CONTAINER_MUST_HAVE_VALUE_ARRAY, ErrorsJvm.REPEATABLE_CONTAINER_MUST_HAVE_VALUE_ARRAY_ERROR).on((KtAnnotationEntry)((PsiElement)reportOn), DescriptorUtilsKt.getFqNameSafe(containerClass), DescriptorUtilsKt.getFqNameSafe(annotationClass));
            }
            iterable = containerCtor.getValueParameters();
            Intrinsics.checkNotNullExpressionValue(iterable, "containerCtor.valueParameters");
            iterable = iterable;
            List<ValueParameterDescriptor> list2 = iterable;
            Iterator iterator2 = list2.iterator();
            while (iterator2.hasNext()) {
                Object t = iterator2.next();
                ValueParameterDescriptor it = (ValueParameterDescriptor)t;
                boolean bl = false;
                if (!(!Intrinsics.areEqual(it.getName().asString(), "value") && !it.declaresDefaultValue())) continue;
                v1 = t;
                break block6;
            }
            v1 = null;
        }
        ValueParameterDescriptor otherNonDefault = v1;
        if (otherNonDefault != null) {
            return this.select(ErrorsJvm.REPEATABLE_CONTAINER_HAS_NON_DEFAULT_PARAMETER, ErrorsJvm.REPEATABLE_CONTAINER_HAS_NON_DEFAULT_PARAMETER_ERROR).on((KtAnnotationEntry)((PsiElement)reportOn), DescriptorUtilsKt.getFqNameSafe(containerClass), otherNonDefault);
        }
        return null;
    }

    private final Diagnostic checkContainerRetention(ClassDescriptor containerClass, ClassDescriptor annotationClass, KtAnnotationEntry reportOn) {
        KotlinRetention containerRetention;
        KotlinRetention kotlinRetention = DescriptorUtilsKt.getAnnotationRetention(annotationClass);
        KotlinRetention annotationRetention = kotlinRetention == null ? KotlinRetention.RUNTIME : kotlinRetention;
        KotlinRetention kotlinRetention2 = DescriptorUtilsKt.getAnnotationRetention(containerClass);
        KotlinRetention kotlinRetention3 = containerRetention = kotlinRetention2 == null ? KotlinRetention.RUNTIME : kotlinRetention2;
        if (containerRetention.compareTo((Enum)annotationRetention) > 0) {
            return this.select(ErrorsJvm.REPEATABLE_CONTAINER_HAS_SHORTER_RETENTION, ErrorsJvm.REPEATABLE_CONTAINER_HAS_SHORTER_RETENTION_ERROR).on((KtAnnotationEntry)((PsiElement)reportOn), DescriptorUtilsKt.getFqNameSafe(containerClass), containerRetention.name(), DescriptorUtilsKt.getFqNameSafe(annotationClass), annotationRetention.name());
        }
        return null;
    }

    private final Diagnostic checkContainerTarget(ClassDescriptor containerClass, ClassDescriptor annotationClass, KtAnnotationEntry reportOn) {
        Set<KotlinTarget> annotationTargets = AnnotationChecker.Companion.applicableTargetSet(annotationClass);
        Set<KotlinTarget> containerTargets = AnnotationChecker.Companion.applicableTargetSet(containerClass);
        Iterator<KotlinTarget> iterator2 = containerTargets.iterator();
        while (iterator2.hasNext()) {
            KotlinTarget target;
            KotlinTarget kotlinTarget = target = iterator2.next();
            int n = WhenMappings.$EnumSwitchMapping$0[kotlinTarget.ordinal()];
            boolean ok = annotationTargets.contains((Object)kotlinTarget) ? true : (n == 1 ? annotationTargets.contains((Object)KotlinTarget.CLASS) || annotationTargets.contains((Object)KotlinTarget.TYPE) : (n == 2 ? annotationTargets.contains((Object)KotlinTarget.TYPE) : (n == 3 ? annotationTargets.contains((Object)KotlinTarget.TYPE) : false)));
            if (ok) continue;
            return this.select(ErrorsJvm.REPEATABLE_CONTAINER_TARGET_SET_NOT_A_SUBSET, ErrorsJvm.REPEATABLE_CONTAINER_TARGET_SET_NOT_A_SUBSET_ERROR).on((KtAnnotationEntry)((PsiElement)reportOn), DescriptorUtilsKt.getFqNameSafe(containerClass), DescriptorUtilsKt.getFqNameSafe(annotationClass));
        }
        return null;
    }

    private final <D> D select(D warning, D error) {
        return this.languageVersionSettings.supportsFeature(LanguageFeature.RepeatableAnnotationContainerConstraints) ? error : warning;
    }

    private final boolean isRepeatableAnnotation(ClassDescriptor classDescriptor) {
        return DescriptorUtilsKt.isAnnotatedWithKotlinRepeatable(classDescriptor) || this.platformAnnotationFeaturesSupport.isRepeatableAnnotationClass(classDescriptor);
    }

    private final FqName resolveContainerAnnotation(ClassDescriptor annotationClass) {
        Annotations annotations2 = annotationClass.getAnnotations();
        Object object = JvmAnnotationNames.REPEATABLE_ANNOTATION;
        Intrinsics.checkNotNullExpressionValue(object, "REPEATABLE_ANNOTATION");
        AnnotationDescriptor annotationDescriptor = annotations2.findAnnotation((FqName)object);
        if (annotationDescriptor == null) {
            return null;
        }
        AnnotationDescriptor javaRepeatable = annotationDescriptor;
        ConstantValue<?> constantValue = javaRepeatable.getAllValueArguments().get(Name.identifier("value"));
        Object object2 = object = constantValue instanceof KClassValue ? (KClassValue)constantValue : null;
        if (object == null) {
            return null;
        }
        Object value2 = object;
        Object t = ((ConstantValue)value2).getValue();
        ConstantValue<?> constantValue2 = constantValue = t instanceof KClassValue.Value.NormalClass ? (KClassValue.Value.NormalClass)t : null;
        if (constantValue == null) {
            return null;
        }
        ConstantValue<?> normalClass = constantValue;
        return ((KClassValue.Value.NormalClass)((Object)normalClass)).getClassId().asSingleFqName();
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0005H\u00c6\u0003J\u000b\u0010\u0011\u001a\u0004\u0018\u00010\u0007H\u00c6\u0003J)\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/resolve/jvm/checkers/RepeatableAnnotationChecker$ResolvedAnnotation;", "", "entry", "Lorg/jetbrains/kotlin/psi/KtAnnotationEntry;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/annotations/AnnotationDescriptor;", "useSiteTarget", "Lorg/jetbrains/kotlin/descriptors/annotations/AnnotationUseSiteTarget;", "(Lorg/jetbrains/kotlin/psi/KtAnnotationEntry;Lorg/jetbrains/kotlin/descriptors/annotations/AnnotationDescriptor;Lorg/jetbrains/kotlin/descriptors/annotations/AnnotationUseSiteTarget;)V", "getDescriptor", "()Lorg/jetbrains/kotlin/descriptors/annotations/AnnotationDescriptor;", "getEntry", "()Lorg/jetbrains/kotlin/psi/KtAnnotationEntry;", "getUseSiteTarget", "()Lorg/jetbrains/kotlin/descriptors/annotations/AnnotationUseSiteTarget;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "", "frontend.java"})
    private static final class ResolvedAnnotation {
        @NotNull
        private final KtAnnotationEntry entry;
        @NotNull
        private final AnnotationDescriptor descriptor;
        @Nullable
        private final AnnotationUseSiteTarget useSiteTarget;

        public ResolvedAnnotation(@NotNull KtAnnotationEntry entry, @NotNull AnnotationDescriptor descriptor2, @Nullable AnnotationUseSiteTarget useSiteTarget) {
            Intrinsics.checkNotNullParameter(entry, "entry");
            Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
            this.entry = entry;
            this.descriptor = descriptor2;
            this.useSiteTarget = useSiteTarget;
        }

        @NotNull
        public final KtAnnotationEntry getEntry() {
            return this.entry;
        }

        @NotNull
        public final AnnotationDescriptor getDescriptor() {
            return this.descriptor;
        }

        @Nullable
        public final AnnotationUseSiteTarget getUseSiteTarget() {
            return this.useSiteTarget;
        }

        @NotNull
        public final KtAnnotationEntry component1() {
            return this.entry;
        }

        @NotNull
        public final AnnotationDescriptor component2() {
            return this.descriptor;
        }

        @Nullable
        public final AnnotationUseSiteTarget component3() {
            return this.useSiteTarget;
        }

        @NotNull
        public final ResolvedAnnotation copy(@NotNull KtAnnotationEntry entry, @NotNull AnnotationDescriptor descriptor2, @Nullable AnnotationUseSiteTarget useSiteTarget) {
            Intrinsics.checkNotNullParameter(entry, "entry");
            Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
            return new ResolvedAnnotation(entry, descriptor2, useSiteTarget);
        }

        public static /* synthetic */ ResolvedAnnotation copy$default(ResolvedAnnotation resolvedAnnotation, KtAnnotationEntry ktAnnotationEntry, AnnotationDescriptor annotationDescriptor, AnnotationUseSiteTarget annotationUseSiteTarget, int n, Object object) {
            if ((n & 1) != 0) {
                ktAnnotationEntry = resolvedAnnotation.entry;
            }
            if ((n & 2) != 0) {
                annotationDescriptor = resolvedAnnotation.descriptor;
            }
            if ((n & 4) != 0) {
                annotationUseSiteTarget = resolvedAnnotation.useSiteTarget;
            }
            return resolvedAnnotation.copy(ktAnnotationEntry, annotationDescriptor, annotationUseSiteTarget);
        }

        @NotNull
        public String toString() {
            return "ResolvedAnnotation(entry=" + this.entry + ", descriptor=" + this.descriptor + ", useSiteTarget=" + (Object)((Object)this.useSiteTarget) + ')';
        }

        public int hashCode() {
            int result2 = this.entry.hashCode();
            result2 = result2 * 31 + this.descriptor.hashCode();
            result2 = result2 * 31 + (this.useSiteTarget == null ? 0 : this.useSiteTarget.hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ResolvedAnnotation)) {
                return false;
            }
            ResolvedAnnotation resolvedAnnotation = (ResolvedAnnotation)other;
            if (!Intrinsics.areEqual(this.entry, resolvedAnnotation.entry)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.descriptor, resolvedAnnotation.descriptor)) {
                return false;
            }
            return this.useSiteTarget == resolvedAnnotation.useSiteTarget;
        }
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[KotlinTarget.values().length];
            nArray[KotlinTarget.ANNOTATION_CLASS.ordinal()] = 1;
            nArray[KotlinTarget.CLASS.ordinal()] = 2;
            nArray[KotlinTarget.TYPE_PARAMETER.ordinal()] = 3;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

