/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.eclipse.aether.internal.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import javax.inject.Named;
import org.jetbrains.kotlin.org.apache.commons.lang3.StringUtils;
import org.jetbrains.kotlin.org.eclipse.aether.RepositoryCache;
import org.jetbrains.kotlin.org.eclipse.aether.RepositorySystemSession;
import org.jetbrains.kotlin.org.eclipse.aether.impl.RemoteRepositoryManager;
import org.jetbrains.kotlin.org.eclipse.aether.impl.UpdatePolicyAnalyzer;
import org.jetbrains.kotlin.org.eclipse.aether.repository.Authentication;
import org.jetbrains.kotlin.org.eclipse.aether.repository.AuthenticationSelector;
import org.jetbrains.kotlin.org.eclipse.aether.repository.MirrorSelector;
import org.jetbrains.kotlin.org.eclipse.aether.repository.Proxy;
import org.jetbrains.kotlin.org.eclipse.aether.repository.ProxySelector;
import org.jetbrains.kotlin.org.eclipse.aether.repository.RemoteRepository;
import org.jetbrains.kotlin.org.eclipse.aether.repository.RepositoryPolicy;
import org.jetbrains.kotlin.org.eclipse.aether.spi.connector.checksum.ChecksumPolicyProvider;
import org.jetbrains.kotlin.org.eclipse.aether.spi.locator.Service;
import org.jetbrains.kotlin.org.eclipse.aether.spi.locator.ServiceLocator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
public class DefaultRemoteRepositoryManager
implements RemoteRepositoryManager,
Service {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultRemoteRepositoryManager.class);
    private UpdatePolicyAnalyzer updatePolicyAnalyzer;
    private ChecksumPolicyProvider checksumPolicyProvider;

    @Override
    public void initService(ServiceLocator locator) {
        this.setUpdatePolicyAnalyzer(locator.getService(UpdatePolicyAnalyzer.class));
        this.setChecksumPolicyProvider(locator.getService(ChecksumPolicyProvider.class));
    }

    public DefaultRemoteRepositoryManager setUpdatePolicyAnalyzer(UpdatePolicyAnalyzer updatePolicyAnalyzer) {
        this.updatePolicyAnalyzer = Objects.requireNonNull(updatePolicyAnalyzer, "update policy analyzer cannot be null");
        return this;
    }

    public DefaultRemoteRepositoryManager setChecksumPolicyProvider(ChecksumPolicyProvider checksumPolicyProvider) {
        this.checksumPolicyProvider = Objects.requireNonNull(checksumPolicyProvider, "checksum policy provider cannot be null");
        return this;
    }

    @Override
    public List<RemoteRepository> aggregateRepositories(RepositorySystemSession session2, List<RemoteRepository> dominantRepositories, List<RemoteRepository> recessiveRepositories, boolean recessiveIsRaw) {
        if (recessiveRepositories.isEmpty()) {
            return dominantRepositories;
        }
        MirrorSelector mirrorSelector = session2.getMirrorSelector();
        AuthenticationSelector authSelector = session2.getAuthenticationSelector();
        ProxySelector proxySelector = session2.getProxySelector();
        ArrayList<RemoteRepository> result2 = new ArrayList<RemoteRepository>(dominantRepositories);
        Iterator<RemoteRepository> iterator2 = recessiveRepositories.iterator();
        block0: while (iterator2.hasNext()) {
            RemoteRepository mirrorRepository;
            RemoteRepository recessiveRepository;
            RemoteRepository repository = recessiveRepository = iterator2.next();
            if (recessiveIsRaw && (mirrorRepository = mirrorSelector.getMirror(recessiveRepository)) != null) {
                this.logMirror(session2, recessiveRepository, mirrorRepository);
                repository = mirrorRepository;
            }
            String key = this.getKey(repository);
            ListIterator<RemoteRepository> it = result2.listIterator();
            while (it.hasNext()) {
                RemoteRepository mergedRepository;
                RemoteRepository dominantRepository = (RemoteRepository)it.next();
                if (!key.equals(this.getKey(dominantRepository))) continue;
                if (dominantRepository.getMirroredRepositories().isEmpty() || repository.getMirroredRepositories().isEmpty() || (mergedRepository = this.mergeMirrors(session2, dominantRepository, repository)) == dominantRepository) continue block0;
                it.set(mergedRepository);
                continue block0;
            }
            if (recessiveIsRaw) {
                Proxy proxy;
                RemoteRepository.Builder builder2 = null;
                Authentication auth = authSelector.getAuthentication(repository);
                if (auth != null) {
                    builder2 = new RemoteRepository.Builder(repository);
                    builder2.setAuthentication(auth);
                }
                if ((proxy = proxySelector.getProxy(repository)) != null) {
                    if (builder2 == null) {
                        builder2 = new RemoteRepository.Builder(repository);
                    }
                    builder2.setProxy(proxy);
                }
                if (builder2 != null) {
                    repository = builder2.build();
                }
            }
            result2.add(repository);
        }
        return result2;
    }

    private void logMirror(RepositorySystemSession session2, RemoteRepository original, RemoteRepository mirror) {
        if (!LOGGER.isDebugEnabled()) {
            return;
        }
        RepositoryCache cache2 = session2.getCache();
        if (cache2 != null) {
            LoggedMirror key = new LoggedMirror(original, mirror);
            if (cache2.get(session2, key) != null) {
                return;
            }
            cache2.put(session2, key, Boolean.TRUE);
        }
        LOGGER.debug("Using mirror {} ({}) for {} ({}).", mirror.getId(), mirror.getUrl(), original.getId(), original.getUrl());
    }

    private String getKey(RemoteRepository repository) {
        return repository.getId();
    }

    private RemoteRepository mergeMirrors(RepositorySystemSession session2, RemoteRepository dominant, RemoteRepository recessive) {
        RemoteRepository.Builder merged = null;
        RepositoryPolicy releases = null;
        RepositoryPolicy snapshots = null;
        block0: for (RemoteRepository rec : recessive.getMirroredRepositories()) {
            String recKey = this.getKey(rec);
            for (RemoteRepository dom : dominant.getMirroredRepositories()) {
                if (!recKey.equals(this.getKey(dom))) continue;
                continue block0;
            }
            if (merged == null) {
                merged = new RemoteRepository.Builder(dominant);
                releases = dominant.getPolicy(false);
                snapshots = dominant.getPolicy(true);
            }
            releases = this.merge(session2, releases, rec.getPolicy(false), false);
            snapshots = this.merge(session2, snapshots, rec.getPolicy(true), false);
            merged.addMirroredRepository(rec);
        }
        if (merged == null) {
            return dominant;
        }
        return merged.setReleasePolicy(releases).setSnapshotPolicy(snapshots).build();
    }

    @Override
    public RepositoryPolicy getPolicy(RepositorySystemSession session2, RemoteRepository repository, boolean releases, boolean snapshots) {
        RepositoryPolicy policy1 = releases ? repository.getPolicy(false) : null;
        RepositoryPolicy policy2 = snapshots ? repository.getPolicy(true) : null;
        return this.merge(session2, policy1, policy2, true);
    }

    private RepositoryPolicy merge(RepositorySystemSession session2, RepositoryPolicy policy1, RepositoryPolicy policy2, boolean globalPolicy) {
        RepositoryPolicy policy;
        if (policy2 == null) {
            policy = globalPolicy ? this.merge(policy1, session2.getUpdatePolicy(), session2.getChecksumPolicy()) : policy1;
        } else if (policy1 == null) {
            policy = globalPolicy ? this.merge(policy2, session2.getUpdatePolicy(), session2.getChecksumPolicy()) : policy2;
        } else if (!policy2.isEnabled()) {
            policy = globalPolicy ? this.merge(policy1, session2.getUpdatePolicy(), session2.getChecksumPolicy()) : policy1;
        } else if (!policy1.isEnabled()) {
            policy = globalPolicy ? this.merge(policy2, session2.getUpdatePolicy(), session2.getChecksumPolicy()) : policy2;
        } else {
            String checksums = session2.getChecksumPolicy();
            if (!globalPolicy || StringUtils.isEmpty(checksums)) {
                checksums = this.checksumPolicyProvider.getEffectiveChecksumPolicy(session2, policy1.getChecksumPolicy(), policy2.getChecksumPolicy());
            }
            String updates = session2.getUpdatePolicy();
            if (!globalPolicy || StringUtils.isEmpty(updates)) {
                updates = this.updatePolicyAnalyzer.getEffectiveUpdatePolicy(session2, policy1.getUpdatePolicy(), policy2.getUpdatePolicy());
            }
            policy = new RepositoryPolicy(true, updates, checksums);
        }
        return policy;
    }

    private RepositoryPolicy merge(RepositoryPolicy policy, String updates, String checksums) {
        if (policy != null) {
            if (StringUtils.isEmpty(updates)) {
                updates = policy.getUpdatePolicy();
            }
            if (StringUtils.isEmpty(checksums)) {
                checksums = policy.getChecksumPolicy();
            }
            if (!policy.getUpdatePolicy().equals(updates) || !policy.getChecksumPolicy().equals(checksums)) {
                policy = new RepositoryPolicy(policy.isEnabled(), updates, checksums);
            }
        }
        return policy;
    }

    private static final class LoggedMirror {
        private final Object[] keys;

        LoggedMirror(RemoteRepository original, RemoteRepository mirror) {
            this.keys = new Object[]{mirror.getId(), mirror.getUrl(), original.getId(), original.getUrl()};
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof LoggedMirror)) {
                return false;
            }
            LoggedMirror that = (LoggedMirror)obj;
            return Arrays.equals(this.keys, that.keys);
        }

        public int hashCode() {
            return Arrays.hashCode(this.keys);
        }
    }
}

