/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.eclipse.aether.internal.impl;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.inject.Named;
import org.jetbrains.kotlin.org.eclipse.aether.RepositoryEvent;
import org.jetbrains.kotlin.org.eclipse.aether.RepositorySystemSession;
import org.jetbrains.kotlin.org.eclipse.aether.RequestTrace;
import org.jetbrains.kotlin.org.eclipse.aether.SyncContext;
import org.jetbrains.kotlin.org.eclipse.aether.artifact.Artifact;
import org.jetbrains.kotlin.org.eclipse.aether.impl.ArtifactResolver;
import org.jetbrains.kotlin.org.eclipse.aether.impl.OfflineController;
import org.jetbrains.kotlin.org.eclipse.aether.impl.RemoteRepositoryManager;
import org.jetbrains.kotlin.org.eclipse.aether.impl.RepositoryConnectorProvider;
import org.jetbrains.kotlin.org.eclipse.aether.impl.RepositoryEventDispatcher;
import org.jetbrains.kotlin.org.eclipse.aether.impl.SyncContextFactory;
import org.jetbrains.kotlin.org.eclipse.aether.impl.UpdateCheck;
import org.jetbrains.kotlin.org.eclipse.aether.impl.UpdateCheckManager;
import org.jetbrains.kotlin.org.eclipse.aether.impl.VersionResolver;
import org.jetbrains.kotlin.org.eclipse.aether.internal.impl.SafeTransferListener;
import org.jetbrains.kotlin.org.eclipse.aether.internal.impl.Utils;
import org.jetbrains.kotlin.org.eclipse.aether.repository.ArtifactRepository;
import org.jetbrains.kotlin.org.eclipse.aether.repository.LocalArtifactRegistration;
import org.jetbrains.kotlin.org.eclipse.aether.repository.LocalArtifactRequest;
import org.jetbrains.kotlin.org.eclipse.aether.repository.LocalArtifactResult;
import org.jetbrains.kotlin.org.eclipse.aether.repository.LocalRepository;
import org.jetbrains.kotlin.org.eclipse.aether.repository.LocalRepositoryManager;
import org.jetbrains.kotlin.org.eclipse.aether.repository.RemoteRepository;
import org.jetbrains.kotlin.org.eclipse.aether.repository.RepositoryPolicy;
import org.jetbrains.kotlin.org.eclipse.aether.repository.WorkspaceReader;
import org.jetbrains.kotlin.org.eclipse.aether.resolution.ArtifactRequest;
import org.jetbrains.kotlin.org.eclipse.aether.resolution.ArtifactResolutionException;
import org.jetbrains.kotlin.org.eclipse.aether.resolution.ArtifactResult;
import org.jetbrains.kotlin.org.eclipse.aether.resolution.VersionRequest;
import org.jetbrains.kotlin.org.eclipse.aether.resolution.VersionResolutionException;
import org.jetbrains.kotlin.org.eclipse.aether.resolution.VersionResult;
import org.jetbrains.kotlin.org.eclipse.aether.spi.connector.ArtifactDownload;
import org.jetbrains.kotlin.org.eclipse.aether.spi.connector.RepositoryConnector;
import org.jetbrains.kotlin.org.eclipse.aether.spi.io.FileProcessor;
import org.jetbrains.kotlin.org.eclipse.aether.spi.locator.Service;
import org.jetbrains.kotlin.org.eclipse.aether.spi.locator.ServiceLocator;
import org.jetbrains.kotlin.org.eclipse.aether.transfer.ArtifactNotFoundException;
import org.jetbrains.kotlin.org.eclipse.aether.transfer.ArtifactTransferException;
import org.jetbrains.kotlin.org.eclipse.aether.transfer.NoRepositoryConnectorException;
import org.jetbrains.kotlin.org.eclipse.aether.transfer.RepositoryOfflineException;
import org.jetbrains.kotlin.org.eclipse.aether.util.ConfigUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
public class DefaultArtifactResolver
implements ArtifactResolver,
Service {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultArtifactResolver.class);
    private FileProcessor fileProcessor;
    private RepositoryEventDispatcher repositoryEventDispatcher;
    private VersionResolver versionResolver;
    private UpdateCheckManager updateCheckManager;
    private RepositoryConnectorProvider repositoryConnectorProvider;
    private RemoteRepositoryManager remoteRepositoryManager;
    private SyncContextFactory syncContextFactory;
    private OfflineController offlineController;

    @Override
    public void initService(ServiceLocator locator) {
        this.setFileProcessor(locator.getService(FileProcessor.class));
        this.setRepositoryEventDispatcher(locator.getService(RepositoryEventDispatcher.class));
        this.setVersionResolver(locator.getService(VersionResolver.class));
        this.setUpdateCheckManager(locator.getService(UpdateCheckManager.class));
        this.setRepositoryConnectorProvider(locator.getService(RepositoryConnectorProvider.class));
        this.setRemoteRepositoryManager(locator.getService(RemoteRepositoryManager.class));
        this.setSyncContextFactory(locator.getService(SyncContextFactory.class));
        this.setOfflineController(locator.getService(OfflineController.class));
    }

    public DefaultArtifactResolver setFileProcessor(FileProcessor fileProcessor) {
        this.fileProcessor = Objects.requireNonNull(fileProcessor, "file processor cannot be null");
        return this;
    }

    public DefaultArtifactResolver setRepositoryEventDispatcher(RepositoryEventDispatcher repositoryEventDispatcher) {
        this.repositoryEventDispatcher = Objects.requireNonNull(repositoryEventDispatcher, "repository event dispatcher cannot be null");
        return this;
    }

    public DefaultArtifactResolver setVersionResolver(VersionResolver versionResolver) {
        this.versionResolver = Objects.requireNonNull(versionResolver, "version resolver cannot be null");
        return this;
    }

    public DefaultArtifactResolver setUpdateCheckManager(UpdateCheckManager updateCheckManager) {
        this.updateCheckManager = Objects.requireNonNull(updateCheckManager, "update check manager cannot be null");
        return this;
    }

    public DefaultArtifactResolver setRepositoryConnectorProvider(RepositoryConnectorProvider repositoryConnectorProvider) {
        this.repositoryConnectorProvider = Objects.requireNonNull(repositoryConnectorProvider, "repository connector provider cannot be null");
        return this;
    }

    public DefaultArtifactResolver setRemoteRepositoryManager(RemoteRepositoryManager remoteRepositoryManager) {
        this.remoteRepositoryManager = Objects.requireNonNull(remoteRepositoryManager, "remote repository provider cannot be null");
        return this;
    }

    public DefaultArtifactResolver setSyncContextFactory(SyncContextFactory syncContextFactory) {
        this.syncContextFactory = Objects.requireNonNull(syncContextFactory, "sync context factory cannot be null");
        return this;
    }

    public DefaultArtifactResolver setOfflineController(OfflineController offlineController) {
        this.offlineController = Objects.requireNonNull(offlineController, "offline controller cannot be null");
        return this;
    }

    @Override
    public ArtifactResult resolveArtifact(RepositorySystemSession session2, ArtifactRequest request) throws ArtifactResolutionException {
        return this.resolveArtifacts(session2, Collections.singleton(request)).get(0);
    }

    @Override
    public List<ArtifactResult> resolveArtifacts(RepositorySystemSession session2, Collection<? extends ArtifactRequest> requests) throws ArtifactResolutionException {
        SyncContext syncContext = this.syncContextFactory.newInstance(session2, false);
        Throwable throwable = null;
        try {
            ArrayList<Artifact> artifacts = new ArrayList<Artifact>(requests.size());
            for (ArtifactRequest artifactRequest : requests) {
                if (artifactRequest.getArtifact().getProperty("localPath", null) != null) continue;
                artifacts.add(artifactRequest.getArtifact());
            }
            syncContext.acquire(artifacts, null);
            List<ArtifactResult> list2 = this.resolve(session2, requests);
            return list2;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            if (syncContext != null) {
                if (throwable != null) {
                    try {
                        syncContext.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                } else {
                    syncContext.close();
                }
            }
        }
    }

    private List<ArtifactResult> resolve(RepositorySystemSession session2, Collection<? extends ArtifactRequest> requests) throws ArtifactResolutionException {
        ArrayList<ArtifactResult> results = new ArrayList<ArtifactResult>(requests.size());
        boolean failures = false;
        LocalRepositoryManager lrm = session2.getLocalRepositoryManager();
        WorkspaceReader workspace = session2.getWorkspaceReader();
        ArrayList<ResolutionGroup> groups2 = new ArrayList<ResolutionGroup>();
        for (ArtifactRequest artifactRequest : requests) {
            File file2;
            VersionResult versionResult;
            RequestTrace trace = RequestTrace.newChild(artifactRequest.getTrace(), artifactRequest);
            ArtifactResult result2 = new ArtifactResult(artifactRequest);
            results.add(result2);
            Artifact artifact = artifactRequest.getArtifact();
            List<RemoteRepository> repos = artifactRequest.getRepositories();
            this.artifactResolving(session2, trace, artifact);
            String localPath = artifact.getProperty("localPath", null);
            if (localPath != null) {
                File file3 = new File(localPath);
                if (!file3.isFile()) {
                    failures = true;
                    result2.addException(new ArtifactNotFoundException(artifact, null));
                    continue;
                }
                artifact = artifact.setFile(file3);
                result2.setArtifact(artifact);
                this.artifactResolved(session2, trace, artifact, null, result2.getExceptions());
                continue;
            }
            try {
                VersionRequest versionRequest = new VersionRequest(artifact, repos, artifactRequest.getRequestContext());
                versionRequest.setTrace(trace);
                versionResult = this.versionResolver.resolveVersion(session2, versionRequest);
            }
            catch (VersionResolutionException e) {
                result2.addException(e);
                continue;
            }
            artifact = artifact.setVersion(versionResult.getVersion());
            if (versionResult.getRepository() != null) {
                repos = versionResult.getRepository() instanceof RemoteRepository ? Collections.singletonList((RemoteRepository)versionResult.getRepository()) : Collections.emptyList();
            }
            if (workspace != null && (file2 = workspace.findArtifact(artifact)) != null) {
                artifact = artifact.setFile(file2);
                result2.setArtifact(artifact);
                result2.setRepository(workspace.getRepository());
                this.artifactResolved(session2, trace, artifact, result2.getRepository(), null);
                continue;
            }
            LocalArtifactResult local = lrm.find(session2, new LocalArtifactRequest(artifact, repos, artifactRequest.getRequestContext()));
            if (this.isLocallyInstalled(local, versionResult)) {
                if (local.getRepository() != null) {
                    result2.setRepository(local.getRepository());
                } else {
                    result2.setRepository(lrm.getRepository());
                }
                try {
                    artifact = artifact.setFile(this.getFile(session2, artifact, local.getFile()));
                    result2.setArtifact(artifact);
                    this.artifactResolved(session2, trace, artifact, result2.getRepository(), null);
                }
                catch (ArtifactTransferException e) {
                    result2.addException(e);
                }
                if (local.isAvailable()) continue;
                lrm.add(session2, new LocalArtifactRegistration(artifact));
                continue;
            }
            if (local.getFile() != null) {
                LOGGER.debug("Verifying availability of {} from {}", (Object)local.getFile(), (Object)repos);
            }
            AtomicBoolean resolved = new AtomicBoolean(false);
            Iterator<Object> groupIt = groups2.iterator();
            for (RemoteRepository repo : repos) {
                if (!repo.getPolicy(artifact.isSnapshot()).isEnabled()) continue;
                try {
                    Utils.checkOffline(session2, this.offlineController, repo);
                }
                catch (RepositoryOfflineException e) {
                    ArtifactNotFoundException exception = new ArtifactNotFoundException(artifact, repo, "Cannot access " + repo.getId() + " (" + repo.getUrl() + ") in offline mode and the artifact " + artifact + " has not been downloaded from it before.", e);
                    result2.addException(exception);
                    continue;
                }
                ResolutionGroup group = null;
                while (groupIt.hasNext()) {
                    ResolutionGroup t = (ResolutionGroup)groupIt.next();
                    if (!t.matches(repo)) continue;
                    group = t;
                    break;
                }
                if (group == null) {
                    group = new ResolutionGroup(repo);
                    groups2.add(group);
                    groupIt = Collections.emptyList().iterator();
                }
                group.items.add(new ResolutionItem(trace, artifact, resolved, result2, local, repo));
            }
        }
        for (ResolutionGroup resolutionGroup : groups2) {
            this.performDownloads(session2, resolutionGroup);
        }
        for (ArtifactResult artifactResult : results) {
            ArtifactRequest request = artifactResult.getRequest();
            Artifact artifact = artifactResult.getArtifact();
            if (artifact != null && artifact.getFile() != null) continue;
            failures = true;
            if (artifactResult.getExceptions().isEmpty()) {
                ArtifactNotFoundException exception = new ArtifactNotFoundException(request.getArtifact(), null);
                artifactResult.addException(exception);
            }
            RequestTrace trace = RequestTrace.newChild(request.getTrace(), request);
            this.artifactResolved(session2, trace, request.getArtifact(), null, artifactResult.getExceptions());
        }
        if (failures) {
            throw new ArtifactResolutionException(results);
        }
        return results;
    }

    private boolean isLocallyInstalled(LocalArtifactResult lar, VersionResult vr) {
        if (lar.isAvailable()) {
            return true;
        }
        if (lar.getFile() != null) {
            if (vr.getRepository() instanceof LocalRepository) {
                return true;
            }
            if (vr.getRepository() == null && lar.getRequest().getRepositories().isEmpty()) {
                return true;
            }
        }
        return false;
    }

    private File getFile(RepositorySystemSession session2, Artifact artifact, File file2) throws ArtifactTransferException {
        if (artifact.isSnapshot() && !artifact.getVersion().equals(artifact.getBaseVersion()) && ConfigUtils.getBoolean(session2, true, "aether.artifactResolver.snapshotNormalization")) {
            boolean copy2;
            String name2 = file2.getName().replace(artifact.getVersion(), artifact.getBaseVersion());
            File dst = new File(file2.getParent(), name2);
            boolean bl = copy2 = dst.length() != file2.length() || dst.lastModified() != file2.lastModified();
            if (copy2) {
                try {
                    this.fileProcessor.copy(file2, dst);
                    dst.setLastModified(file2.lastModified());
                }
                catch (IOException e) {
                    throw new ArtifactTransferException(artifact, null, e);
                }
            }
            file2 = dst;
        }
        return file2;
    }

    private void performDownloads(RepositorySystemSession session2, ResolutionGroup group) {
        List<ArtifactDownload> downloads = this.gatherDownloads(session2, group);
        if (downloads.isEmpty()) {
            return;
        }
        for (ArtifactDownload download : downloads) {
            this.artifactDownloading(session2, download.getTrace(), download.getArtifact(), group.repository);
        }
        try {
            RemoteRepository repo = group.repository;
            if (repo.isBlocked()) {
                if (repo.getMirroredRepositories().isEmpty()) {
                    throw new NoRepositoryConnectorException(repo, "Blocked repository: " + repo);
                }
                throw new NoRepositoryConnectorException(repo, "Blocked mirror for repositories: " + repo.getMirroredRepositories());
            }
            RepositoryConnector connector = this.repositoryConnectorProvider.newRepositoryConnector(session2, group.repository);
            Throwable throwable = null;
            try {
                connector.get(downloads, null);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (connector != null) {
                    if (throwable != null) {
                        try {
                            connector.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        connector.close();
                    }
                }
            }
        }
        catch (NoRepositoryConnectorException e) {
            for (ArtifactDownload download : downloads) {
                download.setException(new ArtifactTransferException(download.getArtifact(), group.repository, e));
            }
        }
        this.evaluateDownloads(session2, group);
    }

    private List<ArtifactDownload> gatherDownloads(RepositorySystemSession session2, ResolutionGroup group) {
        LocalRepositoryManager lrm = session2.getLocalRepositoryManager();
        ArrayList<ArtifactDownload> downloads = new ArrayList<ArtifactDownload>();
        for (ResolutionItem item : group.items) {
            Artifact artifact = item.artifact;
            if (item.resolved.get()) continue;
            ArtifactDownload download = new ArtifactDownload();
            download.setArtifact(artifact);
            download.setRequestContext(item.request.getRequestContext());
            download.setListener(SafeTransferListener.wrap(session2));
            download.setTrace(item.trace);
            if (item.local.getFile() != null) {
                download.setFile(item.local.getFile());
                download.setExistenceCheck(true);
            } else {
                String path2 = lrm.getPathForRemoteArtifact(artifact, group.repository, item.request.getRequestContext());
                download.setFile(new File(lrm.getRepository().getBasedir(), path2));
            }
            boolean snapshot = artifact.isSnapshot();
            RepositoryPolicy policy = this.remoteRepositoryManager.getPolicy(session2, group.repository, !snapshot, snapshot);
            int errorPolicy = Utils.getPolicy(session2, artifact, group.repository);
            if ((errorPolicy & 3) != 0) {
                UpdateCheck<Artifact, ArtifactTransferException> check2 = new UpdateCheck<Artifact, ArtifactTransferException>();
                check2.setItem(artifact);
                check2.setFile(download.getFile());
                check2.setFileValid(false);
                check2.setRepository(group.repository);
                check2.setPolicy(policy.getUpdatePolicy());
                item.updateCheck = check2;
                this.updateCheckManager.checkArtifact(session2, check2);
                if (!check2.isRequired()) {
                    item.result.addException(check2.getException());
                    continue;
                }
            }
            download.setChecksumPolicy(policy.getChecksumPolicy());
            download.setRepositories(item.repository.getMirroredRepositories());
            downloads.add(download);
            item.download = download;
        }
        return downloads;
    }

    private void evaluateDownloads(RepositorySystemSession session2, ResolutionGroup group) {
        LocalRepositoryManager lrm = session2.getLocalRepositoryManager();
        for (ResolutionItem item : group.items) {
            ArtifactDownload download = item.download;
            if (download == null) continue;
            Artifact artifact = download.getArtifact();
            if (download.getException() == null) {
                item.resolved.set(true);
                item.result.setRepository(group.repository);
                try {
                    artifact = artifact.setFile(this.getFile(session2, artifact, download.getFile()));
                    item.result.setArtifact(artifact);
                    lrm.add(session2, new LocalArtifactRegistration(artifact, group.repository, download.getSupportedContexts()));
                }
                catch (ArtifactTransferException e) {
                    download.setException(e);
                    item.result.addException(e);
                }
            } else {
                item.result.addException(download.getException());
            }
            if (item.updateCheck != null) {
                item.updateCheck.setException(download.getException());
                this.updateCheckManager.touchArtifact(session2, item.updateCheck);
            }
            this.artifactDownloaded(session2, download.getTrace(), artifact, group.repository, download.getException());
            if (download.getException() != null) continue;
            this.artifactResolved(session2, download.getTrace(), artifact, group.repository, null);
        }
    }

    private void artifactResolving(RepositorySystemSession session2, RequestTrace trace, Artifact artifact) {
        RepositoryEvent.Builder event = new RepositoryEvent.Builder(session2, RepositoryEvent.EventType.ARTIFACT_RESOLVING);
        event.setTrace(trace);
        event.setArtifact(artifact);
        this.repositoryEventDispatcher.dispatch(event.build());
    }

    private void artifactResolved(RepositorySystemSession session2, RequestTrace trace, Artifact artifact, ArtifactRepository repository, List<Exception> exceptions) {
        RepositoryEvent.Builder event = new RepositoryEvent.Builder(session2, RepositoryEvent.EventType.ARTIFACT_RESOLVED);
        event.setTrace(trace);
        event.setArtifact(artifact);
        event.setRepository(repository);
        event.setExceptions(exceptions);
        if (artifact != null) {
            event.setFile(artifact.getFile());
        }
        this.repositoryEventDispatcher.dispatch(event.build());
    }

    private void artifactDownloading(RepositorySystemSession session2, RequestTrace trace, Artifact artifact, RemoteRepository repository) {
        RepositoryEvent.Builder event = new RepositoryEvent.Builder(session2, RepositoryEvent.EventType.ARTIFACT_DOWNLOADING);
        event.setTrace(trace);
        event.setArtifact(artifact);
        event.setRepository(repository);
        this.repositoryEventDispatcher.dispatch(event.build());
    }

    private void artifactDownloaded(RepositorySystemSession session2, RequestTrace trace, Artifact artifact, RemoteRepository repository, Exception exception) {
        RepositoryEvent.Builder event = new RepositoryEvent.Builder(session2, RepositoryEvent.EventType.ARTIFACT_DOWNLOADED);
        event.setTrace(trace);
        event.setArtifact(artifact);
        event.setRepository(repository);
        event.setException(exception);
        if (artifact != null) {
            event.setFile(artifact.getFile());
        }
        this.repositoryEventDispatcher.dispatch(event.build());
    }

    static class ResolutionItem {
        final RequestTrace trace;
        final ArtifactRequest request;
        final ArtifactResult result;
        final LocalArtifactResult local;
        final RemoteRepository repository;
        final Artifact artifact;
        final AtomicBoolean resolved;
        ArtifactDownload download;
        UpdateCheck<Artifact, ArtifactTransferException> updateCheck;

        ResolutionItem(RequestTrace trace, Artifact artifact, AtomicBoolean resolved, ArtifactResult result2, LocalArtifactResult local, RemoteRepository repository) {
            this.trace = trace;
            this.artifact = artifact;
            this.resolved = resolved;
            this.result = result2;
            this.request = result2.getRequest();
            this.local = local;
            this.repository = repository;
        }
    }

    static class ResolutionGroup {
        final RemoteRepository repository;
        final List<ResolutionItem> items = new ArrayList<ResolutionItem>();

        ResolutionGroup(RemoteRepository repository) {
            this.repository = repository;
        }

        boolean matches(RemoteRepository repo) {
            return this.repository.getUrl().equals(repo.getUrl()) && this.repository.getContentType().equals(repo.getContentType()) && this.repository.isRepositoryManager() == repo.isRepositoryManager();
        }
    }
}

