/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.apache.http.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import org.jetbrains.kotlin.org.apache.http.util.Args;

public class VersionInfo {
    private final String infoPackage;
    private final String infoModule;
    private final String infoRelease;
    private final String infoTimestamp;
    private final String infoClassloader;

    protected VersionInfo(String pckg, String module2, String release, String time, String clsldr) {
        Args.notNull(pckg, "Package identifier");
        this.infoPackage = pckg;
        this.infoModule = module2 != null ? module2 : "UNAVAILABLE";
        this.infoRelease = release != null ? release : "UNAVAILABLE";
        this.infoTimestamp = time != null ? time : "UNAVAILABLE";
        this.infoClassloader = clsldr != null ? clsldr : "UNAVAILABLE";
    }

    public final String getRelease() {
        return this.infoRelease;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(20 + this.infoPackage.length() + this.infoModule.length() + this.infoRelease.length() + this.infoTimestamp.length() + this.infoClassloader.length());
        sb.append("VersionInfo(").append(this.infoPackage).append(':').append(this.infoModule);
        if (!"UNAVAILABLE".equals(this.infoRelease)) {
            sb.append(':').append(this.infoRelease);
        }
        if (!"UNAVAILABLE".equals(this.infoTimestamp)) {
            sb.append(':').append(this.infoTimestamp);
        }
        sb.append(')');
        if (!"UNAVAILABLE".equals(this.infoClassloader)) {
            sb.append('@').append(this.infoClassloader);
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static VersionInfo loadVersionInfo(String pckg, ClassLoader clsldr) {
        Properties vip;
        ClassLoader cl;
        block6: {
            Args.notNull(pckg, "Package identifier");
            cl = clsldr != null ? clsldr : Thread.currentThread().getContextClassLoader();
            vip = null;
            try {
                InputStream is = cl.getResourceAsStream(pckg.replace('.', '/') + "/" + "version.properties");
                if (is == null) break block6;
                try {
                    Properties props = new Properties();
                    props.load(is);
                    vip = props;
                }
                finally {
                    is.close();
                }
            }
            catch (IOException is) {
                // empty catch block
            }
        }
        VersionInfo result2 = null;
        if (vip != null) {
            result2 = VersionInfo.fromMap(pckg, vip, cl);
        }
        return result2;
    }

    protected static VersionInfo fromMap(String pckg, Map<?, ?> info, ClassLoader clsldr) {
        Args.notNull(pckg, "Package identifier");
        String module2 = null;
        String release = null;
        String timestamp = null;
        if (info != null) {
            module2 = (String)info.get("info.module");
            if (module2 != null && module2.length() < 1) {
                module2 = null;
            }
            if ((release = (String)info.get("info.release")) != null && (release.length() < 1 || release.equals("${pom.version}"))) {
                release = null;
            }
            if ((timestamp = (String)info.get("info.timestamp")) != null && (timestamp.length() < 1 || timestamp.equals("${mvn.timestamp}"))) {
                timestamp = null;
            }
        }
        String clsldrstr = null;
        if (clsldr != null) {
            clsldrstr = clsldr.toString();
        }
        return new VersionInfo(pckg, module2, release, timestamp, clsldrstr);
    }

    public static String getUserAgent(String name2, String pkg, Class<?> cls) {
        VersionInfo vi = VersionInfo.loadVersionInfo(pkg, cls.getClassLoader());
        String release = vi != null ? vi.getRelease() : "UNAVAILABLE";
        String javaVersion = System.getProperty("java.version");
        return String.format("%s/%s (Java/%s)", name2, release, javaVersion);
    }
}

