/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.dce;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.js.backend.ast.JsArrayLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsBinaryOperation;
import org.jetbrains.kotlin.js.backend.ast.JsBinaryOperator;
import org.jetbrains.kotlin.js.backend.ast.JsBlock;
import org.jetbrains.kotlin.js.backend.ast.JsConditional;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsExpressionStatement;
import org.jetbrains.kotlin.js.backend.ast.JsFunction;
import org.jetbrains.kotlin.js.backend.ast.JsIf;
import org.jetbrains.kotlin.js.backend.ast.JsInvocation;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.JsNode;
import org.jetbrains.kotlin.js.backend.ast.JsObjectLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsParameter;
import org.jetbrains.kotlin.js.backend.ast.JsPrefixOperation;
import org.jetbrains.kotlin.js.backend.ast.JsPropertyInitializer;
import org.jetbrains.kotlin.js.backend.ast.JsReturn;
import org.jetbrains.kotlin.js.backend.ast.JsStatement;
import org.jetbrains.kotlin.js.backend.ast.JsStringLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsUnaryOperation;
import org.jetbrains.kotlin.js.backend.ast.JsUnaryOperator;
import org.jetbrains.kotlin.js.backend.ast.JsVars;
import org.jetbrains.kotlin.js.backend.ast.JsVisitor;
import org.jetbrains.kotlin.js.backend.ast.RecursiveJsVisitor;
import org.jetbrains.kotlin.js.dce.AnalysisResult;
import org.jetbrains.kotlin.js.dce.Context;
import org.jetbrains.kotlin.js.dce.UtilKt;
import org.jetbrains.kotlin.js.inline.util.CollectUtilsKt;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u00a0\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001e\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u000e2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\"0!H\u0002J\"\u0010#\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u000e2\u0010\u0010 \u001a\f\u0012\b\u0012\u00060\u0010R\u00020\u00030!H\u0002J\u0016\u0010$\u001a\b\u0018\u00010\u0010R\u00020\u00032\u0006\u0010%\u001a\u00020\"H\u0002J\u001e\u0010&\u001a\u00020\u001e2\u0006\u0010'\u001a\u00020\u00122\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\"0!H\u0002J\u001e\u0010(\u001a\u00020\u001e2\n\u0010)\u001a\u00060\u0010R\u00020\u00032\b\u0010*\u001a\u0004\u0018\u00010\"H\u0002J.\u0010+\u001a\u00020\u001e2\u0006\u0010,\u001a\u00020\u00152\b\u0010)\u001a\u0004\u0018\u00010\"2\b\u0010-\u001a\u0004\u0018\u00010\"2\b\u0010.\u001a\u0004\u0018\u00010\"H\u0002J\u0018\u0010/\u001a\u0002002\u0006\u00101\u001a\u00020\u00152\u0006\u00102\u001a\u000203H\u0002J(\u00104\u001a\b\u0018\u00010\u0010R\u00020\u00032\b\u00105\u001a\u0004\u0018\u00010\u000b2\u0006\u00106\u001a\u00020\"2\u0006\u00107\u001a\u00020\"H\u0002J\u0010\u00108\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u000eH\u0002J(\u00109\u001a\u001a\u0012\u0004\u0012\u00020\u000e\u0012\u000e\u0012\f\u0012\b\u0012\u00060\u0010R\u00020\u00030!\u0018\u00010:2\u0006\u0010%\u001a\u00020\"H\u0002J\u0010\u0010;\u001a\u00020\u001e2\u0006\u0010<\u001a\u00020=H\u0016J\u0010\u0010>\u001a\u00020\u001e2\u0006\u0010<\u001a\u00020?H\u0016J\u0010\u0010@\u001a\u00020\u001e2\u0006\u0010<\u001a\u00020AH\u0016J\u0010\u0010B\u001a\u00020\u001e2\u0006\u0010<\u001a\u00020CH\u0016J\u0010\u0010D\u001a\u00020\u001e2\u0006\u0010<\u001a\u00020EH\u0016J\u0010\u0010F\u001a\u00020\u001e2\u0006\u0010<\u001a\u00020GH\u0016R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u000f\u001a\f\u0012\b\u0012\u00060\u0010R\u00020\u00030\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00160\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u001e\u0010\u0019\u001a\u0012\u0012\u0004\u0012\u00020\u000b\u0012\b\u0012\u00060\u0010R\u00020\u00030\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u000e0\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u000e0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006H"}, d2={"Lorg/jetbrains/kotlin/js/dce/Analyzer;", "Lorg/jetbrains/kotlin/js/backend/ast/JsVisitor;", "context", "Lorg/jetbrains/kotlin/js/dce/Context;", "(Lorg/jetbrains/kotlin/js/dce/Context;)V", "analysisResult", "Lorg/jetbrains/kotlin/js/dce/AnalysisResult;", "getAnalysisResult", "()Lorg/jetbrains/kotlin/js/dce/AnalysisResult;", "astNodesToEliminate", "", "Lorg/jetbrains/kotlin/js/backend/ast/JsNode;", "astNodesToSkip", "functionsToEnter", "Lorg/jetbrains/kotlin/js/backend/ast/JsFunction;", "functionsToSkip", "Lorg/jetbrains/kotlin/js/dce/Context$Node;", "invocationsToSkip", "Lorg/jetbrains/kotlin/js/backend/ast/JsInvocation;", "moduleMapping", "", "Lorg/jetbrains/kotlin/js/backend/ast/JsStatement;", "", "getModuleMapping", "()Ljava/util/Map;", "nodeMap", "postponedFunctions", "Lorg/jetbrains/kotlin/js/backend/ast/JsName;", "processedFunctions", "enterFunction", "", "function", "arguments", "", "Lorg/jetbrains/kotlin/js/backend/ast/JsExpression;", "enterFunctionWithGivenNodes", "extractVariableInitializedByEmptyObject", "expression", "handleAmdDefine", "invocation", "handleObjectCreate", "target", "arg", "handleObjectDefineProperty", "statement", "propertyName", "propertyDescriptor", "isProperFunctionalParameter", "", "body", "parameter", "Lorg/jetbrains/kotlin/js/backend/ast/JsParameter;", "processAssignment", "node", "lhs", "rhs", "processFunction", "tryExtractFunction", "Lkotlin/Pair;", "visit", "x", "Lorg/jetbrains/kotlin/js/backend/ast/JsVars$JsVar;", "visitBlock", "Lorg/jetbrains/kotlin/js/backend/ast/JsBlock;", "visitExpressionStatement", "Lorg/jetbrains/kotlin/js/backend/ast/JsExpressionStatement;", "visitIf", "Lorg/jetbrains/kotlin/js/backend/ast/JsIf;", "visitReturn", "Lorg/jetbrains/kotlin/js/backend/ast/JsReturn;", "visitVars", "Lorg/jetbrains/kotlin/js/backend/ast/JsVars;", "js.dce"})
public final class Analyzer
extends JsVisitor {
    @NotNull
    private final Context context;
    @NotNull
    private final Set<JsFunction> processedFunctions;
    @NotNull
    private final Map<JsName, JsFunction> postponedFunctions;
    @NotNull
    private final Map<JsNode, Context.Node> nodeMap;
    @NotNull
    private final Set<JsNode> astNodesToEliminate;
    @NotNull
    private final Set<JsNode> astNodesToSkip;
    @NotNull
    private final Set<JsInvocation> invocationsToSkip;
    @NotNull
    private final Map<JsStatement, String> moduleMapping;
    @NotNull
    private final Set<JsFunction> functionsToEnter;
    @NotNull
    private final Set<Context.Node> functionsToSkip;
    @NotNull
    private final AnalysisResult analysisResult;

    public Analyzer(@NotNull Context context2) {
        Intrinsics.checkNotNullParameter(context2, "context");
        this.context = context2;
        this.processedFunctions = new LinkedHashSet();
        this.postponedFunctions = new LinkedHashMap();
        this.nodeMap = new LinkedHashMap();
        this.astNodesToEliminate = new LinkedHashSet();
        this.astNodesToSkip = new LinkedHashSet();
        this.invocationsToSkip = new LinkedHashSet();
        this.moduleMapping = new LinkedHashMap();
        this.functionsToEnter = new LinkedHashSet();
        this.functionsToSkip = new LinkedHashSet();
        this.analysisResult = new AnalysisResult(this){
            final /* synthetic */ Analyzer this$0;
            {
                this.this$0 = $receiver;
            }

            @NotNull
            public Map<JsNode, Context.Node> getNodeMap() {
                return Analyzer.access$getNodeMap$p(this.this$0);
            }

            @NotNull
            public Set<JsNode> getAstNodesToEliminate() {
                return Analyzer.access$getAstNodesToEliminate$p(this.this$0);
            }

            @NotNull
            public Set<JsNode> getAstNodesToSkip() {
                return Analyzer.access$getAstNodesToSkip$p(this.this$0);
            }

            @NotNull
            public Set<JsFunction> getFunctionsToEnter() {
                return Analyzer.access$getFunctionsToEnter$p(this.this$0);
            }

            @NotNull
            public Set<JsInvocation> getInvocationsToSkip() {
                return Analyzer.access$getInvocationsToSkip$p(this.this$0);
            }

            @NotNull
            public Set<Context.Node> getFunctionsToSkip() {
                return Analyzer.access$getFunctionsToSkip$p(this.this$0);
            }
        };
    }

    @NotNull
    public final Map<JsStatement, String> getModuleMapping() {
        return this.moduleMapping;
    }

    @NotNull
    public final AnalysisResult getAnalysisResult() {
        return this.analysisResult;
    }

    @Override
    public void visitVars(@NotNull JsVars x) {
        Intrinsics.checkNotNullParameter(x, "x");
        List<JsVars.JsVar> list2 = x.getVars();
        Intrinsics.checkNotNullExpressionValue(list2, "x.vars");
        Iterable $this$forEach$iv = list2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            JsVars.JsVar it = (JsVars.JsVar)element$iv;
            boolean bl = false;
            this.accept((JsNode)it);
        }
    }

    @Override
    public void visit(@NotNull JsVars.JsVar x) {
        Intrinsics.checkNotNullParameter(x, "x");
        JsExpression rhs = x.getInitExpression();
        if (rhs != null) {
            JsNode jsNode = x;
            Object object = x.getName().makeRef();
            Intrinsics.checkNotNullExpressionValue(object, "x.name.makeRef()");
            Context.Node node = this.processAssignment(jsNode, (JsExpression)object, rhs);
            if (node != null) {
                Object it = object = node;
                boolean bl = false;
                Map<JsNode, Context.Node> map2 = this.nodeMap;
                map2.put(x, (Context.Node)it);
            }
        }
    }

    @Override
    public void visitExpressionStatement(@NotNull JsExpressionStatement x) {
        JsExpression expression2;
        Intrinsics.checkNotNullParameter(x, "x");
        JsExpression jsExpression = x.getExpression();
        Intrinsics.checkNotNullExpressionValue(jsExpression, "x.expression");
        jsExpression = expression2 = jsExpression;
        if (jsExpression instanceof JsBinaryOperation) {
            if (((JsBinaryOperation)expression2).getOperator() == JsBinaryOperator.ASG) {
                JsNode jsNode = x;
                Object object = ((JsBinaryOperation)expression2).getArg1();
                Intrinsics.checkNotNullExpressionValue(object, "expression.arg1");
                JsExpression jsExpression2 = object;
                object = ((JsBinaryOperation)expression2).getArg2();
                Intrinsics.checkNotNullExpressionValue(object, "expression.arg2");
                Context.Node node = this.processAssignment(jsNode, jsExpression2, (JsExpression)object);
                if (node != null) {
                    Object it = object = node;
                    boolean bl = false;
                    Map<JsNode, Context.Node> map2 = this.nodeMap;
                    map2.put(x, (Context.Node)it);
                }
            }
        } else if (jsExpression instanceof JsFunction) {
            JsName jsName = ((JsFunction)expression2).getName();
            if (jsName != null) {
                Object object;
                Object it = object = jsName;
                boolean bl = false;
                Object object2 = this.context.getNodes().get(it);
                Context.Node node = object2 == null ? null : ((Context.Node)object2).getOriginal();
                if (node != null) {
                    it = object = node;
                    boolean bl2 = false;
                    object2 = this.nodeMap;
                    object2.put(x, it);
                    ((Context.Node)it).addFunction((JsFunction)expression2);
                }
            }
        } else if (jsExpression instanceof JsInvocation) {
            Object object;
            List<JsExpression> list2 = ((JsInvocation)expression2).getQualifier();
            Intrinsics.checkNotNullExpressionValue(list2, "expression.qualifier");
            JsExpression function2 = list2;
            if (function2 instanceof JsFunction) {
                JsFunction jsFunction = (JsFunction)function2;
                list2 = ((JsInvocation)expression2).getArguments();
                Intrinsics.checkNotNullExpressionValue(list2, "expression.arguments");
                this.enterFunction(jsFunction, (List<? extends JsExpression>)list2);
                return;
            }
            if (function2 instanceof JsNameRef && ((JsNameRef)function2).getQualifier() == null) {
                Object object3;
                JsFunction jsFunction;
                object = ((JsNameRef)function2).getName();
                if (object == null) {
                    jsFunction = null;
                } else {
                    object3 = object;
                    JsName it = object3;
                    boolean bl = false;
                    jsFunction = this.postponedFunctions.get(it);
                }
                JsFunction postponedFunction = jsFunction;
                if (postponedFunction != null) {
                    object = ((JsInvocation)expression2).getArguments();
                    Intrinsics.checkNotNullExpressionValue(object, "expression.arguments");
                    this.enterFunction(postponedFunction, (List<? extends JsExpression>)object);
                    object = this;
                    object3 = ((Analyzer)object).invocationsToSkip;
                    JsExpression jsExpression3 = expression2;
                    object3.add(jsExpression3);
                    return;
                }
            }
            if (UtilKt.isObjectDefineProperty(this.context, function2)) {
                JsStatement jsStatement = x;
                list2 = ((JsInvocation)expression2).getArguments();
                Intrinsics.checkNotNullExpressionValue(list2, "expression.arguments");
                JsExpression jsExpression4 = (JsExpression)CollectionsKt.getOrNull(list2, 0);
                list2 = ((JsInvocation)expression2).getArguments();
                Intrinsics.checkNotNullExpressionValue(list2, "expression.arguments");
                list2 = ((JsInvocation)expression2).getArguments();
                Intrinsics.checkNotNullExpressionValue(list2, "expression.arguments");
                this.handleObjectDefineProperty(jsStatement, jsExpression4, CollectionsKt.getOrNull(list2, 1), CollectionsKt.getOrNull(list2, 2));
            } else if (UtilKt.isDefineModule(this.context, function2)) {
                list2 = this;
                object = ((Analyzer)((Object)list2)).astNodesToEliminate;
                object.add(x);
            } else if (UtilKt.isAmdDefine(this.context, function2)) {
                JsInvocation jsInvocation = (JsInvocation)expression2;
                list2 = ((JsInvocation)expression2).getArguments();
                Intrinsics.checkNotNullExpressionValue(list2, "expression.arguments");
                this.handleAmdDefine(jsInvocation, list2);
            }
        }
    }

    private final void handleObjectDefineProperty(JsStatement statement2, JsExpression target, JsExpression propertyName, JsExpression propertyDescriptor) {
        if (target == null || !(propertyName instanceof JsStringLiteral) || propertyDescriptor == null) {
            return;
        }
        Context.Node node = this.context.extractNode(target);
        if (node == null) {
            return;
        }
        Context.Node targetNode = node;
        Iterator<JsPropertyInitializer> iterator2 = ((JsStringLiteral)propertyName).getValue();
        Intrinsics.checkNotNullExpressionValue(iterator2, "propertyName.value");
        Context.Node memberNode = targetNode.member((String)((Object)iterator2));
        iterator2 = this.nodeMap;
        iterator2.put(statement2, memberNode);
        memberNode.setHasSideEffects(true);
        if (propertyDescriptor instanceof JsObjectLiteral) {
            for (JsPropertyInitializer initializer2 : ((JsObjectLiteral)propertyDescriptor).getPropertyInitializers()) {
                JsNode jsNode = statement2;
                JsExpression jsExpression = new JsNameRef(((JsStringLiteral)propertyName).getValue(), target);
                JsExpression jsExpression2 = initializer2.getValueExpr();
                Intrinsics.checkNotNullExpressionValue(jsExpression2, "initializer.valueExpr");
                this.processAssignment(jsNode, jsExpression, jsExpression2);
            }
        } else if (propertyDescriptor instanceof JsInvocation) {
            JsExpression initializer2 = ((JsInvocation)propertyDescriptor).getQualifier();
            Intrinsics.checkNotNullExpressionValue(initializer2, "propertyDescriptor.qualifier");
            JsExpression function2 = initializer2;
            if (UtilKt.isObjectGetOwnPropertyDescriptor(this.context, function2)) {
                List<JsExpression> list2 = ((JsInvocation)propertyDescriptor).getArguments();
                Intrinsics.checkNotNullExpressionValue(list2, "propertyDescriptor.arguments");
                JsExpression source = CollectionsKt.getOrNull(list2, 0);
                List<JsExpression> list3 = ((JsInvocation)propertyDescriptor).getArguments();
                Intrinsics.checkNotNullExpressionValue(list3, "propertyDescriptor.arguments");
                JsExpression sourcePropertyName = CollectionsKt.getOrNull(list3, 1);
                if (source != null && sourcePropertyName instanceof JsStringLiteral) {
                    this.processAssignment(statement2, new JsNameRef(((JsStringLiteral)propertyName).getValue(), target), new JsNameRef(((JsStringLiteral)sourcePropertyName).getValue(), source));
                }
            }
        }
    }

    private final void handleAmdDefine(JsInvocation invocation, List<? extends JsExpression> arguments2) {
        Object object;
        JsStringLiteral it;
        Object object2;
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Object object3;
        Object object4;
        JsArrayLiteral jsArrayLiteral;
        List<JsExpression> list2;
        int n = arguments2.size();
        switch (n) {
            case 2: {
                list2 = arguments2;
                break;
            }
            case 3: {
                list2 = CollectionsKt.drop((Iterable)arguments2, 1);
                break;
            }
            default: {
                return;
            }
        }
        List<? extends JsExpression> argumentsWithoutName = list2;
        JsExpression jsExpression = argumentsWithoutName.get(0);
        JsArrayLiteral jsArrayLiteral2 = jsArrayLiteral = jsExpression instanceof JsArrayLiteral ? (JsArrayLiteral)jsExpression : null;
        if (jsArrayLiteral == null) {
            return;
        }
        JsArrayLiteral dependencies2 = jsArrayLiteral;
        JsExpression functionRef = argumentsWithoutName.get(1);
        JsExpression jsExpression2 = functionRef;
        if (jsExpression2 instanceof JsFunction) {
            object4 = (JsFunction)functionRef;
        } else if (jsExpression2 instanceof JsNameRef) {
            if (((JsNameRef)functionRef).getQualifier() != null) {
                return;
            }
            object3 = this.postponedFunctions.get(((JsNameRef)functionRef).getName());
            if (object3 == null) {
                return;
            }
            object4 = object3;
        } else {
            return;
        }
        JsFunction function2 = object4;
        object3 = dependencies2.getExpressions();
        Intrinsics.checkNotNullExpressionValue(object3, "dependencies.expressions");
        object3 = (Iterable)object3;
        boolean $i$f$map = false;
        void var10_11 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            JsExpression jsExpression3 = (JsExpression)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            Object object5 = object2 = it instanceof JsStringLiteral ? (JsStringLiteral)it : null;
            if (object2 == null) {
                return;
            }
            object = object2;
            collection.add(object);
        }
        $this$map$iv = (List)destination$iv$iv;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Context.Node node;
            it = (JsStringLiteral)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            if (Intrinsics.areEqual(it.getValue(), "exports")) {
                node = this.context.getCurrentModule();
            } else {
                Context.Node node2 = this.context.getGlobalScope();
                object2 = it.getValue();
                Intrinsics.checkNotNullExpressionValue(object2, "it.value");
                node = node2.member((String)object2);
            }
            object = node;
            collection.add(object);
        }
        List dependencyNodes = (List)destination$iv$iv;
        this.enterFunctionWithGivenNodes(function2, dependencyNodes);
        object3 = this;
        ((Collection)((Analyzer)object3).astNodesToSkip).add(invocation.getQualifier());
    }

    @Override
    public void visitBlock(@NotNull JsBlock x) {
        Intrinsics.checkNotNullParameter(x, "x");
        String newModule = this.moduleMapping.get(x);
        if (newModule != null) {
            this.context.setCurrentModule(this.context.getGlobalScope().member(newModule));
        }
        List<JsStatement> list2 = x.getStatements();
        Intrinsics.checkNotNullExpressionValue(list2, "x.statements");
        Iterable $this$forEach$iv = list2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            JsStatement it = (JsStatement)element$iv;
            boolean bl = false;
            this.accept((JsNode)it);
        }
    }

    @Override
    public void visitIf(@NotNull JsIf x) {
        Intrinsics.checkNotNullParameter(x, "x");
        this.accept((JsNode)x.getThenStatement());
        JsStatement jsStatement = x.getElseStatement();
        if (jsStatement != null) {
            jsStatement.accept(this);
        }
    }

    @Override
    public void visitReturn(@NotNull JsReturn x) {
        Context.Node node;
        Intrinsics.checkNotNullParameter(x, "x");
        JsExpression expr = x.getExpression();
        if (expr != null && (node = this.context.extractNode(expr)) != null) {
            Context.Node node2;
            Context.Node it = node2 = node;
            boolean bl = false;
            Map<JsNode, Context.Node> map2 = this.nodeMap;
            map2.put(x, it);
        }
    }

    private final Context.Node processAssignment(JsNode node, JsExpression lhs, JsExpression rhs) {
        Context.Node leftNode = this.context.extractNode(lhs);
        Context.Node rightNode = this.context.extractNode(rhs);
        if (leftNode != null && rightNode != null) {
            leftNode.alias(rightNode);
            return leftNode;
        }
        if (leftNode != null) {
            Object object;
            Pair<JsFunction, List<Context.Node>> pair;
            if (rhs instanceof JsInvocation) {
                pair = ((JsInvocation)rhs).getQualifier();
                Intrinsics.checkNotNullExpressionValue(pair, "rhs.qualifier");
                JsExpression function2 = pair;
                if (function2 instanceof JsFunction) {
                    JsFunction jsFunction = (JsFunction)function2;
                    pair = ((JsInvocation)rhs).getArguments();
                    Intrinsics.checkNotNullExpressionValue(pair, "rhs.arguments");
                    this.enterFunction(jsFunction, (List<? extends JsExpression>)((Object)pair));
                    pair = this;
                    Collection collection = ((Analyzer)((Object)pair)).astNodesToSkip;
                    collection.add(lhs);
                    return null;
                }
                if (function2 instanceof JsNameRef && ((JsNameRef)function2).getQualifier() == null && (pair = ((JsNameRef)function2).getName()) != null) {
                    Object object2;
                    Object it = object2 = pair;
                    boolean bl = false;
                    object = this.postponedFunctions.get(it);
                    if (object != null) {
                        it = object2 = object;
                        boolean bl2 = false;
                        Object object3 = ((JsInvocation)rhs).getArguments();
                        Intrinsics.checkNotNullExpressionValue(object3, "rhs.arguments");
                        this.enterFunction((JsFunction)it, (List<? extends JsExpression>)object3);
                        object3 = this;
                        Collection collection = ((Analyzer)object3).astNodesToSkip;
                        collection.add(lhs);
                        return null;
                    }
                }
                if (UtilKt.isObjectFunction(this.context, function2, "create")) {
                    pair = ((JsInvocation)rhs).getArguments();
                    Intrinsics.checkNotNullExpressionValue(pair, "rhs.arguments");
                    this.handleObjectCreate(leftNode, (JsExpression)CollectionsKt.getOrNull(pair, 0));
                    return leftNode;
                }
                if (UtilKt.isDefineInlineFunction(this.context, function2) && ((JsInvocation)rhs).getArguments().size() == 2) {
                    object = ((JsInvocation)rhs).getArguments().get(1);
                    Intrinsics.checkNotNullExpressionValue(object, "rhs.arguments[1]");
                    pair = this.tryExtractFunction((JsExpression)object);
                    if (pair != null) {
                        Pair<JsFunction, List<Context.Node>> $dstr$inlineableFunction$additionalDeps = object = pair;
                        boolean bl = false;
                        JsFunction inlineableFunction = $dstr$inlineableFunction$additionalDeps.component1();
                        List<Context.Node> additionalDeps = $dstr$inlineableFunction$additionalDeps.component2();
                        leftNode.addFunction(inlineableFunction);
                        Context.Node defineInlineFunctionNode = this.context.extractNode(function2);
                        if (defineInlineFunctionNode != null) {
                            leftNode.addDependency(defineInlineFunctionNode);
                        }
                        Iterable $this$forEach$iv = additionalDeps;
                        boolean $i$f$forEach = false;
                        for (Object element$iv : $this$forEach$iv) {
                            Context.Node it = (Context.Node)element$iv;
                            boolean bl3 = false;
                            leftNode.addDependency(it);
                        }
                        return leftNode;
                    }
                }
                if ((pair = this.tryExtractFunction(rhs)) != null) {
                    Pair<JsFunction, List<Context.Node>> $dstr$functionBody$additionalDeps = object = pair;
                    boolean bl = false;
                    JsFunction functionBody = (JsFunction)$dstr$functionBody$additionalDeps.component1();
                    List additionalDeps = (List)$dstr$functionBody$additionalDeps.component2();
                    leftNode.addFunction(functionBody);
                    Iterable $this$forEach$iv = additionalDeps;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        Context.Node it = (Context.Node)element$iv;
                        boolean bl4 = false;
                        leftNode.addDependency(it);
                    }
                    return leftNode;
                }
            } else if (rhs instanceof JsBinaryOperation) {
                if (((JsBinaryOperation)rhs).getOperator() == JsBinaryOperator.OR) {
                    pair = ((JsBinaryOperation)rhs).getArg1();
                    Intrinsics.checkNotNullExpressionValue(pair, "rhs.arg1");
                    Context.Node secondNode = this.context.extractNode((JsExpression)((Object)pair));
                    JsExpression reassignment = ((JsBinaryOperation)rhs).getArg2();
                    if (reassignment instanceof JsBinaryOperation && ((JsBinaryOperation)reassignment).getOperator() == JsBinaryOperator.ASG) {
                        JsExpression $dstr$functionBody$additionalDeps = ((JsBinaryOperation)reassignment).getArg1();
                        Intrinsics.checkNotNullExpressionValue($dstr$functionBody$additionalDeps, "reassignment.arg1");
                        Context.Node reassignNode = this.context.extractNode($dstr$functionBody$additionalDeps);
                        JsExpression reassignValue = ((JsBinaryOperation)reassignment).getArg2();
                        if (Intrinsics.areEqual(reassignNode, secondNode) && reassignNode != null && reassignValue instanceof JsObjectLiteral && ((JsObjectLiteral)reassignValue).getPropertyInitializers().isEmpty()) {
                            JsExpression jsExpression = ((JsBinaryOperation)rhs).getArg1();
                            Intrinsics.checkNotNullExpressionValue(jsExpression, "rhs.arg1");
                            return this.processAssignment(node, lhs, jsExpression);
                        }
                    }
                }
            } else {
                if (rhs instanceof JsFunction) {
                    leftNode.addFunction((JsFunction)rhs);
                    return leftNode;
                }
                if (Intrinsics.areEqual(leftNode.getMemberName(), "$metadata$")) {
                    leftNode.addExpression(rhs);
                    return leftNode;
                }
                if (rhs instanceof JsObjectLiteral && ((JsObjectLiteral)rhs).getPropertyInitializers().isEmpty()) {
                    return leftNode;
                }
            }
            Context.Node nodeInitializedByEmptyObject = this.extractVariableInitializedByEmptyObject(rhs);
            if (nodeInitializedByEmptyObject != null) {
                pair = this;
                object = ((Analyzer)((Object)pair)).astNodesToSkip;
                object.add(rhs);
                leftNode.alias(nodeInitializedByEmptyObject);
                return leftNode;
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private final Pair<JsFunction, List<Context.Node>> tryExtractFunction(JsExpression expression2) {
        JsExpression jsExpression = expression2;
        if (jsExpression instanceof JsFunction) {
            return new Pair(expression2, CollectionsKt.emptyList());
        }
        if (jsExpression instanceof JsInvocation) {
            JsExpression jsExpression2 = ((JsInvocation)expression2).getQualifier();
            Intrinsics.checkNotNullExpressionValue(jsExpression2, "expression.qualifier");
            if (UtilKt.isWrapFunction(this.context, jsExpression2)) {
                List<JsExpression> list2 = ((JsInvocation)expression2).getArguments();
                Intrinsics.checkNotNullExpressionValue(list2, "expression.arguments");
                JsExpression jsExpression3 = CollectionsKt.getOrNull(list2, 0);
                JsExpression jsExpression4 = jsExpression2 = jsExpression3 instanceof JsFunction ? (JsFunction)jsExpression3 : null;
                if (jsExpression2 != null) {
                    void $this$filterIsInstanceTo$iv$iv;
                    Object object;
                    List<JsStatement> it;
                    List<JsStatement> list3;
                    void $this$filterTo$iv$iv;
                    JsExpression wrapper = jsExpression3 = jsExpression2;
                    boolean bl = false;
                    List<JsStatement> list4 = ((JsFunction)wrapper).getBody().getStatements();
                    Intrinsics.checkNotNullExpressionValue(list4, "wrapper.body.statements");
                    Object $this$filter$iv = list4;
                    boolean $i$f$filter = false;
                    Iterable iterable = $this$filter$iv;
                    Collection destination$iv$iv = new ArrayList();
                    boolean $i$f$filterTo = false;
                    for (Object element$iv$iv : $this$filterTo$iv$iv) {
                        JsStatement it2 = (JsStatement)element$iv$iv;
                        boolean bl2 = false;
                        if (!(!(it2 instanceof JsReturn))) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    List statementsWithoutBody = (List)destination$iv$iv;
                    Object it3 = $this$filter$iv = new JsBlock(statementsWithoutBody);
                    boolean bl3 = false;
                    this.context.addNodesForLocalVars((Collection<? extends JsName>)CollectUtilsKt.collectDefinedNames((JsNode)it3));
                    this.accept((JsNode)it3);
                    Object object2 = ((JsInvocation)expression2).getQualifier();
                    Intrinsics.checkNotNullExpressionValue(object2, "expression.qualifier");
                    it3 = this.context.extractNode((JsExpression)object2);
                    if (it3 == null) {
                        list3 = null;
                    } else {
                        Object element$iv$iv;
                        object2 = it3;
                        it = object2;
                        boolean bl4 = false;
                        object = this;
                        element$iv$iv = ((Analyzer)object).functionsToSkip;
                        element$iv$iv.add(it);
                        list3 = object2;
                    }
                    List<JsStatement> wrapperNode = list3;
                    it = ((JsFunction)wrapper).getBody().getStatements();
                    Intrinsics.checkNotNullExpressionValue(it, "wrapper.body.statements");
                    Iterable $this$filterIsInstance$iv = it;
                    boolean $i$f$filterIsInstance = false;
                    object = $this$filterIsInstance$iv;
                    Collection destination$iv$iv2 = new ArrayList();
                    boolean $i$f$filterIsInstanceTo = false;
                    for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                        if (!(element$iv$iv instanceof JsReturn)) continue;
                        destination$iv$iv2.add(element$iv$iv);
                    }
                    object2 = ((JsReturn)CollectionsKt.first((List)destination$iv$iv2)).getExpression();
                    if (object2 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.js.backend.ast.JsFunction");
                    }
                    JsFunction body2 = (JsFunction)object2;
                    return new Pair<JsFunction, List<Context.Node>>(body2, CollectionsKt.listOfNotNull(wrapperNode));
                }
            }
        }
        return null;
    }

    private final void handleObjectCreate(Context.Node target, JsExpression arg) {
        if (arg == null) {
            return;
        }
        Context.Node node = this.context.extractNode(arg);
        if (node == null) {
            return;
        }
        Context.Node prototypeNode = node;
        target.addDependency(prototypeNode.getOriginal());
        target.addExpression(arg);
    }

    private final Context.Node extractVariableInitializedByEmptyObject(JsExpression expression2) {
        JsBinaryOperation jsBinaryOperation;
        if (!(expression2 instanceof JsConditional)) {
            return null;
        }
        JsExpression jsExpression = ((JsConditional)expression2).getTestExpression();
        JsBinaryOperation jsBinaryOperation2 = jsBinaryOperation = jsExpression instanceof JsBinaryOperation ? (JsBinaryOperation)jsExpression : null;
        if (jsBinaryOperation == null) {
            return null;
        }
        JsBinaryOperation testExpr = jsBinaryOperation;
        if (testExpr.getOperator() != JsBinaryOperator.REF_EQ) {
            return null;
        }
        Object object = testExpr.getArg1();
        JsExpression jsExpression2 = jsExpression = object instanceof JsPrefixOperation ? (JsPrefixOperation)object : null;
        if (jsExpression == null) {
            return null;
        }
        JsExpression testExprLhs = jsExpression;
        if (((JsUnaryOperation)testExprLhs).getOperator() != JsUnaryOperator.TYPEOF) {
            return null;
        }
        JsExpression jsExpression3 = ((JsUnaryOperation)testExprLhs).getArg();
        Intrinsics.checkNotNullExpressionValue(jsExpression3, "testExprLhs.arg");
        object = this.context.extractNode(jsExpression3);
        if (object == null) {
            return null;
        }
        Object testExprNode = object;
        Object object2 = testExpr.getArg2();
        JsExpression jsExpression4 = jsExpression3 = object2 instanceof JsStringLiteral ? (JsStringLiteral)object2 : null;
        if (jsExpression3 == null) {
            return null;
        }
        JsExpression testExprRhs = jsExpression3;
        if (!Intrinsics.areEqual(((JsStringLiteral)testExprRhs).getValue(), "undefined")) {
            return null;
        }
        Object object3 = ((JsConditional)expression2).getThenExpression();
        Object object4 = object2 = object3 instanceof JsObjectLiteral ? (JsObjectLiteral)object3 : null;
        if (object2 == null) {
            return null;
        }
        JsExpression thenExpr = object2;
        object2 = ((JsObjectLiteral)thenExpr).getPropertyInitializers();
        Intrinsics.checkNotNullExpressionValue(object2, "thenExpr.propertyInitializers");
        if (!((Collection)object2).isEmpty()) {
            return null;
        }
        JsExpression jsExpression5 = ((JsConditional)expression2).getElseExpression();
        Intrinsics.checkNotNullExpressionValue(jsExpression5, "expression.elseExpression");
        object3 = this.context.extractNode(jsExpression5);
        if (object3 == null) {
            return null;
        }
        Object elseNode = object3;
        if (!Intrinsics.areEqual(((Context.Node)testExprNode).getOriginal(), ((Context.Node)elseNode).getOriginal())) {
            return null;
        }
        return ((Context.Node)testExprNode).getOriginal();
    }

    private final void enterFunction(JsFunction function2, List<? extends JsExpression> arguments2) {
        Iterator iterator2 = this;
        Collection object2 = ((Analyzer)((Object)iterator2)).functionsToEnter;
        object2.add(function2);
        this.context.addNodesForLocalVars(CollectUtilsKt.collectLocalVariables$default(function2, false, 1, null));
        iterator2 = function2.getBody();
        Intrinsics.checkNotNullExpressionValue(iterator2, "function.body");
        this.context.markSpecialFunctions((JsNode)((Object)iterator2));
        List<JsParameter> list2 = function2.getParameters();
        Intrinsics.checkNotNullExpressionValue(list2, "function.parameters");
        for (Pair pair : CollectionsKt.zip((Iterable)list2, (Iterable)arguments2)) {
            Object object;
            Map<JsName, JsFunction> map2;
            JsParameter param = (JsParameter)pair.component1();
            JsExpression arg = (JsExpression)pair.component2();
            if (arg instanceof JsFunction && ((JsFunction)arg).getName() == null) {
                map2 = ((JsFunction)arg).getBody();
                Intrinsics.checkNotNullExpressionValue(map2, "arg.body");
                JsStatement jsStatement = (JsStatement)((Object)map2);
                Intrinsics.checkNotNullExpressionValue(param, "param");
                if (this.isProperFunctionalParameter(jsStatement, param)) {
                    map2 = this.postponedFunctions;
                    object = param.getName();
                    Intrinsics.checkNotNullExpressionValue(object, "param.name");
                    JsExpression jsExpression = arg;
                    map2.put((JsName)object, (JsFunction)jsExpression);
                    continue;
                }
            }
            JsNode jsNode = function2;
            map2 = param.getName().makeRef();
            Intrinsics.checkNotNullExpressionValue(map2, "param.name.makeRef()");
            if (this.processAssignment(jsNode, (JsExpression)((Object)map2), arg) == null) continue;
            map2 = this;
            object = ((Analyzer)((Object)map2)).astNodesToSkip;
            object.add(arg);
        }
        this.processFunction(function2);
    }

    private final void enterFunctionWithGivenNodes(JsFunction function2, List<Context.Node> arguments2) {
        Iterator iterator2 = this;
        Collection object2 = ((Analyzer)((Object)iterator2)).functionsToEnter;
        object2.add(function2);
        this.context.addNodesForLocalVars(CollectUtilsKt.collectLocalVariables$default(function2, false, 1, null));
        iterator2 = function2.getBody();
        Intrinsics.checkNotNullExpressionValue(iterator2, "function.body");
        this.context.markSpecialFunctions((JsNode)((Object)iterator2));
        List<JsParameter> list2 = function2.getParameters();
        Intrinsics.checkNotNullExpressionValue(list2, "function.parameters");
        for (Pair pair : CollectionsKt.zip((Iterable)list2, (Iterable)arguments2)) {
            Context.Node paramNode;
            JsParameter param = (JsParameter)pair.component1();
            Context.Node arg = (Context.Node)pair.component2();
            Intrinsics.checkNotNull(this.context.getNodes().get(param.getName()));
            paramNode.alias(arg);
        }
        this.processFunction(function2);
    }

    private final void processFunction(JsFunction function2) {
        if (this.processedFunctions.add(function2)) {
            this.accept((JsNode)function2.getBody());
        }
    }

    private final boolean isProperFunctionalParameter(JsStatement body2, JsParameter parameter) {
        Ref.BooleanRef result2 = new Ref.BooleanRef();
        result2.element = true;
        body2.accept(new RecursiveJsVisitor(parameter, this, result2){
            final /* synthetic */ JsParameter $parameter;
            final /* synthetic */ Analyzer this$0;
            final /* synthetic */ Ref.BooleanRef $result;
            {
                this.$parameter = $parameter;
                this.this$0 = $receiver;
                this.$result = $result;
            }

            /*
             * WARNING - void declaration
             */
            public void visitInvocation(@NotNull JsInvocation invocation) {
                Intrinsics.checkNotNullParameter(invocation, "invocation");
                Object object = invocation.getQualifier();
                Intrinsics.checkNotNullExpressionValue(object, "invocation.qualifier");
                JsExpression qualifier = object;
                if (qualifier instanceof JsNameRef && ((JsNameRef)qualifier).getQualifier() == null && Intrinsics.areEqual(((JsNameRef)qualifier).getName(), this.$parameter.getName())) {
                    boolean bl;
                    block6: {
                        void $this$all$iv;
                        object = invocation.getArguments();
                        Intrinsics.checkNotNullExpressionValue(object, "invocation.arguments");
                        object = (Iterable)object;
                        Analyzer analyzer2 = this.this$0;
                        boolean $i$f$all = false;
                        if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                            bl = true;
                        } else {
                            for (T element$iv : $this$all$iv) {
                                JsExpression it = (JsExpression)element$iv;
                                boolean bl2 = false;
                                Context context2 = Analyzer.access$getContext$p(analyzer2);
                                Intrinsics.checkNotNullExpressionValue(it, "it");
                                if (context2.extractNode(it) != null) continue;
                                bl = false;
                                break block6;
                            }
                            bl = true;
                        }
                    }
                    if (bl) {
                        return;
                    }
                }
                if (UtilKt.isAmdDefine(Analyzer.access$getContext$p(this.this$0), qualifier)) {
                    return;
                }
                super.visitInvocation(invocation);
            }

            public void visitNameRef(@NotNull JsNameRef nameRef) {
                Intrinsics.checkNotNullParameter(nameRef, "nameRef");
                if (Intrinsics.areEqual(nameRef.getName(), this.$parameter.getName())) {
                    this.$result.element = false;
                }
                super.visitNameRef(nameRef);
            }
        });
        return result2.element;
    }

    public static final /* synthetic */ Context access$getContext$p(Analyzer $this) {
        return $this.context;
    }

    public static final /* synthetic */ Map access$getNodeMap$p(Analyzer $this) {
        return $this.nodeMap;
    }

    public static final /* synthetic */ Set access$getAstNodesToEliminate$p(Analyzer $this) {
        return $this.astNodesToEliminate;
    }

    public static final /* synthetic */ Set access$getAstNodesToSkip$p(Analyzer $this) {
        return $this.astNodesToSkip;
    }

    public static final /* synthetic */ Set access$getFunctionsToEnter$p(Analyzer $this) {
        return $this.functionsToEnter;
    }

    public static final /* synthetic */ Set access$getInvocationsToSkip$p(Analyzer $this) {
        return $this.invocationsToSkip;
    }

    public static final /* synthetic */ Set access$getFunctionsToSkip$p(Analyzer $this) {
        return $this.functionsToSkip;
    }
}

