/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.incremental;

import java.security.MessageDigest;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.incremental.IncrementalJvmCacheKt;
import org.jetbrains.kotlin.inline.InlineUtilKt;
import org.jetbrains.kotlin.load.kotlin.header.KotlinClassHeader;
import org.jetbrains.kotlin.resolve.jvm.AsmTypes;
import org.jetbrains.org.objectweb.asm.ClassReader;
import org.jetbrains.org.objectweb.asm.ClassVisitor;
import org.jetbrains.org.objectweb.asm.ClassWriter;
import org.jetbrains.org.objectweb.asm.FieldVisitor;
import org.jetbrains.org.objectweb.asm.MethodVisitor;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000F\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000f\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a,\u0010\u0004\u001a\u001e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00060\u0005j\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u0006`\u00072\u0006\u0010\b\u001a\u00020\tH\u0002\u001a4\u0010\n\u001a\u001e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u000b0\u0005j\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u000b`\u00072\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\tH\u0002\u001a \u0010\u000e\u001a\u00020\u0001\"\u000e\b\u0000\u0010\u000f*\b\u0012\u0004\u0012\u0002H\u000f0\u0010*\b\u0012\u0004\u0012\u0002H\u000f0\u0011\u001a@\u0010\u0012\u001a\u00020\u0001\"\u000e\b\u0000\u0010\u0013*\b\u0012\u0004\u0012\u0002H\u00130\u0010\"\u0004\b\u0001\u0010\u0014*\u000e\u0012\u0004\u0012\u0002H\u0013\u0012\u0004\u0012\u0002H\u00140\u00152\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u0002H\u0014\u0012\u0004\u0012\u00020\u00010\u0017\u001a\n\u0010\u0018\u001a\u00020\u000b*\u00020\t\"\u0014\u0010\u0000\u001a\u00020\u0001X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0019"}, d2={"KOTLIN_CACHE_DIRECTORY_NAME", "", "getKOTLIN_CACHE_DIRECTORY_NAME", "()Ljava/lang/String;", "getConstantsMap", "Ljava/util/LinkedHashMap;", "", "Lkotlin/collections/LinkedHashMap;", "bytes", "", "getInlineFunctionsMap", "", "header", "Lorg/jetbrains/kotlin/load/kotlin/header/KotlinClassHeader;", "dumpCollection", "T", "", "", "dumpMap", "K", "V", "", "dumpValue", "Lkotlin/Function1;", "md5", "kotlin-build-common"})
public final class IncrementalJvmCacheKt {
    @NotNull
    private static final String KOTLIN_CACHE_DIRECTORY_NAME = "kotlin";

    @NotNull
    public static final String getKOTLIN_CACHE_DIRECTORY_NAME() {
        return KOTLIN_CACHE_DIRECTORY_NAME;
    }

    public static final long md5(@NotNull byte[] $this$md5) {
        Intrinsics.checkNotNullParameter($this$md5, "<this>");
        byte[] byArray = MessageDigest.getInstance("MD5").digest($this$md5);
        Intrinsics.checkNotNull(byArray);
        byte[] d = byArray;
        return (long)d[0] & 0xFFL | ((long)d[1] & 0xFFL) << 8 | ((long)d[2] & 0xFFL) << 16 | ((long)d[3] & 0xFFL) << 24 | ((long)d[4] & 0xFFL) << 32 | ((long)d[5] & 0xFFL) << 40 | ((long)d[6] & 0xFFL) << 48 | ((long)d[7] & 0xFFL) << 56;
    }

    @NotNull
    public static final <K extends Comparable<? super K>, V> String dumpMap(@NotNull Map<K, ? extends V> $this$dumpMap, @NotNull Function1<? super V, String> dumpValue2) {
        StringBuilder stringBuilder2;
        Intrinsics.checkNotNullParameter($this$dumpMap, "<this>");
        Intrinsics.checkNotNullParameter(dumpValue2, "dumpValue");
        StringBuilder $this$dumpMap_u24lambda_u2d0 = stringBuilder2 = new StringBuilder();
        boolean bl = false;
        $this$dumpMap_u24lambda_u2d0.append("{");
        for (Comparable key : CollectionsKt.sorted((Iterable)$this$dumpMap.keySet())) {
            String string2;
            V v;
            if ($this$dumpMap_u24lambda_u2d0.length() != 1) {
                $this$dumpMap_u24lambda_u2d0.append(", ");
            }
            if ((v = $this$dumpMap.get(key)) == null) {
                string2 = "null";
            } else {
                V v2 = v;
                string2 = dumpValue2.invoke(v2);
            }
            String value2 = string2;
            $this$dumpMap_u24lambda_u2d0.append(key + " -> " + value2);
        }
        $this$dumpMap_u24lambda_u2d0.append("}");
        String string3 = stringBuilder2.toString();
        Intrinsics.checkNotNullExpressionValue(string3, "StringBuilder().apply(builderAction).toString()");
        return string3;
    }

    @NotNull
    public static final <T extends Comparable<? super T>> String dumpCollection(@NotNull Collection<? extends T> $this$dumpCollection) {
        Intrinsics.checkNotNullParameter($this$dumpCollection, "<this>");
        return '[' + CollectionsKt.joinToString$default(CollectionsKt.sorted((Iterable)$this$dumpCollection), ", ", null, null, 0, null, dumpCollection.1.INSTANCE, 30, null) + ']';
    }

    private static final LinkedHashMap<String, Object> getConstantsMap(byte[] bytes) {
        LinkedHashMap<String, Object> result2 = new LinkedHashMap<String, Object>();
        new ClassReader(bytes).accept(new ClassVisitor(result2){
            final /* synthetic */ LinkedHashMap<String, Object> $result;
            {
                this.$result = $result;
                super(589824);
            }

            @Nullable
            public FieldVisitor visitField(int access, @NotNull String name2, @NotNull String desc, @Nullable String signature2, @Nullable Object value2) {
                Intrinsics.checkNotNullParameter(name2, "name");
                Intrinsics.checkNotNullParameter(desc, "desc");
                int staticFinal = 26;
                if (value2 != null && (access & staticFinal) == 24) {
                    Map map2 = this.$result;
                    map2.put(name2, value2);
                }
                return null;
            }
        }, 7);
        return result2;
    }

    private static final LinkedHashMap<String, Long> getInlineFunctionsMap(KotlinClassHeader header, byte[] bytes) {
        Set<String> inlineFunctions = InlineUtilKt.inlineFunctionsJvmNames(header);
        if (inlineFunctions.isEmpty()) {
            return new LinkedHashMap<String, Long>();
        }
        LinkedHashMap<String, Long> result2 = new LinkedHashMap<String, Long>();
        Ref.IntRef dummyVersion = new Ref.IntRef();
        dummyVersion.element = -1;
        new ClassReader(bytes).accept(new ClassVisitor(dummyVersion, inlineFunctions, result2){
            final /* synthetic */ Ref.IntRef $dummyVersion;
            final /* synthetic */ Set<String> $inlineFunctions;
            final /* synthetic */ LinkedHashMap<String, Long> $result;
            {
                this.$dummyVersion = $dummyVersion;
                this.$inlineFunctions = $inlineFunctions;
                this.$result = $result;
                super(589824);
            }

            public void visit(int version, int access, @Nullable String name2, @Nullable String signature2, @Nullable String superName, @Nullable String[] interfaces) {
                super.visit(version, access, name2, signature2, superName, interfaces);
                this.$dummyVersion.element = version;
            }

            @NotNull
            public MethodVisitor visitMethod(int access, @NotNull String name2, @NotNull String desc, @Nullable String signature2, @Nullable String[] exceptions) {
                Intrinsics.checkNotNullParameter(name2, "name");
                Intrinsics.checkNotNullParameter(desc, "desc");
                ClassWriter dummyClassWriter = new ClassWriter(0);
                dummyClassWriter.visit(this.$dummyVersion.element, 0, "dummy", null, AsmTypes.OBJECT_TYPE.getInternalName(), null);
                MethodVisitor methodVisitor = dummyClassWriter.visitMethod(0, name2, desc, null, exceptions);
                return new MethodVisitor(name2, desc, this.$inlineFunctions, dummyClassWriter, this.$result, methodVisitor){
                    final /* synthetic */ String $name;
                    final /* synthetic */ String $desc;
                    final /* synthetic */ Set<String> $inlineFunctions;
                    final /* synthetic */ ClassWriter $dummyClassWriter;
                    final /* synthetic */ LinkedHashMap<String, Long> $result;
                    {
                        this.$name = $name;
                        this.$desc = $desc;
                        this.$inlineFunctions = $inlineFunctions;
                        this.$dummyClassWriter = $dummyClassWriter;
                        this.$result = $result;
                        super(589824, $super_call_param$1);
                    }

                    public void visitEnd() {
                        String jvmName2 = Intrinsics.stringPlus(this.$name, this.$desc);
                        if (!this.$inlineFunctions.contains(jvmName2)) {
                            return;
                        }
                        byte[] byArray = this.$dummyClassWriter.toByteArray();
                        Intrinsics.checkNotNull(byArray);
                        byte[] dummyBytes = byArray;
                        long hash = IncrementalJvmCacheKt.md5(dummyBytes);
                        Map map2 = this.$result;
                        Long l = hash;
                        map2.put(jvmName2, l);
                    }
                };
            }
        }, 0);
        return result2;
    }

    public static final /* synthetic */ LinkedHashMap access$getConstantsMap(byte[] bytes) {
        return IncrementalJvmCacheKt.getConstantsMap(bytes);
    }

    public static final /* synthetic */ LinkedHashMap access$getInlineFunctionsMap(KotlinClassHeader header, byte[] bytes) {
        return IncrementalJvmCacheKt.getInlineFunctionsMap(header, bytes);
    }
}

