/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.transformers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.ArrayDeque;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousObject;
import org.jetbrains.kotlin.fir.declarations.FirConstructor;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirEnumEntry;
import org.jetbrains.kotlin.fir.declarations.FirField;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirPropertyAccessor;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirResolvePhase;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.declarations.FirTypeAlias;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameter;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameterRef;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameterRefsOwner;
import org.jetbrains.kotlin.fir.declarations.FirTypeParametersOwner;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.declarations.utils.DeclarationAttributesKt;
import org.jetbrains.kotlin.fir.expressions.FirAnnotationCall;
import org.jetbrains.kotlin.fir.expressions.FirBlock;
import org.jetbrains.kotlin.fir.expressions.FirDelegatedConstructorCall;
import org.jetbrains.kotlin.fir.expressions.FirStatement;
import org.jetbrains.kotlin.fir.resolve.ScopeSession;
import org.jetbrains.kotlin.fir.resolve.diagnostics.ConeCyclicTypeBound;
import org.jetbrains.kotlin.fir.resolve.transformers.FirAbstractTreeTransformerWithSuperTypes;
import org.jetbrains.kotlin.fir.resolve.transformers.FirSpecificTypeResolverTransformer;
import org.jetbrains.kotlin.fir.resolve.transformers.ScopeClassDeclaration;
import org.jetbrains.kotlin.fir.resolve.transformers.StoreType;
import org.jetbrains.kotlin.fir.resolve.transformers.TransformUtilsKt;
import org.jetbrains.kotlin.fir.scopes.FirScope;
import org.jetbrains.kotlin.fir.scopes.ScopesKt;
import org.jetbrains.kotlin.fir.symbols.ConeTypeParameterLookupTag;
import org.jetbrains.kotlin.fir.symbols.impl.FirTypeParameterSymbol;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeTypeParameterType;
import org.jetbrains.kotlin.fir.types.FirErrorTypeRef;
import org.jetbrains.kotlin.fir.types.FirImplicitTypeRef;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.builder.FirErrorTypeRefBuilder;
import org.jetbrains.kotlin.kotlinx.collections.immutable.ExtensionsKt;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u00c8\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\tJ&\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00132\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00130\u0016H\u0002J\u001a\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0016J\u001a\u0010\u001d\u001a\u00020\u00182\u0006\u0010\u001e\u001a\u00020\u001f2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0016J\u001a\u0010 \u001a\u00020\u00182\u0006\u0010!\u001a\u00020\"2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0016J\u001a\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020$2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0016J\u001a\u0010&\u001a\u00020\u00182\u0006\u0010'\u001a\u00020(2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0016J\u001a\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020*2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0016J\u001a\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020-2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0016J\u001a\u0010/\u001a\u00020\u000b2\u0006\u00100\u001a\u00020\u000b2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0016J\u001a\u00101\u001a\u0002022\u0006\u00103\u001a\u0002042\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0016J\u001a\u00105\u001a\u0002062\u0006\u00107\u001a\u0002062\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0016J\u001a\u00108\u001a\u00020\u00182\u0006\u00109\u001a\u00020:2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0016J\u001a\u0010;\u001a\u00020<2\u0006\u0010=\u001a\u00020<2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0016J\u001a\u0010>\u001a\u00020?2\u0006\u0010@\u001a\u00020?2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0016J\u001a\u0010A\u001a\u00020B2\u0006\u0010C\u001a\u0002022\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0016J\u001a\u0010D\u001a\u00020\u00182\u0006\u0010E\u001a\u00020F2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0016J\u0010\u0010G\u001a\u00020H2\u0006\u0010I\u001a\u00020JH\u0002R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006K"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/transformers/FirTypeResolveTransformer;", "Lorg/jetbrains/kotlin/fir/resolve/transformers/FirAbstractTreeTransformerWithSuperTypes;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "scopeSession", "Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;", "initialScopes", "", "Lorg/jetbrains/kotlin/fir/scopes/FirScope;", "(Lorg/jetbrains/kotlin/fir/FirSession;Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;Ljava/util/List;)V", "currentFile", "Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "getSession", "()Lorg/jetbrains/kotlin/fir/FirSession;", "typeResolverTransformer", "Lorg/jetbrains/kotlin/fir/resolve/transformers/FirSpecificTypeResolverTransformer;", "hasSupertypePathToParameter", "", "currentTypeParameter", "Lorg/jetbrains/kotlin/fir/declarations/FirTypeParameter;", "typeParameter", "visited", "", "transformAnnotationCall", "Lorg/jetbrains/kotlin/fir/expressions/FirStatement;", "annotationCall", "Lorg/jetbrains/kotlin/fir/expressions/FirAnnotationCall;", "data", "", "transformAnonymousObject", "anonymousObject", "Lorg/jetbrains/kotlin/fir/declarations/FirAnonymousObject;", "transformBlock", "block", "Lorg/jetbrains/kotlin/fir/expressions/FirBlock;", "transformConstructor", "Lorg/jetbrains/kotlin/fir/declarations/FirConstructor;", "constructor", "transformDelegatedConstructorCall", "delegatedConstructorCall", "Lorg/jetbrains/kotlin/fir/expressions/FirDelegatedConstructorCall;", "transformEnumEntry", "Lorg/jetbrains/kotlin/fir/declarations/FirEnumEntry;", "enumEntry", "transformField", "Lorg/jetbrains/kotlin/fir/declarations/FirField;", "field", "transformFile", "file", "transformImplicitTypeRef", "Lorg/jetbrains/kotlin/fir/types/FirTypeRef;", "implicitTypeRef", "Lorg/jetbrains/kotlin/fir/types/FirImplicitTypeRef;", "transformProperty", "Lorg/jetbrains/kotlin/fir/declarations/FirProperty;", "property", "transformRegularClass", "regularClass", "Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;", "transformSimpleFunction", "Lorg/jetbrains/kotlin/fir/declarations/FirSimpleFunction;", "simpleFunction", "transformTypeAlias", "Lorg/jetbrains/kotlin/fir/declarations/FirTypeAlias;", "typeAlias", "transformTypeRef", "Lorg/jetbrains/kotlin/fir/types/FirResolvedTypeRef;", "typeRef", "transformValueParameter", "valueParameter", "Lorg/jetbrains/kotlin/fir/declarations/FirValueParameter;", "unboundCyclesInTypeParametersSupertypes", "", "typeParametersOwner", "Lorg/jetbrains/kotlin/fir/declarations/FirTypeParameterRefsOwner;", "resolve"})
public class FirTypeResolveTransformer
extends FirAbstractTreeTransformerWithSuperTypes {
    @NotNull
    private final FirSession session;
    @NotNull
    private final FirSpecificTypeResolverTransformer typeResolverTransformer;
    @Nullable
    private FirFile currentFile;

    public FirTypeResolveTransformer(@NotNull FirSession session2, @NotNull ScopeSession scopeSession, @NotNull List<? extends FirScope> initialScopes) {
        Intrinsics.checkNotNullParameter(session2, "session");
        Intrinsics.checkNotNullParameter(scopeSession, "scopeSession");
        Intrinsics.checkNotNullParameter(initialScopes, "initialScopes");
        super(FirResolvePhase.TYPES, scopeSession);
        this.session = session2;
        this.getScopes().addAll((Collection<FirScope>)CollectionsKt.asReversed(initialScopes));
        this.typeResolverTransformer = new FirSpecificTypeResolverTransformer(this.session, false, 2, null);
    }

    public /* synthetic */ FirTypeResolveTransformer(FirSession firSession, ScopeSession scopeSession, List list2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            list2 = CollectionsKt.emptyList();
        }
        this(firSession, scopeSession, list2);
    }

    @Override
    @NotNull
    public final FirSession getSession() {
        return this.session;
    }

    @Override
    @NotNull
    public FirFile transformFile(@NotNull FirFile file2, @Nullable Object data2) {
        int n;
        Intrinsics.checkNotNullParameter(file2, "file");
        this.checkSessionConsistency(file2);
        this.currentFile = file2;
        FirAbstractTreeTransformerWithSuperTypes this_$iv = this;
        boolean $i$f$withScopeCleanup = false;
        int sizeBefore$iv = FirAbstractTreeTransformerWithSuperTypes.access$getScopes(this_$iv).size();
        boolean bl = false;
        this.getScopes().addAll(ScopesKt.createImportingScopes$default(file2, this.getSession(), this.getScopeSession(), false, 8, null));
        FirFile result$iv = FirTypeResolveTransformer.super.transformFile(file2, data2);
        int size$iv = FirAbstractTreeTransformerWithSuperTypes.access$getScopes(this_$iv).size();
        int n2 = n = size$iv >= sizeBefore$iv ? 1 : 0;
        if (_Assertions.ENABLED && n == 0) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        n = size$iv - sizeBefore$iv;
        int n3 = 0;
        while (n3 < n) {
            int n4;
            int it$iv = n4 = n3++;
            boolean bl2 = false;
            FirAbstractTreeTransformerWithSuperTypes.access$getScopes(this_$iv).remove(CollectionsKt.getLastIndex(FirAbstractTreeTransformerWithSuperTypes.access$getScopes(this_$iv)));
        }
        return result$iv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public FirStatement transformRegularClass(@NotNull FirRegularClass regularClass, @Nullable Object data2) {
        FirStatement firStatement;
        Intrinsics.checkNotNullParameter(regularClass, "regularClass");
        FirAbstractTreeTransformerWithSuperTypes this_$iv = this;
        boolean $i$f$withClassDeclarationCleanup = false;
        ArrayDeque classDeclarations$iv$iv = FirAbstractTreeTransformerWithSuperTypes.access$getClassDeclarationsStack(this_$iv);
        boolean $i$f$withClassDeclarationCleanup2 = false;
        classDeclarations$iv$iv.addLast(regularClass);
        try {
            int n;
            boolean bl = false;
            boolean bl2 = false;
            FirAbstractTreeTransformerWithSuperTypes this_$iv2 = this;
            boolean $i$f$withScopeCleanup = false;
            int sizeBefore$iv = FirAbstractTreeTransformerWithSuperTypes.access$getScopes(this_$iv2).size();
            boolean bl3 = false;
            this.addTypeParametersScope(regularClass);
            Iterable $this$forEach$iv = regularClass.getTypeParameters();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                FirTypeParameterRef it = (FirTypeParameterRef)element$iv;
                boolean bl4 = false;
                it.accept(this, data2);
            }
            this.unboundCyclesInTypeParametersSupertypes(regularClass);
            Unit result$iv = Unit.INSTANCE;
            int size$iv = FirAbstractTreeTransformerWithSuperTypes.access$getScopes(this_$iv2).size();
            int n2 = n = size$iv >= sizeBefore$iv ? 1 : 0;
            if (_Assertions.ENABLED && n == 0) {
                String string2 = "Assertion failed";
                throw new AssertionError((Object)string2);
            }
            n = size$iv - sizeBefore$iv;
            int n3 = 0;
            while (n3 < n) {
                int n4;
                int it$iv = n4 = n3++;
                boolean bl5 = false;
                FirAbstractTreeTransformerWithSuperTypes.access$getScopes(this_$iv2).remove(CollectionsKt.getLastIndex(FirAbstractTreeTransformerWithSuperTypes.access$getScopes(this_$iv2)));
            }
            firStatement = this.resolveNestedClassesSupertypes(regularClass, data2);
        }
        finally {
            classDeclarations$iv$iv.removeLast();
        }
        return firStatement;
    }

    @Override
    @NotNull
    public FirStatement transformAnonymousObject(@NotNull FirAnonymousObject anonymousObject, @Nullable Object data2) {
        Intrinsics.checkNotNullParameter(anonymousObject, "anonymousObject");
        return this.resolveNestedClassesSupertypes(anonymousObject, data2);
    }

    @NotNull
    public FirConstructor transformConstructor(@NotNull FirConstructor constructor2, @Nullable Object data2) {
        int n;
        Intrinsics.checkNotNullParameter(constructor2, "constructor");
        FirAbstractTreeTransformerWithSuperTypes this_$iv = this;
        boolean $i$f$withScopeCleanup = false;
        int sizeBefore$iv = FirAbstractTreeTransformerWithSuperTypes.access$getScopes(this_$iv).size();
        boolean bl = false;
        this.addTypeParametersScope(constructor2);
        FirDeclaration result$iv = this.transformDeclaration(constructor2, data2);
        int size$iv = FirAbstractTreeTransformerWithSuperTypes.access$getScopes(this_$iv).size();
        int n2 = n = size$iv >= sizeBefore$iv ? 1 : 0;
        if (_Assertions.ENABLED && n == 0) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        n = size$iv - sizeBefore$iv;
        int n3 = 0;
        while (n3 < n) {
            int n4;
            int it$iv = n4 = n3++;
            boolean bl2 = false;
            FirAbstractTreeTransformerWithSuperTypes.access$getScopes(this_$iv).remove(CollectionsKt.getLastIndex(FirAbstractTreeTransformerWithSuperTypes.access$getScopes(this_$iv)));
        }
        return (FirConstructor)result$iv;
    }

    @NotNull
    public FirTypeAlias transformTypeAlias(@NotNull FirTypeAlias typeAlias, @Nullable Object data2) {
        int n;
        Intrinsics.checkNotNullParameter(typeAlias, "typeAlias");
        FirAbstractTreeTransformerWithSuperTypes this_$iv = this;
        boolean $i$f$withScopeCleanup = false;
        int sizeBefore$iv = FirAbstractTreeTransformerWithSuperTypes.access$getScopes(this_$iv).size();
        boolean bl = false;
        this.addTypeParametersScope(typeAlias);
        FirDeclaration result$iv = this.transformDeclaration(typeAlias, data2);
        int size$iv = FirAbstractTreeTransformerWithSuperTypes.access$getScopes(this_$iv).size();
        int n2 = n = size$iv >= sizeBefore$iv ? 1 : 0;
        if (_Assertions.ENABLED && n == 0) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        n = size$iv - sizeBefore$iv;
        int n3 = 0;
        while (n3 < n) {
            int n4;
            int it$iv = n4 = n3++;
            boolean bl2 = false;
            FirAbstractTreeTransformerWithSuperTypes.access$getScopes(this_$iv).remove(CollectionsKt.getLastIndex(FirAbstractTreeTransformerWithSuperTypes.access$getScopes(this_$iv)));
        }
        return (FirTypeAlias)result$iv;
    }

    @NotNull
    public FirEnumEntry transformEnumEntry(@NotNull FirEnumEntry enumEntry, @Nullable Object data2) {
        Intrinsics.checkNotNullParameter(enumEntry, "enumEntry");
        enumEntry.transformReturnTypeRef(this, data2);
        enumEntry.transformTypeParameters(this, data2);
        enumEntry.transformAnnotations(this, data2);
        return enumEntry;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public FirProperty transformProperty(@NotNull FirProperty property2, @Nullable Object data2) {
        int n;
        Intrinsics.checkNotNullParameter(property2, "property");
        FirAbstractTreeTransformerWithSuperTypes this_$iv = this;
        boolean $i$f$withScopeCleanup = false;
        int sizeBefore$iv = FirAbstractTreeTransformerWithSuperTypes.access$getScopes(this_$iv).size();
        boolean bl = false;
        this.addTypeParametersScope(property2);
        property2.transformTypeParameters(this, data2).transformReturnTypeRef(this, data2).transformReceiverTypeRef(this, data2).transformGetter(this, data2).transformSetter(this, data2).transformAnnotations(this, data2);
        if (Intrinsics.areEqual(DeclarationAttributesKt.isFromVararg(property2), true)) {
            TransformUtilsKt.transformTypeToArrayType(property2);
            FirPropertyAccessor firPropertyAccessor = property2.getGetter();
            if (firPropertyAccessor != null) {
                firPropertyAccessor.transformReturnTypeRef(StoreType.INSTANCE, property2.getReturnTypeRef());
            }
            firPropertyAccessor = property2.getSetter();
            if (firPropertyAccessor != null) {
                void $this$mapTo$iv$iv;
                List<FirValueParameter> list2 = firPropertyAccessor.getValueParameters();
                Iterable $this$map$iv = list2;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    FirValueParameter firValueParameter = (FirValueParameter)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl2 = false;
                    FirValueParameter firValueParameter2 = it.transformReturnTypeRef(StoreType.INSTANCE, property2.getReturnTypeRef());
                    collection.add(firValueParameter2);
                }
                List cfr_ignored_0 = (List)destination$iv$iv;
            }
        }
        this.unboundCyclesInTypeParametersSupertypes(property2);
        FirProperty result$iv = property2;
        int size$iv = FirAbstractTreeTransformerWithSuperTypes.access$getScopes(this_$iv).size();
        int n2 = n = size$iv >= sizeBefore$iv ? 1 : 0;
        if (_Assertions.ENABLED && n == 0) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        n = size$iv - sizeBefore$iv;
        int n3 = 0;
        while (n3 < n) {
            int n4;
            int it$iv = n4 = n3++;
            boolean bl3 = false;
            FirAbstractTreeTransformerWithSuperTypes.access$getScopes(this_$iv).remove(CollectionsKt.getLastIndex(FirAbstractTreeTransformerWithSuperTypes.access$getScopes(this_$iv)));
        }
        return result$iv;
    }

    @NotNull
    public FirField transformField(@NotNull FirField field2, @Nullable Object data2) {
        int n;
        Intrinsics.checkNotNullParameter(field2, "field");
        FirAbstractTreeTransformerWithSuperTypes this_$iv = this;
        boolean $i$f$withScopeCleanup = false;
        int sizeBefore$iv = FirAbstractTreeTransformerWithSuperTypes.access$getScopes(this_$iv).size();
        boolean bl = false;
        field2.transformReturnTypeRef(this, data2).transformAnnotations(this, data2);
        FirField result$iv = field2;
        int size$iv = FirAbstractTreeTransformerWithSuperTypes.access$getScopes(this_$iv).size();
        int n2 = n = size$iv >= sizeBefore$iv ? 1 : 0;
        if (_Assertions.ENABLED && n == 0) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        n = size$iv - sizeBefore$iv;
        int n3 = 0;
        while (n3 < n) {
            int n4;
            int it$iv = n4 = n3++;
            boolean bl2 = false;
            FirAbstractTreeTransformerWithSuperTypes.access$getScopes(this_$iv).remove(CollectionsKt.getLastIndex(FirAbstractTreeTransformerWithSuperTypes.access$getScopes(this_$iv)));
        }
        return result$iv;
    }

    @NotNull
    public FirSimpleFunction transformSimpleFunction(@NotNull FirSimpleFunction simpleFunction, @Nullable Object data2) {
        int n;
        FirDeclaration firDeclaration;
        Intrinsics.checkNotNullParameter(simpleFunction, "simpleFunction");
        FirAbstractTreeTransformerWithSuperTypes this_$iv = this;
        boolean $i$f$withScopeCleanup = false;
        int sizeBefore$iv = FirAbstractTreeTransformerWithSuperTypes.access$getScopes(this_$iv).size();
        boolean bl = false;
        this.addTypeParametersScope(simpleFunction);
        FirDeclaration it = firDeclaration = this.transformDeclaration(simpleFunction, data2);
        boolean bl2 = false;
        this.unboundCyclesInTypeParametersSupertypes((FirTypeParametersOwner)((Object)it));
        FirDeclaration result$iv = firDeclaration;
        int size$iv = FirAbstractTreeTransformerWithSuperTypes.access$getScopes(this_$iv).size();
        int n2 = n = size$iv >= sizeBefore$iv ? 1 : 0;
        if (_Assertions.ENABLED && n == 0) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        n = size$iv - sizeBefore$iv;
        int n3 = 0;
        while (n3 < n) {
            int n4;
            int it$iv = n4 = n3++;
            boolean bl3 = false;
            FirAbstractTreeTransformerWithSuperTypes.access$getScopes(this_$iv).remove(CollectionsKt.getLastIndex(FirAbstractTreeTransformerWithSuperTypes.access$getScopes(this_$iv)));
        }
        return (FirSimpleFunction)result$iv;
    }

    private final void unboundCyclesInTypeParametersSupertypes(FirTypeParameterRefsOwner typeParametersOwner) {
        for (FirTypeParameterRef typeParameter : typeParametersOwner.getTypeParameters()) {
            FirErrorTypeRefBuilder firErrorTypeRefBuilder;
            if (!(typeParameter instanceof FirTypeParameter) || !this.hasSupertypePathToParameter((FirTypeParameter)typeParameter, (FirTypeParameter)typeParameter, new LinkedHashSet())) continue;
            boolean $i$f$buildErrorTypeRef = false;
            FirErrorTypeRefBuilder $this$unboundCyclesInTypeParametersSupertypes_u24lambda_u2d11 = firErrorTypeRefBuilder = new FirErrorTypeRefBuilder();
            boolean bl = false;
            $this$unboundCyclesInTypeParametersSupertypes_u24lambda_u2d11.setDiagnostic(new ConeCyclicTypeBound(typeParameter.getSymbol(), ExtensionsKt.toImmutableList((Iterable)((FirTypeParameter)typeParameter).getBounds())));
            FirErrorTypeRef errorType = firErrorTypeRefBuilder.build();
            ((FirTypeParameter)typeParameter).replaceBounds(CollectionsKt.listOf(errorType));
        }
    }

    private final boolean hasSupertypePathToParameter(FirTypeParameter currentTypeParameter, FirTypeParameter typeParameter, Set<FirTypeParameter> visited2) {
        boolean bl;
        block8: {
            if (!((Collection)visited2).isEmpty() && Intrinsics.areEqual(currentTypeParameter, typeParameter)) {
                return true;
            }
            if (!visited2.add(currentTypeParameter)) {
                return false;
            }
            Iterable $this$any$iv = currentTypeParameter.getBounds();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    boolean bl2;
                    ConeTypeParameterType coneTypeParameterType;
                    FirTypeRef it = (FirTypeRef)element$iv;
                    boolean bl3 = false;
                    FirTypeRef $this$coneTypeSafe$iv = it;
                    boolean $i$f$coneTypeSafe = false;
                    FirResolvedTypeRef firResolvedTypeRef = $this$coneTypeSafe$iv instanceof FirResolvedTypeRef ? (FirResolvedTypeRef)$this$coneTypeSafe$iv : null;
                    ConeKotlinType coneKotlinType = firResolvedTypeRef == null ? null : firResolvedTypeRef.getType();
                    if (!(coneKotlinType instanceof ConeTypeParameterType)) {
                        coneKotlinType = null;
                    }
                    if ((coneTypeParameterType = (ConeTypeParameterType)((ConeKotlinType)((ConeTypeParameterType)coneKotlinType))) == null) {
                        bl2 = false;
                    } else {
                        ConeTypeParameterLookupTag coneTypeParameterLookupTag = coneTypeParameterType.getLookupTag();
                        FirTypeParameterSymbol firTypeParameterSymbol = coneTypeParameterLookupTag.getTypeParameterSymbol();
                        FirTypeParameter nextTypeParameter = (FirTypeParameter)firTypeParameterSymbol.getFir();
                        bl2 = this.hasSupertypePathToParameter(nextTypeParameter, typeParameter, visited2);
                    }
                    if (!bl2) continue;
                    bl = true;
                    break block8;
                }
                bl = false;
            }
        }
        return bl;
    }

    @Override
    @NotNull
    public FirTypeRef transformImplicitTypeRef(@NotNull FirImplicitTypeRef implicitTypeRef, @Nullable Object data2) {
        Intrinsics.checkNotNullParameter(implicitTypeRef, "implicitTypeRef");
        return implicitTypeRef;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public FirResolvedTypeRef transformTypeRef(@NotNull FirTypeRef typeRef, @Nullable Object data2) {
        FirResolvedTypeRef firResolvedTypeRef;
        void this_$iv;
        Intrinsics.checkNotNullParameter(typeRef, "typeRef");
        FirSpecificTypeResolverTransformer firSpecificTypeResolverTransformer = this.typeResolverTransformer;
        FirFile file$iv = this.currentFile;
        boolean $i$f$withFile = false;
        FirFile oldValue$iv = this_$iv.currentFile;
        this_$iv.currentFile = file$iv;
        try {
            void $this$transformTypeRef_u24lambda_u2d13 = this_$iv;
            boolean bl = false;
            firResolvedTypeRef = (FirResolvedTypeRef)typeRef.transform(this.typeResolverTransformer, new ScopeClassDeclaration(this.getTowerScope(), this.getClassDeclarationsStack().lastOrNull()));
        }
        finally {
            this_$iv.currentFile = oldValue$iv;
        }
        return firResolvedTypeRef;
    }

    @Override
    @NotNull
    public FirStatement transformValueParameter(@NotNull FirValueParameter valueParameter2, @Nullable Object data2) {
        Intrinsics.checkNotNullParameter(valueParameter2, "valueParameter");
        valueParameter2.transformReturnTypeRef(this, data2);
        valueParameter2.transformAnnotations(this, data2);
        TransformUtilsKt.transformVarargTypeToArrayType(valueParameter2);
        return valueParameter2;
    }

    @Override
    @NotNull
    public FirStatement transformBlock(@NotNull FirBlock block, @Nullable Object data2) {
        Intrinsics.checkNotNullParameter(block, "block");
        return block;
    }

    @Override
    @NotNull
    public FirStatement transformDelegatedConstructorCall(@NotNull FirDelegatedConstructorCall delegatedConstructorCall, @Nullable Object data2) {
        Intrinsics.checkNotNullParameter(delegatedConstructorCall, "delegatedConstructorCall");
        delegatedConstructorCall.replaceConstructedTypeRef((FirTypeRef)delegatedConstructorCall.getConstructedTypeRef().transform(this, data2));
        delegatedConstructorCall.transformCalleeReference(this, data2);
        return delegatedConstructorCall;
    }

    @Override
    @NotNull
    public FirStatement transformAnnotationCall(@NotNull FirAnnotationCall annotationCall, @Nullable Object data2) {
        Intrinsics.checkNotNullParameter(annotationCall, "annotationCall");
        annotationCall.transformAnnotationTypeRef(this, data2);
        return annotationCall;
    }
}

