/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers;

import java.util.Iterator;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.com.intellij.lang.LighterASTNode;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirSourceElement;
import org.jetbrains.kotlin.fir.analysis.checkers.LightTreeSourceNavigator;
import org.jetbrains.kotlin.fir.analysis.checkers.SourceHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.SourceNavigator;
import org.jetbrains.kotlin.fir.analysis.diagnostics.LightTreePositioningStrategiesKt;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.symbols.impl.FirValueParameterSymbol;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.stubs.elements.KtNameReferenceExpressionElementType;
import org.jetbrains.kotlin.psi.stubs.elements.KtTypeProjectionElementType;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u0004\u0018\u00010\u0004*\u00020\u0005H\u0016J\u000e\u0010\u0006\u001a\u0004\u0018\u00010\u0004*\u00020\u0007H\u0016J\f\u0010\b\u001a\u00020\t*\u00020\nH\u0016J\f\u0010\u000b\u001a\u00020\t*\u00020\fH\u0016J\f\u0010\r\u001a\u00020\t*\u00020\fH\u0016J-\u0010\u000e\u001a\u0004\u0018\u0001H\u000f\"\u0004\b\u0000\u0010\u000f*\u00020\u00102\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u0002H\u000f0\u0012H\u0002\u00a2\u0006\u0002\u0010\u0013\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/LightTreeSourceNavigator;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/SourceNavigator;", "()V", "getRawIdentifier", "", "Lorg/jetbrains/kotlin/fir/FirSourceElement;", "getRawName", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "isCatchElementParameter", "", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirValueParameterSymbol;", "isInConstructorCallee", "Lorg/jetbrains/kotlin/fir/types/FirTypeRef;", "isInTypeConstraint", "withSource", "T", "Lorg/jetbrains/kotlin/fir/FirElement;", "f", "Lkotlin/Function1;", "(Lorg/jetbrains/kotlin/fir/FirElement;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "checkers"})
public class LightTreeSourceNavigator
implements SourceNavigator {
    private final <T> T withSource(FirElement $this$withSource, Function1<? super FirSourceElement, ? extends T> f) {
        T t;
        FirSourceElement firSourceElement = $this$withSource.getSource();
        if (firSourceElement == null) {
            t = null;
        } else {
            FirSourceElement firSourceElement2;
            FirSourceElement it = firSourceElement2 = firSourceElement;
            boolean bl = false;
            t = f.invoke(it);
        }
        return t;
    }

    @Override
    public boolean isInConstructorCallee(@NotNull FirTypeRef $this$isInConstructorCallee) {
        Intrinsics.checkNotNullParameter($this$isInConstructorCallee, "<this>");
        Boolean bl = (Boolean)this.withSource($this$isInConstructorCallee, isInConstructorCallee.1.INSTANCE);
        return bl == null ? false : bl;
    }

    @Override
    public boolean isInTypeConstraint(@NotNull FirTypeRef $this$isInTypeConstraint) {
        LighterASTNode lighterASTNode2;
        Object object;
        block2: {
            Sequence<LighterASTNode> sequence2;
            Intrinsics.checkNotNullParameter($this$isInTypeConstraint, "<this>");
            object = $this$isInTypeConstraint.getSource();
            if (object == null) {
                return false;
            }
            FirSourceElement source = object;
            Sequence<LighterASTNode> sequence3 = sequence2 = LightTreePositioningStrategiesKt.getAncestors(source.getTreeStructure(), source.getLighterASTNode());
            Iterator<LighterASTNode> iterator2 = sequence3.iterator();
            while (iterator2.hasNext()) {
                LighterASTNode lighterASTNode3;
                LighterASTNode it = lighterASTNode3 = iterator2.next();
                boolean bl = false;
                if (!(Intrinsics.areEqual(it.getTokenType(), KtNodeTypes.TYPE_CONSTRAINT) || Intrinsics.areEqual(it.getTokenType(), KtNodeTypes.TYPE_PARAMETER))) continue;
                lighterASTNode2 = lighterASTNode3;
                break block2;
            }
            lighterASTNode2 = null;
        }
        object = lighterASTNode2;
        return Intrinsics.areEqual(object == null ? null : object.getTokenType(), KtNodeTypes.TYPE_CONSTRAINT);
    }

    @Override
    @Nullable
    public String getRawIdentifier(@NotNull FirSourceElement $this$getRawIdentifier) {
        Intrinsics.checkNotNullParameter($this$getRawIdentifier, "<this>");
        IElementType tokenType = $this$getRawIdentifier.getElementType();
        return tokenType instanceof KtNameReferenceExpressionElementType || Intrinsics.areEqual(tokenType, KtTokens.IDENTIFIER) ? $this$getRawIdentifier.getLighterASTNode().toString() : (tokenType instanceof KtTypeProjectionElementType ? String.valueOf(CollectionsKt.last(SourceHelpersKt.getChildren($this$getRawIdentifier.getLighterASTNode(), $this$getRawIdentifier.getTreeStructure()))) : (String)null);
    }

    @Override
    @Nullable
    public String getRawName(@NotNull FirDeclaration $this$getRawName) {
        String string2;
        Intrinsics.checkNotNullParameter($this$getRawName, "<this>");
        FirSourceElement firSourceElement = $this$getRawName.getSource();
        if (firSourceElement == null) {
            string2 = null;
        } else {
            FirSourceElement firSourceElement2;
            FirSourceElement it = firSourceElement2 = firSourceElement;
            boolean bl = false;
            LighterASTNode lighterASTNode2 = LightTreePositioningStrategiesKt.nameIdentifier(it.getTreeStructure(), it.getLighterASTNode());
            string2 = lighterASTNode2 == null ? null : lighterASTNode2.toString();
        }
        return string2;
    }

    @Override
    public boolean isCatchElementParameter(@NotNull FirValueParameterSymbol $this$isCatchElementParameter) {
        Intrinsics.checkNotNullParameter($this$isCatchElementParameter, "<this>");
        FirSourceElement firSourceElement = $this$isCatchElementParameter.getSource();
        if (firSourceElement == null) {
            return false;
        }
        FirSourceElement localSource = firSourceElement;
        LighterASTNode parent2 = null;
        parent2 = localSource.getTreeStructure().getParent(localSource.getLighterASTNode());
        LighterASTNode lighterASTNode2 = parent2;
        if (lighterASTNode2 != null) {
            LighterASTNode lighterASTNode3;
            LighterASTNode it = lighterASTNode3 = lighterASTNode2;
            boolean bl = false;
            parent2 = localSource.getTreeStructure().getParent(it);
        }
        lighterASTNode2 = parent2;
        return Intrinsics.areEqual(lighterASTNode2 == null ? null : lighterASTNode2.getTokenType(), KtNodeTypes.CATCH);
    }
}

