/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.compiler.plugin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.compiler.plugin.AbstractCliOption;
import org.jetbrains.kotlin.compiler.plugin.CliOptionValue;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000\u001e\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u001c\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u001a\u001e\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\u00012\u0006\u0010\b\u001a\u00020\u0001\u001a\u0010\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\u0001\u00a8\u0006\f"}, d2={"cliPluginUsageString", "", "pluginId", "options", "", "Lorg/jetbrains/kotlin/compiler/plugin/AbstractCliOption;", "getPluginOptionString", "key", "value", "parsePluginOption", "Lorg/jetbrains/kotlin/compiler/plugin/CliOptionValue;", "argumentValue", "plugin-api"})
public final class CliOptionsKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String cliPluginUsageString(@NotNull String pluginId, @NotNull Collection<? extends AbstractCliOption> options) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(pluginId, "pluginId");
        Intrinsics.checkNotNullParameter(options, "options");
        int LEFT_INDENT = 2;
        int MAX_OPTION_WIDTH = 26;
        Iterable $this$map$iv = options;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            AbstractCliOption abstractCliOption = (AbstractCliOption)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String name2 = it.getOptionName() + ' ' + it.getValueDescription();
            String margin = name2.length() > MAX_OPTION_WIDTH ? Intrinsics.stringPlus("\n", StringsKt.repeat(" ", MAX_OPTION_WIDTH + LEFT_INDENT + 1)) : StringsKt.repeat(" ", 1 + MAX_OPTION_WIDTH - name2.length());
            String[] stringArray = new String[]{it.getRequired() ? "required" : null, it.getAllowMultipleOccurrences() ? "multiple" : null};
            List<String> modifiers2 = CollectionsKt.listOfNotNull(stringArray);
            String modifiersEnclosed = modifiers2.isEmpty() ? "" : " (" + CollectionsKt.joinToString$default(modifiers2, null, null, null, 0, null, null, 63, null) + ')';
            String string2 = StringsKt.repeat(" ", LEFT_INDENT) + name2 + margin + it.getDescription() + modifiersEnclosed;
            collection.add(string2);
        }
        List renderedOptions = (List)destination$iv$iv;
        return "Plugin \"" + pluginId + "\" usage:\n" + CollectionsKt.joinToString$default(renderedOptions, "\n", null, "\n", 0, null, null, 58, null);
    }

    @Nullable
    public static final CliOptionValue parsePluginOption(@NotNull String argumentValue) {
        Intrinsics.checkNotNullParameter(argumentValue, "argumentValue");
        Pattern pattern = Pattern.compile("^plugin:([^:]*):([^=]*)=(.*)$");
        Matcher matcher2 = pattern.matcher(argumentValue);
        if (matcher2.matches()) {
            String string2 = matcher2.group(1);
            Intrinsics.checkNotNullExpressionValue(string2, "matcher.group(1)");
            String string3 = string2;
            string2 = matcher2.group(2);
            Intrinsics.checkNotNullExpressionValue(string2, "matcher.group(2)");
            String string4 = string2;
            string2 = matcher2.group(3);
            Intrinsics.checkNotNullExpressionValue(string2, "matcher.group(3)");
            return new CliOptionValue(string3, string4, string2);
        }
        return null;
    }

    @NotNull
    public static final String getPluginOptionString(@NotNull String pluginId, @NotNull String key, @NotNull String value2) {
        Intrinsics.checkNotNullParameter(pluginId, "pluginId");
        Intrinsics.checkNotNullParameter(key, "key");
        Intrinsics.checkNotNullParameter(value2, "value");
        return "plugin:" + pluginId + ':' + key + '=' + value2;
    }
}

