/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.serialization;

import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.overrides.DefaultFakeOverrideClassFilter;
import org.jetbrains.kotlin.backend.common.overrides.FakeOverrideBuilder;
import org.jetbrains.kotlin.backend.common.overrides.FileLocalAwareLinker;
import org.jetbrains.kotlin.backend.common.serialization.CompatibilityMode;
import org.jetbrains.kotlin.backend.common.serialization.DescriptorByIdSignatureFinder;
import org.jetbrains.kotlin.backend.common.serialization.IrDeclarationDeserializer;
import org.jetbrains.kotlin.backend.common.serialization.IrSymbolDeserializer;
import org.jetbrains.kotlin.backend.common.serialization.encodings.BinarySymbolData;
import org.jetbrains.kotlin.backend.common.serialization.proto.IrDeclaration;
import org.jetbrains.kotlin.backend.jvm.serialization.DeserializeLazyDeclarationsKt;
import org.jetbrains.kotlin.backend.jvm.serialization.IrLibraryFileFromAnnotation;
import org.jetbrains.kotlin.backend.jvm.serialization.PrePopulatedDeclarationTable;
import org.jetbrains.kotlin.backend.jvm.serialization.proto.JvmIr;
import org.jetbrains.kotlin.descriptors.ClassConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.TypeAliasDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.ir.IrBuiltIns;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.IrFileEntry;
import org.jetbrains.kotlin.ir.backend.jvm.serialization.JvmDescriptorMangler;
import org.jetbrains.kotlin.ir.backend.jvm.serialization.JvmIrMangler;
import org.jetbrains.kotlin.ir.declarations.IrAnonymousInitializer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationBase;
import org.jetbrains.kotlin.ir.declarations.IrEnumEntry;
import org.jetbrains.kotlin.ir.declarations.IrErrorDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrExternalPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrLocalDelegatedProperty;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import org.jetbrains.kotlin.ir.declarations.IrPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrScript;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrTypeAlias;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.declarations.impl.IrFileImpl;
import org.jetbrains.kotlin.ir.declarations.lazy.LazyIrFactory;
import org.jetbrains.kotlin.ir.expressions.IrBlock;
import org.jetbrains.kotlin.ir.expressions.IrBlockBody;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrBranch;
import org.jetbrains.kotlin.ir.expressions.IrBreak;
import org.jetbrains.kotlin.ir.expressions.IrBreakContinue;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrCallableReference;
import org.jetbrains.kotlin.ir.expressions.IrCatch;
import org.jetbrains.kotlin.ir.expressions.IrClassReference;
import org.jetbrains.kotlin.ir.expressions.IrComposite;
import org.jetbrains.kotlin.ir.expressions.IrConst;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrContainerExpression;
import org.jetbrains.kotlin.ir.expressions.IrContinue;
import org.jetbrains.kotlin.ir.expressions.IrDeclarationReference;
import org.jetbrains.kotlin.ir.expressions.IrDelegatingConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrDoWhileLoop;
import org.jetbrains.kotlin.ir.expressions.IrDynamicExpression;
import org.jetbrains.kotlin.ir.expressions.IrDynamicMemberExpression;
import org.jetbrains.kotlin.ir.expressions.IrDynamicOperatorExpression;
import org.jetbrains.kotlin.ir.expressions.IrElseBranch;
import org.jetbrains.kotlin.ir.expressions.IrEnumConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrErrorCallExpression;
import org.jetbrains.kotlin.ir.expressions.IrErrorExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpressionBody;
import org.jetbrains.kotlin.ir.expressions.IrFieldAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrGetClass;
import org.jetbrains.kotlin.ir.expressions.IrGetEnumValue;
import org.jetbrains.kotlin.ir.expressions.IrGetField;
import org.jetbrains.kotlin.ir.expressions.IrGetObjectValue;
import org.jetbrains.kotlin.ir.expressions.IrGetSingletonValue;
import org.jetbrains.kotlin.ir.expressions.IrGetValue;
import org.jetbrains.kotlin.ir.expressions.IrInstanceInitializerCall;
import org.jetbrains.kotlin.ir.expressions.IrLocalDelegatedPropertyReference;
import org.jetbrains.kotlin.ir.expressions.IrLoop;
import org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrPropertyReference;
import org.jetbrains.kotlin.ir.expressions.IrRawFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrReturn;
import org.jetbrains.kotlin.ir.expressions.IrSetField;
import org.jetbrains.kotlin.ir.expressions.IrSetValue;
import org.jetbrains.kotlin.ir.expressions.IrSpreadElement;
import org.jetbrains.kotlin.ir.expressions.IrStringConcatenation;
import org.jetbrains.kotlin.ir.expressions.IrSuspendableExpression;
import org.jetbrains.kotlin.ir.expressions.IrSuspensionPoint;
import org.jetbrains.kotlin.ir.expressions.IrSyntheticBody;
import org.jetbrains.kotlin.ir.expressions.IrThrow;
import org.jetbrains.kotlin.ir.expressions.IrTry;
import org.jetbrains.kotlin.ir.expressions.IrTypeOperatorCall;
import org.jetbrains.kotlin.ir.expressions.IrValueAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrVararg;
import org.jetbrains.kotlin.ir.expressions.IrWhen;
import org.jetbrains.kotlin.ir.expressions.IrWhileLoop;
import org.jetbrains.kotlin.ir.symbols.IrBindableSymbol;
import org.jetbrains.kotlin.ir.symbols.IrFileSymbol;
import org.jetbrains.kotlin.ir.symbols.IrPropertySymbol;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.symbols.impl.IrFileSymbolImpl;
import org.jetbrains.kotlin.ir.types.IrTypeSystemContext;
import org.jetbrains.kotlin.ir.util.AdditionalIrUtilsKt;
import org.jetbrains.kotlin.ir.util.DeclarationStubGenerator;
import org.jetbrains.kotlin.ir.util.ExternalDependenciesGenerator;
import org.jetbrains.kotlin.ir.util.IdSignature;
import org.jetbrains.kotlin.ir.util.NaiveSourceBasedFileEntryImpl;
import org.jetbrains.kotlin.ir.util.SymbolTable;
import org.jetbrains.kotlin.ir.visitors.IrElementVisitorVoid;
import org.jetbrains.kotlin.ir.visitors.IrElementVisitorVoidKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.protobuf.ByteString;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000V\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a(\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002\u001a.\u0010\n\u001a\u00020\u00012\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u0011\u001a.\u0010\u0012\u001a\u00020\u00012\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u0011\u001a\u001e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u001a(\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002\u00a8\u0006\u001e"}, d2={"buildFakeOverridesForLocalClasses", "", "symbolTable", "Lorg/jetbrains/kotlin/ir/util/SymbolTable;", "typeSystemContext", "Lorg/jetbrains/kotlin/ir/types/IrTypeSystemContext;", "symbolDeserializer", "Lorg/jetbrains/kotlin/backend/common/serialization/IrSymbolDeserializer;", "toplevel", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "deserializeClassFromByteArray", "byteArray", "", "stubGenerator", "Lorg/jetbrains/kotlin/ir/util/DeclarationStubGenerator;", "irClass", "allowErrorNodes", "", "deserializeIrFileFromByteArray", "facadeClass", "makeSimpleFakeOverrideBuilder", "Lorg/jetbrains/kotlin/backend/common/overrides/FakeOverrideBuilder;", "referencePublicSymbol", "Lorg/jetbrains/kotlin/ir/symbols/IrSymbol;", "descriptorFinder", "Lorg/jetbrains/kotlin/backend/common/serialization/DescriptorByIdSignatureFinder;", "idSig", "Lorg/jetbrains/kotlin/ir/util/IdSignature;", "symbolKind", "Lorg/jetbrains/kotlin/backend/common/serialization/encodings/BinarySymbolData$SymbolKind;", "ir.serialization.jvm"})
public final class DeserializeLazyDeclarationsKt {
    public static final void deserializeClassFromByteArray(@NotNull byte[] byteArray, @NotNull DeclarationStubGenerator stubGenerator, @NotNull IrClass irClass2, @NotNull IrTypeSystemContext typeSystemContext2, boolean allowErrorNodes) {
        Intrinsics.checkNotNullParameter(byteArray, "byteArray");
        Intrinsics.checkNotNullParameter(stubGenerator, "stubGenerator");
        Intrinsics.checkNotNullParameter(irClass2, "irClass");
        Intrinsics.checkNotNullParameter(typeSystemContext2, "typeSystemContext");
        IrBuiltIns irBuiltIns = stubGenerator.getIrBuiltIns();
        SymbolTable symbolTable = stubGenerator.getSymbolTable();
        JvmIr.JvmIrClass irProto = JvmIr.JvmIrClass.parseFrom(byteArray);
        List<ByteString> list2 = irProto.getAuxTables().getTypeList();
        Intrinsics.checkNotNullExpressionValue(list2, "irProto.auxTables.typeList");
        List<ByteString> list3 = list2;
        list2 = irProto.getAuxTables().getSignatureList();
        Intrinsics.checkNotNullExpressionValue(list2, "irProto.auxTables.signatureList");
        List<ByteString> list4 = list2;
        list2 = irProto.getAuxTables().getStringList();
        Intrinsics.checkNotNullExpressionValue(list2, "irProto.auxTables.stringList");
        List<ByteString> list5 = list2;
        list2 = irProto.getAuxTables().getBodyList();
        Intrinsics.checkNotNullExpressionValue(list2, "irProto.auxTables.bodyList");
        List<ByteString> list6 = list2;
        list2 = irProto.getAuxTables().getDebugInfoList();
        Intrinsics.checkNotNullExpressionValue(list2, "irProto.auxTables.debugInfoList");
        IrLibraryFileFromAnnotation irLibraryFile = new IrLibraryFileFromAnnotation(list3, list4, list5, list6, list2);
        DescriptorByIdSignatureFinder descriptorFinder = new DescriptorByIdSignatureFinder(stubGenerator.getModuleDescriptor(), new JvmDescriptorMangler(null), DescriptorByIdSignatureFinder.LookupMode.MODULE_WITH_DEPENDENCIES);
        IrFileEntry irFileEntry = new NaiveSourceBasedFileEntryImpl("<unknown>", null, 2, null);
        IrFileSymbol irFileSymbol = new IrFileSymbolImpl(null, 1, null);
        FqName fqName2 = AdditionalIrUtilsKt.getPackageFqName(irClass2);
        Intrinsics.checkNotNull(fqName2);
        IrFileImpl dummyIrFile = new IrFileImpl(irFileEntry, irFileSymbol, fqName2);
        IrSymbolDeserializer symbolDeserializer2 = new IrSymbolDeserializer(symbolTable, irLibraryFile, dummyIrFile.getSymbol(), CollectionsKt.emptyList(), deserializeClassFromByteArray.symbolDeserializer.1.INSTANCE, deserializeClassFromByteArray.symbolDeserializer.2.INSTANCE, false, null, new Function2<IdSignature, BinarySymbolData.SymbolKind, IrSymbol>(symbolTable, descriptorFinder){
            final /* synthetic */ SymbolTable $symbolTable;
            final /* synthetic */ DescriptorByIdSignatureFinder $descriptorFinder;
            {
                this.$symbolTable = $symbolTable;
                this.$descriptorFinder = $descriptorFinder;
                super(2);
            }

            @NotNull
            public final IrSymbol invoke(@NotNull IdSignature idSignature, @NotNull BinarySymbolData.SymbolKind symbolKind) {
                Intrinsics.checkNotNullParameter(idSignature, "idSignature");
                Intrinsics.checkNotNullParameter((Object)((Object)symbolKind), "symbolKind");
                return DeserializeLazyDeclarationsKt.access$referencePublicSymbol(this.$symbolTable, this.$descriptorFinder, idSignature, symbolKind);
            }
        }, 192, null);
        LazyIrFactory lazyIrFactory = new LazyIrFactory(irBuiltIns.getIrFactory());
        IrDeclarationDeserializer deserializer = new IrDeclarationDeserializer(irBuiltIns, symbolTable, lazyIrFactory, irLibraryFile, irClass2.getParent(), allowErrorNodes, true, true, symbolDeserializer2, DefaultFakeOverrideClassFilter.INSTANCE, DeserializeLazyDeclarationsKt.makeSimpleFakeOverrideBuilder(symbolTable, typeSystemContext2, symbolDeserializer2), false, null, false, CompatibilityMode.Companion.getCURRENT(), false, false, 112640, null);
        org.jetbrains.kotlin.backend.common.serialization.proto.IrClass irClass3 = irProto.getIrClass();
        Intrinsics.checkNotNullExpressionValue(irClass3, "irProto.irClass");
        deserializer.deserializeIrClass(irClass3);
        new ExternalDependenciesGenerator(stubGenerator.getSymbolTable(), CollectionsKt.listOf(stubGenerator)).generateUnboundSymbolsAsDependencies();
        DeserializeLazyDeclarationsKt.buildFakeOverridesForLocalClasses(stubGenerator.getSymbolTable(), typeSystemContext2, symbolDeserializer2, irClass2);
    }

    public static final void deserializeIrFileFromByteArray(@NotNull byte[] byteArray, @NotNull DeclarationStubGenerator stubGenerator, @NotNull IrClass facadeClass, @NotNull IrTypeSystemContext typeSystemContext2, boolean allowErrorNodes) {
        Intrinsics.checkNotNullParameter(byteArray, "byteArray");
        Intrinsics.checkNotNullParameter(stubGenerator, "stubGenerator");
        Intrinsics.checkNotNullParameter(facadeClass, "facadeClass");
        Intrinsics.checkNotNullParameter(typeSystemContext2, "typeSystemContext");
        IrBuiltIns irBuiltIns = stubGenerator.getIrBuiltIns();
        SymbolTable symbolTable = stubGenerator.getSymbolTable();
        JvmIr.JvmIrFile irProto = JvmIr.JvmIrFile.parseFrom(byteArray);
        List<ByteString> list2 = irProto.getAuxTables().getTypeList();
        Intrinsics.checkNotNullExpressionValue(list2, "irProto.auxTables.typeList");
        List<ByteString> list3 = list2;
        list2 = irProto.getAuxTables().getSignatureList();
        Intrinsics.checkNotNullExpressionValue(list2, "irProto.auxTables.signatureList");
        List<ByteString> list4 = list2;
        list2 = irProto.getAuxTables().getStringList();
        Intrinsics.checkNotNullExpressionValue(list2, "irProto.auxTables.stringList");
        List<ByteString> list5 = list2;
        list2 = irProto.getAuxTables().getBodyList();
        Intrinsics.checkNotNullExpressionValue(list2, "irProto.auxTables.bodyList");
        List<ByteString> list6 = list2;
        list2 = irProto.getAuxTables().getDebugInfoList();
        Intrinsics.checkNotNullExpressionValue(list2, "irProto.auxTables.debugInfoList");
        IrLibraryFileFromAnnotation irLibraryFile = new IrLibraryFileFromAnnotation(list3, list4, list5, list6, list2);
        DescriptorByIdSignatureFinder descriptorFinder = new DescriptorByIdSignatureFinder(stubGenerator.getModuleDescriptor(), new JvmDescriptorMangler(null), DescriptorByIdSignatureFinder.LookupMode.MODULE_WITH_DEPENDENCIES);
        IrFileEntry irFileEntry = new NaiveSourceBasedFileEntryImpl("<unknown>", null, 2, null);
        IrFileSymbol irFileSymbol = new IrFileSymbolImpl(null, 1, null);
        FqName fqName2 = AdditionalIrUtilsKt.getPackageFqName(facadeClass);
        Intrinsics.checkNotNull(fqName2);
        IrFileImpl dummyIrFile = new IrFileImpl(irFileEntry, irFileSymbol, fqName2);
        IrSymbolDeserializer symbolDeserializer2 = new IrSymbolDeserializer(symbolTable, irLibraryFile, dummyIrFile.getSymbol(), CollectionsKt.emptyList(), deserializeIrFileFromByteArray.symbolDeserializer.1.INSTANCE, deserializeIrFileFromByteArray.symbolDeserializer.2.INSTANCE, false, null, new Function2<IdSignature, BinarySymbolData.SymbolKind, IrSymbol>(symbolTable, descriptorFinder){
            final /* synthetic */ SymbolTable $symbolTable;
            final /* synthetic */ DescriptorByIdSignatureFinder $descriptorFinder;
            {
                this.$symbolTable = $symbolTable;
                this.$descriptorFinder = $descriptorFinder;
                super(2);
            }

            @NotNull
            public final IrSymbol invoke(@NotNull IdSignature idSignature, @NotNull BinarySymbolData.SymbolKind symbolKind) {
                Intrinsics.checkNotNullParameter(idSignature, "idSignature");
                Intrinsics.checkNotNullParameter((Object)((Object)symbolKind), "symbolKind");
                return DeserializeLazyDeclarationsKt.access$referencePublicSymbol(this.$symbolTable, this.$descriptorFinder, idSignature, symbolKind);
            }
        }, 192, null);
        LazyIrFactory lazyIrFactory = new LazyIrFactory(irBuiltIns.getIrFactory());
        FakeOverrideBuilder fakeOverrideBuilder = DeserializeLazyDeclarationsKt.makeSimpleFakeOverrideBuilder(symbolTable, typeSystemContext2, symbolDeserializer2);
        IrDeclarationDeserializer deserializer = new IrDeclarationDeserializer(irBuiltIns, symbolTable, lazyIrFactory, irLibraryFile, facadeClass, allowErrorNodes, true, true, symbolDeserializer2, DefaultFakeOverrideClassFilter.INSTANCE, fakeOverrideBuilder, false, null, false, CompatibilityMode.Companion.getCURRENT(), false, false, 112640, null);
        for (IrDeclaration declarationProto : irProto.getDeclarationList()) {
            Intrinsics.checkNotNullExpressionValue(declarationProto, "declarationProto");
            deserializer.deserializeDeclaration(declarationProto);
        }
        new ExternalDependenciesGenerator(stubGenerator.getSymbolTable(), CollectionsKt.listOf(stubGenerator)).generateUnboundSymbolsAsDependencies();
        DeserializeLazyDeclarationsKt.buildFakeOverridesForLocalClasses(stubGenerator.getSymbolTable(), typeSystemContext2, symbolDeserializer2, facadeClass);
    }

    private static final IrSymbol referencePublicSymbol(SymbolTable symbolTable, DescriptorByIdSignatureFinder descriptorFinder, IdSignature idSig, BinarySymbolData.SymbolKind symbolKind) {
        IrSymbol irSymbol2;
        SymbolTable $this$referencePublicSymbol_u24lambda_u2d0 = symbolTable;
        boolean bl = false;
        DeclarationDescriptor descriptor2 = descriptorFinder.findDescriptorBySignature(idSig);
        if (descriptor2 != null) {
            IrBindableSymbol irBindableSymbol;
            BinarySymbolData.SymbolKind symbolKind2 = symbolKind;
            int n = WhenMappings.$EnumSwitchMapping$0[symbolKind2.ordinal()];
            switch (n) {
                case 1: {
                    irBindableSymbol = $this$referencePublicSymbol_u24lambda_u2d0.referenceClass((ClassDescriptor)descriptor2);
                    break;
                }
                case 2: {
                    irBindableSymbol = $this$referencePublicSymbol_u24lambda_u2d0.referenceConstructor((ClassConstructorDescriptor)descriptor2);
                    break;
                }
                case 3: {
                    irBindableSymbol = $this$referencePublicSymbol_u24lambda_u2d0.referenceEnumEntry((ClassDescriptor)descriptor2);
                    break;
                }
                case 4: 
                case 5: {
                    irBindableSymbol = $this$referencePublicSymbol_u24lambda_u2d0.referenceField((PropertyDescriptor)descriptor2);
                    break;
                }
                case 6: {
                    irBindableSymbol = $this$referencePublicSymbol_u24lambda_u2d0.referenceSimpleFunction((FunctionDescriptor)descriptor2);
                    break;
                }
                case 7: {
                    irBindableSymbol = $this$referencePublicSymbol_u24lambda_u2d0.referenceTypeAlias((TypeAliasDescriptor)descriptor2);
                    break;
                }
                case 8: {
                    irBindableSymbol = $this$referencePublicSymbol_u24lambda_u2d0.referenceProperty((PropertyDescriptor)descriptor2);
                    break;
                }
                case 9: {
                    irBindableSymbol = $this$referencePublicSymbol_u24lambda_u2d0.referenceTypeParameter((TypeParameterDescriptor)descriptor2);
                    break;
                }
                default: {
                    throw new IllegalStateException(("Unexpected classifier symbol kind: " + (Object)((Object)symbolKind) + " for signature " + idSig).toString());
                }
            }
            irSymbol2 = irBindableSymbol;
        } else {
            IrBindableSymbol irBindableSymbol;
            BinarySymbolData.SymbolKind symbolKind3 = symbolKind;
            int n = WhenMappings.$EnumSwitchMapping$0[symbolKind3.ordinal()];
            switch (n) {
                case 1: {
                    irBindableSymbol = $this$referencePublicSymbol_u24lambda_u2d0.referenceClassFromLinker(idSig);
                    break;
                }
                case 2: {
                    irBindableSymbol = $this$referencePublicSymbol_u24lambda_u2d0.referenceConstructorFromLinker(idSig);
                    break;
                }
                case 3: {
                    irBindableSymbol = $this$referencePublicSymbol_u24lambda_u2d0.referenceEnumEntryFromLinker(idSig);
                    break;
                }
                case 4: 
                case 5: {
                    irBindableSymbol = $this$referencePublicSymbol_u24lambda_u2d0.referenceFieldFromLinker(idSig);
                    break;
                }
                case 6: {
                    irBindableSymbol = $this$referencePublicSymbol_u24lambda_u2d0.referenceSimpleFunctionFromLinker(idSig);
                    break;
                }
                case 7: {
                    irBindableSymbol = $this$referencePublicSymbol_u24lambda_u2d0.referenceTypeAliasFromLinker(idSig);
                    break;
                }
                case 8: {
                    irBindableSymbol = $this$referencePublicSymbol_u24lambda_u2d0.referencePropertyFromLinker(idSig);
                    break;
                }
                default: {
                    throw new IllegalStateException(("Unexpected classifier symbol kind: " + (Object)((Object)symbolKind) + " for signature " + idSig).toString());
                }
            }
            irSymbol2 = irBindableSymbol;
        }
        return irSymbol2;
    }

    @NotNull
    public static final FakeOverrideBuilder makeSimpleFakeOverrideBuilder(@NotNull SymbolTable symbolTable, @NotNull IrTypeSystemContext typeSystemContext2, @NotNull IrSymbolDeserializer symbolDeserializer2) {
        Intrinsics.checkNotNullParameter(symbolTable, "symbolTable");
        Intrinsics.checkNotNullParameter(typeSystemContext2, "typeSystemContext");
        Intrinsics.checkNotNullParameter(symbolDeserializer2, "symbolDeserializer");
        FileLocalAwareLinker fileLocalAwareLinker = new FileLocalAwareLinker(symbolDeserializer2){
            final /* synthetic */ IrSymbolDeserializer $symbolDeserializer;
            {
                this.$symbolDeserializer = $symbolDeserializer;
            }

            @NotNull
            public IrPropertySymbol tryReferencingPropertyByLocalSignature(@NotNull org.jetbrains.kotlin.ir.declarations.IrDeclaration parent2, @NotNull IdSignature idSignature) {
                Intrinsics.checkNotNullParameter(parent2, "parent");
                Intrinsics.checkNotNullParameter(idSignature, "idSignature");
                return this.$symbolDeserializer.referencePropertyByLocalSignature(idSignature);
            }

            @NotNull
            public IrSimpleFunctionSymbol tryReferencingSimpleFunctionByLocalSignature(@NotNull org.jetbrains.kotlin.ir.declarations.IrDeclaration parent2, @NotNull IdSignature idSignature) {
                Intrinsics.checkNotNullParameter(parent2, "parent");
                Intrinsics.checkNotNullParameter(idSignature, "idSignature");
                return this.$symbolDeserializer.referenceSimpleFunctionByLocalSignature(idSignature);
            }
        };
        JvmIrMangler jvmIrMangler = JvmIrMangler.INSTANCE;
        PrePopulatedDeclarationTable prePopulatedDeclarationTable = new PrePopulatedDeclarationTable(symbolDeserializer2.getDeserializedSymbols());
        Map map2 = MapsKt.emptyMap();
        return new FakeOverrideBuilder(fileLocalAwareLinker, symbolTable, jvmIrMangler, typeSystemContext2, map2, null, prePopulatedDeclarationTable, 32, null);
    }

    private static final void buildFakeOverridesForLocalClasses(SymbolTable symbolTable, IrTypeSystemContext typeSystemContext2, IrSymbolDeserializer symbolDeserializer2, IrClass toplevel) {
        FakeOverrideBuilder builder2 = DeserializeLazyDeclarationsKt.makeSimpleFakeOverrideBuilder(symbolTable, typeSystemContext2, symbolDeserializer2);
        IrElementVisitorVoidKt.acceptChildrenVoid(toplevel, new IrElementVisitorVoid(builder2){
            final /* synthetic */ FakeOverrideBuilder $builder;
            {
                this.$builder = $builder;
            }

            public void visitElement(@NotNull IrElement element) {
                Intrinsics.checkNotNullParameter(element, "element");
                IrElementVisitorVoidKt.acceptChildrenVoid(element, this);
            }

            public void visitClass(@NotNull IrClass declaration2) {
                Intrinsics.checkNotNullParameter(declaration2, "declaration");
                if (Intrinsics.areEqual(declaration2.getVisibility(), DescriptorVisibilities.LOCAL)) {
                    this.$builder.provideFakeOverrides(declaration2, CompatibilityMode.Companion.getCURRENT());
                }
                IrElementVisitorVoid.DefaultImpls.visitClass(this, declaration2);
            }

            public <T> void visitConst(@NotNull IrConst<T> expression2) {
                IrElementVisitorVoid.DefaultImpls.visitConst(this, expression2);
            }

            public <T> void visitConst(@NotNull IrConst<T> expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitConst(this, expression2, data2);
            }

            public void visitAnonymousInitializer(@NotNull IrAnonymousInitializer declaration2) {
                IrElementVisitorVoid.DefaultImpls.visitAnonymousInitializer(this, declaration2);
            }

            public void visitAnonymousInitializer(@NotNull IrAnonymousInitializer declaration2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitAnonymousInitializer(this, declaration2, data2);
            }

            public void visitBlock(@NotNull IrBlock expression2) {
                IrElementVisitorVoid.DefaultImpls.visitBlock(this, expression2);
            }

            public void visitBlock(@NotNull IrBlock expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitBlock(this, expression2, data2);
            }

            public void visitBlockBody(@NotNull IrBlockBody body2) {
                IrElementVisitorVoid.DefaultImpls.visitBlockBody(this, body2);
            }

            public void visitBlockBody(@NotNull IrBlockBody body2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitBlockBody(this, body2, data2);
            }

            public void visitBody(@NotNull IrBody body2) {
                IrElementVisitorVoid.DefaultImpls.visitBody(this, body2);
            }

            public void visitBody(@NotNull IrBody body2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitBody(this, body2, data2);
            }

            public void visitBranch(@NotNull IrBranch branch) {
                IrElementVisitorVoid.DefaultImpls.visitBranch(this, branch);
            }

            public void visitBranch(@NotNull IrBranch branch, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitBranch(this, branch, data2);
            }

            public void visitBreak(@NotNull IrBreak jump) {
                IrElementVisitorVoid.DefaultImpls.visitBreak(this, jump);
            }

            public void visitBreak(@NotNull IrBreak jump, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitBreak(this, jump, data2);
            }

            public void visitBreakContinue(@NotNull IrBreakContinue jump) {
                IrElementVisitorVoid.DefaultImpls.visitBreakContinue(this, jump);
            }

            public void visitBreakContinue(@NotNull IrBreakContinue jump, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitBreakContinue(this, jump, data2);
            }

            public void visitCall(@NotNull IrCall expression2) {
                IrElementVisitorVoid.DefaultImpls.visitCall(this, expression2);
            }

            public void visitCall(@NotNull IrCall expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitCall(this, expression2, data2);
            }

            public void visitCallableReference(@NotNull IrCallableReference<?> expression2) {
                IrElementVisitorVoid.DefaultImpls.visitCallableReference(this, expression2);
            }

            public void visitCallableReference(@NotNull IrCallableReference<?> expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitCallableReference(this, expression2, data2);
            }

            public void visitCatch(@NotNull IrCatch aCatch) {
                IrElementVisitorVoid.DefaultImpls.visitCatch(this, aCatch);
            }

            public void visitCatch(@NotNull IrCatch aCatch, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitCatch(this, aCatch, data2);
            }

            public void visitClass(@NotNull IrClass declaration2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitClass(this, declaration2, data2);
            }

            public void visitClassReference(@NotNull IrClassReference expression2) {
                IrElementVisitorVoid.DefaultImpls.visitClassReference(this, expression2);
            }

            public void visitClassReference(@NotNull IrClassReference expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitClassReference(this, expression2, data2);
            }

            public void visitComposite(@NotNull IrComposite expression2) {
                IrElementVisitorVoid.DefaultImpls.visitComposite(this, expression2);
            }

            public void visitComposite(@NotNull IrComposite expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitComposite(this, expression2, data2);
            }

            public void visitConstructor(@NotNull IrConstructor declaration2) {
                IrElementVisitorVoid.DefaultImpls.visitConstructor(this, declaration2);
            }

            public void visitConstructor(@NotNull IrConstructor declaration2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitConstructor(this, declaration2, data2);
            }

            public void visitConstructorCall(@NotNull IrConstructorCall expression2) {
                IrElementVisitorVoid.DefaultImpls.visitConstructorCall(this, expression2);
            }

            public void visitConstructorCall(@NotNull IrConstructorCall expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitConstructorCall(this, expression2, data2);
            }

            public void visitContainerExpression(@NotNull IrContainerExpression expression2) {
                IrElementVisitorVoid.DefaultImpls.visitContainerExpression(this, expression2);
            }

            public void visitContainerExpression(@NotNull IrContainerExpression expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitContainerExpression(this, expression2, data2);
            }

            public void visitContinue(@NotNull IrContinue jump) {
                IrElementVisitorVoid.DefaultImpls.visitContinue(this, jump);
            }

            public void visitContinue(@NotNull IrContinue jump, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitContinue(this, jump, data2);
            }

            public void visitDeclaration(@NotNull IrDeclarationBase declaration2) {
                IrElementVisitorVoid.DefaultImpls.visitDeclaration(this, declaration2);
            }

            public void visitDeclaration(@NotNull IrDeclarationBase declaration2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitDeclaration(this, declaration2, data2);
            }

            public void visitDeclarationReference(@NotNull IrDeclarationReference expression2) {
                IrElementVisitorVoid.DefaultImpls.visitDeclarationReference(this, expression2);
            }

            public void visitDeclarationReference(@NotNull IrDeclarationReference expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitDeclarationReference(this, expression2, data2);
            }

            public void visitDelegatingConstructorCall(@NotNull IrDelegatingConstructorCall expression2) {
                IrElementVisitorVoid.DefaultImpls.visitDelegatingConstructorCall(this, expression2);
            }

            public void visitDelegatingConstructorCall(@NotNull IrDelegatingConstructorCall expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitDelegatingConstructorCall(this, expression2, data2);
            }

            public void visitDoWhileLoop(@NotNull IrDoWhileLoop loop2) {
                IrElementVisitorVoid.DefaultImpls.visitDoWhileLoop(this, loop2);
            }

            public void visitDoWhileLoop(@NotNull IrDoWhileLoop loop2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitDoWhileLoop(this, loop2, data2);
            }

            public void visitDynamicExpression(@NotNull IrDynamicExpression expression2) {
                IrElementVisitorVoid.DefaultImpls.visitDynamicExpression(this, expression2);
            }

            public void visitDynamicExpression(@NotNull IrDynamicExpression expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitDynamicExpression(this, expression2, data2);
            }

            public void visitDynamicMemberExpression(@NotNull IrDynamicMemberExpression expression2) {
                IrElementVisitorVoid.DefaultImpls.visitDynamicMemberExpression(this, expression2);
            }

            public void visitDynamicMemberExpression(@NotNull IrDynamicMemberExpression expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitDynamicMemberExpression(this, expression2, data2);
            }

            public void visitDynamicOperatorExpression(@NotNull IrDynamicOperatorExpression expression2) {
                IrElementVisitorVoid.DefaultImpls.visitDynamicOperatorExpression(this, expression2);
            }

            public void visitDynamicOperatorExpression(@NotNull IrDynamicOperatorExpression expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitDynamicOperatorExpression(this, expression2, data2);
            }

            public void visitElement(@NotNull IrElement element, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitElement(this, element, data2);
            }

            public void visitElseBranch(@NotNull IrElseBranch branch) {
                IrElementVisitorVoid.DefaultImpls.visitElseBranch(this, branch);
            }

            public void visitElseBranch(@NotNull IrElseBranch branch, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitElseBranch(this, branch, data2);
            }

            public void visitEnumConstructorCall(@NotNull IrEnumConstructorCall expression2) {
                IrElementVisitorVoid.DefaultImpls.visitEnumConstructorCall(this, expression2);
            }

            public void visitEnumConstructorCall(@NotNull IrEnumConstructorCall expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitEnumConstructorCall(this, expression2, data2);
            }

            public void visitEnumEntry(@NotNull IrEnumEntry declaration2) {
                IrElementVisitorVoid.DefaultImpls.visitEnumEntry(this, declaration2);
            }

            public void visitEnumEntry(@NotNull IrEnumEntry declaration2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitEnumEntry(this, declaration2, data2);
            }

            public void visitErrorCallExpression(@NotNull IrErrorCallExpression expression2) {
                IrElementVisitorVoid.DefaultImpls.visitErrorCallExpression(this, expression2);
            }

            public void visitErrorCallExpression(@NotNull IrErrorCallExpression expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitErrorCallExpression(this, expression2, data2);
            }

            public void visitErrorDeclaration(@NotNull IrErrorDeclaration declaration2) {
                IrElementVisitorVoid.DefaultImpls.visitErrorDeclaration(this, declaration2);
            }

            public void visitErrorDeclaration(@NotNull IrErrorDeclaration declaration2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitErrorDeclaration(this, declaration2, data2);
            }

            public void visitErrorExpression(@NotNull IrErrorExpression expression2) {
                IrElementVisitorVoid.DefaultImpls.visitErrorExpression(this, expression2);
            }

            public void visitErrorExpression(@NotNull IrErrorExpression expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitErrorExpression(this, expression2, data2);
            }

            public void visitExpression(@NotNull IrExpression expression2) {
                IrElementVisitorVoid.DefaultImpls.visitExpression(this, expression2);
            }

            public void visitExpression(@NotNull IrExpression expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitExpression(this, expression2, data2);
            }

            public void visitExpressionBody(@NotNull IrExpressionBody body2) {
                IrElementVisitorVoid.DefaultImpls.visitExpressionBody(this, body2);
            }

            public void visitExpressionBody(@NotNull IrExpressionBody body2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitExpressionBody(this, body2, data2);
            }

            public void visitExternalPackageFragment(@NotNull IrExternalPackageFragment declaration2) {
                IrElementVisitorVoid.DefaultImpls.visitExternalPackageFragment(this, declaration2);
            }

            public void visitExternalPackageFragment(@NotNull IrExternalPackageFragment declaration2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitExternalPackageFragment(this, declaration2, data2);
            }

            public void visitField(@NotNull IrField declaration2) {
                IrElementVisitorVoid.DefaultImpls.visitField(this, declaration2);
            }

            public void visitField(@NotNull IrField declaration2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitField(this, declaration2, data2);
            }

            public void visitFieldAccess(@NotNull IrFieldAccessExpression expression2) {
                IrElementVisitorVoid.DefaultImpls.visitFieldAccess(this, expression2);
            }

            public void visitFieldAccess(@NotNull IrFieldAccessExpression expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitFieldAccess(this, expression2, data2);
            }

            public void visitFile(@NotNull IrFile declaration2) {
                IrElementVisitorVoid.DefaultImpls.visitFile(this, declaration2);
            }

            public void visitFile(@NotNull IrFile declaration2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitFile(this, declaration2, data2);
            }

            public void visitFunction(@NotNull IrFunction declaration2) {
                IrElementVisitorVoid.DefaultImpls.visitFunction(this, declaration2);
            }

            public void visitFunction(@NotNull IrFunction declaration2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitFunction(this, declaration2, data2);
            }

            public void visitFunctionAccess(@NotNull IrFunctionAccessExpression expression2) {
                IrElementVisitorVoid.DefaultImpls.visitFunctionAccess(this, expression2);
            }

            public void visitFunctionAccess(@NotNull IrFunctionAccessExpression expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitFunctionAccess(this, expression2, data2);
            }

            public void visitFunctionExpression(@NotNull IrFunctionExpression expression2) {
                IrElementVisitorVoid.DefaultImpls.visitFunctionExpression(this, expression2);
            }

            public void visitFunctionExpression(@NotNull IrFunctionExpression expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitFunctionExpression(this, expression2, data2);
            }

            public void visitFunctionReference(@NotNull IrFunctionReference expression2) {
                IrElementVisitorVoid.DefaultImpls.visitFunctionReference(this, expression2);
            }

            public void visitFunctionReference(@NotNull IrFunctionReference expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitFunctionReference(this, expression2, data2);
            }

            public void visitGetClass(@NotNull IrGetClass expression2) {
                IrElementVisitorVoid.DefaultImpls.visitGetClass(this, expression2);
            }

            public void visitGetClass(@NotNull IrGetClass expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitGetClass(this, expression2, data2);
            }

            public void visitGetEnumValue(@NotNull IrGetEnumValue expression2) {
                IrElementVisitorVoid.DefaultImpls.visitGetEnumValue(this, expression2);
            }

            public void visitGetEnumValue(@NotNull IrGetEnumValue expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitGetEnumValue(this, expression2, data2);
            }

            public void visitGetField(@NotNull IrGetField expression2) {
                IrElementVisitorVoid.DefaultImpls.visitGetField(this, expression2);
            }

            public void visitGetField(@NotNull IrGetField expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitGetField(this, expression2, data2);
            }

            public void visitGetObjectValue(@NotNull IrGetObjectValue expression2) {
                IrElementVisitorVoid.DefaultImpls.visitGetObjectValue(this, expression2);
            }

            public void visitGetObjectValue(@NotNull IrGetObjectValue expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitGetObjectValue(this, expression2, data2);
            }

            public void visitGetValue(@NotNull IrGetValue expression2) {
                IrElementVisitorVoid.DefaultImpls.visitGetValue(this, expression2);
            }

            public void visitGetValue(@NotNull IrGetValue expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitGetValue(this, expression2, data2);
            }

            public void visitInstanceInitializerCall(@NotNull IrInstanceInitializerCall expression2) {
                IrElementVisitorVoid.DefaultImpls.visitInstanceInitializerCall(this, expression2);
            }

            public void visitInstanceInitializerCall(@NotNull IrInstanceInitializerCall expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitInstanceInitializerCall(this, expression2, data2);
            }

            public void visitLocalDelegatedProperty(@NotNull IrLocalDelegatedProperty declaration2) {
                IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedProperty(this, declaration2);
            }

            public void visitLocalDelegatedProperty(@NotNull IrLocalDelegatedProperty declaration2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedProperty(this, declaration2, data2);
            }

            public void visitLocalDelegatedPropertyReference(@NotNull IrLocalDelegatedPropertyReference expression2) {
                IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedPropertyReference(this, expression2);
            }

            public void visitLocalDelegatedPropertyReference(@NotNull IrLocalDelegatedPropertyReference expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedPropertyReference(this, expression2, data2);
            }

            public void visitLoop(@NotNull IrLoop loop2) {
                IrElementVisitorVoid.DefaultImpls.visitLoop(this, loop2);
            }

            public void visitLoop(@NotNull IrLoop loop2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitLoop(this, loop2, data2);
            }

            public void visitMemberAccess(@NotNull IrMemberAccessExpression<?> expression2) {
                IrElementVisitorVoid.DefaultImpls.visitMemberAccess(this, expression2);
            }

            public void visitMemberAccess(@NotNull IrMemberAccessExpression<?> expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitMemberAccess(this, expression2, data2);
            }

            public void visitModuleFragment(@NotNull IrModuleFragment declaration2) {
                IrElementVisitorVoid.DefaultImpls.visitModuleFragment(this, declaration2);
            }

            public void visitModuleFragment(@NotNull IrModuleFragment declaration2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitModuleFragment(this, declaration2, data2);
            }

            public void visitPackageFragment(@NotNull IrPackageFragment declaration2) {
                IrElementVisitorVoid.DefaultImpls.visitPackageFragment(this, declaration2);
            }

            public void visitPackageFragment(@NotNull IrPackageFragment declaration2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitPackageFragment(this, declaration2, data2);
            }

            public void visitProperty(@NotNull IrProperty declaration2) {
                IrElementVisitorVoid.DefaultImpls.visitProperty(this, declaration2);
            }

            public void visitProperty(@NotNull IrProperty declaration2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitProperty(this, declaration2, data2);
            }

            public void visitPropertyReference(@NotNull IrPropertyReference expression2) {
                IrElementVisitorVoid.DefaultImpls.visitPropertyReference(this, expression2);
            }

            public void visitPropertyReference(@NotNull IrPropertyReference expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitPropertyReference(this, expression2, data2);
            }

            public void visitRawFunctionReference(@NotNull IrRawFunctionReference expression2) {
                IrElementVisitorVoid.DefaultImpls.visitRawFunctionReference(this, expression2);
            }

            public void visitRawFunctionReference(@NotNull IrRawFunctionReference expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitRawFunctionReference(this, expression2, data2);
            }

            public void visitReturn(@NotNull IrReturn expression2) {
                IrElementVisitorVoid.DefaultImpls.visitReturn(this, expression2);
            }

            public void visitReturn(@NotNull IrReturn expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitReturn(this, expression2, data2);
            }

            public void visitScript(@NotNull IrScript declaration2) {
                IrElementVisitorVoid.DefaultImpls.visitScript(this, declaration2);
            }

            public void visitScript(@NotNull IrScript declaration2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitScript(this, declaration2, data2);
            }

            public void visitSetField(@NotNull IrSetField expression2) {
                IrElementVisitorVoid.DefaultImpls.visitSetField(this, expression2);
            }

            public void visitSetField(@NotNull IrSetField expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitSetField(this, expression2, data2);
            }

            public void visitSetValue(@NotNull IrSetValue expression2) {
                IrElementVisitorVoid.DefaultImpls.visitSetValue(this, expression2);
            }

            public void visitSetValue(@NotNull IrSetValue expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitSetValue(this, expression2, data2);
            }

            public void visitSimpleFunction(@NotNull IrSimpleFunction declaration2) {
                IrElementVisitorVoid.DefaultImpls.visitSimpleFunction(this, declaration2);
            }

            public void visitSimpleFunction(@NotNull IrSimpleFunction declaration2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitSimpleFunction(this, declaration2, data2);
            }

            public void visitSingletonReference(@NotNull IrGetSingletonValue expression2) {
                IrElementVisitorVoid.DefaultImpls.visitSingletonReference(this, expression2);
            }

            public void visitSingletonReference(@NotNull IrGetSingletonValue expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitSingletonReference(this, expression2, data2);
            }

            public void visitSpreadElement(@NotNull IrSpreadElement spread) {
                IrElementVisitorVoid.DefaultImpls.visitSpreadElement(this, spread);
            }

            public void visitSpreadElement(@NotNull IrSpreadElement spread, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitSpreadElement(this, spread, data2);
            }

            public void visitStringConcatenation(@NotNull IrStringConcatenation expression2) {
                IrElementVisitorVoid.DefaultImpls.visitStringConcatenation(this, expression2);
            }

            public void visitStringConcatenation(@NotNull IrStringConcatenation expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitStringConcatenation(this, expression2, data2);
            }

            public void visitSuspendableExpression(@NotNull IrSuspendableExpression expression2) {
                IrElementVisitorVoid.DefaultImpls.visitSuspendableExpression(this, expression2);
            }

            public void visitSuspendableExpression(@NotNull IrSuspendableExpression expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitSuspendableExpression(this, expression2, data2);
            }

            public void visitSuspensionPoint(@NotNull IrSuspensionPoint expression2) {
                IrElementVisitorVoid.DefaultImpls.visitSuspensionPoint(this, expression2);
            }

            public void visitSuspensionPoint(@NotNull IrSuspensionPoint expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitSuspensionPoint(this, expression2, data2);
            }

            public void visitSyntheticBody(@NotNull IrSyntheticBody body2) {
                IrElementVisitorVoid.DefaultImpls.visitSyntheticBody(this, body2);
            }

            public void visitSyntheticBody(@NotNull IrSyntheticBody body2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitSyntheticBody(this, body2, data2);
            }

            public void visitThrow(@NotNull IrThrow expression2) {
                IrElementVisitorVoid.DefaultImpls.visitThrow(this, expression2);
            }

            public void visitThrow(@NotNull IrThrow expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitThrow(this, expression2, data2);
            }

            public void visitTry(@NotNull IrTry aTry) {
                IrElementVisitorVoid.DefaultImpls.visitTry(this, aTry);
            }

            public void visitTry(@NotNull IrTry aTry, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitTry(this, aTry, data2);
            }

            public void visitTypeAlias(@NotNull IrTypeAlias declaration2) {
                IrElementVisitorVoid.DefaultImpls.visitTypeAlias(this, declaration2);
            }

            public void visitTypeAlias(@NotNull IrTypeAlias declaration2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitTypeAlias(this, declaration2, data2);
            }

            public void visitTypeOperator(@NotNull IrTypeOperatorCall expression2) {
                IrElementVisitorVoid.DefaultImpls.visitTypeOperator(this, expression2);
            }

            public void visitTypeOperator(@NotNull IrTypeOperatorCall expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitTypeOperator(this, expression2, data2);
            }

            public void visitTypeParameter(@NotNull IrTypeParameter declaration2) {
                IrElementVisitorVoid.DefaultImpls.visitTypeParameter(this, declaration2);
            }

            public void visitTypeParameter(@NotNull IrTypeParameter declaration2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitTypeParameter(this, declaration2, data2);
            }

            public void visitValueAccess(@NotNull IrValueAccessExpression expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitValueAccess(this, expression2, data2);
            }

            public void visitValueParameter(@NotNull IrValueParameter declaration2) {
                IrElementVisitorVoid.DefaultImpls.visitValueParameter(this, declaration2);
            }

            public void visitValueParameter(@NotNull IrValueParameter declaration2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitValueParameter(this, declaration2, data2);
            }

            public void visitVararg(@NotNull IrVararg expression2) {
                IrElementVisitorVoid.DefaultImpls.visitVararg(this, expression2);
            }

            public void visitVararg(@NotNull IrVararg expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitVararg(this, expression2, data2);
            }

            public void visitVariable(@NotNull IrVariable declaration2) {
                IrElementVisitorVoid.DefaultImpls.visitVariable(this, declaration2);
            }

            public void visitVariable(@NotNull IrVariable declaration2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitVariable(this, declaration2, data2);
            }

            public void visitVariableAccess(@NotNull IrValueAccessExpression expression2) {
                IrElementVisitorVoid.DefaultImpls.visitVariableAccess(this, expression2);
            }

            public void visitWhen(@NotNull IrWhen expression2) {
                IrElementVisitorVoid.DefaultImpls.visitWhen(this, expression2);
            }

            public void visitWhen(@NotNull IrWhen expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitWhen(this, expression2, data2);
            }

            public void visitWhileLoop(@NotNull IrWhileLoop loop2) {
                IrElementVisitorVoid.DefaultImpls.visitWhileLoop(this, loop2);
            }

            public void visitWhileLoop(@NotNull IrWhileLoop loop2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitWhileLoop(this, loop2, data2);
            }
        });
    }

    public static final /* synthetic */ IrSymbol access$referencePublicSymbol(SymbolTable symbolTable, DescriptorByIdSignatureFinder descriptorFinder, IdSignature idSig, BinarySymbolData.SymbolKind symbolKind) {
        return DeserializeLazyDeclarationsKt.referencePublicSymbol(symbolTable, descriptorFinder, idSig, symbolKind);
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[BinarySymbolData.SymbolKind.values().length];
            nArray[BinarySymbolData.SymbolKind.CLASS_SYMBOL.ordinal()] = 1;
            nArray[BinarySymbolData.SymbolKind.CONSTRUCTOR_SYMBOL.ordinal()] = 2;
            nArray[BinarySymbolData.SymbolKind.ENUM_ENTRY_SYMBOL.ordinal()] = 3;
            nArray[BinarySymbolData.SymbolKind.STANDALONE_FIELD_SYMBOL.ordinal()] = 4;
            nArray[BinarySymbolData.SymbolKind.FIELD_SYMBOL.ordinal()] = 5;
            nArray[BinarySymbolData.SymbolKind.FUNCTION_SYMBOL.ordinal()] = 6;
            nArray[BinarySymbolData.SymbolKind.TYPEALIAS_SYMBOL.ordinal()] = 7;
            nArray[BinarySymbolData.SymbolKind.PROPERTY_SYMBOL.ordinal()] = 8;
            nArray[BinarySymbolData.SymbolKind.TYPE_PARAMETER_SYMBOL.ordinal()] = 9;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

