/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.cli;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.cli.HelpPrinter;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0016J\b\u0010\n\u001a\u00020\u0006H\u0016J\u0010\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lkotlinx/cli/SimpleHelpPrinter;", "Lkotlinx/cli/HelpPrinter;", "syntaxWidth", "", "(I)V", "printEntry", "", "helpEntry", "", "description", "printSeparator", "printText", "text", "ki-shell"})
public final class SimpleHelpPrinter
implements HelpPrinter {
    private final int syntaxWidth;

    public SimpleHelpPrinter(int syntaxWidth) {
        this.syntaxWidth = syntaxWidth;
    }

    @Override
    public void printText(@NotNull String text2) {
        Intrinsics.checkNotNullParameter(text2, "text");
        System.out.println((Object)text2);
    }

    @Override
    public void printSeparator() {
        System.out.println();
    }

    @Override
    public void printEntry(@NotNull String helpEntry, @NotNull String description2) {
        Intrinsics.checkNotNullParameter(helpEntry, "helpEntry");
        Intrinsics.checkNotNullParameter(description2, "description");
        if (helpEntry.length() <= this.syntaxWidth) {
            System.out.println((Object)("  " + StringsKt.padEnd$default(helpEntry, this.syntaxWidth, '\u0000', 2, null) + "  " + description2));
        } else {
            System.out.println((Object)Intrinsics.stringPlus("  ", helpEntry));
            System.out.println((Object)("  " + StringsKt.padEnd$default("", this.syntaxWidth, '\u0000', 2, null) + "  " + description2));
        }
    }

    @Override
    public void begin() {
        HelpPrinter.DefaultImpls.begin(this);
    }

    @Override
    public void end() {
        HelpPrinter.DefaultImpls.end(this);
    }
}

