/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.context;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.FunctionTypesKt;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.com.google.common.collect.Lists;
import org.jetbrains.kotlin.com.google.common.collect.Sets;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.kotlin.com.intellij.util.containers.hash.LinkedHashMap;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FindClassInModuleKt;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.MemberDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.PackageViewDescriptor;
import org.jetbrains.kotlin.descriptors.ParameterDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyGetterDescriptor;
import org.jetbrains.kotlin.descriptors.PropertySetterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptorWithAccessors;
import org.jetbrains.kotlin.descriptors.impl.LocalVariableDescriptor;
import org.jetbrains.kotlin.incremental.components.NoLookupLocation;
import org.jetbrains.kotlin.js.backend.ast.JsArrayAccess;
import org.jetbrains.kotlin.js.backend.ast.JsBlock;
import org.jetbrains.kotlin.js.backend.ast.JsDynamicScope;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsExpressionStatement;
import org.jetbrains.kotlin.js.backend.ast.JsFunction;
import org.jetbrains.kotlin.js.backend.ast.JsImportedModule;
import org.jetbrains.kotlin.js.backend.ast.JsImportedModuleKey;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsNameBinding;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.JsNew;
import org.jetbrains.kotlin.js.backend.ast.JsProgram;
import org.jetbrains.kotlin.js.backend.ast.JsProgramFragment;
import org.jetbrains.kotlin.js.backend.ast.JsRootScope;
import org.jetbrains.kotlin.js.backend.ast.JsScope;
import org.jetbrains.kotlin.js.backend.ast.JsStatement;
import org.jetbrains.kotlin.js.backend.ast.JsStringLiteral;
import org.jetbrains.kotlin.js.backend.ast.metadata.MetadataProperties;
import org.jetbrains.kotlin.js.backend.ast.metadata.SideEffectKind;
import org.jetbrains.kotlin.js.backend.ast.metadata.SpecialFunction;
import org.jetbrains.kotlin.js.config.JsConfig;
import org.jetbrains.kotlin.js.naming.NameSuggestion;
import org.jetbrains.kotlin.js.naming.NameSuggestionKt;
import org.jetbrains.kotlin.js.naming.SuggestedName;
import org.jetbrains.kotlin.js.resolve.diagnostics.JsBuiltinNameClashChecker;
import org.jetbrains.kotlin.js.sourceMap.SourceFilePathResolver;
import org.jetbrains.kotlin.js.translate.context.DeclarationExporter;
import org.jetbrains.kotlin.js.translate.context.DeferredCallSite;
import org.jetbrains.kotlin.js.translate.context.Namer;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.context.generator.Generator;
import org.jetbrains.kotlin.js.translate.context.generator.Rule;
import org.jetbrains.kotlin.js.translate.declaration.ClassModelGenerator;
import org.jetbrains.kotlin.js.translate.intrinsic.Intrinsics;
import org.jetbrains.kotlin.js.translate.utils.AnnotationsUtils;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;
import org.jetbrains.kotlin.js.translate.utils.JsDescriptorUtils;
import org.jetbrains.kotlin.js.translate.utils.SignatureUtilsKt;
import org.jetbrains.kotlin.js.translate.utils.TranslationUtils;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.calls.tasks.DynamicCallsKt;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.source.PsiSourceElementKt;
import org.jetbrains.kotlin.serialization.js.ModuleKind;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

public final class StaticContext {
    @NotNull
    private final JsProgram program;
    @NotNull
    private final JsProgramFragment fragment;
    @NotNull
    private final BindingTrace bindingTrace;
    @NotNull
    private final Namer namer;
    @NotNull
    private final Intrinsics intrinsics;
    @NotNull
    private final JsScope rootScope;
    @NotNull
    private final Generator<JsName> innerNames;
    @NotNull
    private final Generator<JsScope> scopes;
    @NotNull
    private final Generator<JsName> objectInstanceNames;
    @NotNull
    private final Map<JsScope, JsFunction> scopeToFunction;
    @NotNull
    private final Map<MemberDescriptor, List<DeclarationDescriptor>> classOrConstructorClosure;
    @NotNull
    private final Map<ClassDescriptor, List<DeferredCallSite>> deferredCallSites;
    @NotNull
    private final JsConfig config;
    @NotNull
    private final ModuleDescriptor currentModule;
    @NotNull
    private final JsImportedModule currentModuleAsImported;
    @NotNull
    private final NameSuggestion nameSuggestion;
    @NotNull
    private final Map<DeclarationDescriptor, JsName> nameCache;
    @NotNull
    private final Map<VariableDescriptorWithAccessors, JsName> backingFieldNameCache;
    @NotNull
    private final Map<DeclarationDescriptor, JsExpression> fqnCache;
    private final Map<DeclarationDescriptor, String> tagCache;
    @NotNull
    private final Map<JsImportedModuleKey, JsImportedModule> importedModules;
    @NotNull
    private final DeclarationExporter exporter;
    @NotNull
    private final Map<FqName, JsScope> packageScopes;
    @NotNull
    private final ClassModelGenerator classModelGenerator;
    @Nullable
    private JsName nameForImportsForInline;
    private final Map<String, JsExpression> modulesImportedForInline;
    private final Map<SpecialFunction, JsName> specialFunctions;
    private final Map<String, JsName> intrinsicNames;
    @NotNull
    private final SourceFilePathResolver sourceFilePathResolver;
    private final Map<VariableDescriptorWithAccessors, JsName> propertyMetadataVariables;
    private final boolean isStdlib;
    private static final Set<String> BUILTIN_JS_PROPERTIES = Sets.union(JsBuiltinNameClashChecker.PROHIBITED_MEMBER_NAMES, JsBuiltinNameClashChecker.PROHIBITED_STATIC_NAMES);
    private final Set<String> inlineFunctionTags;

    public StaticContext(@NotNull BindingTrace bindingTrace, @NotNull JsConfig config, @NotNull ModuleDescriptor moduleDescriptor, @NotNull SourceFilePathResolver sourceFilePathResolver, @NotNull String packageFqn) {
        if (bindingTrace == null) {
            StaticContext.$$$reportNull$$$1(0);
        }
        if (config == null) {
            StaticContext.$$$reportNull$$$1(1);
        }
        if (moduleDescriptor == null) {
            StaticContext.$$$reportNull$$$1(2);
        }
        if (sourceFilePathResolver == null) {
            StaticContext.$$$reportNull$$$1(3);
        }
        if (packageFqn == null) {
            StaticContext.$$$reportNull$$$1(4);
        }
        if (bindingTrace == null) {
            StaticContext.$$$reportNull$$$0(0);
        }
        if (config == null) {
            StaticContext.$$$reportNull$$$0(1);
        }
        if (moduleDescriptor == null) {
            StaticContext.$$$reportNull$$$0(2);
        }
        if (sourceFilePathResolver == null) {
            StaticContext.$$$reportNull$$$0(3);
        }
        if (packageFqn == null) {
            StaticContext.$$$reportNull$$$0(4);
        }
        this.innerNames = new InnerNameGenerator();
        this.scopes = new ScopeGenerator();
        this.objectInstanceNames = new ObjectInstanceNameGenerator();
        this.scopeToFunction = new HashMap<JsScope, JsFunction>();
        this.classOrConstructorClosure = new HashMap<MemberDescriptor, List<DeclarationDescriptor>>();
        this.deferredCallSites = new HashMap<ClassDescriptor, List<DeferredCallSite>>();
        this.nameCache = new HashMap<DeclarationDescriptor, JsName>();
        this.backingFieldNameCache = new HashMap<VariableDescriptorWithAccessors, JsName>();
        this.fqnCache = new HashMap<DeclarationDescriptor, JsExpression>();
        this.tagCache = new HashMap<DeclarationDescriptor, String>();
        this.importedModules = new LinkedHashMap<JsImportedModuleKey, JsImportedModule>();
        this.exporter = new DeclarationExporter(this);
        this.packageScopes = new HashMap<FqName, JsScope>();
        this.modulesImportedForInline = new HashMap<String, JsExpression>();
        this.specialFunctions = new EnumMap<SpecialFunction, JsName>(SpecialFunction.class);
        this.intrinsicNames = new HashMap<String, JsName>();
        this.propertyMetadataVariables = new HashMap<VariableDescriptorWithAccessors, JsName>();
        this.inlineFunctionTags = new HashSet<String>();
        this.program = new JsProgram();
        JsFunction rootFunction = JsAstUtils.createFunctionWithEmptyBody(this.program.getScope());
        this.fragment = new JsProgramFragment(rootFunction.getScope(), packageFqn);
        this.bindingTrace = bindingTrace;
        this.nameSuggestion = new NameSuggestion();
        this.namer = Namer.newInstance(this.program.getRootScope());
        this.intrinsics = new Intrinsics();
        this.rootScope = this.fragment.getScope();
        this.config = config;
        this.currentModule = moduleDescriptor;
        this.currentModuleAsImported = new JsImportedModule(Namer.getRootPackageName(), this.rootScope.declareName(Namer.getRootPackageName()), null);
        JsName kotlinName = this.rootScope.declareName("Kotlin");
        this.createImportedModule(new JsImportedModuleKey(Namer.KOTLIN_LOWER_NAME, null), Namer.KOTLIN_LOWER_NAME, kotlinName, null);
        this.classModelGenerator = new ClassModelGenerator(TranslationContext.rootContext(this));
        this.sourceFilePathResolver = sourceFilePathResolver;
        ClassDescriptor exceptionClass = FindClassInModuleKt.findClassAcrossModuleDependencies(moduleDescriptor, ClassId.topLevel(new FqName("kotlin.Exception")));
        this.isStdlib = exceptionClass != null && DescriptorUtils.getContainingModule(exceptionClass) == moduleDescriptor;
    }

    @NotNull
    public JsProgram getProgram() {
        JsProgram jsProgram = this.program;
        if (jsProgram == null) {
            StaticContext.$$$reportNull$$$0(5);
        }
        if (jsProgram == null) {
            StaticContext.$$$reportNull$$$1(5);
        }
        return jsProgram;
    }

    @NotNull
    public JsProgramFragment getFragment() {
        JsProgramFragment jsProgramFragment = this.fragment;
        if (jsProgramFragment == null) {
            StaticContext.$$$reportNull$$$0(6);
        }
        if (jsProgramFragment == null) {
            StaticContext.$$$reportNull$$$1(6);
        }
        return jsProgramFragment;
    }

    @NotNull
    public BindingTrace getBindingTrace() {
        BindingTrace bindingTrace = this.bindingTrace;
        if (bindingTrace == null) {
            StaticContext.$$$reportNull$$$0(7);
        }
        if (bindingTrace == null) {
            StaticContext.$$$reportNull$$$1(7);
        }
        return bindingTrace;
    }

    @NotNull
    public BindingContext getBindingContext() {
        BindingContext bindingContext = this.bindingTrace.getBindingContext();
        if (bindingContext == null) {
            StaticContext.$$$reportNull$$$0(8);
        }
        if (bindingContext == null) {
            StaticContext.$$$reportNull$$$1(8);
        }
        return bindingContext;
    }

    @NotNull
    public Intrinsics getIntrinsics() {
        Intrinsics intrinsics = this.intrinsics;
        if (intrinsics == null) {
            StaticContext.$$$reportNull$$$0(9);
        }
        if (intrinsics == null) {
            StaticContext.$$$reportNull$$$1(9);
        }
        return intrinsics;
    }

    @NotNull
    public Namer getNamer() {
        Namer namer = this.namer;
        if (namer == null) {
            StaticContext.$$$reportNull$$$0(10);
        }
        if (namer == null) {
            StaticContext.$$$reportNull$$$1(10);
        }
        return namer;
    }

    @NotNull
    public SourceFilePathResolver getSourceFilePathResolver() {
        SourceFilePathResolver sourceFilePathResolver = this.sourceFilePathResolver;
        if (sourceFilePathResolver == null) {
            StaticContext.$$$reportNull$$$0(11);
        }
        if (sourceFilePathResolver == null) {
            StaticContext.$$$reportNull$$$1(11);
        }
        return sourceFilePathResolver;
    }

    @NotNull
    public JsScope getScopeForDescriptor(@NotNull DeclarationDescriptor descriptor2) {
        if (descriptor2 == null) {
            StaticContext.$$$reportNull$$$1(12);
        }
        if (descriptor2 == null) {
            StaticContext.$$$reportNull$$$0(12);
        }
        if (descriptor2 instanceof ModuleDescriptor) {
            JsScope jsScope = this.rootScope;
            if (jsScope == null) {
                StaticContext.$$$reportNull$$$0(13);
            }
            if (jsScope == null) {
                StaticContext.$$$reportNull$$$1(13);
            }
            return jsScope;
        }
        JsScope scope2 = this.scopes.get(descriptor2.getOriginal());
        assert (scope2 != null) : "Must have a scope for descriptor";
        JsScope jsScope = scope2;
        if (jsScope == null) {
            StaticContext.$$$reportNull$$$0(14);
        }
        if (jsScope == null) {
            StaticContext.$$$reportNull$$$1(14);
        }
        return jsScope;
    }

    @NotNull
    public JsFunction getFunctionWithScope(@NotNull CallableDescriptor descriptor2) {
        if (descriptor2 == null) {
            StaticContext.$$$reportNull$$$1(15);
        }
        if (descriptor2 == null) {
            StaticContext.$$$reportNull$$$0(15);
        }
        JsScope scope2 = this.getScopeForDescriptor(descriptor2);
        JsFunction function2 = this.scopeToFunction.get(scope2);
        assert (scope2.equals(function2.getScope())) : "Inconsistency.";
        JsFunction jsFunction = function2;
        if (jsFunction == null) {
            StaticContext.$$$reportNull$$$0(16);
        }
        if (jsFunction == null) {
            StaticContext.$$$reportNull$$$1(16);
        }
        return jsFunction;
    }

    @NotNull
    public JsNameRef getQualifiedReference(@NotNull DeclarationDescriptor descriptor2) {
        if (descriptor2 == null) {
            StaticContext.$$$reportNull$$$1(17);
        }
        if (descriptor2 == null) {
            StaticContext.$$$reportNull$$$0(17);
        }
        return (JsNameRef)this.getQualifiedExpression(descriptor2);
    }

    @Nullable
    public String getTag(@NotNull DeclarationDescriptor descriptor2) {
        String tag;
        if (descriptor2 == null) {
            StaticContext.$$$reportNull$$$1(18);
        }
        if (descriptor2 == null) {
            StaticContext.$$$reportNull$$$0(18);
        }
        if (!this.tagCache.containsKey(descriptor2)) {
            tag = SignatureUtilsKt.generateSignature(descriptor2);
            this.tagCache.put(descriptor2, tag);
        } else {
            tag = this.tagCache.get(descriptor2);
        }
        return tag;
    }

    @NotNull
    private JsExpression getQualifiedExpression(@NotNull DeclarationDescriptor descriptor2) {
        JsExpression fqn;
        if (descriptor2 == null) {
            StaticContext.$$$reportNull$$$1(19);
        }
        if (descriptor2 == null) {
            StaticContext.$$$reportNull$$$0(19);
        }
        if ((fqn = this.fqnCache.get(descriptor2)) == null) {
            fqn = this.buildQualifiedExpression(descriptor2);
            this.fqnCache.put(descriptor2, fqn);
        }
        JsExpression jsExpression = fqn.deepCopy();
        if (jsExpression == null) {
            StaticContext.$$$reportNull$$$0(20);
        }
        if (jsExpression == null) {
            StaticContext.$$$reportNull$$$1(20);
        }
        return jsExpression;
    }

    @Nullable
    public SuggestedName suggestName(@NotNull DeclarationDescriptor descriptor2) {
        if (descriptor2 == null) {
            StaticContext.$$$reportNull$$$1(21);
        }
        if (descriptor2 == null) {
            StaticContext.$$$reportNull$$$0(21);
        }
        return this.nameSuggestion.suggest(descriptor2, this.getBindingContext());
    }

    @NotNull
    private JsExpression buildQualifiedExpression(@NotNull DeclarationDescriptor descriptor2) {
        String moduleName;
        SuggestedName suggested;
        if (descriptor2 == null) {
            StaticContext.$$$reportNull$$$1(22);
        }
        if (descriptor2 == null) {
            StaticContext.$$$reportNull$$$0(22);
        }
        if (descriptor2 instanceof ClassDescriptor) {
            ClassDescriptor classDescriptor = (ClassDescriptor)descriptor2;
            SimpleType type2 = classDescriptor.getDefaultType();
            if (KotlinBuiltIns.isAny(classDescriptor)) {
                JsNameRef jsNameRef = JsAstUtils.pureFqn("Object", null);
                if (jsNameRef == null) {
                    StaticContext.$$$reportNull$$$0(23);
                }
                if (jsNameRef == null) {
                    StaticContext.$$$reportNull$$$1(23);
                }
                return jsNameRef;
            }
            if (KotlinBuiltIns.isInt(type2) || KotlinBuiltIns.isShort(type2) || KotlinBuiltIns.isByte(type2) || KotlinBuiltIns.isFloat(type2) || KotlinBuiltIns.isDouble(type2)) {
                JsNameRef jsNameRef = JsAstUtils.pureFqn("Number", null);
                if (jsNameRef == null) {
                    StaticContext.$$$reportNull$$$0(24);
                }
                if (jsNameRef == null) {
                    StaticContext.$$$reportNull$$$1(24);
                }
                return jsNameRef;
            }
            if (KotlinBuiltIns.isLong(type2)) {
                JsNameRef jsNameRef = JsAstUtils.pureFqn("Long", (JsExpression)Namer.kotlinObject());
                if (jsNameRef == null) {
                    StaticContext.$$$reportNull$$$0(25);
                }
                if (jsNameRef == null) {
                    StaticContext.$$$reportNull$$$1(25);
                }
                return jsNameRef;
            }
            if (KotlinBuiltIns.isChar(type2)) {
                JsNameRef jsNameRef = JsAstUtils.pureFqn("BoxedChar", (JsExpression)Namer.kotlinObject());
                if (jsNameRef == null) {
                    StaticContext.$$$reportNull$$$0(26);
                }
                if (jsNameRef == null) {
                    StaticContext.$$$reportNull$$$1(26);
                }
                return jsNameRef;
            }
            if (KotlinBuiltIns.isString(type2)) {
                JsNameRef jsNameRef = JsAstUtils.pureFqn("String", null);
                if (jsNameRef == null) {
                    StaticContext.$$$reportNull$$$0(27);
                }
                if (jsNameRef == null) {
                    StaticContext.$$$reportNull$$$1(27);
                }
                return jsNameRef;
            }
            if (KotlinBuiltIns.isBoolean(type2)) {
                JsNameRef jsNameRef = JsAstUtils.pureFqn("Boolean", null);
                if (jsNameRef == null) {
                    StaticContext.$$$reportNull$$$0(28);
                }
                if (jsNameRef == null) {
                    StaticContext.$$$reportNull$$$1(28);
                }
                return jsNameRef;
            }
            if (KotlinBuiltIns.isArrayOrPrimitiveArray(classDescriptor)) {
                JsNameRef jsNameRef = JsAstUtils.pureFqn("Array", null);
                if (jsNameRef == null) {
                    StaticContext.$$$reportNull$$$0(29);
                }
                if (jsNameRef == null) {
                    StaticContext.$$$reportNull$$$1(29);
                }
                return jsNameRef;
            }
            if (FunctionTypesKt.isBuiltinFunctionalType(type2)) {
                JsNameRef jsNameRef = JsAstUtils.pureFqn("Function", null);
                if (jsNameRef == null) {
                    StaticContext.$$$reportNull$$$0(30);
                }
                if (jsNameRef == null) {
                    StaticContext.$$$reportNull$$$1(30);
                }
                return jsNameRef;
            }
            if (TypeUtilsKt.isNotNullThrowable(classDescriptor.getDefaultType())) {
                JsNameRef jsNameRef = JsAstUtils.pureFqn("Error", null);
                if (jsNameRef == null) {
                    StaticContext.$$$reportNull$$$0(31);
                }
                if (jsNameRef == null) {
                    StaticContext.$$$reportNull$$$1(31);
                }
                return jsNameRef;
            }
        }
        if ((suggested = this.suggestName(descriptor2)) == null) {
            ModuleDescriptor module2 = DescriptorUtils.getContainingModule(descriptor2);
            JsExpression result2 = this.getModuleExpressionFor(module2);
            JsExpression jsExpression = result2 != null ? result2 : JsAstUtils.pureFqn(Namer.getRootPackageName(), null);
            if (jsExpression == null) {
                StaticContext.$$$reportNull$$$0(32);
            }
            if (jsExpression == null) {
                StaticContext.$$$reportNull$$$1(32);
            }
            return jsExpression;
        }
        if (this.config.getModuleKind() != ModuleKind.PLAIN && (moduleName = AnnotationsUtils.getModuleName(suggested.getDescriptor())) != null) {
            JsNameRef jsNameRef = JsAstUtils.pureFqn(this.getImportedModule(moduleName, suggested.getDescriptor()).getInternalName(), null);
            if (jsNameRef == null) {
                StaticContext.$$$reportNull$$$0(33);
            }
            if (jsNameRef == null) {
                StaticContext.$$$reportNull$$$1(33);
            }
            return jsNameRef;
        }
        List<JsName> partNames = this.getActualNameFromSuggested(suggested);
        Object expression2 = AnnotationsUtils.isLibraryObject(suggested.getDescriptor()) ? Namer.kotlinObject() : (AnnotationsUtils.isNativeObject(suggested.getDescriptor()) && !AnnotationsUtils.isNativeObject(suggested.getScope()) || suggested.getDescriptor() instanceof CallableDescriptor && suggested.getScope() instanceof FunctionDescriptor ? null : this.getQualifiedExpression(suggested.getScope()));
        if (AnnotationsUtils.isNativeObject(suggested.getDescriptor()) && DescriptorUtils.isTopLevelDeclaration(suggested.getDescriptor())) {
            String qualifier;
            String fileModuleName = AnnotationsUtils.getFileModuleName(this.getBindingContext(), suggested.getDescriptor());
            if (fileModuleName != null) {
                JsName moduleJsName = this.getImportedModule(fileModuleName, null).getInternalName();
                expression2 = JsAstUtils.pureFqn(moduleJsName, (JsExpression)expression2);
            }
            if ((qualifier = AnnotationsUtils.getFileQualifier(this.getBindingContext(), suggested.getDescriptor())) != null) {
                for (String qualifierPart : StringUtil.split(qualifier, ".")) {
                    expression2 = JsAstUtils.pureFqn(qualifierPart, (JsExpression)expression2);
                }
            }
        }
        for (JsName partName : partNames) {
            expression2 = new JsNameRef(partName, (JsExpression)expression2);
            StaticContext.applySideEffects((JsExpression)expression2, suggested.getDescriptor());
        }
        assert (expression2 != null) : "Since partNames is not empty, expression must be non-null";
        JsExpression jsExpression = expression2;
        if (jsExpression == null) {
            StaticContext.$$$reportNull$$$0(34);
        }
        if (jsExpression == null) {
            StaticContext.$$$reportNull$$$1(34);
        }
        return jsExpression;
    }

    @NotNull
    public JsName getNameForDescriptor(@NotNull DeclarationDescriptor descriptor2) {
        if (descriptor2 == null) {
            StaticContext.$$$reportNull$$$1(35);
        }
        if (descriptor2 == null) {
            StaticContext.$$$reportNull$$$0(35);
        }
        if (descriptor2 instanceof ClassDescriptor && KotlinBuiltIns.isAny((ClassDescriptor)descriptor2)) {
            JsName result2 = this.rootScope.declareName("Object");
            MetadataProperties.setDescriptor(result2, descriptor2);
            JsName jsName = result2;
            if (jsName == null) {
                StaticContext.$$$reportNull$$$0(36);
            }
            if (jsName == null) {
                StaticContext.$$$reportNull$$$1(36);
            }
            return jsName;
        }
        SuggestedName suggested = this.nameSuggestion.suggest(descriptor2, this.getBindingContext());
        if (suggested == null) {
            throw new IllegalArgumentException("Can't generate name for root declarations: " + descriptor2);
        }
        JsName jsName = this.getActualNameFromSuggested(suggested).get(0);
        if (jsName == null) {
            StaticContext.$$$reportNull$$$0(37);
        }
        if (jsName == null) {
            StaticContext.$$$reportNull$$$1(37);
        }
        return jsName;
    }

    @NotNull
    public JsName getNameForBackingField(@NotNull VariableDescriptorWithAccessors property2) {
        JsName name2;
        if (property2 == null) {
            StaticContext.$$$reportNull$$$1(38);
        }
        if (property2 == null) {
            StaticContext.$$$reportNull$$$0(38);
        }
        if ((name2 = this.backingFieldNameCache.get(property2)) == null) {
            SuggestedName fqn = this.nameSuggestion.suggest(property2, this.getBindingContext());
            assert (fqn != null) : "Properties are non-root declarations: " + property2;
            assert (fqn.getNames().size() == 1) : "Private names must always consist of exactly one name";
            JsScope scope2 = this.getScopeForDescriptor(fqn.getScope());
            String baseName = NameSuggestion.getPrivateMangledName(fqn.getNames().get(0), property2) + "_0";
            name2 = scope2.declareFreshName(baseName);
            this.backingFieldNameCache.put(property2, name2);
        }
        JsName jsName = name2;
        if (jsName == null) {
            StaticContext.$$$reportNull$$$0(39);
        }
        if (jsName == null) {
            StaticContext.$$$reportNull$$$1(39);
        }
        return jsName;
    }

    @NotNull
    public JsName getInnerNameForDescriptor(@NotNull DeclarationDescriptor descriptor2) {
        if (descriptor2 == null) {
            StaticContext.$$$reportNull$$$1(40);
        }
        if (descriptor2 == null) {
            StaticContext.$$$reportNull$$$0(40);
        }
        JsName name2 = this.innerNames.get(descriptor2.getOriginal());
        assert (name2 != null) : "Must have inner name for descriptor";
        JsName jsName = name2;
        if (jsName == null) {
            StaticContext.$$$reportNull$$$0(41);
        }
        if (jsName == null) {
            StaticContext.$$$reportNull$$$1(41);
        }
        return jsName;
    }

    @NotNull
    public JsName getNameForObjectInstance(@NotNull ClassDescriptor descriptor2) {
        if (descriptor2 == null) {
            StaticContext.$$$reportNull$$$1(42);
        }
        if (descriptor2 == null) {
            StaticContext.$$$reportNull$$$0(42);
        }
        JsName name2 = this.objectInstanceNames.get(descriptor2.getOriginal());
        assert (name2 != null) : "Must have inner name for object instance";
        JsName jsName = name2;
        if (jsName == null) {
            StaticContext.$$$reportNull$$$0(43);
        }
        if (jsName == null) {
            StaticContext.$$$reportNull$$$1(43);
        }
        return jsName;
    }

    @NotNull
    private List<JsName> getActualNameFromSuggested(@NotNull SuggestedName suggested) {
        if (suggested == null) {
            StaticContext.$$$reportNull$$$1(44);
        }
        if (suggested == null) {
            StaticContext.$$$reportNull$$$0(44);
        }
        JsScope scope2 = this.getScopeForDescriptor(suggested.getScope());
        if (DynamicCallsKt.isDynamic(suggested.getDescriptor())) {
            scope2 = JsDynamicScope.INSTANCE;
        } else if (AnnotationsUtils.isPredefinedObject(suggested.getDescriptor()) && DescriptorUtils.isTopLevelDeclaration(suggested.getDescriptor())) {
            scope2 = this.rootScope;
        }
        ArrayList<JsName> names2 = new ArrayList<JsName>();
        if (suggested.getStable()) {
            String tag = this.getTag(suggested.getDescriptor());
            int index2 = 0;
            for (String namePart : suggested.getNames()) {
                JsName name2 = scope2.declareName(namePart);
                MetadataProperties.setDescriptor(name2, suggested.getDescriptor());
                if (tag != null && !AnnotationsUtils.isNativeObject(suggested.getDescriptor()) && !AnnotationsUtils.isLibraryObject(suggested.getDescriptor())) {
                    this.fragment.getNameBindings().add(new JsNameBinding(index2++ + ":" + tag, name2));
                }
                names2.add(name2);
            }
        } else {
            assert (suggested.getNames().size() == 1) : "Private names must always consist of exactly one name";
            JsName name3 = this.nameCache.get(suggested.getDescriptor());
            if (name3 == null) {
                String baseName = NameSuggestion.sanitizeName(suggested.getNames().get(0));
                if (suggested.getDescriptor() instanceof LocalVariableDescriptor || suggested.getDescriptor() instanceof ValueParameterDescriptor) {
                    name3 = JsScope.declareTemporaryName(baseName);
                } else {
                    if (!DescriptorUtils.isDescriptorWithLocalVisibility(suggested.getDescriptor())) {
                        baseName = baseName + "_0";
                    }
                    name3 = scope2.declareFreshName(baseName);
                }
            }
            this.nameCache.put(suggested.getDescriptor(), name3);
            MetadataProperties.setDescriptor(name3, suggested.getDescriptor());
            String tag = this.getTag(suggested.getDescriptor());
            if (tag != null) {
                this.fragment.getNameBindings().add(new JsNameBinding(tag, name3));
            }
            names2.add(name3);
        }
        ArrayList<JsName> arrayList = names2;
        if (arrayList == null) {
            StaticContext.$$$reportNull$$$0(45);
        }
        if (arrayList == null) {
            StaticContext.$$$reportNull$$$1(45);
        }
        return arrayList;
    }

    @NotNull
    public JsConfig getConfig() {
        JsConfig jsConfig = this.config;
        if (jsConfig == null) {
            StaticContext.$$$reportNull$$$0(46);
        }
        if (jsConfig == null) {
            StaticContext.$$$reportNull$$$1(46);
        }
        return jsConfig;
    }

    @NotNull
    JsName importDeclaration(@NotNull String suggestedName, @NotNull String tag, @NotNull JsExpression declaration2) {
        if (suggestedName == null) {
            StaticContext.$$$reportNull$$$1(47);
        }
        if (tag == null) {
            StaticContext.$$$reportNull$$$1(48);
        }
        if (declaration2 == null) {
            StaticContext.$$$reportNull$$$1(49);
        }
        if (suggestedName == null) {
            StaticContext.$$$reportNull$$$0(47);
        }
        if (tag == null) {
            StaticContext.$$$reportNull$$$0(48);
        }
        if (declaration2 == null) {
            StaticContext.$$$reportNull$$$0(49);
        }
        JsName result2 = this.importDeclarationImpl(suggestedName, tag, declaration2);
        this.fragment.getNameBindings().add(new JsNameBinding(tag, result2));
        JsName jsName = result2;
        if (jsName == null) {
            StaticContext.$$$reportNull$$$0(50);
        }
        if (jsName == null) {
            StaticContext.$$$reportNull$$$1(50);
        }
        return jsName;
    }

    @NotNull
    private JsName importDeclarationImpl(@NotNull String suggestedName, @NotNull String tag, @NotNull JsExpression declaration2) {
        if (suggestedName == null) {
            StaticContext.$$$reportNull$$$1(51);
        }
        if (tag == null) {
            StaticContext.$$$reportNull$$$1(52);
        }
        if (declaration2 == null) {
            StaticContext.$$$reportNull$$$1(53);
        }
        if (suggestedName == null) {
            StaticContext.$$$reportNull$$$0(51);
        }
        if (tag == null) {
            StaticContext.$$$reportNull$$$0(52);
        }
        if (declaration2 == null) {
            StaticContext.$$$reportNull$$$0(53);
        }
        JsName result2 = JsScope.declareTemporaryName(suggestedName);
        MetadataProperties.setImported(result2, true);
        this.fragment.getImports().put(tag, declaration2);
        JsName jsName = result2;
        if (jsName == null) {
            StaticContext.$$$reportNull$$$0(54);
        }
        if (jsName == null) {
            StaticContext.$$$reportNull$$$1(54);
        }
        return jsName;
    }

    @NotNull
    private JsName localOrImportedName(@NotNull DeclarationDescriptor descriptor2, @NotNull String suggestedName) {
        JsName name2;
        boolean isNative;
        if (descriptor2 == null) {
            StaticContext.$$$reportNull$$$1(55);
        }
        if (suggestedName == null) {
            StaticContext.$$$reportNull$$$1(56);
        }
        if (descriptor2 == null) {
            StaticContext.$$$reportNull$$$0(55);
        }
        if (suggestedName == null) {
            StaticContext.$$$reportNull$$$0(56);
        }
        ModuleDescriptor module2 = DescriptorUtilsKt.getModule(descriptor2);
        String tag = this.getTag(descriptor2);
        boolean bl = isNative = AnnotationsUtils.isNativeObject(descriptor2) || AnnotationsUtils.isLibraryObject(descriptor2);
        if (module2 != this.currentModule && !this.isLocallyRedeclaredBuiltin(descriptor2) || isNative) {
            assert (tag != null) : "Can't import declaration without tag: " + descriptor2;
            JsNameRef result2 = this.getQualifiedReference(descriptor2);
            if (isNative && result2.getQualifier() == null && result2.getName() != null) {
                name2 = result2.getName();
                tag = null;
            } else {
                name2 = this.importDeclarationImpl(suggestedName, tag, result2);
            }
        } else {
            name2 = JsScope.declareTemporaryName(suggestedName);
        }
        if (tag != null) {
            this.fragment.getNameBindings().add(new JsNameBinding(tag, name2));
        }
        MetadataProperties.setDescriptor(name2, descriptor2);
        JsName jsName = name2;
        if (jsName == null) {
            StaticContext.$$$reportNull$$$0(57);
        }
        if (jsName == null) {
            StaticContext.$$$reportNull$$$1(57);
        }
        return jsName;
    }

    private boolean isLocallyRedeclaredBuiltin(@NotNull DeclarationDescriptor descriptor2) {
        if (descriptor2 == null) {
            StaticContext.$$$reportNull$$$1(58);
        }
        if (descriptor2 == null) {
            StaticContext.$$$reportNull$$$0(58);
        }
        if (!(descriptor2 instanceof ClassDescriptor)) {
            return false;
        }
        FqName fqName2 = DescriptorUtils.getFqNameSafe(descriptor2);
        ClassId classId = ClassId.topLevel(fqName2);
        ClassDescriptor localDescriptor = FindClassInModuleKt.findClassAcrossModuleDependencies(this.currentModule, classId);
        return localDescriptor != null && DescriptorUtils.getContainingModule(localDescriptor) == this.currentModule;
    }

    @NotNull
    public Set<String> getInlineFunctionTags() {
        Set<String> set = this.inlineFunctionTags;
        if (set == null) {
            StaticContext.$$$reportNull$$$0(59);
        }
        if (set == null) {
            StaticContext.$$$reportNull$$$1(59);
        }
        return set;
    }

    public void reportInlineFunctionTag(@NotNull String tag) {
        if (tag == null) {
            StaticContext.$$$reportNull$$$1(60);
        }
        if (tag == null) {
            StaticContext.$$$reportNull$$$0(60);
        }
        this.inlineFunctionTags.add(tag);
    }

    @NotNull
    public static String getSuggestedName(@NotNull DeclarationDescriptor descriptor2) {
        String suggestedName;
        if (descriptor2 == null) {
            StaticContext.$$$reportNull$$$1(61);
        }
        if (descriptor2 == null) {
            StaticContext.$$$reportNull$$$0(61);
        }
        if (descriptor2 instanceof PropertyGetterDescriptor) {
            PropertyGetterDescriptor getter2 = (PropertyGetterDescriptor)descriptor2;
            suggestedName = "get_" + StaticContext.getSuggestedName(getter2.getCorrespondingProperty());
        } else if (descriptor2 instanceof PropertySetterDescriptor) {
            PropertySetterDescriptor setter2 = (PropertySetterDescriptor)descriptor2;
            suggestedName = "set_" + StaticContext.getSuggestedName(setter2.getCorrespondingProperty());
        } else if (descriptor2 instanceof ConstructorDescriptor) {
            ConstructorDescriptor constructor2 = (ConstructorDescriptor)descriptor2;
            suggestedName = StaticContext.getSuggestedName(constructor2.getContainingDeclaration()) + "_init";
            descriptor2 = descriptor2.getContainingDeclaration();
            assert (descriptor2 != null) : "ConstructorDescriptor should have containing declaration: " + constructor2;
        } else {
            suggestedName = descriptor2.getName().isSpecial() ? (descriptor2 instanceof ClassDescriptor ? (DescriptorUtils.isAnonymousObject(descriptor2) ? "ObjectLiteral" : "Anonymous") : (descriptor2 instanceof FunctionDescriptor ? "lambda" : "anonymous")) : NameSuggestion.sanitizeName(descriptor2.getName().asString());
        }
        if (!(descriptor2 instanceof PackageFragmentDescriptor) && !DescriptorUtils.isTopLevelDeclaration(descriptor2)) {
            DeclarationDescriptor container = descriptor2.getContainingDeclaration();
            assert (container != null) : "We just figured out that descriptor is not for a top-level declaration: " + descriptor2;
            suggestedName = StaticContext.getSuggestedName(container) + "$" + NameSuggestion.sanitizeName(suggestedName);
        }
        String string2 = suggestedName;
        if (string2 == null) {
            StaticContext.$$$reportNull$$$0(62);
        }
        if (string2 == null) {
            StaticContext.$$$reportNull$$$1(62);
        }
        return string2;
    }

    private JsScope getScopeForPackage(FqName fqName2) {
        JsScope scope2 = this.packageScopes.get(fqName2);
        if (scope2 == null) {
            if (fqName2.isRoot()) {
                scope2 = new JsRootScope(this.program);
            } else {
                JsScope parentScope = this.getScopeForPackage(fqName2.parent());
                scope2 = parentScope.innerObjectScope(fqName2.shortName().asString());
            }
            this.packageScopes.put(fqName2, scope2);
        }
        return scope2;
    }

    @Nullable
    private JsExpression getModuleExpressionFor(@NotNull DeclarationDescriptor descriptor2) {
        JsName name2;
        if (descriptor2 == null) {
            StaticContext.$$$reportNull$$$1(63);
        }
        if (descriptor2 == null) {
            StaticContext.$$$reportNull$$$0(63);
        }
        return (name2 = this.getModuleInnerName(descriptor2)) != null ? JsAstUtils.pureFqn(name2, null) : null;
    }

    @Nullable
    private JsName getModuleInnerName(@NotNull DeclarationDescriptor descriptor2) {
        JsImportedModule module2;
        if (descriptor2 == null) {
            StaticContext.$$$reportNull$$$1(64);
        }
        if (descriptor2 == null) {
            StaticContext.$$$reportNull$$$0(64);
        }
        return (module2 = this.getJsImportedModule(descriptor2)) == null ? null : module2.getInternalName();
    }

    @Nullable
    private JsImportedModule getJsImportedModule(@NotNull DeclarationDescriptor descriptor2) {
        ModuleDescriptor module2;
        if (descriptor2 == null) {
            StaticContext.$$$reportNull$$$1(65);
        }
        if (descriptor2 == null) {
            StaticContext.$$$reportNull$$$0(65);
        }
        if (this.currentModule == (module2 = DescriptorUtils.getContainingModule(descriptor2))) {
            return this.currentModuleAsImported;
        }
        String moduleName = JsDescriptorUtils.getModuleName(module2);
        if ("<unknown>".equals(moduleName)) {
            return null;
        }
        return this.getImportedModule(moduleName, null);
    }

    @NotNull
    public JsImportedModule getImportedModule(@NotNull String baseName, @Nullable DeclarationDescriptor descriptor2) {
        String plainName;
        JsImportedModuleKey key;
        JsImportedModule module2;
        if (baseName == null) {
            StaticContext.$$$reportNull$$$1(66);
        }
        if (baseName == null) {
            StaticContext.$$$reportNull$$$0(66);
        }
        if ((module2 = this.importedModules.get(key = new JsImportedModuleKey(baseName, plainName = descriptor2 != null && this.config.getModuleKind() == ModuleKind.UMD ? this.getPlainId(descriptor2) : null))) == null) {
            JsName internalName2 = JsScope.declareTemporaryName("$module$" + Namer.suggestedModuleName(baseName));
            module2 = this.createImportedModule(key, baseName, internalName2, plainName != null ? JsAstUtils.pureFqn(plainName, null) : null);
        }
        JsImportedModule jsImportedModule = module2;
        if (jsImportedModule == null) {
            StaticContext.$$$reportNull$$$0(67);
        }
        if (jsImportedModule == null) {
            StaticContext.$$$reportNull$$$1(67);
        }
        return jsImportedModule;
    }

    private JsImportedModule createImportedModule(JsImportedModuleKey key, String baseName, JsName internalName2, JsExpression plainName) {
        JsImportedModule module2 = new JsImportedModule(baseName, internalName2, plainName);
        this.importedModules.put(key, module2);
        this.fragment.getImportedModules().add(module2);
        return module2;
    }

    @NotNull
    private String getPlainId(@NotNull DeclarationDescriptor declaration2) {
        if (declaration2 == null) {
            StaticContext.$$$reportNull$$$1(68);
        }
        if (declaration2 == null) {
            StaticContext.$$$reportNull$$$0(68);
        }
        SuggestedName suggestedName = this.nameSuggestion.suggest(declaration2, this.getBindingContext());
        assert (suggestedName != null) : "Declaration should not be ModuleDescriptor, therefore suggestedName should be non-null";
        String string2 = suggestedName.getNames().get(0);
        if (string2 == null) {
            StaticContext.$$$reportNull$$$0(69);
        }
        if (string2 == null) {
            StaticContext.$$$reportNull$$$1(69);
        }
        return string2;
    }

    private static void applySideEffects(JsExpression expression2, DeclarationDescriptor descriptor2) {
        if (descriptor2 instanceof FunctionDescriptor || descriptor2 instanceof PackageFragmentDescriptor || descriptor2 instanceof ClassDescriptor) {
            MetadataProperties.setSideEffects(expression2, SideEffectKind.PURE);
        }
    }

    public void putClassOrConstructorClosure(@NotNull MemberDescriptor localClass, @NotNull List<DeclarationDescriptor> closure) {
        if (localClass == null) {
            StaticContext.$$$reportNull$$$1(70);
        }
        if (closure == null) {
            StaticContext.$$$reportNull$$$1(71);
        }
        if (localClass == null) {
            StaticContext.$$$reportNull$$$0(70);
        }
        if (closure == null) {
            StaticContext.$$$reportNull$$$0(71);
        }
        this.classOrConstructorClosure.put(localClass, Lists.newArrayList(closure));
    }

    @Nullable
    public List<DeclarationDescriptor> getClassOrConstructorClosure(@NotNull MemberDescriptor descriptor2) {
        List<DeclarationDescriptor> result2;
        if (descriptor2 == null) {
            StaticContext.$$$reportNull$$$1(72);
        }
        if (descriptor2 == null) {
            StaticContext.$$$reportNull$$$0(72);
        }
        return (result2 = this.classOrConstructorClosure.get(descriptor2)) != null ? Lists.newArrayList(result2) : null;
    }

    @NotNull
    public Map<ClassDescriptor, List<DeferredCallSite>> getDeferredCallSites() {
        Map<ClassDescriptor, List<DeferredCallSite>> map2 = this.deferredCallSites;
        if (map2 == null) {
            StaticContext.$$$reportNull$$$0(73);
        }
        if (map2 == null) {
            StaticContext.$$$reportNull$$$1(73);
        }
        return map2;
    }

    @NotNull
    public List<JsStatement> getTopLevelStatements() {
        List<JsStatement> list2 = this.fragment.getInitializerBlock().getStatements();
        if (list2 == null) {
            StaticContext.$$$reportNull$$$0(74);
        }
        if (list2 == null) {
            StaticContext.$$$reportNull$$$1(74);
        }
        return list2;
    }

    @NotNull
    public List<JsStatement> getDeclarationStatements() {
        List<JsStatement> list2 = this.fragment.getDeclarationBlock().getStatements();
        if (list2 == null) {
            StaticContext.$$$reportNull$$$0(75);
        }
        if (list2 == null) {
            StaticContext.$$$reportNull$$$1(75);
        }
        return list2;
    }

    public void addClass(@NotNull ClassDescriptor classDescriptor) {
        if (classDescriptor == null) {
            StaticContext.$$$reportNull$$$1(76);
        }
        if (classDescriptor == null) {
            StaticContext.$$$reportNull$$$0(76);
        }
        if (!AnnotationsUtils.isNativeObject(classDescriptor) && !AnnotationsUtils.isLibraryObject(classDescriptor)) {
            this.fragment.getClasses().put(this.getInnerNameForDescriptor(classDescriptor), this.classModelGenerator.generateClassModel(classDescriptor));
        }
    }

    public void export(@NotNull MemberDescriptor descriptor2, boolean force) {
        if (descriptor2 == null) {
            StaticContext.$$$reportNull$$$1(77);
        }
        if (descriptor2 == null) {
            StaticContext.$$$reportNull$$$0(77);
        }
        this.exporter.export(descriptor2, force);
    }

    @NotNull
    public NameSuggestion getNameSuggestion() {
        NameSuggestion nameSuggestion = this.nameSuggestion;
        if (nameSuggestion == null) {
            StaticContext.$$$reportNull$$$0(78);
        }
        if (nameSuggestion == null) {
            StaticContext.$$$reportNull$$$1(78);
        }
        return nameSuggestion;
    }

    @NotNull
    public ModuleDescriptor getCurrentModule() {
        ModuleDescriptor moduleDescriptor = this.currentModule;
        if (moduleDescriptor == null) {
            StaticContext.$$$reportNull$$$0(79);
        }
        if (moduleDescriptor == null) {
            StaticContext.$$$reportNull$$$1(79);
        }
        return moduleDescriptor;
    }

    public void addInlineCall(@NotNull CallableDescriptor descriptor2) {
        if (descriptor2 == null) {
            StaticContext.$$$reportNull$$$1(80);
        }
        if (descriptor2 == null) {
            StaticContext.$$$reportNull$$$0(80);
        }
        descriptor2 = (CallableDescriptor)JsDescriptorUtils.findRealInlineDeclaration(descriptor2);
        String tag = Namer.getFunctionTag(descriptor2, this.config, this.getBindingContext());
        JsExpression moduleExpression = this.exportModuleForInline(DescriptorUtils.getContainingModule(descriptor2));
        if (moduleExpression == null) {
            moduleExpression = this.getModuleExpressionFor(descriptor2);
        }
        this.fragment.getInlineModuleMap().put(tag, moduleExpression);
    }

    @NotNull
    private JsName getNameForImportsForInline() {
        if (this.nameForImportsForInline == null) {
            JsName name2 = JsScope.declareTemporaryName("$$importsForInline$$");
            this.fragment.getNameBindings().add(new JsNameBinding("$$importsForInline$$", name2));
            this.nameForImportsForInline = name2;
            JsName jsName = name2;
            if (jsName == null) {
                StaticContext.$$$reportNull$$$0(81);
            }
            if (jsName == null) {
                StaticContext.$$$reportNull$$$1(81);
            }
            return jsName;
        }
        JsName jsName = this.nameForImportsForInline;
        if (jsName == null) {
            StaticContext.$$$reportNull$$$0(82);
        }
        if (jsName == null) {
            StaticContext.$$$reportNull$$$1(82);
        }
        return jsName;
    }

    @Nullable
    public JsExpression exportModuleForInline(@NotNull ModuleDescriptor declaration2) {
        String moduleName;
        if (declaration2 == null) {
            StaticContext.$$$reportNull$$$1(83);
        }
        if (declaration2 == null) {
            StaticContext.$$$reportNull$$$0(83);
        }
        if ((moduleName = JsDescriptorUtils.getModuleName(declaration2)).equals(Namer.KOTLIN_LOWER_NAME)) {
            return null;
        }
        JsImportedModule importedModule = this.getJsImportedModule(declaration2);
        if (importedModule == null) {
            return null;
        }
        return this.exportModuleForInline(moduleName, importedModule);
    }

    @NotNull
    public JsExpression exportModuleForInline(@NotNull String moduleId, @NotNull JsImportedModule moduleName) {
        JsExpression moduleRef;
        if (moduleId == null) {
            StaticContext.$$$reportNull$$$1(84);
        }
        if (moduleName == null) {
            StaticContext.$$$reportNull$$$1(85);
        }
        if (moduleId == null) {
            StaticContext.$$$reportNull$$$0(84);
        }
        if (moduleName == null) {
            StaticContext.$$$reportNull$$$0(85);
        }
        if ((moduleRef = this.modulesImportedForInline.get(moduleId)) == null) {
            JsExpression lhsModuleRef;
            JsNameRef currentModuleRef = JsAstUtils.pureFqn(this.getInnerNameForDescriptor(this.getCurrentModule()), null);
            JsNameRef importsRef = JsAstUtils.pureFqn("$$importsForInline$$", (JsExpression)currentModuleRef);
            JsNameRef currentImports = JsAstUtils.pureFqn(this.getNameForImportsForInline(), null);
            if (NameSuggestionKt.isValidES5Identifier(moduleId)) {
                moduleRef = JsAstUtils.pureFqn(moduleId, (JsExpression)importsRef);
                lhsModuleRef = JsAstUtils.pureFqn(moduleId, (JsExpression)currentImports);
            } else {
                moduleRef = new JsArrayAccess(importsRef, new JsStringLiteral(moduleId));
                MetadataProperties.setSideEffects(moduleRef, SideEffectKind.PURE);
                lhsModuleRef = new JsArrayAccess(currentImports, new JsStringLiteral(moduleId));
            }
            MetadataProperties.setLocalAlias(moduleRef, moduleName);
            JsExpressionStatement importStmt = new JsExpressionStatement(JsAstUtils.assignment(lhsModuleRef, moduleName.getInternalName().makeRef()));
            MetadataProperties.setExportedTag(importStmt, "imports:" + moduleId);
            this.getFragment().getExportBlock().getStatements().add(importStmt);
            this.modulesImportedForInline.put(moduleId, moduleRef);
        }
        JsExpression jsExpression = moduleRef.deepCopy();
        if (jsExpression == null) {
            StaticContext.$$$reportNull$$$0(86);
        }
        if (jsExpression == null) {
            StaticContext.$$$reportNull$$$1(86);
        }
        return jsExpression;
    }

    @NotNull
    public JsName getNameForSpecialFunction(@NotNull SpecialFunction specialFunction) {
        if (specialFunction == null) {
            StaticContext.$$$reportNull$$$1(87);
        }
        if (specialFunction == null) {
            StaticContext.$$$reportNull$$$0(87);
        }
        JsName jsName = this.specialFunctions.computeIfAbsent(specialFunction, f -> {
            JsExpression expression2 = Namer.createSpecialFunction(specialFunction);
            JsName name2 = this.importDeclaration(f.getSuggestedName(), TranslationUtils.getTagForSpecialFunction(f), expression2);
            MetadataProperties.setSpecialFunction(name2, f);
            return name2;
        });
        if (jsName == null) {
            StaticContext.$$$reportNull$$$0(88);
        }
        if (jsName == null) {
            StaticContext.$$$reportNull$$$1(88);
        }
        return jsName;
    }

    @NotNull
    public JsExpression getReferenceToIntrinsic(@NotNull String name2) {
        if (name2 == null) {
            StaticContext.$$$reportNull$$$1(89);
        }
        if (name2 == null) {
            StaticContext.$$$reportNull$$$0(89);
        }
        JsNameRef jsNameRef = JsAstUtils.pureFqn(this.getNameForIntrinsic(name2), null);
        if (jsNameRef == null) {
            StaticContext.$$$reportNull$$$0(90);
        }
        if (jsNameRef == null) {
            StaticContext.$$$reportNull$$$1(90);
        }
        return jsNameRef;
    }

    @NotNull
    public JsName getNameForIntrinsic(@NotNull String name2) {
        JsName resultName;
        if (name2 == null) {
            StaticContext.$$$reportNull$$$1(91);
        }
        if (name2 == null) {
            StaticContext.$$$reportNull$$$0(91);
        }
        JsName jsName = resultName = this.intrinsicNames.computeIfAbsent(name2, k -> {
            DeclarationDescriptor descriptor2;
            if (this.isStdlib && (descriptor2 = this.findDescriptorForIntrinsic(name2)) != null) {
                return this.getInnerNameForDescriptor(descriptor2);
            }
            return this.importDeclaration(NameSuggestion.sanitizeName(name2), "intrinsic:" + name2, TranslationUtils.getIntrinsicFqn(name2));
        });
        if (jsName == null) {
            StaticContext.$$$reportNull$$$0(92);
        }
        if (jsName == null) {
            StaticContext.$$$reportNull$$$1(92);
        }
        return jsName;
    }

    @Nullable
    private DeclarationDescriptor findDescriptorForIntrinsic(@NotNull String name2) {
        PackageViewDescriptor rootPackage;
        FunctionDescriptor functionDescriptor;
        if (name2 == null) {
            StaticContext.$$$reportNull$$$1(93);
        }
        if (name2 == null) {
            StaticContext.$$$reportNull$$$0(93);
        }
        if ((functionDescriptor = DescriptorUtils.getFunctionByNameOrNull((rootPackage = this.currentModule.getPackage(FqName.ROOT)).getMemberScope(), Name.identifier(name2))) != null) {
            return functionDescriptor;
        }
        ClassifierDescriptor cls = rootPackage.getMemberScope().getContributedClassifier(Name.identifier(name2), NoLookupLocation.FROM_BACKEND);
        if (cls != null) {
            return cls;
        }
        return null;
    }

    @NotNull
    public JsName getVariableForPropertyMetadata(@NotNull VariableDescriptorWithAccessors property2) {
        if (property2 == null) {
            StaticContext.$$$reportNull$$$1(94);
        }
        if (property2 == null) {
            StaticContext.$$$reportNull$$$0(94);
        }
        JsName jsName = this.propertyMetadataVariables.computeIfAbsent(property2, p -> {
            String id = StaticContext.getSuggestedName(property2) + "_metadata";
            JsName name2 = JsScope.declareTemporaryName(NameSuggestion.sanitizeName(id));
            MetadataProperties.setImported(name2, true);
            JsStringLiteral propertyNameLiteral = new JsStringLiteral(property2.getName().asString());
            JsNew construction = new JsNew(this.getReferenceToIntrinsic("PropertyMetadata"), Collections.singletonList(propertyNameLiteral));
            this.fragment.getDeclarationBlock().getStatements().add(JsAstUtils.newVar(name2, construction));
            return name2;
        });
        if (jsName == null) {
            StaticContext.$$$reportNull$$$0(95);
        }
        if (jsName == null) {
            StaticContext.$$$reportNull$$$1(95);
        }
        return jsName;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 16: 
            case 20: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 36: 
            case 37: 
            case 39: 
            case 41: 
            case 43: 
            case 45: 
            case 46: 
            case 50: 
            case 54: 
            case 57: 
            case 59: 
            case 62: 
            case 67: 
            case 69: 
            case 73: 
            case 74: 
            case 75: 
            case 78: 
            case 79: 
            case 81: 
            case 82: 
            case 86: 
            case 88: 
            case 90: 
            case 92: 
            case 95: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 16: 
            case 20: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 36: 
            case 37: 
            case 39: 
            case 41: 
            case 43: 
            case 45: 
            case 46: 
            case 50: 
            case 54: 
            case 57: 
            case 59: 
            case 62: 
            case 67: 
            case 69: 
            case 73: 
            case 74: 
            case 75: 
            case 78: 
            case 79: 
            case 81: 
            case 82: 
            case 86: 
            case 88: 
            case 90: 
            case 92: 
            case 95: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bindingTrace";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleDescriptor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceFilePathResolver";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageFqn";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 16: 
            case 20: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 36: 
            case 37: 
            case 39: 
            case 41: 
            case 43: 
            case 45: 
            case 46: 
            case 50: 
            case 54: 
            case 57: 
            case 59: 
            case 62: 
            case 67: 
            case 69: 
            case 73: 
            case 74: 
            case 75: 
            case 78: 
            case 79: 
            case 81: 
            case 82: 
            case 86: 
            case 88: 
            case 90: 
            case 92: 
            case 95: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/js/translate/context/StaticContext";
                break;
            }
            case 12: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 35: 
            case 40: 
            case 42: 
            case 55: 
            case 58: 
            case 61: 
            case 63: 
            case 64: 
            case 65: 
            case 72: 
            case 77: 
            case 80: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 38: 
            case 94: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suggested";
                break;
            }
            case 47: 
            case 51: 
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suggestedName";
                break;
            }
            case 48: 
            case 52: 
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
            case 49: 
            case 53: 
            case 68: 
            case 83: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declaration";
                break;
            }
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseName";
                break;
            }
            case 70: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localClass";
                break;
            }
            case 71: {
                objectArray2 = objectArray3;
                objectArray3[0] = "closure";
                break;
            }
            case 76: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classDescriptor";
                break;
            }
            case 84: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleId";
                break;
            }
            case 85: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleName";
                break;
            }
            case 87: {
                objectArray2 = objectArray3;
                objectArray3[0] = "specialFunction";
                break;
            }
            case 89: 
            case 91: 
            case 93: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/js/translate/context/StaticContext";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getProgram";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getFragment";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getBindingTrace";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getBindingContext";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getIntrinsics";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getNamer";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getSourceFilePathResolver";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getScopeForDescriptor";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getFunctionWithScope";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getQualifiedExpression";
                break;
            }
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "buildQualifiedExpression";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "getNameForDescriptor";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "getNameForBackingField";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "getInnerNameForDescriptor";
                break;
            }
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "getNameForObjectInstance";
                break;
            }
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "getActualNameFromSuggested";
                break;
            }
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfig";
                break;
            }
            case 50: {
                objectArray = objectArray2;
                objectArray2[1] = "importDeclaration";
                break;
            }
            case 54: {
                objectArray = objectArray2;
                objectArray2[1] = "importDeclarationImpl";
                break;
            }
            case 57: {
                objectArray = objectArray2;
                objectArray2[1] = "localOrImportedName";
                break;
            }
            case 59: {
                objectArray = objectArray2;
                objectArray2[1] = "getInlineFunctionTags";
                break;
            }
            case 62: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuggestedName";
                break;
            }
            case 67: {
                objectArray = objectArray2;
                objectArray2[1] = "getImportedModule";
                break;
            }
            case 69: {
                objectArray = objectArray2;
                objectArray2[1] = "getPlainId";
                break;
            }
            case 73: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeferredCallSites";
                break;
            }
            case 74: {
                objectArray = objectArray2;
                objectArray2[1] = "getTopLevelStatements";
                break;
            }
            case 75: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeclarationStatements";
                break;
            }
            case 78: {
                objectArray = objectArray2;
                objectArray2[1] = "getNameSuggestion";
                break;
            }
            case 79: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentModule";
                break;
            }
            case 81: 
            case 82: {
                objectArray = objectArray2;
                objectArray2[1] = "getNameForImportsForInline";
                break;
            }
            case 86: {
                objectArray = objectArray2;
                objectArray2[1] = "exportModuleForInline";
                break;
            }
            case 88: {
                objectArray = objectArray2;
                objectArray2[1] = "getNameForSpecialFunction";
                break;
            }
            case 90: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferenceToIntrinsic";
                break;
            }
            case 92: {
                objectArray = objectArray2;
                objectArray2[1] = "getNameForIntrinsic";
                break;
            }
            case 95: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariableForPropertyMetadata";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 16: 
            case 20: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 36: 
            case 37: 
            case 39: 
            case 41: 
            case 43: 
            case 45: 
            case 46: 
            case 50: 
            case 54: 
            case 57: 
            case 59: 
            case 62: 
            case 67: 
            case 69: 
            case 73: 
            case 74: 
            case 75: 
            case 78: 
            case 79: 
            case 81: 
            case 82: 
            case 86: 
            case 88: 
            case 90: 
            case 92: 
            case 95: {
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getScopeForDescriptor";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getFunctionWithScope";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getQualifiedReference";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getTag";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getQualifiedExpression";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "suggestName";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "buildQualifiedExpression";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "getNameForDescriptor";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "getNameForBackingField";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "getInnerNameForDescriptor";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "getNameForObjectInstance";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "getActualNameFromSuggested";
                break;
            }
            case 47: 
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "importDeclaration";
                break;
            }
            case 51: 
            case 52: 
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "importDeclarationImpl";
                break;
            }
            case 55: 
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "localOrImportedName";
                break;
            }
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "isLocallyRedeclaredBuiltin";
                break;
            }
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "reportInlineFunctionTag";
                break;
            }
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "getSuggestedName";
                break;
            }
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "getModuleExpressionFor";
                break;
            }
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "getModuleInnerName";
                break;
            }
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "getJsImportedModule";
                break;
            }
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "getImportedModule";
                break;
            }
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "getPlainId";
                break;
            }
            case 70: 
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "putClassOrConstructorClosure";
                break;
            }
            case 72: {
                objectArray = objectArray;
                objectArray[2] = "getClassOrConstructorClosure";
                break;
            }
            case 76: {
                objectArray = objectArray;
                objectArray[2] = "addClass";
                break;
            }
            case 77: {
                objectArray = objectArray;
                objectArray[2] = "export";
                break;
            }
            case 80: {
                objectArray = objectArray;
                objectArray[2] = "addInlineCall";
                break;
            }
            case 83: 
            case 84: 
            case 85: {
                objectArray = objectArray;
                objectArray[2] = "exportModuleForInline";
                break;
            }
            case 87: {
                objectArray = objectArray;
                objectArray[2] = "getNameForSpecialFunction";
                break;
            }
            case 89: {
                objectArray = objectArray;
                objectArray[2] = "getReferenceToIntrinsic";
                break;
            }
            case 91: {
                objectArray = objectArray;
                objectArray[2] = "getNameForIntrinsic";
                break;
            }
            case 93: {
                objectArray = objectArray;
                objectArray[2] = "findDescriptorForIntrinsic";
                break;
            }
            case 94: {
                objectArray = objectArray;
                objectArray[2] = "getVariableForPropertyMetadata";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 16: 
            case 20: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 36: 
            case 37: 
            case 39: 
            case 41: 
            case 43: 
            case 45: 
            case 46: 
            case 50: 
            case 54: 
            case 57: 
            case 59: 
            case 62: 
            case 67: 
            case 69: 
            case 73: 
            case 74: 
            case 75: 
            case 78: 
            case 79: 
            case 81: 
            case 82: 
            case 86: 
            case 88: 
            case 90: 
            case 92: 
            case 95: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private static /* synthetic */ void $$$reportNull$$$1(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 16: 
            case 20: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 36: 
            case 37: 
            case 39: 
            case 41: 
            case 43: 
            case 45: 
            case 46: 
            case 50: 
            case 54: 
            case 57: 
            case 59: 
            case 62: 
            case 67: 
            case 69: 
            case 73: 
            case 74: 
            case 75: 
            case 78: 
            case 79: 
            case 81: 
            case 82: 
            case 86: 
            case 88: 
            case 90: 
            case 92: 
            case 95: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 16: 
            case 20: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 36: 
            case 37: 
            case 39: 
            case 41: 
            case 43: 
            case 45: 
            case 46: 
            case 50: 
            case 54: 
            case 57: 
            case 59: 
            case 62: 
            case 67: 
            case 69: 
            case 73: 
            case 74: 
            case 75: 
            case 78: 
            case 79: 
            case 81: 
            case 82: 
            case 86: 
            case 88: 
            case 90: 
            case 92: 
            case 95: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bindingTrace";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleDescriptor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceFilePathResolver";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageFqn";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 16: 
            case 20: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 36: 
            case 37: 
            case 39: 
            case 41: 
            case 43: 
            case 45: 
            case 46: 
            case 50: 
            case 54: 
            case 57: 
            case 59: 
            case 62: 
            case 67: 
            case 69: 
            case 73: 
            case 74: 
            case 75: 
            case 78: 
            case 79: 
            case 81: 
            case 82: 
            case 86: 
            case 88: 
            case 90: 
            case 92: 
            case 95: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/js/translate/context/StaticContext";
                break;
            }
            case 12: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 35: 
            case 40: 
            case 42: 
            case 55: 
            case 58: 
            case 61: 
            case 63: 
            case 64: 
            case 65: 
            case 72: 
            case 77: 
            case 80: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 38: 
            case 94: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suggested";
                break;
            }
            case 47: 
            case 51: 
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suggestedName";
                break;
            }
            case 48: 
            case 52: 
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
            case 49: 
            case 53: 
            case 68: 
            case 83: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declaration";
                break;
            }
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseName";
                break;
            }
            case 70: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localClass";
                break;
            }
            case 71: {
                objectArray2 = objectArray3;
                objectArray3[0] = "closure";
                break;
            }
            case 76: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classDescriptor";
                break;
            }
            case 84: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleId";
                break;
            }
            case 85: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleName";
                break;
            }
            case 87: {
                objectArray2 = objectArray3;
                objectArray3[0] = "specialFunction";
                break;
            }
            case 89: 
            case 91: 
            case 93: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/js/translate/context/StaticContext";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getProgram";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getFragment";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getBindingTrace";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getBindingContext";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getIntrinsics";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getNamer";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getSourceFilePathResolver";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getScopeForDescriptor";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getFunctionWithScope";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getQualifiedExpression";
                break;
            }
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "buildQualifiedExpression";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "getNameForDescriptor";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "getNameForBackingField";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "getInnerNameForDescriptor";
                break;
            }
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "getNameForObjectInstance";
                break;
            }
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "getActualNameFromSuggested";
                break;
            }
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfig";
                break;
            }
            case 50: {
                objectArray = objectArray2;
                objectArray2[1] = "importDeclaration";
                break;
            }
            case 54: {
                objectArray = objectArray2;
                objectArray2[1] = "importDeclarationImpl";
                break;
            }
            case 57: {
                objectArray = objectArray2;
                objectArray2[1] = "localOrImportedName";
                break;
            }
            case 59: {
                objectArray = objectArray2;
                objectArray2[1] = "getInlineFunctionTags";
                break;
            }
            case 62: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuggestedName";
                break;
            }
            case 67: {
                objectArray = objectArray2;
                objectArray2[1] = "getImportedModule";
                break;
            }
            case 69: {
                objectArray = objectArray2;
                objectArray2[1] = "getPlainId";
                break;
            }
            case 73: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeferredCallSites";
                break;
            }
            case 74: {
                objectArray = objectArray2;
                objectArray2[1] = "getTopLevelStatements";
                break;
            }
            case 75: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeclarationStatements";
                break;
            }
            case 78: {
                objectArray = objectArray2;
                objectArray2[1] = "getNameSuggestion";
                break;
            }
            case 79: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentModule";
                break;
            }
            case 81: 
            case 82: {
                objectArray = objectArray2;
                objectArray2[1] = "getNameForImportsForInline";
                break;
            }
            case 86: {
                objectArray = objectArray2;
                objectArray2[1] = "exportModuleForInline";
                break;
            }
            case 88: {
                objectArray = objectArray2;
                objectArray2[1] = "getNameForSpecialFunction";
                break;
            }
            case 90: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferenceToIntrinsic";
                break;
            }
            case 92: {
                objectArray = objectArray2;
                objectArray2[1] = "getNameForIntrinsic";
                break;
            }
            case 95: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariableForPropertyMetadata";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 16: 
            case 20: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 36: 
            case 37: 
            case 39: 
            case 41: 
            case 43: 
            case 45: 
            case 46: 
            case 50: 
            case 54: 
            case 57: 
            case 59: 
            case 62: 
            case 67: 
            case 69: 
            case 73: 
            case 74: 
            case 75: 
            case 78: 
            case 79: 
            case 81: 
            case 82: 
            case 86: 
            case 88: 
            case 90: 
            case 92: 
            case 95: {
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getScopeForDescriptor";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getFunctionWithScope";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getQualifiedReference";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getTag";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getQualifiedExpression";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "suggestName";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "buildQualifiedExpression";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "getNameForDescriptor";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "getNameForBackingField";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "getInnerNameForDescriptor";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "getNameForObjectInstance";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "getActualNameFromSuggested";
                break;
            }
            case 47: 
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "importDeclaration";
                break;
            }
            case 51: 
            case 52: 
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "importDeclarationImpl";
                break;
            }
            case 55: 
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "localOrImportedName";
                break;
            }
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "isLocallyRedeclaredBuiltin";
                break;
            }
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "reportInlineFunctionTag";
                break;
            }
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "getSuggestedName";
                break;
            }
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "getModuleExpressionFor";
                break;
            }
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "getModuleInnerName";
                break;
            }
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "getJsImportedModule";
                break;
            }
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "getImportedModule";
                break;
            }
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "getPlainId";
                break;
            }
            case 70: 
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "putClassOrConstructorClosure";
                break;
            }
            case 72: {
                objectArray = objectArray;
                objectArray[2] = "getClassOrConstructorClosure";
                break;
            }
            case 76: {
                objectArray = objectArray;
                objectArray[2] = "addClass";
                break;
            }
            case 77: {
                objectArray = objectArray;
                objectArray[2] = "export";
                break;
            }
            case 80: {
                objectArray = objectArray;
                objectArray[2] = "addInlineCall";
                break;
            }
            case 83: 
            case 84: 
            case 85: {
                objectArray = objectArray;
                objectArray[2] = "exportModuleForInline";
                break;
            }
            case 87: {
                objectArray = objectArray;
                objectArray[2] = "getNameForSpecialFunction";
                break;
            }
            case 89: {
                objectArray = objectArray;
                objectArray[2] = "getReferenceToIntrinsic";
                break;
            }
            case 91: {
                objectArray = objectArray;
                objectArray[2] = "getNameForIntrinsic";
                break;
            }
            case 93: {
                objectArray = objectArray;
                objectArray[2] = "findDescriptorForIntrinsic";
                break;
            }
            case 94: {
                objectArray = objectArray;
                objectArray[2] = "getVariableForPropertyMetadata";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 16: 
            case 20: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 36: 
            case 37: 
            case 39: 
            case 41: 
            case 43: 
            case 45: 
            case 46: 
            case 50: 
            case 54: 
            case 57: 
            case 59: 
            case 62: 
            case 67: 
            case 69: 
            case 73: 
            case 74: 
            case 75: 
            case 78: 
            case 79: 
            case 81: 
            case 82: 
            case 86: 
            case 88: 
            case 90: 
            case 92: 
            case 95: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private final class ScopeGenerator
    extends Generator<JsScope> {
        public ScopeGenerator() {
            Rule<JsScope> generateNewScopesForClassesWithNoAncestors = descriptor2 -> {
                if (!(descriptor2 instanceof ClassDescriptor)) {
                    return null;
                }
                if (JsDescriptorUtils.getSuperclass((ClassDescriptor)descriptor2) == null) {
                    JsFunction function2 = new JsFunction((JsScope)new JsRootScope(StaticContext.this.program), new JsBlock(), descriptor2.toString());
                    for (String builtinName : BUILTIN_JS_PROPERTIES) {
                        function2.getScope().declareName(builtinName);
                    }
                    StaticContext.this.scopeToFunction.put(function2.getScope(), function2);
                    return function2.getScope();
                }
                return null;
            };
            Rule<JsScope> generateInnerScopesForDerivedClasses = descriptor2 -> {
                if (!(descriptor2 instanceof ClassDescriptor)) {
                    return null;
                }
                ClassDescriptor superclass = JsDescriptorUtils.getSuperclass((ClassDescriptor)descriptor2);
                if (superclass == null) {
                    return null;
                }
                return StaticContext.this.getScopeForDescriptor(superclass).innerObjectScope("Scope for class " + descriptor2.getName());
            };
            Rule<JsScope> generateNewScopesForPackageDescriptors = descriptor2 -> StaticContext.this.fragment.getScope();
            Rule<JsScope> generateInnerScopesForMembers = descriptor2 -> StaticContext.this.fragment.getScope().innerObjectScope("Scope for member " + descriptor2.getName());
            Rule<JsScope> createFunctionObjectsForCallableDescriptors = descriptor2 -> {
                if (!(descriptor2 instanceof CallableDescriptor)) {
                    return null;
                }
                JsFunction correspondingFunction = JsAstUtils.createFunctionWithEmptyBody(StaticContext.this.fragment.getScope());
                assert (!StaticContext.this.scopeToFunction.containsKey(correspondingFunction.getScope())) : "Scope to function value overridden for " + descriptor2;
                StaticContext.this.scopeToFunction.put(correspondingFunction.getScope(), correspondingFunction);
                correspondingFunction.setSource(PsiSourceElementKt.getPsi(((CallableDescriptor)descriptor2).getSource()));
                return correspondingFunction.getScope();
            };
            Rule<JsScope> scopeForPackage = descriptor2 -> {
                if (!(descriptor2 instanceof PackageFragmentDescriptor)) {
                    return null;
                }
                PackageFragmentDescriptor packageDescriptor = (PackageFragmentDescriptor)descriptor2;
                return StaticContext.this.getScopeForPackage(packageDescriptor.getFqName());
            };
            this.addRule(scopeForPackage);
            this.addRule(createFunctionObjectsForCallableDescriptors);
            this.addRule(generateNewScopesForClassesWithNoAncestors);
            this.addRule(generateInnerScopesForDerivedClasses);
            this.addRule(generateNewScopesForPackageDescriptors);
            this.addRule(generateInnerScopesForMembers);
        }
    }

    private final class ObjectInstanceNameGenerator
    extends Generator<JsName> {
        public ObjectInstanceNameGenerator() {
            this.addRule(descriptor2 -> {
                String suggested = StaticContext.getSuggestedName(descriptor2) + "_getInstance";
                JsName result2 = JsScope.declareTemporaryName(suggested);
                String tag = SignatureUtilsKt.generateSignature(descriptor2);
                if (tag != null) {
                    StaticContext.this.fragment.getNameBindings().add(new JsNameBinding("object:" + tag, result2));
                }
                return result2;
            });
        }
    }

    private final class InnerNameGenerator
    extends Generator<JsName> {
        public InnerNameGenerator() {
            this.addRule(descriptor2 -> {
                FunctionDescriptor initialDescriptor;
                if (descriptor2 instanceof PackageFragmentDescriptor && DescriptorUtils.getContainingModule(descriptor2) == StaticContext.this.currentModule) {
                    return StaticContext.this.exporter.getLocalPackageName(((PackageFragmentDescriptor)descriptor2).getFqName());
                }
                if (descriptor2 instanceof FunctionDescriptor && (initialDescriptor = ((FunctionDescriptor)descriptor2).getInitialSignatureDescriptor()) != null) {
                    return StaticContext.this.getInnerNameForDescriptor(initialDescriptor);
                }
                if (descriptor2 instanceof ModuleDescriptor) {
                    return StaticContext.this.getModuleInnerName(descriptor2);
                }
                if (descriptor2 instanceof LocalVariableDescriptor || descriptor2 instanceof ParameterDescriptor) {
                    return StaticContext.this.getNameForDescriptor(descriptor2);
                }
                if (descriptor2 instanceof ConstructorDescriptor && ((ConstructorDescriptor)descriptor2).isPrimary()) {
                    return StaticContext.this.getInnerNameForDescriptor(((ConstructorDescriptor)descriptor2).getConstructedClass());
                }
                return StaticContext.this.localOrImportedName(descriptor2, StaticContext.getSuggestedName(descriptor2));
            });
        }
    }
}

