/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.overrides;

import java.util.Collection;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.ir.declarations.IrOverridableMember;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000\u0016\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u001a\u0014\u0010\u0000\u001a\u00020\u00012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003\u001a\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\u0001\u00a8\u0006\b"}, d2={"findMemberWithMaxVisibility", "Lorg/jetbrains/kotlin/ir/declarations/IrOverridableMember;", "members", "", "isVisibleForOverride", "", "overriding", "fromSuper", "ir.tree"})
public final class IrVisibilityUtilKt {
    public static final boolean isVisibleForOverride(@NotNull IrOverridableMember overriding, @NotNull IrOverridableMember fromSuper) {
        Intrinsics.checkNotNullParameter(overriding, "overriding");
        Intrinsics.checkNotNullParameter(fromSuper, "fromSuper");
        return !DescriptorVisibilities.isPrivate(fromSuper.getVisibility());
    }

    @NotNull
    public static final IrOverridableMember findMemberWithMaxVisibility(@NotNull Collection<? extends IrOverridableMember> members2) {
        boolean bl;
        Intrinsics.checkNotNullParameter(members2, "members");
        boolean bl2 = bl = !members2.isEmpty();
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        IrOverridableMember member2 = null;
        for (IrOverridableMember irOverridableMember : members2) {
            if (member2 == null) {
                member2 = irOverridableMember;
                continue;
            }
            Integer result2 = DescriptorVisibilities.compare(member2.getVisibility(), irOverridableMember.getVisibility());
            if (result2 == null || result2 >= 0) continue;
            member2 = irOverridableMember;
        }
        IrOverridableMember irOverridableMember = member2;
        if (irOverridableMember == null) {
            throw new IllegalStateException("Could not find a visible member".toString());
        }
        return irOverridableMember;
    }
}

